/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.Enhance;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.modules.logisticspurchase.inquiry.entity.PurchaseAwardOpinionLp;
import com.els.modules.logisticspurchase.inquiry.service.PurchaseAwardOpinionLpService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lpEnquiry/purchaseEnquiryHeadLp"})
@Tag(name="\u91c7\u8d2d\u8be2\u4ef7\u5934")
public class PurchaseEnquiryHeadLpController
extends BaseController<PurchaseEnquiryHeadLp, PurchaseEnquiryHeadLpService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryHeadLpController.class);
    @Autowired
    private PurchaseEnquiryItemLpService purchaseEnquiryItemService;
    @Autowired
    private EnquirySupplierListLpService enquirySupplierListService;
    @Autowired
    private PurchaseAwardOpinionLpService purchaseAwardOpinionService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:list"})
    public Result<?> queryPageList(PurchaseEnquiryHeadLp purchaseEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEnquiryHeadLpService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:list"})
    public Result<?> queryTabsCount(PurchaseEnquiryHeadLp purchaseEnquiryHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StrUtil.isNotBlank((CharSequence)purchaseEnquiryHead.getId())) {
            ids = purchaseEnquiryHead.getId().replace(" ", "").split(",");
            purchaseEnquiryHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select((Object[])new String[]{"enquiry_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"enquiry_status");
        List list = ((PurchaseEnquiryHeadLpService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseEnquiryHeadLp::getEnquiryStatus, PurchaseEnquiryHeadLp::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "enquiryStatus", null, (long)all.intValue()));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEnquiryStatusLp", TenantContext.getTenant());
        String[] statuses = new String[]{"0", "1", "7", "10", "16", "9"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "enquiryStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:delete"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadLpService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseEnquiryHeadLpService)this.service).delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8be2\u4ef7-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:delete"})
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        ((PurchaseEnquiryHeadLpService)this.service).delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:list"})
    public Result<?> queryItemPageList(PurchaseEnquiryItemLp purchaseEnquiryItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String headId = purchaseEnquiryItem.getHeadId();
        if (StrUtil.isBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)this.service).getById((Serializable)((Object)headId)));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        List itemList = pageList.getRecords();
        if (!EnquiryLpStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5", description="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    @Enhance(enhancePoint="enquiryDetail")
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:view"})
    @BusinessModule(module="enquiry")
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)this.service).getById((Serializable)((Object)id)));
        PurchaseEnquiryHeadLpVO headVO = new PurchaseEnquiryHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItemLp> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
        headVO.setPurchaseEnquiryItemList(itemList);
        List<EnquirySupplierListLp> supplierList = this.enquirySupplierListService.selectByMainId(id);
        headVO.setEnquirySupplierListList(supplierList);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        headVO.setPurchaseAttachmentList(attachmentList);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        headVO.setPurchaseAttachmentDemandList(demandList);
        List<PurchaseAwardOpinionLp> awardOpinionList = this.purchaseAwardOpinionService.selectByMainId(id);
        headVO.setPurchaseAwardOpinionList(awardOpinionList);
        List<SubjectFileItem> subjectFileItemList = this.subjectFileItemService.selectByMainId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectFileItemList(subjectFileItemList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u8be2\u4ef7\u603b\u89c8\u5927\u5385-\u7efc\u5408\u6392\u540d")
    @Operation(summary="\u7efc\u5408\u6392\u540d", description="\u7efc\u5408\u6392\u540d")
    @GetMapping(value={"/overallRanking"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:overallRanking"})
    public Result<?> overallRanking() {
        return Result.ok(((PurchaseEnquiryHeadLpService)this.service).overallRanking());
    }

    @AutoLog(value="\u8be2\u4ef7-\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:cancel"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadLpService.class)
    public Result<?> cancel(@RequestParam(name="headId") String headId) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)this.service).getById((Serializable)((Object)headId)));
        List<String> status = Arrays.asList(EnquiryLpStatusEnum.QUOTING.getValue(), EnquiryLpStatusEnum.BARGAIN.getValue(), EnquiryLpStatusEnum.NO_QUOTE.getValue(), EnquiryLpStatusEnum.PUBLISHING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_zELsusWIusWLsujtFnqtk_4ac70cc4", (String)"\u72b6\u6001\u4e3a\u62a5\u4ef7\u4e2d\u3001\u8bae\u4ef7\u4e2d\u3001\u672a\u62a5\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"), (Object[])new Object[0]);
        ((PurchaseEnquiryHeadLpService)this.service).cancel(dbHead);
        return this.commonSuccessResult(3);
    }
}

