/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.column.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.column.entity.TenderCustomColumn;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.column.mapper.TenderCustomColumnMapper;
import com.els.modules.tender.column.service.TenderCustomColumnService;
import com.els.modules.tender.column.utils.Hex;
import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderCustomColumnServiceImpl
extends BaseServiceImpl<TenderCustomColumnMapper, TenderCustomColumn>
implements TenderCustomColumnService {
    @Override
    public void add(TenderCustomColumn tenderCustomColumn) {
        this.checkParamAndSet(tenderCustomColumn);
        tenderCustomColumn.setDeleted(CommonConstant.DEL_FLAG_0);
        super.setHeadDefaultValue((ParentEntity)tenderCustomColumn);
        ((TenderCustomColumnMapper)this.baseMapper).insert((Object)tenderCustomColumn);
    }

    private void checkParamAndSet(TenderCustomColumn tenderCustomColumn) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderCustomColumn.getName()), (String)I18nUtil.translate((String)"i18n_alert_JORxOLVW_ef013dc2", (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        if ("100000".equals(TenantContext.getTenant())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderCustomColumn.getColumnFieldName()), (String)I18nUtil.translate((String)"i18n_alert_JOAoxOLVW_58d33728", (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        } else {
            if (StrUtil.isBlank((CharSequence)tenderCustomColumn.getColumnFieldName())) {
                tenderCustomColumn.setColumnFieldName(this.generateColumnFieldName(tenderCustomColumn.getName()));
            }
            if (StrUtil.isBlank((CharSequence)tenderCustomColumn.getId())) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TenderCustomColumn::getColumnFieldName, (Object)tenderCustomColumn.getColumnFieldName());
                List list = this.list((Wrapper)wrapper);
                Assert.isTrue((boolean)list.isEmpty(), (String)(tenderCustomColumn.getName() + I18nUtil.translate((String)"i18n_alert_JOIMKW_f756a33d", (String)"\u5b57\u6bb5\u5df2\u5b58\u5728\uff01")));
            }
        }
        if (CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(tenderCustomColumn.getFieldCategory())) {
            Assert.isTrue((boolean)"number".equals(tenderCustomColumn.getFieldType()), (String)(tenderCustomColumn.getName() + I18nUtil.translate((String)"i18n_alert_suAjWFROLWJAcW_ee35e660", (String)"\u62a5\u4ef7\u5217\u7684\u6570\u636e\u53ea\u80fd\u4e3a\u6570\u5b57\u7c7b\u578b\uff01")));
        }
    }

    @Override
    public void edit(TenderCustomColumn tenderCustomColumn) {
        this.checkParamAndSet(tenderCustomColumn);
        int count = ((TenderCustomColumnMapper)this.baseMapper).updateById((Object)tenderCustomColumn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TenderCustomColumnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TenderCustomColumnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private String generateColumnFieldName(String name) {
        int keyHashCode = name.hashCode();
        List pinyins = HanLP.convertToPinyinList((String)name);
        StringBuilder stringBuilder = new StringBuilder();
        for (Pinyin s : pinyins) {
            String headString = s.getPinyinWithoutTone();
            int total = 0;
            for (byte b : headString.getBytes()) {
                total += b - 96;
            }
            stringBuilder.append(Hex.byteToHex(total));
        }
        return TenantContext.getTenant() + "_" + stringBuilder.toString() + "_" + Integer.toHexString(keyHashCode);
    }
}

