/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.enquiry.entity.EnquirySubstituteHead;
import com.els.modules.enquiry.entity.EnquirySubstituteItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.SaleEnquiryHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enquiry/enquirySubstituteHead"})
@Tag(name="\u8be2\u4ef7\u4ee3\u62a5\u4ef7\u5934")
public class EnquirySubstituteHeadController
extends BaseController<EnquirySubstituteHead, EnquirySubstituteHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnquirySubstituteHeadController.class);
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Lazy
    @Resource
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Resource
    @Lazy
    private SaleEnquiryItemService saleEnquiryItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="enquirySubstituteHead")
    @RequiresPermissions(value={"enquiry#enquirySubstituteHead:list"})
    public Result<?> queryPageList(EnquirySubstituteHead enquirySubstituteHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)enquirySubstituteHead), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SaleEnquiryHead::getToElsAccount, (Object)this.getTenantId())).ne(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.CANCEL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((EnquirySubstituteHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"enquiry#enquirySubstituteHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        EnquirySubstituteHead dbHead = (EnquirySubstituteHead)((Object)((EnquirySubstituteHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"to_els_account", (Object)TenantContext.getTenant())));
        SaleEnquiryHeadVO headVO = new SaleEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<EnquirySubstituteItem> substituteItemList = this.enquirySubstituteItemService.selectByMainId(id);
        ArrayList<SaleEnquiryItem> itemList = new ArrayList<SaleEnquiryItem>(substituteItemList);
        headVO.setSaleEnquiryItemList(itemList);
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(saleAttachmentList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u4ee3\u62a5\u4ef7\u8be2\u4ef7\u5934-\u786e\u8ba4\u62a5\u4ef7")
    @Operation(summary="\u786e\u8ba4\u62a5\u4ef7", description="\u786e\u8ba4\u62a5\u4ef7")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"enquiry#SaleEnquiryHead:confirm"})
    @SrmValidated
    public Result<?> confirm(@RequestBody SaleEnquiryHead head) {
        Assert.hasText((String)head.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)head.getId())));
        Assert.notNull((Object)dbHead.getQuoteConfirmTime(), (String)I18nUtil.translate((String)"i18n_alert_STRLsu_60685988", (String)"\u65e0\u9700\u786e\u8ba4\u62a5\u4ef7"));
        Assert.isTrue((boolean)"0".equals(dbHead.getQuoteConfirmFlag()), (String)I18nUtil.translate((String)"i18n_alert_STVBRLsu_74ec2268", (String)"\u65e0\u9700\u91cd\u590d\u786e\u8ba4\u62a5\u4ef7"));
        Assert.isTrue((boolean)dbHead.getQuoteConfirmTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_KIIRWxqtk_b7df80ca", (String)"\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        this.saleEnquiryItemService.quoteConfirm(dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ee3\u62a5\u4ef7\u8be2\u4ef7\u5934-\u4fdd\u5b58")
    @Operation(summary="\u4fdd\u5b58", description="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"enquiry#SaleEnquiryHead:save"})
    @SrmValidated
    public Result<?> save(@RequestBody SaleEnquiryHeadVO saleHeadVO) {
        SaleEnquiryHead head = new SaleEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)saleHeadVO), (Object)((Object)head));
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)saleHeadVO.getId())));
        Assert.isTrue((boolean)dbHead.getEnquiryStatus().equals(head.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)statusList.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_RqtksusWIusSIMBntF_a17c3b24", (String)"\u53ea\u53ef\u64cd\u4f5c\u62a5\u4ef7\u4e2d\u3001\u8bae\u4ef7\u4e2d\u6216\u5df2\u6094\u6807\u7684\u5355\u636e"));
        this.saleEnquiryHeadService.save(head, saleHeadVO.getSaleEnquiryItemList(), saleHeadVO.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ee3\u62a5\u4ef7\u8be2\u4ef7\u5934-\u62a5\u4ef7")
    @Operation(summary="\u62a5\u4ef7", description="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    @RequiresPermissions(value={"enquiry#SaleEnquiryHead:quote"})
    @SrmValidated
    @FormCommit
    public Result<?> quote(@RequestBody SaleEnquiryHeadVO saleHeadVO) {
        Assert.notEmpty(saleHeadVO.getSaleEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)saleHeadVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkPrice(saleHeadVO);
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)saleHeadVO.getId())));
        Assert.isTrue((boolean)dbHead.getEnquiryStatus().equals(saleHeadVO.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        if (dbHead.getQuoteConfirmTime() != null) {
            Assert.isTrue((boolean)"1".equals(dbHead.getQuoteConfirmFlag()), (String)I18nUtil.translate((String)"i18n_alert_suRLyRKIPLHcsuRLWxiTDJsu_e9a10fb2", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u524d\u672a\u8fdb\u884c\u62a5\u4ef7\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u62a5\u4ef7"));
        }
        List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)statusList.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExiTsu_3e65ad91", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u62a5\u4ef7"));
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(dbHead.getId()).stream().filter(demand -> "1".equals(demand.getRequired()) && StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbHead.getId());
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> StrUtil.isNotBlank((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (SaleAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"i18n_alert_VpYPVXVIdAcjQIW_61f8e1a5", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        this.saleEnquiryHeadService.quote(dbHead, saleHeadVO.getSaleEnquiryItemList(), saleHeadVO.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    private void checkPrice(SaleEnquiryHeadVO vo) {
        List<SaleEnquiryItem> saleEnquiryItemList = vo.getSaleEnquiryItemList();
        if (CollectionUtils.isEmpty(saleEnquiryItemList)) {
            return;
        }
        saleEnquiryItemList.forEach(e -> {
            this.comparePrice(e.getBudgetPrice());
            this.comparePrice(e.getPrice());
            this.comparePrice(e.getNetPrice());
            this.comparePrice(e.getTaxAmount());
            this.comparePrice(e.getNetAmount());
        });
    }

    private void comparePrice(BigDecimal budgetPrice) {
        if (ObjectUtils.isEmpty((Object)budgetPrice)) {
            return;
        }
        boolean less = BigDecimalUtils.lessThan((BigDecimal)budgetPrice, (BigDecimal)BigDecimal.ZERO);
        Assert.isTrue((!less ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umxOKBW_96a86b0b", (String)"\u4ef7\u683c\u4e0d\u80fd\u662f\u8d1f\u6570"));
    }
}

