/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.arima;

import com.els.modules.forecast.arima.ARMAMath;
import java.util.Vector;

public class ARMA {
    double[] stdoriginalData = new double[0];
    int p;
    int q;
    ARMAMath armamath = new ARMAMath();

    public ARMA(double[] stdoriginalData, int p, int q) {
        this.stdoriginalData = stdoriginalData;
        this.p = p;
        this.q = q;
    }

    public Vector<double[]> ARMAmodel() {
        double[] arcoe = this.armamath.parcorrCompute(this.stdoriginalData, this.p, this.q);
        double[] autocorData = this.getautocorofMA(this.p, this.q, this.stdoriginalData, arcoe);
        double[] macoe = this.armamath.getMApara(autocorData, this.q);
        Vector<double[]> v = new Vector<double[]>();
        v.add(arcoe);
        v.add(macoe);
        return v;
    }

    public double[] getautocorofMA(int p, int q, double[] stdoriginalData, double[] autoRegress) {
        int temp = 0;
        double[] errArray = new double[stdoriginalData.length - p];
        int count = 0;
        for (int i = p; i < stdoriginalData.length; ++i) {
            temp = 0;
            for (int j = 1; j <= p; ++j) {
                temp = (int)((double)temp + stdoriginalData[i - j] * autoRegress[j - 1]);
            }
            errArray[count++] = stdoriginalData[i] - (double)temp;
        }
        return this.armamath.autocorGrma(errArray, q);
    }
}

