/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeHisEnum;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingItemHisLpServiceImpl
extends ServiceImpl<PurchaseEbiddingItemHisLpMapper, PurchaseEbiddingItemHisLp>
implements PurchaseEbiddingItemHisLpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingItemHisLpServiceImpl.class);
    @Autowired
    private SaleEbiddingItemHisLpMapper saleEbiddingItemHisMapper;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;

    @Override
    public List<PurchaseEbiddingItemHisLp> queryBidLobbyDetail(PurchaseEbiddingHeadLp dbHead, String itemNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHisLp::getItemNumber, (Object)itemNumber);
        wrapper.eq(PurchaseEbiddingItemHisLp::getHeadId, (Object)dbHead.getId());
        wrapper.orderByDesc(PurchaseEbiddingItemHisLp::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<PurchaseEbiddingItemHisLp> queryAcceptDetail(PurchaseEbiddingHeadLp dbHead) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHisLp::getAccept, (Object)"1");
        wrapper.eq(PurchaseEbiddingItemHisLp::getHeadId, (Object)dbHead.getId());
        wrapper.orderByDesc(PurchaseEbiddingItemHisLp::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void queryAddQuoteSite(PurchaseEbiddingHeadLp dbHead, PurchaseEbiddingItemLp dbItem) {
        String tenant = TenantContext.getTenant();
        if (!tenant.equals(dbHead.getElsAccount())) {
            TenantContext.setTenant((String)dbHead.getElsAccount());
        }
        List dbHisList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHisLp::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHisLp::getQuoteTime));
        TenantContext.setTenant((String)tenant);
        if (CollectionUtil.isNotEmpty((Collection)dbHisList)) {
            String relationId = dbItem.getRelationId();
            String id = dbItem.getId();
            BeanUtils.copyProperties(dbHisList.get(0), (Object)((Object)dbItem));
            dbItem.setId(id);
            dbItem.setRelationId(relationId);
        }
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal netTotalAmount = dbItem.getNetTotalAmount();
                quotePrice = netTotalAmount == null ? dbHead.getStartTotalAmount() : this.getQuotePrice(netTotalAmount, dbHead);
                dbItem.setNetTotalAmount(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
                dbItem.setTotalAmount(EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getNetTotalAmount()));
            } else {
                BigDecimal totalAmount = dbItem.getTotalAmount();
                quotePrice = totalAmount == null ? dbHead.getStartTotalAmount() : this.getQuotePrice(totalAmount, dbHead);
                dbItem.setTotalAmount(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
                dbItem.setNetTotalAmount(EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getTotalAmount()));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal netPrice = dbItem.getNetPrice();
            quotePrice = netPrice == null || netPrice.compareTo(BigDecimal.ZERO) == 0 ? dbItem.getStartPrice() : this.getQuotePrice(netPrice, dbHead);
            dbItem.setNetPrice(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
            dbItem.setPrice(EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getNetPrice()));
        } else {
            BigDecimal price = dbItem.getPrice();
            log.info("queryAddQuoteSite->price:{}", (Object)price);
            quotePrice = price == null || price.compareTo(BigDecimal.ZERO) == 0 ? dbItem.getStartPrice() : this.getQuotePrice(price, dbHead);
            log.info("queryAddQuoteSite->quotePrice:{}", (Object)quotePrice);
            dbItem.setPrice(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
            dbItem.setNetPrice(EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getPrice()));
            log.info("queryAddQuoteSite->dbItem:{}", (Object)JSONObject.toJSONString((Object)((Object)dbItem)));
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            dbItem.setBidNumber(dbItem.getRemainingQuantity());
        }
    }

    private BigDecimal getQuotePrice(BigDecimal lastPrice, PurchaseEbiddingHeadLp dbHead) {
        BigDecimal changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? lastPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 3, 4)) : dbHead.getChangeRange();
        return LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? lastPrice.add(changeRange) : lastPrice.subtract(changeRange);
    }

    @Override
    public List<PurchaseEbiddingItemHisLp> queryQuoteSite(PurchaseEbiddingHeadLp dbHead, String itemNumber, String toElsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseEbiddingItemHisLp::getHeadId, (Object)dbHead.getId());
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHisLp::getItemNumber, (Object)itemNumber);
        wrapper.eq(PurchaseEbiddingItemHisLp::getToElsAccount, (Object)toElsAccount);
        wrapper.orderByAsc(PurchaseEbiddingItemHisLp::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void save(PurchaseEbiddingItemLp quoteItem, SaleEbiddingHeadLp saleHead) {
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
        executor.execute(() -> {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemHisLp::getItemId, (Object)quoteItem.getId())).set(PurchaseEbiddingItemHisLp::getLastQuote, (Object)"0"));
            SaleEbiddingItemHisLp updateSale = new SaleEbiddingItemHisLp();
            updateSale.setLastQuote("0");
            this.saleEbiddingItemHisMapper.update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHisLp::getItemId, (Object)quoteItem.getRelationId()));
            PurchaseEbiddingItemHisLp purchase = new PurchaseEbiddingItemHisLp();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchase));
            purchase.setId(IdWorker.getIdStr());
            purchase.setRelationId(IdWorker.getIdStr());
            purchase.setHeadId(quoteItem.getHeadId());
            purchase.setItemId(quoteItem.getId());
            purchase.setLastQuote("1");
            purchase.setQuoteType(saleHead.getQuoteType());
            purchase.setEbiddingWay(saleHead.getEbiddingWay());
            purchase.setQuoteSubAccount(sysUser == null ? "System" : sysUser.getSubAccount());
            purchase.setQuoteUser(sysUser == null ? "System" : sysUser.getRealname());
            if (EbiddingWayEnum.PACKAGE.getValue().equals(saleHead.getEbiddingWay())) {
                List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(quoteItem.getHeadId());
                String materialNumber = itemList.stream().map(PurchaseEbiddingItemLp::getMaterialNumber).distinct().collect(Collectors.joining(","));
                purchase.setMaterialNumber(materialNumber);
                purchase.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
            }
            purchase.setBidNumber(quoteItem.getBidNumber());
            ((PurchaseEbiddingItemHisLpMapper)this.baseMapper).insert((Object)purchase);
            SaleEbiddingItemHisLp sale = new SaleEbiddingItemHisLp();
            BeanUtils.copyProperties((Object)((Object)purchase), (Object)((Object)sale));
            sale.setId(purchase.getRelationId());
            sale.setRelationId(purchase.getId());
            sale.setHeadId(saleHead.getId());
            sale.setItemId(quoteItem.getRelationId());
            sale.setElsAccount(purchase.getToElsAccount());
            sale.setToElsAccount(purchase.getElsAccount());
            sale.setBidNumber(quoteItem.getBidNumber());
            this.saleEbiddingItemHisMapper.insert((Object)sale);
        });
    }

    @Override
    public void updateBidByHeadId(List<PurchaseEbiddingItemHisLp> purchaseItemList) {
        ((PurchaseEbiddingItemHisLpMapper)this.baseMapper).updateBidByHeadId(purchaseItemList);
    }

    @Override
    public List<PurchaseEbiddingItemHisLp> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemHisLpMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public List<PurchaseEbiddingItemHisLp> selectQuoteHisList(List<String> keys) {
        return ((PurchaseEbiddingItemHisLpMapper)this.baseMapper).selectQuoteHisList(keys);
    }
}

