/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringHead;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringItem;
import com.els.modules.tender.clarification.service.SaleTenderMentoringHeadService;
import com.els.modules.tender.clarification.service.SaleTenderMentoringItemService;
import com.els.modules.tender.clarification.vo.SaleTenderMentoringHeadVO;
import com.els.modules.tender.clarification.vo.SaleTenderMentoringItemVO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/saleTenderMentoringHead"})
@Tag(name="\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934")
public class SaleTenderMentoringHeadController
extends BaseController<SaleTenderMentoringHead, SaleTenderMentoringHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleTenderMentoringHeadController.class);
    @Autowired
    private SaleTenderMentoringHeadService saleTenderMentoringHeadService;
    @Autowired
    private SaleTenderMentoringItemService saleTenderMentoringItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryPageList(SaleTenderMentoringHead saleTenderMentoringHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTenderMentoringHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"check_type", (Object)TenderFlagInjectionContext.getTenderCheckType());
        IPage pageList = this.saleTenderMentoringHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u56de\u590d", description="\u56de\u590d")
    @PostMapping(value={"/reply"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> reply(@RequestBody SaleTenderMentoringItemVO saleTenderMentoringItemVO) {
        SaleTenderMentoringItem saleTenderMentoringItem = this.saleTenderMentoringHeadService.saleReply(saleTenderMentoringItemVO);
        return Result.ok((Object)((Object)saleTenderMentoringItem));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody SaleTenderMentoringHeadVO saleTenderMentoringHeadPage) {
        SaleTenderMentoringHead saleTenderMentoringHead = new SaleTenderMentoringHead();
        BeanUtils.copyProperties((Object)((Object)saleTenderMentoringHeadPage), (Object)((Object)saleTenderMentoringHead));
        ArrayList saleTenderMentoringItemList = SysUtil.copyProperties(saleTenderMentoringHeadPage.getPurchaseTenderMentoringItemList(), SaleTenderMentoringItem.class);
        this.saleTenderMentoringHeadService.saveMain(saleTenderMentoringHead, saleTenderMentoringItemList, saleTenderMentoringHeadPage.getAttachmentList());
        return this.queryById(saleTenderMentoringHead.getId());
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody SaleTenderMentoringHeadVO saleTenderMentoringHeadPage) {
        SaleTenderMentoringHead saleTenderMentoringHead = new SaleTenderMentoringHead();
        BeanUtils.copyProperties((Object)((Object)saleTenderMentoringHeadPage), (Object)((Object)saleTenderMentoringHead));
        ArrayList saleTenderMentoringItemList = SysUtil.copyProperties(saleTenderMentoringHeadPage.getPurchaseTenderMentoringItemList(), SaleTenderMentoringItem.class);
        this.saleTenderMentoringHeadService.updateMain(saleTenderMentoringHead, saleTenderMentoringItemList, saleTenderMentoringHeadPage.getAttachmentList());
        return this.queryById(saleTenderMentoringHead.getId());
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleTenderMentoringHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleTenderMentoringHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleTenderMentoringHeadVO saleTenderMentoringHeadVO = this.saleTenderMentoringHeadService.queryById(id);
        return Result.ok((Object)((Object)saleTenderMentoringHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934\u884c", description="\u901a\u8fc7\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u62db\u6807\u7b54\u7591\u5934\u884c")
    @GetMapping(value={"/querySaleTenderMentoringItemByMainId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> querySaleTenderMentoringItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleTenderMentoringItem> saleTenderMentoringItemList = this.saleTenderMentoringItemService.selectByMainId(id);
        return Result.ok(saleTenderMentoringItemList);
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u7b54\u7591-\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestParam(name="id") String id) {
        this.saleTenderMentoringHeadService.publish(id);
        return this.commonSuccessResult(CommonConstant.SC_OK_200);
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u7b54\u7591-\u5173\u95ed")
    @Operation(summary="\u5173\u95ed", description="\u5173\u95ed")
    @PostMapping(value={"/close"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> close(@RequestParam(name="id") String id) {
        this.saleTenderMentoringHeadService.close(id);
        return this.commonSuccessResult(CommonConstant.SC_OK_200);
    }
}

