/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringItem;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringHead;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringItem;
import com.els.modules.tender.clarification.enumerate.SaleTenderMentoringStatusEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringResponderTypeEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringStatusEnum;
import com.els.modules.tender.clarification.mapper.SaleTenderMentoringHeadMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderMentoringHeadService;
import com.els.modules.tender.clarification.service.SaleTenderMentoringHeadService;
import com.els.modules.tender.clarification.service.SaleTenderMentoringItemService;
import com.els.modules.tender.clarification.vo.SaleTenderMentoringHeadVO;
import com.els.modules.tender.clarification.vo.SaleTenderMentoringItemVO;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleTenderMentoringHeadServiceImpl
extends BaseServiceImpl<SaleTenderMentoringHeadMapper, SaleTenderMentoringHead>
implements SaleTenderMentoringHeadService {
    @Autowired
    private SaleTenderMentoringItemService saleTenderMentoringItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private PurchaseTenderMentoringHeadService purchaseTenderMentoringHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    @Lazy
    private InvokeAccountRpcService accountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleTenderMentoringHead saleTenderMentoringHead, List<SaleTenderMentoringItem> saleTenderMentoringItemList, List<SaleAttachmentDTO> attachmentList) {
        this.buildParam(saleTenderMentoringHead);
        saleTenderMentoringHead.setStatus(SaleTenderMentoringStatusEnum.NEW.getValue());
        ((SaleTenderMentoringHeadMapper)this.baseMapper).insert((Object)saleTenderMentoringHead);
        super.setHeadDefaultValue((ParentEntity)saleTenderMentoringHead);
        this.insertData(saleTenderMentoringHead, saleTenderMentoringItemList);
        attachmentList.parallelStream().forEach(attachment -> {
            attachment.setHeadId(saleTenderMentoringHead.getId());
            attachment.setRelationId(((SaleTenderMentoringItem)((Object)((Object)saleTenderMentoringItemList.get(0)))).getId());
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(attachmentList, saleTenderMentoringHead.getId(), saleTenderMentoringHead.getSubpackageId(), saleTenderMentoringHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ANSWER_QUESTIONS_PREFIX.getValue());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleTenderMentoringHead saleTenderMentoringHead, List<SaleTenderMentoringItem> saleTenderMentoringItemList, List<SaleAttachmentDTO> attachmentList) {
        this.buildParam(saleTenderMentoringHead);
        int count = ((SaleTenderMentoringHeadMapper)this.baseMapper).updateById((Object)saleTenderMentoringHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleTenderMentoringItemService.deleteByMainId(saleTenderMentoringHead.getId());
        this.insertData(saleTenderMentoringHead, saleTenderMentoringItemList);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderMentoringHead.getId());
        attachmentList.parallelStream().forEach(attachment -> {
            attachment.setHeadId(saleTenderMentoringHead.getId());
            attachment.setRelationId(((SaleTenderMentoringItem)((Object)((Object)saleTenderMentoringItemList.get(0)))).getId());
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
    }

    private void insertData(SaleTenderMentoringHead saleTenderMentoringHead, List<SaleTenderMentoringItem> saleTenderMentoringItemList) {
        if (!CollectionUtils.isEmpty(saleTenderMentoringItemList)) {
            for (SaleTenderMentoringItem entity : saleTenderMentoringItemList) {
                entity.setTenderProjectId(saleTenderMentoringHead.getTenderProjectId());
                entity.setSubpackageId(saleTenderMentoringHead.getSubpackageId());
                entity.setId(IdWorker.getIdStr());
                entity.setHeadId(saleTenderMentoringHead.getId());
                entity.setResponder(saleTenderMentoringHead.getQuestioner());
                entity.setResponderName(saleTenderMentoringHead.getQuestionerName());
                entity.setResponderType(TenderMentoringResponderTypeEnum.PROPOSER.getValue());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleTenderMentoringHead);
            }
            this.saleTenderMentoringItemService.saveBatch(saleTenderMentoringItemList, 2000);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)this.getById((Serializable)((Object)id)));
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(SaleTenderMentoringItem::getHeadId, (Object)id);
        this.saleTenderMentoringItemService.remove((Wrapper)qw);
        this.removeById((Serializable)((Object)id));
        if (StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getRelationId())) {
            return;
        }
        this.purchaseTenderMentoringHeadService.deleteMain(saleTenderMentoringHead.getRelationId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleTenderMentoringItemService.deleteByMainId(serializable.toString());
            ((SaleTenderMentoringHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void publish(String id) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (String)I18nUtil.translate((String)"i18n_alert_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c!"));
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)((SaleTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        saleTenderMentoringHead.setStatus(SaleTenderMentoringStatusEnum.WAIT_REPLIED.getValue());
        List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        List<SaleTenderMentoringItem> saleTenderMentoringItems = this.saleTenderMentoringItemService.selectByMainId(id);
        this.checkParam(saleTenderMentoringHead, saleTenderMentoringItems);
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = this.purchaseTenderMentoringHeadService.add(saleTenderMentoringHead, saleTenderMentoringItems, saleAttachmentDTOS);
        saleTenderMentoringHead.setRelationId(purchaseTenderMentoringHead.getId());
        ((SaleTenderMentoringHeadMapper)this.baseMapper).updateById((Object)saleTenderMentoringHead);
        if (CollectionUtil.isNotEmpty(saleTenderMentoringItems)) {
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentDTOS, saleTenderMentoringHead.getId(), saleTenderMentoringHead.getSubpackageId(), saleTenderMentoringHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ANSWER_QUESTIONS_PREFIX.getValue());
        }
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)saleTenderMentoringHead.getTenderProjectId())));
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(saleTenderMentoringHead.getTenderProjectId());
        String operation = "proposeMentoring";
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(saleTenderMentoringHead.getCheckType())) {
            operation = "preProposeMentoring";
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(saleTenderMentoringHead.getTenderProjectId()).append("&subpackageId=").append(saleTenderMentoringHead.getSubpackageId());
        Map params = FastJsonUtils.toMap((Object)purchaseTenderMentoringHead);
        params.put("purchaseEnterpriseName", tenderProjectHead.getPurchaseEnterpriseName());
        List collect = accountDTOList.stream().map(ParentEntityDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(saleTenderMentoringHead.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
    }

    @Override
    @SrmTransaction
    public void purchaseReply(PurchaseTenderMentoringHead purchaseTenderMentoringHead, PurchaseTenderMentoringItem purchaseTenderMentoringItem, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)purchaseTenderMentoringHead.getRelationId()), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVKHRvjW_e5feb3d4", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)((SaleTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderMentoringHead.getRelationId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)saleTenderMentoringHead)), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVXVsKW_103fda81", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        saleTenderMentoringHead.setStatus(SaleTenderMentoringStatusEnum.REPLIED.getValue());
        saleTenderMentoringHead.setRelationId(purchaseTenderMentoringHead.getId());
        SaleTenderMentoringItem saleTenderMentoringItem = (SaleTenderMentoringItem)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderMentoringItem), SaleTenderMentoringItem.class));
        saleTenderMentoringItem.setId(IdWorker.getIdStr());
        saleTenderMentoringItem.setHeadId(saleTenderMentoringHead.getId());
        saleTenderMentoringItem.setElsAccount(saleTenderMentoringHead.getElsAccount());
        ((SaleTenderMentoringHeadMapper)this.baseMapper).updateById((Object)saleTenderMentoringHead);
        this.saleTenderMentoringItemService.save((Object)saleTenderMentoringItem);
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            ArrayList saleAttachmentList = SysUtil.copyProperties(purchaseAttachmentList, SaleAttachmentDTO.class);
            saleAttachmentList.parallelStream().forEach(item -> {
                item.setHeadId(saleTenderMentoringItem.getHeadId());
                item.setRelationId(saleTenderMentoringItem.getId());
            });
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn((List)saleAttachmentList);
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentList, saleTenderMentoringItem.getId(), saleTenderMentoringItem.getSubpackageId(), saleTenderMentoringItem.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ANSWER_QUESTIONS_PREFIX.getValue());
        }
    }

    @Override
    @SrmTransaction
    public SaleTenderMentoringItem saleReply(SaleTenderMentoringItemVO saleTenderMentoringItemVO) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringItemVO.getHeadId()), (String)I18nUtil.translate((String)"i18n_alert_eWWxOLV_70d999ff", (String)"\u5934Id\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleTenderMentoringItem saleTenderMentoringItem = (SaleTenderMentoringItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderMentoringItemVO), SaleTenderMentoringItem.class));
        saleTenderMentoringItem.setId(IdWorker.getIdStr());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        saleTenderMentoringItem.setResponder(loginUser.getElsAccount());
        saleTenderMentoringItem.setResponderName(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        saleTenderMentoringItem.setResponderType(TenderMentoringResponderTypeEnum.PROPOSER.getValue());
        this.saleTenderMentoringItemService.save((Object)saleTenderMentoringItem);
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)((SaleTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleTenderMentoringItem.getHeadId())));
        saleTenderMentoringHead.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        ((SaleTenderMentoringHeadMapper)this.baseMapper).updateById((Object)saleTenderMentoringHead);
        List<SaleAttachmentDTO> saleAttachmentList = saleTenderMentoringItemVO.getSaleAttachmentList();
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            saleAttachmentList.parallelStream().forEach(item -> {
                item.setHeadId(saleTenderMentoringItem.getHeadId());
                item.setRelationId(saleTenderMentoringItem.getId());
                item.setUploadElsAccount(loginUser.getElsAccount());
                item.setUploadSubAccount(loginUser.getSubAccount());
            });
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentList);
        }
        this.purchaseTenderMentoringHeadService.saleReply(saleTenderMentoringHead, saleTenderMentoringItem, saleAttachmentList);
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)saleTenderMentoringHead.getTenderProjectId())));
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(saleTenderMentoringHead.getTenderProjectId());
        String operation = "saleReplyMentoring";
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(saleTenderMentoringHead.getCheckType())) {
            operation = "preSaleReplyMentoring";
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(saleTenderMentoringHead.getTenderProjectId()).append("&subpackageId=").append(saleTenderMentoringHead.getSubpackageId());
        Map params = FastJsonUtils.toMap((Object)saleTenderMentoringHead);
        params.put("purchaseEnterpriseName", tenderProjectHead.getPurchaseEnterpriseName());
        List collect = accountDTOList.stream().map(ParentEntityDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(saleTenderMentoringHead.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
        return saleTenderMentoringItem;
    }

    @Override
    public void close(String id) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (String)I18nUtil.translate((String)"i18n_alert_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c!"));
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)((SaleTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        saleTenderMentoringHead.setStatus(SaleTenderMentoringStatusEnum.CLOSE.getValue());
        ((SaleTenderMentoringHeadMapper)this.baseMapper).updateById((Object)saleTenderMentoringHead);
        this.purchaseTenderMentoringHeadService.close(saleTenderMentoringHead.getRelationId());
    }

    @Override
    public SaleTenderMentoringHeadVO queryById(String id) {
        PurchaseTenderMentoringHead mentoringHead;
        SaleTenderMentoringHead saleTenderMentoringHead = (SaleTenderMentoringHead)((Object)this.getById((Serializable)((Object)id)));
        SaleTenderMentoringHeadVO saleTenderMentoringHeadVO = new SaleTenderMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleTenderMentoringHead), (Object)((Object)saleTenderMentoringHeadVO));
        List<SaleTenderMentoringItem> saleTenderMentoringItemList = this.saleTenderMentoringItemService.selectByMainId(id);
        ArrayList saleTenderMentoringItemVOS = SysUtil.copyProperties(saleTenderMentoringItemList, SaleTenderMentoringItemVO.class);
        saleTenderMentoringHeadVO.setPurchaseTenderMentoringItemList(saleTenderMentoringItemVOS);
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleTenderMentoringHeadVO.setAttachmentList(saleAttachmentDTOList);
        if (CollectionUtil.isNotEmpty((Collection)saleAttachmentDTOList)) {
            Map<String, List<SaleAttachmentDTO>> saleAttachmentDTOMap = saleAttachmentDTOList.parallelStream().filter(saleAttachmentDTO -> StrUtil.isBlank((CharSequence)saleAttachmentDTO.getRelationId())).collect(Collectors.groupingBy(SaleAttachmentDTO::getRelationId));
            saleTenderMentoringItemVOS.parallelStream().forEach(item -> {
                List purchaseAttachmentDTOS = (List)saleAttachmentDTOMap.get(item.getId());
                item.setSaleAttachmentList(purchaseAttachmentDTOS);
            });
        }
        if ((mentoringHead = (PurchaseTenderMentoringHead)((Object)this.purchaseTenderMentoringHeadService.getById((Serializable)((Object)saleTenderMentoringHeadVO.getRelationId())))) != null) {
            saleTenderMentoringHeadVO.setBusAccount(mentoringHead.getElsAccount());
        }
        return saleTenderMentoringHeadVO;
    }

    private void buildParam(SaleTenderMentoringHead saleTenderMentoringHead) {
        List tenantList = this.accountRpcService.getTenantList(Arrays.asList(TenantContext.getTenant()));
        saleTenderMentoringHead.setQuestioner(TenantContext.getTenant());
        saleTenderMentoringHead.setQuestionerName(((ElsTenantDTO)tenantList.get(0)).getCompanyName());
        saleTenderMentoringHead.setDeleted(CommonConstant.DEL_FLAG_0);
        saleTenderMentoringHead.setElsAccount(TenantContext.getTenant());
        saleTenderMentoringHead.setMentoringNumber(this.invokeBaseRpcService.getNextCode("mentoringNumber", (Object)saleTenderMentoringHead));
    }

    private void checkParam(SaleTenderMentoringHead saleTenderMentoringHead, List<SaleTenderMentoringItem> saleTenderMentoringItemList) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_alert_YBdIWWxOLVW_cc540f75", (String)"\u62db\u6807\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getTenderProjectName()), (String)I18nUtil.translate((String)"i18n_alert_YBdIRLxOLVW_5b191e2d", (String)"\u62db\u6807\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsWWxOLVW_b61e1b17", (String)"\u5206\u5305Id\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getSubpackageName()), (String)I18nUtil.translate((String)"i18n_alert_zsRLxOLVW_44e329cf", (String)"\u5206\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderMentoringHead.getTitle()), (String)I18nUtil.translate((String)"i18n_alert_BDxOLVW_e6148b40", (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(saleTenderMentoringItemList), (String)I18nUtil.translate((String)"i18n_alert_QDCcxOLVW_6d56bc13", (String)"\u95ee\u9898\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!"));
        saleTenderMentoringItemList.forEach(item -> Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)item.getReplyContent()), (String)I18nUtil.translate((String)"i18n_alert_QDCcxOLVW_6d56bc13", (String)"\u95ee\u9898\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!")));
    }
}

