/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadView;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.vo.SaleTenderPriceOpeningsVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchaseTenderProjectSubpackageInfo"})
@Tag(name="\u91c7\u8d2d\u62db\u6807\u5206\u5305\u9879\u76ee\u5f00\u6807\u57fa\u672c\u4fe1\u606f")
public class PurchaseTenderProjectSubpackageInfoController
extends BaseController<PurchaseTenderProjectSubpackageInfo, PurchaseTenderProjectSubpackageInfoService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectSubpackageInfoController.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService projectSupplierService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectOpenSettingHeadService projectOpenSettingHeadService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @PermissionDataView(businessType="tender")
    public Result<?> queryPageList(PurchaseTenderProjectHeadView purchaseTenderProjectHeadView, HttpServletRequest req, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)purchaseTenderProjectHeadView, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"pro.is_deleted", (Object)0);
        IPage<PurchaseTenderProjectHeadView> pageList = this.subpackageInfoService.projectHeadViewPage((Page<PurchaseTenderProjectHeadView>)page, (QueryWrapper<PurchaseTenderProjectHeadView>)queryWrapper, purchaseTenderProjectHeadView);
        return Result.ok(pageList);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @PermissionDataView(businessType="tender")
    public Result<?> queryTabsCount(PurchaseTenderProjectHeadView purchaseTenderProjectHeadView, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)purchaseTenderProjectHeadView, (Map)req.getParameterMap());
        List<CountVO> result = this.subpackageInfoService.queryTabsCount(TenantContext.getTenant(), (QueryWrapper<PurchaseTenderProjectHeadView>)queryWrapper);
        return Result.ok(result);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2\u5f00\u6807\u4fe1\u606f", description="\u901a\u8fc7id\u67e5\u8be2\u5f00\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderProjectOpenInfoHeadVO tenderProjectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(id);
        return Result.ok((Object)((Object)tenderProjectOpenInfoHeadVO));
    }

    @Operation(summary="\u5f00\u6807", description="\u5f00\u6807")
    @PostMapping(value={"/openBid"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> openBid(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)openInfoHead.getId())));
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
        if (StrUtil.isNotBlank((CharSequence)tenderProjectHead.getOpenBidPassword())) {
            Assert.isTrue((boolean)tenderProjectHead.getOpenBidPassword().equals(openInfoHead.getOpenBidPassword()), (String)I18nUtil.translate((String)"i18n_alert_vBwoNSW_39ff4c49", (String)"\u5f00\u6807\u5bc6\u7801\u9519\u8bef\uff01"), (Object[])new Object[0]);
        }
        if (tenderProjectHead.getBidOpeningLimit() != null) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(TenderProjectSupplier::getSubpackageId, (Object)subpackageInfo.getId());
            lambdaQueryWrapper.eq(TenderProjectSupplier::getEffective, (Object)"1");
            lambdaQueryWrapper.eq(TenderProjectSupplier::getInvalid, (Object)"0");
            List tenderProjectSupplierList = this.projectSupplierService.list((Wrapper)lambdaQueryWrapper);
            long responseNumber = 0L;
            responseNumber = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType()) ? tenderProjectSupplierList.stream().filter(supplier -> "1".equals(supplier.getPreResponseStatus())).count() : tenderProjectSupplierList.stream().filter(supplier -> "1".equals(supplier.getResultResponseStatus())).count();
            Assert.isTrue((responseNumber >= (long)tenderProjectHead.getBidOpeningLimit().intValue() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ddLWxVWxiTvBW_244cc1ff", (String)"\u54cd\u5e94\u4eba\u6570\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u5f00\u6807\uff01"), (Object[])new Object[0]);
        }
        PurchaseOpenSettingHeadVO openSetting = this.projectOpenSettingHeadService.queryBySubpackageId(subpackageInfo.getId());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Assert.isTrue((loginUser.getElsAccount().equals(openSetting.getBidOpenerElsAccount()) && loginUser.getSubAccount().equals(openSetting.getBidOpenerElsSubAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APjDxKvBLxiTtkW_e88d8516", (String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5f00\u6807\u4eba\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"), (Object[])new Object[0]);
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTING.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n__xiTVBvBW_c56fe716", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u5f00\u6807\uff01"), (Object[])new Object[0]);
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u62db\u6807\u4eba " + loginUser.getCompanyName() + " " + loginUser.getRealname() + " \u5ba3\u5e03\u5f00\u6807");
        if (!"1".equals(subpackageInfo.getOpenBidEncrypt())) {
            OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u5f00\u6807\u7ed3\u675f");
        }
        return Result.ok((Object)((Object)openInfoHead));
    }

    @Operation(summary="\u89e3\u5bc6\u7ed3\u675f", description="\u89e3\u5bc6\u7ed3\u675f")
    @PostMapping(value={"/decrypted"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> decrypted(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(openInfoHead.getId());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)openInfoHeadVO), PurchaseTenderProjectSubpackageInfo.class));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setDecryptedSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTED.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n_field_APvBfYzELWWWWWWWxOHcywyWtkW_c1ba3604", (String)"\u5f53\u524d\u5f00\u6807\u5927\u5385\u72b6\u6001\u4e3a[${0}],\u4e0d\u80fd\u8fdb\u884c\u89e3\u5bc6\u7ed3\u675f\u64cd\u4f5c\uff01", (String[])new String[]{PurchaseOpenBidStatusEnum.getOpenBidStatusDesc(openBidStatus)}), (Object[])new Object[0]);
        Assert.isTrue((openInfoHeadVO.getDecryptNumber() == openInfoHeadVO.getFileSubmitNumber() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__QInJLWUywLWxIRWxiTDPyWW_14d17a4f", (String)"\u6587\u4ef6\u9012\u4ea4\u4eba\u6570\u4e0e\u89e3\u5bc6\u4eba\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u524d\u7ed3\u675f\uff01"), (Object[])new Object[0]);
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        TenderJobUtil.deleteOpenBidDecryptAlertJob(openInfoHeadVO);
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u89e3\u5bc6\u73af\u8282\u7ed3\u675f");
        return Result.ok((Object)((Object)openInfoHead));
    }

    @Operation(summary="\u7ed3\u675f\u5f00\u6807", description="\u7ed3\u675f\u5f00\u6807")
    @PostMapping(value={"/endBid"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> endBid(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)openInfoHead.getId())));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setEndBidSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.END_BID.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTED.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n__xiTVByWvBW_e6f10daa", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u7ed3\u675f\u5f00\u6807\uff01"), (Object[])new Object[0]);
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u62db\u6807\u4eba " + loginUser.getCompanyName() + " " + loginUser.getRealname() + " \u5ba3\u5e03\u7ed3\u675f\u5f00\u6807");
        return Result.ok((Object)((Object)openInfoHead));
    }

    @Operation(summary="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868", description="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868")
    @PostMapping(value={"/priceOpeningsBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> getPriceOpeningsBySubpackageId(@RequestParam(name="id") String id) {
        List<SaleTenderPriceOpeningsVO> tenderPriceOpeningsList = this.subpackageInfoService.getPurchasePriceOpeningsById(id);
        return Result.ok(tenderPriceOpeningsList);
    }

    @Operation(summary="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868excel", description="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868")
    @GetMapping(value={"/exportPriceOpenings"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public void exportPriceOpenings(@RequestParam(name="id") String id, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        this.subpackageInfoService.exportPriceOpenings(id, response);
        long end = System.currentTimeMillis();
        log.info("exportPriceOpenings_cost:{}ms", (Object)(end - start));
    }

    @Operation(summary="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868pdf", description="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868pdf")
    @GetMapping(value={"/exportPriceOpeningsPDF"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public void exportPriceOpeningsPDF(@RequestParam(name="id") String id, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        this.subpackageInfoService.exportPriceOpeningsPDF(id, response);
        long end = System.currentTimeMillis();
        log.info("exportPriceOpenings_cost:{}ms", (Object)(end - start));
    }
}

