/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishBiddingAuditCallBackServiceImpl")
public class PublishBiddingAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        String id = flowCallbackDTO.getBusinessId();
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemService.selectByMainId(id);
        List<BiddingSupplier> supplierList = this.biddingSupplierService.selectByMainId(id);
        List<PurchaseBiddingSpecialist> specialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        this.purchaseBiddingHeadService.publish(dbHead, itemList, supplierList, specialistList, demandList, new ArrayList<PurchaseAttachmentDTO>());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseBiddingHeadService.updateById((Object)updateHead);
    }
}

