/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.adapter;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@RpcService(value="purchaseRequestAuditDubboAdapter")
public class PurchaseRequestAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseRequestHeadVO headVO = new PurchaseRequestHeadVO();
        PurchaseRequestHead byId = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)headVO));
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        headVO.setPurchaseRequestItemList(purchaseRequestItems);
        this.checkParams(headVO);
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private void checkParams(PurchaseRequestHeadVO requestHead) {
        Assert.notEmpty(requestHead.getPurchaseRequestItemList(), (String)I18nUtil.translate((String)"i18n_alert_empty_addLine", (String)"\u8bf7\u6dfb\u52a0\u884c\u9879\u76ee"));
        requestHead.getPurchaseRequestItemList().forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cTVWRlTfUQ_49d1f2c", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)item.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_cXjnRVRxOLVWVKItbWsLDWSNVRGRsLDRHIdjRKVRW_306d9a1f", (String)"\u884c\u4e0a\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u4e2d\u7ef4\u62a4,\u6216\u8005\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u5173\u8054\u7ec4\u7ec7!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)item.getCompany()), (String)I18nUtil.translate((String)"i18n_alert_cXjRCooxOLVWVKVRGRsLDRHIdjXtESVRW_c851671b", (String)"\u884c\u4e0a\u7684\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7!"));
        });
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        this.purchaseRequestHeadService.toDemandPool(flowCallbackDTO.getBusinessId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
        String businessId = flowCallbackDTO.getBusinessId();
        this.budgetManageRpcService.refundOfOccupiedAmount(businessId);
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)businessId)));
        this.purchaseRequestHeadService.updateById((Object)purchaseRequestHead);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseRequestHead head = (PurchaseRequestHead)((Object)this.purchaseRequestHeadMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseRequestHead head = new PurchaseRequestHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseRequestHeadMapper.updateById((Object)head);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            purchaseRequestItems.forEach(item -> {
                item.setAuditStatus(auditStatus);
                item.setFlowId(flowCallbackDTO.getProcessInstanceId());
            });
            this.purchaseRequestItemService.updateBatchById(purchaseRequestItems);
        }
    }
}

