/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="saleEnquiryItemLpExcelServiceImpl")
public class SaleEnquiryItemLpExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleEnquiryItemLpExcelServiceImpl.class);
    @Autowired
    private SaleEnquiryHeadLpService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemLpService saleEnquiryItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StrUtil.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
        if (dbHead == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        List elsInitialTableDTOS = this.invokeBaseRpcService.getInitTableListByRelationId(dbHead.getRelationId());
        ArrayList<SaleEnquiryItemLp> itemList = new ArrayList<SaleEnquiryItemLp>();
        for (ElsInitialTableDTO table : elsInitialTableDTOS) {
            SaleEnquiryItemLp item = (SaleEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), SaleEnquiryItemLp.class));
            itemList.add(item);
        }
        return new ArrayList<Object>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList oldList = new ArrayList();
        for (Map data : dataList) {
            oldList.add(new HashMap(data));
            if (data.get("quotePrice") == null || !"0".equals(data.get("quotePrice").toString())) continue;
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                if ("itemNumber".equals(key) || "quotePrice".equals(key)) continue;
                data.put((String)entry.getKey(), null);
            }
        }
        List quotePriceList = null;
        Map costPriceMap = null;
        if (((Map)dataList.get(dataList.size() - 1)).get("otherSheetList") != null) {
            quotePriceList = (List)((Map)dataList.get(dataList.size() - 1)).get("otherSheetList");
            dataList.remove(dataList.size() - 1);
            oldList.remove(oldList.size() - 1);
            if (((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice") != null) {
                costPriceMap = (Map)((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice");
                quotePriceList.remove(quotePriceList.size() - 1);
            }
        }
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)this.headId)));
        List<SaleEnquiryItemLp> dbItemList = this.saleEnquiryItemService.selectByMainId(this.headId);
        List<String> excludeColumn = Arrays.asList("price", "netPrice", "taxCode", "taxRate");
        TemplateHeadDTO template = this.getTemplate(excelImportDTO.getExcelByConfigDTO());
        Map editColumnMap = template.getTemplateConfigItemList().stream().filter(item -> !excludeColumn.contains(item.getFieldName())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, Function.identity(), (v1, v2) -> v2));
        List editColumn = template.getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleEdit())).map(TemplateConfigItemDTO::getFieldName).filter(s -> !excludeColumn.contains(s)).collect(Collectors.toList());
        if ("1".equals(dbHead.getSupplierTaxRate())) {
            editColumn.add("taxCode");
        }
        if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            editColumn.add("netPrice");
        } else {
            editColumn.add("price");
        }
        Map taxMap = this.invokeBaseRpcService.getAllTax(dbHead.getToElsAccount());
        Iterator iterator = dataList.iterator();
        Iterator oldIterator = oldList.iterator();
        while (iterator.hasNext()) {
            String taxCode;
            List list;
            Map data = (Map)iterator.next();
            Map errorData = (Map)oldIterator.next();
            boolean flag = this.checkDisableConfigItemData(excelImportDTO, iterator, editColumnMap, editColumn, errorData);
            if (!flag || CollectionUtil.isEmpty(list = dbItemList.stream().filter(s -> s.getItemNumber().equals(data.get("itemNumber"))).collect(Collectors.toList()))) continue;
            SaleEnquiryItemLp dbItem = (SaleEnquiryItemLp)((Object)list.get(0));
            BigDecimal taxRate = BigDecimal.ONE;
            if (dbItem != null && !StrUtil.isBlank((CharSequence)dbItem.getTaxRate())) {
                taxRate = new BigDecimal(dbItem.getTaxRate());
            }
            Integer requireQuantity = dbItem.getRequireQuantity() != null ? dbItem.getRequireQuantity().intValue() : 1;
            for (Map.Entry entry : data.entrySet()) {
                if (!editColumn.contains(entry.getKey())) {
                    data.put((String)entry.getKey(), null);
                    continue;
                }
                data.put((String)entry.getKey(), entry.getValue());
            }
            if (!EnquiryQuoteWayEnum.NORMAL.getValue().equals(dbItem.getQuotePriceWay())) {
                data.put("price", null);
                data.put("netPrice", null);
            }
            if (StrUtil.isNotBlank((CharSequence)(taxCode = (String)data.get("taxCode")))) {
                if (!taxMap.containsKey(taxCode)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    iterator.remove();
                    continue;
                }
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(dbItem.getQuotePriceWay()) && quotePriceList != null) {
                List<Map> newQuotePriceList = quotePriceList.stream().filter(info -> dbItem.getItemNumber().equals(info.get("itemNumber"))).collect(Collectors.toList());
                BigDecimal finalTaxRate = taxRate;
                newQuotePriceList.forEach(info -> {
                    if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("netPrice") != null) {
                        BigDecimal temp = finalTaxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        BigDecimal result = new BigDecimal("" + info.get("netPrice")).multiply(temp);
                        result = result.setScale(6, 4);
                        info.put("price", result);
                    } else if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("price") != null) {
                        BigDecimal temp = finalTaxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        BigDecimal result = new BigDecimal("" + info.get("price")).multiply(temp);
                        result = result.setScale(6, 4);
                        info.put("netPrice", result);
                    }
                });
                data.put("ladderPriceJson", JSONArray.toJSONString(newQuotePriceList));
                data.put("price", ((Map)newQuotePriceList.get(0)).get("price"));
                data.put("netPrice", ((Map)newQuotePriceList.get(0)).get("netPrice"));
                Float netAmount = Float.valueOf(Float.valueOf("" + ((Map)newQuotePriceList.get(0)).get("netPrice")).floatValue() * (float)requireQuantity.intValue());
                Float taxAmount = Float.valueOf(Float.valueOf("" + ((Map)newQuotePriceList.get(0)).get("price")).floatValue() * (float)requireQuantity.intValue());
                data.put("netAmount", String.format("%.6f", netAmount));
                data.put("taxAmount", String.format("%.6f", taxAmount));
                continue;
            }
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(dbItem.getQuotePriceWay()) || quotePriceList == null) continue;
            List costList = (List)costPriceMap.get(dbItem.getMaterialNumber());
            Map<Object, List<Map>> groupList = costList.stream().collect(Collectors.groupingBy(a -> a.get("groupName")));
            JSONObject costJson = JSONObject.parseObject((String)dbItem.getCostFormJson());
            HashMap<Object, Object> newCostJson = new HashMap<Object, Object>();
            for (Map.Entry<Object, List<Map>> map : groupList.entrySet()) {
                if (map.getValue().size() == 1) {
                    newCostJson.put(map.getKey(), map.getValue().get(0));
                    continue;
                }
                newCostJson.put(map.getKey(), map.getValue());
            }
            String newDataJsonStr = JSONObject.toJSONString(newCostJson);
            costJson.put("data", JSONObject.parse((String)newDataJsonStr));
            data.put("costFormJson", JSONObject.toJSONString((Object)costJson));
        }
        this.errorHandle(true, excelImportDTO, SysUtil.getLoginUser().getElsAccount(), totalCount);
        return dataList;
    }
}

