/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassify;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseBaseMaterialPriceStatusEnum;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseManagementClassifyStatusEnum;
import com.els.modules.priceEvaluationManagement.mapper.PurchaseManagementClassifyMapper;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseManagementClassifyServiceImpl
extends BaseServiceImpl<PurchaseManagementClassifyMapper, PurchaseManagementClassify>
implements PurchaseManagementClassifyService {
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void add(PurchaseManagementClassify purchaseManagementClassify) {
        purchaseManagementClassify.setDocumentNumber(this.baseRpcService.getNextCode("purchaseManagementClassifyNumber", (Object)purchaseManagementClassify));
        ((PurchaseManagementClassifyMapper)this.baseMapper).insert((Object)purchaseManagementClassify);
    }

    @Override
    public void edit(PurchaseManagementClassify purchaseManagementClassify) {
        int count = ((PurchaseManagementClassifyMapper)this.baseMapper).updateById((Object)purchaseManagementClassify);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseManagementClassifyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseManagementClassifyMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void submit(PurchaseManagementClassify purchaseManagementClassify) {
        PurchaseManagementClassify managementClassify = new PurchaseManagementClassify();
        PurchaseManagementClassify dbPurchaseManagementClassify = (PurchaseManagementClassify)((Object)this.getById((Serializable)((Object)purchaseManagementClassify.getId())));
        managementClassify.setDocumentStatus(PurchaseBaseMaterialPriceStatusEnum.START.getValue());
        managementClassify.setId(purchaseManagementClassify.getId());
        managementClassify.setDataVersion(dbPurchaseManagementClassify.getDataVersion());
        int count = ((PurchaseManagementClassifyMapper)this.baseMapper).updateById((Object)managementClassify);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void start(PurchaseManagementClassify purchaseManagementClassify) {
        PurchaseManagementClassify dbManagementClassify = (PurchaseManagementClassify)((Object)((PurchaseManagementClassifyMapper)this.baseMapper).selectById((Serializable)((Object)purchaseManagementClassify.getId())));
        if (dbManagementClassify == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        String documentStatus = PurchaseManagementClassifyStatusEnum.START.getValue().equals(dbManagementClassify.getDocumentStatus()) ? PurchaseManagementClassifyStatusEnum.NOT.getValue() : PurchaseManagementClassifyStatusEnum.START.getValue();
        PurchaseManagementClassify managementClassify = new PurchaseManagementClassify();
        managementClassify.setDocumentStatus(documentStatus);
        managementClassify.setId(purchaseManagementClassify.getId());
        managementClassify.setDataVersion(purchaseManagementClassify.getDataVersion());
        int count = ((PurchaseManagementClassifyMapper)this.baseMapper).updateById((Object)managementClassify);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }
}

