/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageHead;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageItem;
import com.els.modules.tender.abnormal.enumerate.SubpackageTerminateHeadStatusEnum;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageHeadService;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageItemService;
import com.els.modules.tender.abnormal.vo.PurchaseTenderAgainSubpackageHeadVO;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="tenderAgainSubpackageAdapterCallBackServiceImpl")
public class TenderAgainSubpackageHeadAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseTenderAgainSubpackageHeadService tenderAgainSubpackageHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderAgainSubpackageItemService tenderAgainSubpackageItemService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderAgainSubpackageHead head = (PurchaseTenderAgainSubpackageHead)((Object)this.tenderAgainSubpackageHeadService.getBaseMapper().selectById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseTenderAgainSubpackageHeadVO headVO = new PurchaseTenderAgainSubpackageHeadVO();
            List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList = this.tenderAgainSubpackageItemService.selectByMainId(id);
            headVO.setPurchaseTenderAgainSubpackageItemList(purchaseTenderAgainSubpackageItemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderAgainSubpackageHead againSubpackageHead = (PurchaseTenderAgainSubpackageHead)((Object)this.tenderAgainSubpackageHeadService.getBaseMapper().selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        againSubpackageHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList = this.tenderAgainSubpackageItemService.selectByMainId(againSubpackageHead.getId());
            againSubpackageHead.setStatus(SubpackageTerminateHeadStatusEnum.AUDIT_YES.getValue());
            againSubpackageHead.setAuditStatus(auditStatus);
            this.tenderAgainSubpackageHeadService.publish(againSubpackageHead, purchaseTenderAgainSubpackageItemList);
            return;
        }
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(auditStatus)) {
            againSubpackageHead.setStatus(SubpackageTerminateHeadStatusEnum.AUDIT.getValue());
        } else {
            againSubpackageHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        }
        againSubpackageHead.setAuditStatus(auditStatus);
        this.tenderAgainSubpackageHeadService.updateById((Object)againSubpackageHead);
    }
}

