/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.approval.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.entity.TenderProjectApprovalItem;
import com.els.modules.tender.approval.enumerate.TenderProjectApprovalStateEnum;
import com.els.modules.tender.approval.mapper.TenderProjectApprovalHeadMapper;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.modules.tender.approval.service.TenderProjectApprovalItemService;
import com.els.modules.tender.approval.vo.TenderProjectApprovalHeadVO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderProjectApprovalHeadServiceImpl
extends BaseServiceImpl<TenderProjectApprovalHeadMapper, TenderProjectApprovalHead>
implements TenderProjectApprovalHeadService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TenderProjectApprovalItemService tenderProjectApprovalItemService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderProjectApprovalHead tenderProjectApprovalHead, List<TenderProjectApprovalItem> approvalItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        super.setHeadDefaultValue((ParentEntity)tenderProjectApprovalHead);
        tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.NEW.getValue());
        tenderProjectApprovalHead.setSourceType(StrUtil.isNotBlank((CharSequence)tenderProjectApprovalHead.getSourceType()) ? tenderProjectApprovalHead.getSourceType() : SourceTypeEnum.MANUAL.getValue());
        tenderProjectApprovalHead.setProjectNumber(this.invokeBaseRpcService.getNextCode("tenderProjectApprovalNumber", (Object)tenderProjectApprovalHead));
        tenderProjectApprovalHead.setDeleted(Integer.valueOf("0"));
        if ("0".equals(tenderProjectApprovalHead.getAudited())) {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        ((TenderProjectApprovalHeadMapper)this.baseMapper).insert((Object)tenderProjectApprovalHead);
        this.insertData(tenderProjectApprovalHead, approvalItemList, purchaseAttachmentList);
        this.goBackDemand(approvalItemList, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue(), false);
    }

    private void goBackDemand(List<TenderProjectApprovalItem> approvalItemList, String status, boolean filter) {
        List<String> idList = approvalItemList.stream().filter(o -> SourceTypeEnum.REQUEST.getValue().equals(o.getSourceType())).filter(o -> StrUtil.isNotBlank((CharSequence)o.getId())).map(TenderProjectApprovalItem::getSourceItemId).collect(Collectors.toList());
        if (!idList.isEmpty()) {
            ArrayList<String> idList1 = new ArrayList<String>();
            idList.forEach(str -> idList1.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            if (filter) {
                List requestItemList = this.purchaseRequestItemService.getBaseMapper().selectBatchIds(idList1);
                idList = requestItemList.stream().filter(o -> PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue().equals(o.getItemStatus())).map(ParentEntity::getId).collect(Collectors.toList());
                this.purchaseRequestItemService.updateStatusById(idList, status);
            } else {
                this.purchaseRequestItemService.updateStatusById(idList1, status);
            }
        }
    }

    private void insertData(TenderProjectApprovalHead tenderProjectApprovalHead, List<TenderProjectApprovalItem> approvalItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (CollectionUtil.isNotEmpty(approvalItemList)) {
            int itemNumber = 1;
            for (TenderProjectApprovalItem tenderProjectApprovalItem : approvalItemList) {
                tenderProjectApprovalItem.setHeadId(tenderProjectApprovalHead.getId());
                tenderProjectApprovalItem.setDeleted(CommonConstant.DEL_FLAG_0);
                tenderProjectApprovalItem.setItemStatus("0");
                tenderProjectApprovalItem.setProjectNumber(tenderProjectApprovalHead.getProjectNumber());
                tenderProjectApprovalItem.setItemNumber("" + ++itemNumber);
                SysUtil.setSysParam((BaseEntity)tenderProjectApprovalItem, (BaseEntity)tenderProjectApprovalHead);
            }
            this.tenderProjectApprovalItemService.deleteByMainId(tenderProjectApprovalHead.getId());
            this.tenderProjectApprovalItemService.saveBatch(approvalItemList);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderProjectApprovalHead.getId());
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            purchaseAttachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectApprovalHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderProjectApprovalHead tenderProjectApprovalHead, List<TenderProjectApprovalItem> approvalItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("0".equals(tenderProjectApprovalHead.getAudited())) {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        int count = ((TenderProjectApprovalHeadMapper)this.baseMapper).updateById((Object)tenderProjectApprovalHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(tenderProjectApprovalHead, approvalItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void replenish(TenderProjectApprovalHead tenderProjectApprovalHead, List<TenderProjectApprovalItem> approvalItemList) {
        int itemNumber = 1;
        for (TenderProjectApprovalItem tenderProjectApprovalItem : approvalItemList) {
            tenderProjectApprovalItem.setHeadId(tenderProjectApprovalHead.getId());
            tenderProjectApprovalItem.setDeleted(CommonConstant.DEL_FLAG_0);
            if (StrUtil.isBlank((CharSequence)tenderProjectApprovalItem.getItemStatus())) {
                tenderProjectApprovalItem.setItemStatus("0");
            }
            tenderProjectApprovalItem.setProjectNumber(tenderProjectApprovalHead.getProjectNumber());
            tenderProjectApprovalItem.setItemNumber("" + ++itemNumber);
            SysUtil.setSysParam((BaseEntity)tenderProjectApprovalItem, (BaseEntity)tenderProjectApprovalHead);
        }
        this.tenderProjectApprovalItemService.deleteByMainId(tenderProjectApprovalHead.getId());
        this.tenderProjectApprovalItemService.saveBatch(approvalItemList);
    }

    @Override
    public TenderProjectApprovalHeadVO queryById(String id) {
        TenderProjectApprovalHeadVO tenderProjectApprovalHeadVO = new TenderProjectApprovalHeadVO();
        TenderProjectApprovalHead projectApprovalHead = (TenderProjectApprovalHead)((Object)((TenderProjectApprovalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)projectApprovalHead), (Object)((Object)tenderProjectApprovalHeadVO));
        List<TenderProjectApprovalItem> approvalHeadItemList = this.tenderProjectApprovalItemService.selectByMainId(id);
        tenderProjectApprovalHeadVO.setApprovalItemList(approvalHeadItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        tenderProjectApprovalHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return tenderProjectApprovalHeadVO;
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount, QueryWrapper<TenderProjectApprovalHead> queryWrapper) {
        return ((TenderProjectApprovalHeadMapper)this.baseMapper).queryTabsCount(elsAccount, queryWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        List<TenderProjectApprovalItem> approvalItemList = this.tenderProjectApprovalItemService.selectByMainId(id);
        this.goBackDemand(approvalItemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue(), false);
        ((TenderProjectApprovalHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.tenderProjectApprovalItemService.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (String id : idList) {
            this.deleteMain(id);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void abandonStatus(TenderProjectApprovalHead tenderProjectApprovalHead) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)tenderProjectApprovalHead.getId())).set((Object)"source_status", (Object)TenderProjectApprovalStateEnum.CANCELLATION.getValue());
        ((TenderProjectApprovalHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        List<TenderProjectApprovalItem> approvalItemList = this.tenderProjectApprovalItemService.selectByMainId(tenderProjectApprovalHead.getId());
        this.goBackDemand(approvalItemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue(), true);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void goBackDemandPool(TenderProjectApprovalHead tenderProjectApprovalHead) {
        this.abandonStatus(tenderProjectApprovalHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        TenderProjectApprovalHead projectApprovalHead = (TenderProjectApprovalHead)((Object)this.getById((Serializable)((Object)id)));
        this.checkAndSetParam(projectApprovalHead);
        projectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.ISSUE.getValue());
        this.updateById((Object)projectApprovalHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentList, id, null, null, TenderProjectArchiveAttachmentEnum.PROJECT_APPROVAL_PREFIX.getValue());
    }

    private void checkAndSetParam(TenderProjectApprovalHead tenderProjectApprovalHead) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectApprovalHead.getProjectType()), (String)I18nUtil.translate((String)"i18n_import_dIAcxOLVW_ee21a94c", (String)"\u9879\u76ee\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectApprovalHead.getPurchaseOrgType()), (String)I18nUtil.translate((String)"i18n_import_YBVRcKxOLVW_a5049835", (String)"\u62db\u6807\u7ec4\u7ec7\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectApprovalHead.getProjectContacts()), (String)I18nUtil.translate((String)"i18n_import_dIKHLxOLVW_628aa8f3", (String)"\u9879\u76ee\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectApprovalHead.getContactsNumber()), (String)I18nUtil.translate((String)"i18n_import_KHCExOLVW_28acbba2", (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
    }
}

