/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectMember;
import com.els.modules.tender.project.mapper.PurchaseTenderProjectMemberMapper;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectMemberService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectMemberServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectMemberMapper, PurchaseTenderProjectMember>
implements PurchaseTenderProjectMemberService {
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @Override
    public void batchAdd(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectMember> purchaseTenderProjectMemberList) {
        ((PurchaseTenderProjectMemberMapper)this.baseMapper).deleteByMainId(purchaseTenderProjectHead.getId());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Assert.isTrue((loginUser.getElsAccount().equals(purchaseTenderProjectHead.getPurchaseExecutorAccount()) && loginUser.getSubAccount().equals(purchaseTenderProjectHead.getPurchaseExecutorSubAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APeyBjbWtkW_413583d2", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectMemberList)) {
            purchaseTenderProjectMemberList.stream().forEach(purchaseTenderProjectMember -> {
                Assert.hasText((String)purchaseTenderProjectMember.getHeadId(), (String)I18nUtil.translate((String)"i18n_alert_YBdIWWxOLVW_cc540f75", (String)"\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                Assert.hasText((String)purchaseTenderProjectMember.getSubAccount(), (String)I18nUtil.translate((String)"i18n_field_eyxOLVW_7840a400", (String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                Assert.hasText((String)purchaseTenderProjectMember.getMemberType(), (String)I18nUtil.translate((String)"i18n_field_LjAcxOLVW_e8c00339", (String)"\u6210\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                Assert.hasText((String)purchaseTenderProjectMember.getMemberRole(), (String)I18nUtil.translate((String)"i18n_field_LjKyxOLVW_c9ba00c9", (String)"\u6210\u5458\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                purchaseTenderProjectMember.setElsAccount(loginUser.getElsAccount());
            });
        }
        this.saveOrUpdateBatch(purchaseTenderProjectMemberList);
    }

    @Override
    public List<PurchaseTenderProjectMember> selectByMainId(String headId) {
        return ((PurchaseTenderProjectMemberMapper)this.baseMapper).selectByMainId(headId);
    }

    @Override
    public void delete(String id) {
        PurchaseTenderProjectMember purchaseTenderProjectMember = (PurchaseTenderProjectMember)((Object)((PurchaseTenderProjectMemberMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)purchaseTenderProjectMember), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)purchaseTenderProjectMember.getHeadId())));
        Assert.notNull((Object)((Object)projectHead), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Assert.isTrue((loginUser.getElsAccount().equals(projectHead.getPurchaseExecutorAccount()) && loginUser.getSubAccount().equals(projectHead.getPurchaseExecutorSubAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        ((PurchaseTenderProjectMemberMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public boolean checkProjectMemberPermission(String projectId) {
        Map<String, List<PurchaseTenderProjectMember>> memberMaps;
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)projectId)));
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        String loginUserAccount = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
        if (loginUserAccount.equals(tenderProjectHead.getPurchaseExecutorAccount() + "_" + tenderProjectHead.getPurchaseExecutorSubAccount())) {
            return true;
        }
        List<PurchaseTenderProjectMember> tenderProjectMembers = this.selectByMainId(projectId);
        return CollectionUtil.isNotEmpty(tenderProjectMembers) && (memberMaps = tenderProjectMembers.stream().collect(Collectors.groupingBy(x -> x.getElsAccount() + "_" + x.getSubAccount()))).containsKey(loginUserAccount);
    }
}

