/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.BiddingEvaluationRegulation;
import com.els.modules.bidding.entity.BiddingEvaluationRegulationSelection;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateItemMapper;
import com.els.modules.bidding.service.BiddingEvaluationRegulationSelectionService;
import com.els.modules.bidding.service.BiddingEvaluationRegulationService;
import com.els.modules.bidding.vo.BiddingEvaluationRegulationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/biddingEvaluationRegulation"})
@Tag(name="\u8bc4\u6807\u6761\u4f8b")
public class BiddingEvaluationRegulationController
extends BaseController<BiddingEvaluationRegulation, BiddingEvaluationRegulationService> {
    @Autowired
    private BiddingEvaluationRegulationService biddingEvaluationRegulationService;
    @Autowired
    private BiddingEvaluationRegulationSelectionService biddingEvaluationRegulationSelectionService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BiddingEvaluationTemplateItemMapper biddingEvaluationTemplateItemMapper;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="biddingEvaluationRegulation")
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:list"})
    public Result<?> queryPageList(BiddingEvaluationRegulation biddingEvaluationRegulation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)biddingEvaluationRegulation), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.biddingEvaluationRegulationService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords() != null) {
            List regulations = pageList.getRecords();
            for (BiddingEvaluationRegulation regulation : regulations) {
                int count = this.biddingEvaluationTemplateItemMapper.getByReluationId(regulation.getId(), TenantContext.getTenant());
                if (count <= 0) continue;
                regulation.setUsed("1");
            }
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:add"})
    public Result<?> add(@RequestBody BiddingEvaluationRegulationVO biddingEvaluationRegulationPage) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = new BiddingEvaluationRegulation();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulationPage), (Object)((Object)biddingEvaluationRegulation));
        this.biddingEvaluationRegulationService.saveMain(biddingEvaluationRegulation, biddingEvaluationRegulationPage.getBiddingEvaluationRegulationSelectionList(), biddingEvaluationRegulationPage.getAttachmentList());
        return Result.ok((Object)((Object)biddingEvaluationRegulation));
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u7f16\u8f91", operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:edit"})
    public Result<?> edit(@RequestBody BiddingEvaluationRegulationVO biddingEvaluationRegulationPage) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = new BiddingEvaluationRegulation();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulationPage), (Object)((Object)biddingEvaluationRegulation));
        this.biddingEvaluationRegulationService.updateMain(biddingEvaluationRegulation, biddingEvaluationRegulationPage.getBiddingEvaluationRegulationSelectionList(), biddingEvaluationRegulationPage.getAttachmentList());
        return Result.ok((Object)((Object)this.getBiddingEvaluationRegulationById(biddingEvaluationRegulation.getId())));
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.biddingEvaluationRegulationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u6279\u91cf\u5220\u9664", operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.biddingEvaluationRegulationService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BiddingEvaluationRegulationVO biddingEvaluationRegulationVO = this.getBiddingEvaluationRegulationById(id);
        return Result.ok((Object)((Object)biddingEvaluationRegulationVO));
    }

    private BiddingEvaluationRegulationVO getBiddingEvaluationRegulationById(String id) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = (BiddingEvaluationRegulation)((Object)this.biddingEvaluationRegulationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BiddingEvaluationRegulationVO biddingEvaluationRegulationVO = new BiddingEvaluationRegulationVO();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulation), (Object)((Object)biddingEvaluationRegulationVO));
        List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList = this.biddingEvaluationRegulationSelectionService.selectByMainId(id);
        biddingEvaluationRegulationVO.setBiddingEvaluationRegulationSelectionList(biddingEvaluationRegulationSelectionList);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        biddingEvaluationRegulationVO.setAttachmentList(attachments);
        return biddingEvaluationRegulationVO;
    }

    @Operation(summary="\u901a\u8fc7\u8bc4\u6807\u6761\u4f8bid\u67e5\u8be2\u8bc4\u6807\u6761\u4f8b\u9009\u9879", description="\u901a\u8fc7\u8bc4\u6807\u6761\u4f8bid\u67e5\u8be2\u8bc4\u6807\u6761\u4f8b\u9009\u9879")
    @GetMapping(value={"/queryBiddingEvaluationRegulationSelectionByMainId"})
    @RequiresPermissions(value={"bidding#biddingEvaluationRegulation:queryById"})
    public Result<?> queryBiddingEvaluationRegulationSelectionListByMainId(@RequestParam(name="id") String id) {
        List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList = this.biddingEvaluationRegulationSelectionService.selectByMainId(id);
        return Result.ok(biddingEvaluationRegulationSelectionList);
    }
}

