/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingNotice;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingProjectSubpackage;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingNoticeService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.utils.RequestItemUtils;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingProjectHead"})
@Tag(name="\u62db\u6807\u9879\u76ee\u5934")
@BusinessModule(module="biddingProject")
public class PurchaseBiddingProjectHeadController
extends BaseController<PurchaseBiddingProjectHead, PurchaseBiddingProjectHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseBiddingProjectHeadController.class);
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseBiddingNoticeService purchaseBiddingNoticeService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private RequestItemUtils requestItemUtils;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SearSourMaterValidService validService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryPageList(PurchaseBiddingProjectHead purchaseBiddingProjectHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingProjectHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/subpackage/list"})
    @PermissionDataView(businessType="biddingProject")
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    public Result<?> queryProjectSubpackagePageList(PurchaseBiddingProjectSubpackage projectSubpackage, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StrUtil.isNotBlank((CharSequence)projectSubpackage.getId())) {
            ids = projectSubpackage.getId().replace(" ", "").split(",");
            projectSubpackage.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)projectSubpackage, (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.eq((Object)"subpackage.create_type", (Object)"project");
        queryWrapper.eq((Object)"subpackage.is_deleted", (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseBiddingProjectSubpackage> pageList = this.purchaseBiddingHeadService.queryProjectSubpackagePageList((Page<PurchaseBiddingProjectSubpackage>)page, projectSubpackage, (QueryWrapper<PurchaseBiddingProjectSubpackage>)queryWrapper);
        return Result.ok(pageList);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/subpackage/counts"})
    @PermissionDataView(businessType="biddingProject")
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    public Result<?> queryTabsCount(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StrUtil.isNotBlank((CharSequence)purchaseBiddingHead.getId())) {
            ids = purchaseBiddingHead.getId().replace(" ", "").split(",");
            purchaseBiddingHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"create_type", (Object)"project");
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select((Object[])new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = this.purchaseBiddingHeadService.list((Wrapper)queryWrapper);
        Map<String, Long> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Long all = 0L;
        for (Map.Entry<String, Long> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all.longValue()));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmProjectBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Long total = countMap.get(status.getValue()) == null ? 0L : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingProjectStatus", status.getValue(), total.longValue()));
        }
        return Result.ok(result);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryTabsCount(PurchaseBiddingProjectHead purchaseBiddingProjectHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StrUtil.isNotBlank((CharSequence)purchaseBiddingProjectHead.getId())) {
            ids = purchaseBiddingProjectHead.getId().replace(" ", "").split(",");
            purchaseBiddingProjectHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select((Object[])new String[]{"project_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"project_status");
        List list = ((PurchaseBiddingProjectHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingProjectHead::getProjectStatus, PurchaseBiddingProjectHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "project_status", null, (long)all.intValue()));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:add"})
    @SrmValidated
    public Result<?> add(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.saveMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        return Result.ok((Object)((Object)purchaseBiddingProjectHead));
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:edit"})
    public Result<?> edit(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.updateMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        String id = purchaseBiddingProjectHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingProjectHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBiddingProjectHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(id);
        return Result.ok((Object)((Object)purchaseBiddingProjectHeadVO));
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:publish"})
    @SrmValidated
    public Result<?> publish(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        this.purchaseBiddingProjectHeadService.publishBiddingProject(purchaseBiddingProjectHeadPage.getId());
        return Result.ok((Object)3);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f", description="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingHeadByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingHeadListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        purchaseBiddingHeadList.parallelStream().forEach(item -> item.setBiddingProjectStatus(item.getBiddingStatus()));
        return Result.ok((Object)purchaseBiddingHeadList);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f", description="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingItemByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingItemListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingItemList);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a", description="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a")
    @GetMapping(value={"/queryPurchaseBiddingNoticeByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingNoticeListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingNoticeList);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6", description="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6")
    @GetMapping(value={"/queryPurchaseBiddingSpecialistByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingSpecialistListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingSpecialistList);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546", description="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546")
    @GetMapping(value={"/querybiddingSupplierByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> querybiddingSupplierListByMainId(@RequestParam(name="id") String id) {
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        return Result.ok((Object)biddingSupplierList);
    }

    @Operation(summary="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236", description="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236")
    @PostMapping(value={"/copyData"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:copyData"})
    public Result<?> copyData(@RequestBody PurchaseBiddingProjectHead purchaseBiddingProjectHead) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(purchaseBiddingProjectHead.getId());
        purchaseBiddingProjectHeadVO.setFlowId(null);
        purchaseBiddingProjectHeadVO.setResultFlowId(null);
        this.purchaseBiddingProjectHeadService.copyData(purchaseBiddingProjectHeadVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u7ba1\u7406", value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305")
    @Operation(summary="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305", description="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305")
    @PostMapping(value={"/requestToBiddingProject"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:requestToBiddingProject"})
    public Result<?> requestToBidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String flag;
        this.requestItemUtils.validRequestItemStatus(requestHeadVO.getPurchaseRequestItemList());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject companySet = ((BaseRpcService)SrmRpcUtil.getExecuteServiceImpl(BaseRpcService.class)).getParamObj(loginUser.getElsAccount());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        boolean allowMultipleSources = false;
        if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
            allowMultipleSources = true;
        }
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseBiddingProjectHead head = new PurchaseBiddingProjectHead();
        head.setId(IdWorker.getIdStr());
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        head.setProjectStatus("0");
        ArrayList<PurchaseBiddingHead> headList = new ArrayList<PurchaseBiddingHead>();
        PurchaseBiddingHead biddingHead = new PurchaseBiddingHead();
        biddingHead.setId(IdWorker.getIdStr());
        biddingHead.setProjectId(head.getId());
        biddingHead.setCreateType("project");
        headList.add(biddingHead);
        ArrayList<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List collect1 = requestItemList.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        List purchaseRequestItemDb = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(ParentEntity::getId, collect1)).list();
        ArrayList<PurchaseRequestItem> purchaseRequestItems = new ArrayList<PurchaseRequestItem>();
        block0: for (PurchaseRequestItem item2 : requestItemList) {
            for (Object item1 : purchaseRequestItemDb) {
                if (!Objects.equals(item2.getId(), item1.getId())) continue;
                purchaseRequestItems.add((PurchaseRequestItem)((Object)item1));
                continue block0;
            }
        }
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("2", ((PurchaseRequestItem)((Object)purchaseRequestItems.get(0))).getPurchaseOrg(), purchaseRequestItems);
        List<PurchaseRequestItem> mergeRequestList = this.purchaseRequestItemService.mergeRequest(purchaseRequestItems);
        Map<String, String> itemValueMap = DefaultValueInitUtil.getItemDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        for (PurchaseRequestItem requestItem : mergeRequestList) {
            if (!allowMultipleSources && !arrayList.contains(requestItem.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseBiddingItem item3 = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item3));
            item3.setId(null);
            item3.setHeadId(null);
            item3.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item3.setSourceNumber(requestItem.getRequestNumber());
            item3.setSourceItemNumber(requestItem.getItemNumber());
            item3.setSourceItemId(requestItem.getId());
            item3.setPriceUnit(requestItem.getUnitPrice());
            String purchaseUnit = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseUnit", requestItem.getPurchaseUnit());
            String purchaseType = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseType", requestItem.getPurchaseType());
            item3.setPurchaseUnit(purchaseUnit);
            item3.setPurchaseType(purchaseType);
            item3.setRequireQuantity(requestItem.getQuantity());
            item3.setRequireDate(requestItem.getDeliveryDate());
            item3.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            item3.setItemStatus(BiddingItemStatusEnum.NEW.getValue());
            item3.setCreateBy(null);
            item3.setCreateTime(null);
            item3.setCreateById(null);
            item3.setUpdateBy(null);
            item3.setUpdateById(null);
            item3.setUpdateTime(null);
            itemList.add(item3);
        }
        head.setDocumentId(requestItemList.get(0).getDocumentId());
        if (StrUtil.isNotBlank((CharSequence)requestItemList.get(0).getDocumentId())) {
            head.setDocumentParentId(requestItemList.get(0).getHeadId());
        }
        head.setCompany(requestItemList.get(0).getCompany());
        Map<String, String> headValueMap = DefaultValueInitUtil.getHeadDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        String purchaseGroup = DefaultValueInitUtil.getFieldValue(headValueMap, "purchaseGroup", mergeRequestList.get(0).getPurchaseGroup());
        head.setPurchaseGroup(purchaseGroup);
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUserDTO sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setProjectNumber(this.invokeBaseRpcService.getNextCode("srmBiddingProjectNumber", (Object)head));
        this.purchaseBiddingProjectHeadService.saveMain(head, headList, itemList, new ArrayList<PurchaseBiddingNotice>(), new ArrayList<PurchaseBiddingSpecialist>(), new ArrayList<BiddingSupplier>());
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_sYBLRWYBtyLWWWWWWW_48162811", (String)"\u8f6c\u62db\u6807\uff08\u591a\u5305\uff09\u6210\u529f,\u62db\u6807\u9879\u76ee\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getProjectNumber()}), Arrays.asList(head));
    }

    private PurchaseBiddingProjectHeadVO queryDataById(String id) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = new PurchaseBiddingProjectHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHead), (Object)((Object)purchaseBiddingProjectHeadVO));
        purchaseBiddingProjectHeadVO.setCreateBy(null);
        purchaseBiddingProjectHeadVO.setCreateTime(null);
        purchaseBiddingProjectHeadVO.setUpdateBy(null);
        purchaseBiddingProjectHeadVO.setUpdateTime(null);
        purchaseBiddingProjectHeadVO.setCurrentRound(null);
        purchaseBiddingProjectHeadVO.setUpdateById(null);
        purchaseBiddingProjectHeadVO.setCreateById(null);
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        Set headIdSet = purchaseBiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toSet());
        purchaseBiddingProjectHeadVO.setPurchaseBiddingHeadList(purchaseBiddingHeadList);
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().in(PurchaseBiddingItem::getHeadId, headIdSet)).list();
        Map<String, List<PurchaseBiddingItem>> listMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getHeadId));
        List<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        for (PurchaseBiddingHead biddingHead : purchaseBiddingHeadList) {
            List<PurchaseBiddingItem> biddingItemList = this.getLastBiddingItem(listMap.getOrDefault(biddingHead.getId(), Collections.emptyList()));
            for (PurchaseBiddingItem item : biddingItemList) {
                if (BiddingStatusEnum.BIDDING.getValue().equals(biddingHead.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(biddingHead.getBiddingStatus())) {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                }
                if (!BiddingStatusEnum.TALK_PRICE.getValue().equals(biddingHead.getBiddingStatus()) && !"4".equals(item.getItemStatus())) continue;
                item.setQuota(null);
            }
            itemList.addAll(biddingItemList);
        }
        if (CollectionUtil.isEmpty(itemList)) {
            itemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        }
        purchaseBiddingProjectHeadVO.setPurchaseBiddingItemList(itemList);
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingNoticeList(purchaseBiddingNoticeList);
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setBiddingSupplierList(biddingSupplierList);
        return purchaseBiddingProjectHeadVO;
    }

    private List<PurchaseBiddingItem> getLastBiddingItem(List<PurchaseBiddingItem> biddingItemList) {
        ArrayList<PurchaseBiddingItem> offerItem = new ArrayList<PurchaseBiddingItem>();
        if (CollectionUtil.isNotEmpty(biddingItemList)) {
            Map<String, List<PurchaseBiddingItem>> itemMaps = biddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getToElsAccount())).collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
            for (String key : itemMaps.keySet()) {
                List<PurchaseBiddingItem> initList = itemMaps.get(key);
                List finalItem = initList.stream().filter(x -> "1".equals(x.getFinalPrice())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(finalItem)) {
                    offerItem.addAll(finalItem);
                    continue;
                }
                offerItem.addAll(initList);
            }
            biddingItemList = offerItem;
        }
        return biddingItemList;
    }

    @AutoLog(value="\u591a\u6807\u5305\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @Operation(summary="\u591a\u6807\u5305\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382", description="\u591a\u6807\u5305\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @PostMapping(value={"/checkEnquirySameMaterial"})
    public Result<?> print(@RequestBody List<PurchaseBiddingItem> itemList) {
        ((PurchaseBiddingProjectHeadService)this.service).checkEnquirySameMaterial(itemList);
        return Result.ok();
    }
}

