/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.mq.api.service.MqMessageRecordRpcService;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class PublishEnquiryConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishEnquiryConsumer.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;

    @Bean(value={"inputPublishEnquiry"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String msgStatus = ((MqMessageRecordRpcService)SrmRpcUtil.getExecuteServiceImpl(MqMessageRecordRpcService.class)).getMsgStatusById(key);
            if ("consumed".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String errorInfo = "";
            String msgBody = (String)message.getPayload();
            JSONObject body = JSONObject.parseObject((String)msgBody);
            PurchaseEnquiryHeadVO headVO = (PurchaseEnquiryHeadVO)((Object)((Object)JSONObject.toJavaObject((JSON)body.getJSONObject("content"), PurchaseEnquiryHeadVO.class)));
            try {
                LoginUserDTO user = (LoginUserDTO)JSONObject.toJavaObject((JSON)body.getJSONObject("user"), LoginUserDTO.class);
                String tenant = body.getString("tenant");
                TenantContext.setTenant((String)tenant);
                LoginUserContext.setUser((LoginUserDTO)user);
                PurchaseEnquiryHead head = new PurchaseEnquiryHead();
                head.setId(headVO.getId());
                head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
                this.purchaseEnquiryHeadService.updateById((Object)head);
                headVO.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
                this.purchaseEnquiryHeadService.publishEnquiry(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList(), user.getEnterpriseName(), user, false);
                msgStatus = "consumed";
            }
            catch (Exception e) {
                log.error("PublishEnquiryConsumer_receive_msgBody:" + msgBody, (Throwable)e);
                errorInfo = e.getMessage();
                msgStatus = "error";
                PurchaseEnquiryHead head = new PurchaseEnquiryHead();
                head.setId(headVO.getId());
                head.setEnquiryStatus(EnquiryStatusEnum.PUBLISH_FAILED.getValue());
                this.purchaseEnquiryHeadService.updateById((Object)head);
                this.purchaseEnquiryHeadService.insertData(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseAttachmentList());
            }
            finally {
                ((MqMessageRecordRpcService)SrmRpcUtil.getExecuteServiceImpl(MqMessageRecordRpcService.class)).updateRecord(key, msgStatus, errorInfo);
                TenantContext.clear();
                LoginUserContext.clear();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SrmTransaction
    public void publish(String msgBody) {
        try {
            JSONObject body = JSONObject.parseObject((String)msgBody);
            PurchaseEnquiryHeadVO headVO = (PurchaseEnquiryHeadVO)((Object)JSONObject.toJavaObject((JSON)body.getJSONObject("content"), PurchaseEnquiryHeadVO.class));
            LoginUserDTO user = (LoginUserDTO)JSONObject.toJavaObject((JSON)body.getJSONObject("user"), LoginUserDTO.class);
            String tenant = body.getString("tenant");
            TenantContext.setTenant((String)tenant);
            LoginUserContext.setUser((LoginUserDTO)user);
            PurchaseEnquiryHead head = new PurchaseEnquiryHead();
            head.setId(headVO.getId());
            head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            this.purchaseEnquiryHeadService.updateById((Object)head);
            headVO.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            this.purchaseEnquiryHeadService.publishEnquiry(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList(), user.getEnterpriseName(), user, false);
        }
        finally {
            TenantContext.clear();
            LoginUserContext.clear();
        }
    }
}

