/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.enums.ImBusinessTypeEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@RpcService(value="purchaseEnquiryLpImUserRecordServiceImpl")
public class PurchaseEnquiryLpUserRecordInvokeDubboServiceImpl
implements GroupChatRecordUserRpcService {
    @Resource
    private PurchaseEnquiryHeadLpService purchaseEnquiryHeadLpService;
    @Resource
    private SaleEnquiryHeadLpService saleEnquiryHeadLpService;
    @Resource
    private EnquirySupplierListLpService enquirySupplierListLpService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        if (ImBusinessTypeEnum.PURCHASE_ENQUIRY_LP.getValue().equals(imRecordDto.getBusinessType())) {
            PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)this.purchaseEnquiryHeadLpService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u7269\u6d41\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            Assert.isTrue((!EbiddingLpStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VIzEWShRe_3e411e67", (String)"\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List<EnquirySupplierListLp> supplierList = this.enquirySupplierListLpService.selectByMainId(imRecordDto.getBusinessId());
            return this.queryAllUserWithGroupChat(accountInfoRpcService, supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImBusinessTypeEnum.SALE_ENQUIRY_LP.getValue().equals(imRecordDto.getBusinessType())) {
            SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadLpService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u7269\u6d41\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getPublishUser().split("_")[0];
            RecordUserDto e = new RecordUserDto();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

