/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationSupplier;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationItem;
import com.els.modules.tender.clarification.enumerate.SaleTenderEvaClarificationItemStatusEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringStatusEnum;
import com.els.modules.tender.clarification.mapper.SaleTenderEvaClarificationHeadMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationItemService;
import com.els.modules.tender.clarification.vo.SaleTenderEvaClarificationItemVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaInfo;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryMember;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryHeadService;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectJuryHeadVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleTenderEvaClarificationHeadServiceImpl
extends BaseServiceImpl<SaleTenderEvaClarificationHeadMapper, SaleTenderEvaClarificationHead>
implements SaleTenderEvaClarificationHeadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleTenderEvaClarificationHeadServiceImpl.class);
    @Autowired
    private SaleTenderEvaClarificationItemService saleTenderEvaClarificationItemService;
    @Autowired
    @Lazy
    private PurchaseTenderEvaClarificationHeadService purchaseTenderEvaClarificationHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectJuryHeadService juryHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private PurchaseTenderProjectEvaInfoService evaInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSuppliers, List<PurchaseAttachmentDTO> attachmentList) {
        ArrayList<SaleTenderEvaClarificationHead> evaClarificationHeads = new ArrayList<SaleTenderEvaClarificationHead>();
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOS = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseTenderEvaClarificationSupplier evaClarificationSupplier : purchaseTenderEvaClarificationSuppliers) {
            SaleTenderEvaClarificationHead saleTenderEvaClarificationHead = (SaleTenderEvaClarificationHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderEvaClarificationHead), SaleTenderEvaClarificationHead.class));
            saleTenderEvaClarificationHead.setElsAccount(evaClarificationSupplier.getSupplierAccount());
            saleTenderEvaClarificationHead.setSupplierAccount(evaClarificationSupplier.getSupplierAccount());
            saleTenderEvaClarificationHead.setSupplierName(evaClarificationSupplier.getSupplierName());
            saleTenderEvaClarificationHead.setRelationId(evaClarificationSupplier.getId());
            saleTenderEvaClarificationHead.setEvaClarificationId(purchaseTenderEvaClarificationHead.getId());
            saleTenderEvaClarificationHead.setId(IdWorker.getIdStr());
            evaClarificationHeads.add(saleTenderEvaClarificationHead);
            if (!CollectionUtil.isNotEmpty(attachmentList)) continue;
            ArrayList saleAttachmentList = SysUtil.copyProperties(attachmentList, SaleAttachmentDTO.class);
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(IdWorker.getIdStr());
                saleAttachmentDTO.setHeadId(saleTenderEvaClarificationHead.getId());
                saleAttachmentDTOS.add(saleAttachmentDTO);
            }
        }
        this.saveBatch(evaClarificationHeads);
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOS)) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOS);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void changeRecord(PurchaseTenderEvaClarificationHead evaClarificationHead) {
        ((SaleTenderEvaClarificationHeadMapper)this.baseMapper).updateFileClarificationEndTimeByEvaClarificationId(evaClarificationHead.getId(), evaClarificationHead.getFileClarificationEndTime());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replyAdd(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        saleTenderEvaClarificationItemVO.setStatus(SaleTenderEvaClarificationItemStatusEnum.NEW.getValue());
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderEvaClarificationItemVO), SaleTenderEvaClarificationItem.class));
        this.saleTenderEvaClarificationItemService.save((Object)saleTenderEvaClarificationItem);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        return saleTenderEvaClarificationItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replyEdit(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        SaleTenderEvaClarificationItem item = (SaleTenderEvaClarificationItem)((Object)this.saleTenderEvaClarificationItemService.getById((Serializable)((Object)saleTenderEvaClarificationItemVO.getId())));
        Assert.notNull((Object)((Object)item), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)SaleTenderEvaClarificationItemStatusEnum.NEW.getValue().equals(item.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTAtW_8ec39a67", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91\uff01"));
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderEvaClarificationItemVO), SaleTenderEvaClarificationItem.class));
        this.saleTenderEvaClarificationItemService.updateById((Object)saleTenderEvaClarificationItem);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        return saleTenderEvaClarificationItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replySubmit(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        Assert.hasText((String)saleTenderEvaClarificationItemVO.getReplyContent(), (String)I18nUtil.translate((String)"i18n_field_MBCcxOLVW_80714dce", (String)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        SaleTenderEvaClarificationHead evaClarificationHead = this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)this.saleTenderEvaClarificationItemService.getById((Serializable)((Object)saleTenderEvaClarificationItemVO.getId())));
        saleTenderEvaClarificationItem.setStatus(SaleTenderEvaClarificationItemStatusEnum.SUBMIT.getValue());
        saleTenderEvaClarificationItem.setReplyContent(saleTenderEvaClarificationItemVO.getReplyContent());
        this.saleTenderEvaClarificationItemService.updateById((Object)saleTenderEvaClarificationItem);
        evaClarificationHead.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        ((SaleTenderEvaClarificationHeadMapper)this.baseMapper).updateById((Object)evaClarificationHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        this.purchaseTenderEvaClarificationHeadService.reply(evaClarificationHead, saleTenderEvaClarificationItemVO);
        this.sendMsg(evaClarificationHead);
        return saleTenderEvaClarificationItem;
    }

    private void sendMsg(SaleTenderEvaClarificationHead evaClarificationHead) {
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(evaClarificationHead.getTenderProjectId()).append("&subpackageId=").append(evaClarificationHead.getSubpackageId()).append("&businessId=").append(evaClarificationHead.getId());
        PurchaseTenderProjectJuryHead juryHead = new PurchaseTenderProjectJuryHead();
        juryHead.setSubpackageId(evaClarificationHead.getSubpackageId());
        PurchaseTenderProjectJuryHeadVO projectJuryHeadVO = this.juryHeadService.queryByCondition(juryHead);
        AccountRpcService accountRpcService = (AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class);
        ArrayList<CallSite> searchAccountList = new ArrayList<CallSite>();
        for (PurchaseTenderProjectJuryMember juryMember : projectJuryHeadVO.getPurchaseTenderProjectJuryMemberList()) {
            searchAccountList.add((CallSite)((Object)(juryMember.getElsAccount() + "_" + juryMember.getElsSubAccount())));
        }
        List accountDTOList = accountRpcService.getAccountListByElsSubAccountWithoutUser(searchAccountList);
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)evaClarificationHead.getEvaInfoId())));
        if (StrUtil.isBlank((CharSequence)TenderFlagInjectionContext.getTenderCheckType()) || StrUtil.isBlank((CharSequence)TenderFlagInjectionContext.getTenderProcessType()) || StrUtil.isBlank((CharSequence)TenderFlagInjectionContext.getTenderCurrentStep())) {
            TenderFlagInjectionContext.setTenderCheckType(evaInfo.getCheckType());
            TenderFlagInjectionContext.setTenderProcessType(evaInfo.getProcessType());
            TenderFlagInjectionContext.setTenderCurrentStep(evaInfo.getCurrentStep());
        }
        String operation = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            operation = "preTenderEvaReplyClarify";
        } else if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(TenderFlagInjectionContext.getTenderProcessType())) {
            operation = "tenderEvaReplyClarify";
        } else if (SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "firstTenderEvaReplyClarify";
        } else if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "secondTenderEvaReplyClarify";
        }
        if (StrUtil.isBlank((CharSequence)operation)) {
            log.error("\u672a\u77e5\u64cd\u4f5c\u72b6\u6001\uff0c\u5934\u8868\u4fe1\u606f\uff1a{},CheckType:{},ProcessType:{},CurrentStep:{}", new Object[]{JSON.toJSONString((Object)((Object)evaClarificationHead)), TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep()});
            return;
        }
        List collect = accountDTOList.stream().map(ParentEntityDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(evaClarificationHead.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
    }

    private SaleTenderEvaClarificationHead checkParamAndSet(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItem) {
        Assert.hasText((String)saleTenderEvaClarificationItem.getHeadId(), (String)I18nUtil.translate((String)"i18n_alert_LVeWWxMKW_586640d2", (String)"\u6f84\u6e05\u5934Id\u4e0d\u5b58\u5728\uff01"));
        SaleTenderEvaClarificationHead evaClarificationHead = (SaleTenderEvaClarificationHead)((Object)((SaleTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleTenderEvaClarificationItem.getHeadId())));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"i18n_alert_LVexMKW_e5ea35d7", (String)"\u6f84\u6e05\u5934\u4e0d\u5b58\u5728\uff01"));
        Date currentDate = new Date();
        Assert.isTrue((currentDate.compareTo(evaClarificationHead.getFileClarificationEndTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LVyRKIIRW_d8c01c75", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff01"));
        saleTenderEvaClarificationItem.setSubpackageId(evaClarificationHead.getSubpackageId());
        saleTenderEvaClarificationItem.setTenderProjectId(evaClarificationHead.getTenderProjectId());
        saleTenderEvaClarificationItem.setSupplierAccount(evaClarificationHead.getSupplierAccount());
        saleTenderEvaClarificationItem.setSupplierName(evaClarificationHead.getSupplierName());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        saleTenderEvaClarificationItem.setRealName(loginUser.getRealname());
        return evaClarificationHead;
    }
}

