/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.library.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.library.entity.PurchaseTenderAgencyLibraryHead;
import com.els.modules.tender.library.enumerate.PurchaseTenderAgencyLibraryEnum;
import com.els.modules.tender.library.service.impl.PurchaseTenderAgencyLibraryHeadServiceImpl;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="tenderAgencyLibraryAuditCallBackServiceImpl")
public class TenderAgencyLibraryAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseTenderAgencyLibraryHeadServiceImpl agencyLibraryHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderAgencyLibraryHead head = (PurchaseTenderAgencyLibraryHead)((Object)this.agencyLibraryHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderAgencyLibraryHead agencyLibraryHead = new PurchaseTenderAgencyLibraryHead();
        agencyLibraryHead.setId(flowCallbackDTO.getBusinessId());
        agencyLibraryHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            agencyLibraryHead.setStatus(PurchaseTenderAgencyLibraryEnum.ENABLE.getValue());
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            agencyLibraryHead.setStatus(PurchaseTenderAgencyLibraryEnum.NEW.getValue());
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            agencyLibraryHead.setStatus(PurchaseTenderAgencyLibraryEnum.NEW.getValue());
        } else {
            agencyLibraryHead.setStatus(PurchaseTenderAgencyLibraryEnum.NO_ENABLE.getValue());
        }
        agencyLibraryHead.setAuditStatus(auditStatus);
        this.agencyLibraryHeadService.updateById((Object)agencyLibraryHead);
    }
}

