/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBiddingProjectUserRecordServiceImpl")
public class PurchaseBiddingProjectUserRecordInvokeDubboServiceImpl
implements GroupChatRecordUserRpcService {
    @Autowired
    private PurchaseBiddingHeadService biddingHeadService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.biddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)imRecordDto.getBusinessId())).list();
        if (CollectionUtil.isEmpty((Collection)purchaseBiddingHeadList)) {
            return resultList;
        }
        for (PurchaseBiddingHead purchaseBiddingHead : purchaseBiddingHeadList) {
            List<RecordUserDto> userDTOList = this.getSupplier(purchaseBiddingHead);
            if (!CollectionUtil.isNotEmpty(userDTOList)) continue;
            resultList.addAll(userDTOList);
        }
        return resultList;
    }

    public List<RecordUserDto> getSupplier(PurchaseBiddingHead dbHead) {
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        if (BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(dbHead.getBiddingStatus())) {
            return null;
        }
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(dbHead.getId());
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(dbHead.getId());
        List supplierList = this.queryAllUserWithGroupChat(accountInfoRpcService, biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        for (RecordUserDto dto : supplierList) {
            dto.setGroupName(dbHead.getBiddingDesc() + "\u4f9b\u5e94\u5546");
        }
        List memberList = purchaseBiddingSpecialistList.stream().map(supplier -> {
            RecordUserDto imUserDTO = new RecordUserDto();
            imUserDTO.setElsAccount(supplier.getElsAccount() + "_" + supplier.getSubAccount());
            imUserDTO.setGroupName(dbHead.getBiddingDesc() + MemberTypeEnum.getMemberTypeDesc(supplier.getMemberType()));
            return imUserDTO;
        }).collect(Collectors.toList());
        supplierList.addAll(memberList);
        return supplierList;
    }
}

