/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.BiddingEvaluationRegulationSelection;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateItem;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationRegulationSelectionMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateItemMapper;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingEvaResultMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingRegulationVO;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.SupplierEvaScoreVO;
import com.els.modules.specialist.service.SpecialistInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingEvaResultServiceImpl
extends ServiceImpl<PurchaseBiddingEvaResultMapper, PurchaseBiddingEvaResult>
implements PurchaseBiddingEvaResultService {
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Resource
    private BiddingEvaluationTemplateItemMapper biddingEvaluationTemplateItemMapper;
    @Resource
    private BiddingEvaluationRegulationSelectionMapper biddingEvaluationRegulationSelectionMapper;
    @Autowired
    private SpecialistInfoService specialistInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseBiddingEvaResultMapper purchaseBiddingEvaResultMapper;

    private List<BiddingRegulationVO> getResult(List<PurchaseBiddingEvaResult> list) {
        if (CollUtil.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList<BiddingRegulationVO> resultList = new ArrayList<BiddingRegulationVO>();
        Map<String, List<PurchaseBiddingEvaResult>> map = list.stream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getRegulationId));
        List<String> regulationIds = list.parallelStream().map(PurchaseBiddingEvaResult::getRegulationId).collect(Collectors.toList());
        Map<String, List<BiddingEvaluationRegulationSelection>> biddingEvaluationRegulationSelectionMap = this.biddingEvaluationRegulationSelectionMapper.selectWithoutElsAccountByRegulationIds(regulationIds).parallelStream().collect(Collectors.groupingBy(BiddingEvaluationRegulationSelection::getHeadId));
        for (String id : map.keySet()) {
            List<PurchaseBiddingEvaResult> itemList = map.get(id);
            BiddingRegulationVO vo = new BiddingRegulationVO();
            BeanUtil.copyProperties((Object)((Object)itemList.get(0)), (Object)((Object)vo), (String[])new String[0]);
            vo.setRegulationSelections(biddingEvaluationRegulationSelectionMap.get(itemList.get(0).getRegulationId()));
            ArrayList<SupplierEvaScoreVO> scoreList = new ArrayList<SupplierEvaScoreVO>();
            for (PurchaseBiddingEvaResult result : itemList) {
                SupplierEvaScoreVO scoreVO = new SupplierEvaScoreVO();
                scoreVO.setToElsAccount(result.getToElsAccount());
                scoreVO.setSupplierName(result.getSupplierName());
                scoreVO.setSupplierCode(result.getSupplierCode());
                scoreVO.setScore(result.getScore());
                scoreList.add(scoreVO);
            }
            vo.setSupplierEvaScoreList(scoreList);
            resultList.add(vo);
        }
        return resultList;
    }

    private void check(String id) {
        LoginUserDTO user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    @Override
    public List<BiddingRegulationVO> findEvaResult(String headId) {
        LoginUserDTO user = SysUtil.getLoginUser();
        List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(headId).stream().filter(o -> MemberTypeEnum.EVA_BID.getValue().equals(o.getMemberType())).collect(Collectors.toList());
        List specialistList = purchaseBiddingSpecialistList.stream().filter(o -> o.getSubAccount().equals(user.getSubAccount())).collect(Collectors.toList());
        if (specialistList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_view_bidding_doc_bidding", (String)"\u53ea\u6709\u5f53\u524d\u62db\u6807\u5355\u7684\u8bc4\u6807\u4e13\u5bb6\u53ef\u4ee5\u67e5\u770b\uff01"));
        }
        List resultList = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId)).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (!resultList.isEmpty()) {
            return this.getResult(resultList);
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)head.getElsAccount())).eq((Object)"evaluation_number", (Object)head.getBidEvaluationNumber())));
        if (evaluationTemplateHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_evaluation_of_bids_template_no_found_template", (String)"\u8bc4\u6807\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        List<BiddingEvaluationTemplateItem> templateItemList = this.biddingEvaluationTemplateItemMapper.selectByMainId(evaluationTemplateHead.getId());
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        PurchaseBiddingSpecialist specialist = (PurchaseBiddingSpecialist)((Object)specialistList.get(0));
        for (BiddingSupplier supplier : biddingSupplierList) {
            for (BiddingEvaluationTemplateItem item : templateItemList) {
                if (!specialist.getSpecialistClasses().contains(item.getRegulationType())) continue;
                PurchaseBiddingEvaResult result = new PurchaseBiddingEvaResult();
                result.setToElsAccount(supplier.getToElsAccount());
                result.setSupplierCode(supplier.getSupplierCode());
                result.setSupplierName(supplier.getSupplierName());
                result.setFullMark(item.getFullMark());
                result.setRegulationDetail(item.getRegulationDetail());
                result.setRegulationId(item.getRegulationId());
                result.setRegulationName(item.getRegulationName());
                result.setRegulationType(item.getRegulationType());
                result.setInputType(item.getInputType());
                result.setInputValue(item.getInputValue());
                resultList.add(result);
            }
        }
        return this.getResult(resultList);
    }

    @Override
    public void saveEvaResult(String headId, List<BiddingRegulationVO> resultList) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        if ("1".equals(head.getBidEvaluationEnd())) {
            Assert.isTrue((boolean)new Date().before(head.getEvaEndTime()), (String)I18nUtil.translate((String)"i18n_alert_UBKIIyR_e8cbd589", (String)"\u8bc4\u6807\u65f6\u95f4\u5df2\u622a\u6b62\uff01"), (Object[])new Object[0]);
        }
        LoginUserDTO user = SysUtil.getLoginUser();
        List list = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId)).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (StrUtil.isNotBlank((CharSequence)head.getBidEvaluationEnd()) && "1".equals(head.getBidEvaluationEnd())) {
            if (!list.isEmpty()) {
                List<String> collect = list.stream().map(ParentEntity::getId).collect(Collectors.toList());
                this.purchaseBiddingEvaResultMapper.deleteByHeadIdAndSub(collect);
            }
        } else if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_doc_score_repeat", (String)"\u5df2\u7ecf\u8bc4\u5206\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u8bc4\u5206\uff01"));
        }
        ArrayList<PurchaseBiddingEvaResult> insertList = new ArrayList<PurchaseBiddingEvaResult>();
        for (BiddingRegulationVO regulationVO : resultList) {
            List<SupplierEvaScoreVO> scoreList = regulationVO.getSupplierEvaScoreList();
            for (SupplierEvaScoreVO scoreVO : scoreList) {
                PurchaseBiddingEvaResult result = new PurchaseBiddingEvaResult();
                BeanUtil.copyProperties((Object)((Object)regulationVO), (Object)((Object)result), (String[])new String[0]);
                if (scoreVO.getScore() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_score_not_empty", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (regulationVO.getFullMark() != null && scoreVO.getScore().compareTo(regulationVO.getFullMark()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_score_no_gt_full marks", (String)"\u8bc4\u5206\u4e0d\u80fd\u5927\u4e8e\u6ee1\u5206\uff01"));
                }
                result.setFullMark(regulationVO.getFullMark());
                result.setToElsAccount(scoreVO.getToElsAccount());
                result.setSupplierName(scoreVO.getSupplierName());
                result.setSupplierCode(scoreVO.getSupplierCode());
                result.setScore(scoreVO.getScore());
                result.setHeadId(headId);
                result.setElsAccount(user.getElsAccount());
                result.setDeleted(CommonConstant.DEL_FLAG_0);
                result.setSubAccount(user.getSubAccount());
                result.setCreateBy(user.getSubAccount());
                result.setCreateTime(new Date());
                result.setScoreTime(new Date());
                result.setEvaBidIp(IPUtils.getIpAddr());
                insertList.add(result);
            }
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
            this.specialistInfoService.addByEvaResult(head);
        }
    }

    @Override
    public void submitEvaResult(String headId, List<BiddingSupplierVO> resultList) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        LoginUserDTO user = SysUtil.getLoginUser();
        List<BiddingSupplier> biddingSuppliers = this.biddingSupplierMapper.selectByMainId(headId);
        Map collect = resultList.stream().collect(Collectors.toMap(BiddingSupplier::getToElsAccount, Function.identity()));
        for (BiddingSupplier biddingSupplier : biddingSuppliers) {
            if (!collect.containsKey(biddingSupplier.getToElsAccount())) continue;
            BiddingSupplierVO biddingSupplierVO = (BiddingSupplierVO)((Object)collect.get(biddingSupplier.getToElsAccount()));
            biddingSupplier.setBidEva(biddingSupplierVO.getBidEva());
            biddingSupplier.setRecommend(biddingSupplierVO.getRecommend());
            biddingSupplier.setPriceScore(biddingSupplierVO.getPriceScore());
            biddingSupplier.setRemark(biddingSupplierVO.getRemark());
            this.biddingSupplierMapper.updateById((Object)biddingSupplier);
        }
    }

    private long getEchoCount(String toElsAccount, Map<String, List<PurchaseBiddingItem>> itemMap) {
        List<PurchaseBiddingItem> itemList = itemMap.get(toElsAccount);
        if (itemList == null) {
            return 0L;
        }
        long echoCount = itemList.stream().filter(o -> o.getPrice() != null).count();
        return echoCount;
    }

    private BigDecimal getTotalAmount(String toElsAccount, Map<String, List<PurchaseBiddingItem>> itemMap) {
        List<PurchaseBiddingItem> itemList = itemMap.get(toElsAccount);
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (itemList == null) {
            return totalAmount;
        }
        for (PurchaseBiddingItem item : itemList) {
            if (item.getPrice() == null) continue;
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal amount = price.multiply(quantity);
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }

    private BigDecimal getScore(String toElsAccount, String type, Map<String, List<PurchaseBiddingEvaResult>> resultMap, BigDecimal weight) {
        List<PurchaseBiddingEvaResult> itemList = resultMap.get(toElsAccount);
        BigDecimal totalScore = BigDecimal.ZERO;
        if (itemList == null) {
            return totalScore;
        }
        itemList = itemList.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        int count = 0;
        for (PurchaseBiddingEvaResult result2 : itemList) {
            totalScore = totalScore.add(result2.getScore());
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        if (weight == null) {
            return totalScore.divide(new BigDecimal(count), 2, 4);
        }
        Map<String, List<PurchaseBiddingEvaResult>> listMap = itemList.parallelStream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getSubAccount));
        return totalScore.divide(new BigDecimal(listMap.size()), 2, 4);
    }

    private void rankByTotalAmount(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTotalAmount)).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setQuoteRank("" + rank);
            ++rank;
        }
    }

    private void rankByBusScore(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getBusScore).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setBusRank("" + rank);
            ++rank;
        }
    }

    private void rankByTecScore(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTecScore).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setTecRank("" + rank);
            ++rank;
        }
    }

    private List<BiddingEvaResultVO> rankByTotalScore(List<BiddingEvaResultVO> resultList) {
        List<BiddingEvaResultVO> list = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTotalScoreNew).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : list) {
            resultVO.setSynthesisRank("" + rank);
            ++rank;
        }
        return list;
    }

    @Override
    public List<BiddingEvaResultVO> findEvaBidList(String headId) {
        this.check(headId);
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_status_can_not_view", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u67e5\u770b\uff01"));
        }
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        Collection itemList = this.purchaseBiddingItemMapper.selectByMainId(headId).stream().map(item -> {
            Integer talkPriceStage = item.getTalkPriceStage() == null ? 1 : item.getTalkPriceStage();
            item.setTalkPriceStage(talkPriceStage);
            return item;
        }).collect(Collectors.toMap(item -> item.getToElsAccount() + "_" + item.getItemNumber() + "_" + item.getTalkPriceStage(), Function.identity(), (o1, o2) -> o2, LinkedHashMap::new)).values();
        Map<String, List<PurchaseBiddingItem>> listMap = itemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        LinkedHashMap<String, Integer> elsAccountTalkPriceStage = new LinkedHashMap<String, Integer>();
        for (String toElsAccount : listMap.keySet()) {
            List biddingItemList = listMap.getOrDefault(toElsAccount, new ArrayList());
            Integer talkPriceStage = biddingItemList.stream().max(Comparator.comparing(PurchaseBiddingItem::getTalkPriceStage)).get().getTalkPriceStage();
            elsAccountTalkPriceStage.put(toElsAccount, talkPriceStage);
        }
        List purchaseBiddingItemList = itemList.stream().filter(item -> ((Integer)elsAccountTalkPriceStage.get(item.getToElsAccount())).equals(item.getTalkPriceStage())).collect(Collectors.toList());
        List itemNumberList = purchaseBiddingItemList.stream().map(PurchaseBiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        int totalRows = itemNumberList.size();
        Map<String, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        BigDecimal busWeight = new BigDecimal(100);
        BigDecimal tecWeight = new BigDecimal(100);
        if (!StrUtil.isBlank((CharSequence)head.getBidEvaluationNumber())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getEvaluationNumber, (Object)head.getBidEvaluationNumber());
            lambdaQueryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
            lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getTemplateStatus, (Object)"1");
            BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectOne((Wrapper)lambdaQueryWrapper));
            if (biddingEvaluationTemplateHead != null) {
                busWeight = biddingEvaluationTemplateHead.getBusWeight();
                tecWeight = biddingEvaluationTemplateHead.getTecWeight();
            }
        }
        List biddingEvaResultList = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId));
        Map<String, List<PurchaseBiddingEvaResult>> resultMap = biddingEvaResultList.stream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getToElsAccount));
        ArrayList<BiddingEvaResultVO> resultList = new ArrayList<BiddingEvaResultVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingEvaResultVO resultVO = new BiddingEvaResultVO();
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)resultVO, (String[])new String[0]);
            resultVO.setQuoteEcho(this.getEchoCount(supplier.getToElsAccount(), itemMap) + "/" + totalRows);
            resultVO.setTotalAmount(this.getTotalAmount(supplier.getToElsAccount(), itemMap));
            resultVO.setBusScore(this.getScore(supplier.getToElsAccount(), "1", resultMap, busWeight));
            resultVO.setTecScore(this.getScore(supplier.getToElsAccount(), "2", resultMap, tecWeight));
            resultVO.setBusScoreByWeights(this.getScoreByWeights(supplier.getToElsAccount(), "1", resultMap, busWeight));
            resultVO.setTecScoreByWeights(this.getScoreByWeights(supplier.getToElsAccount(), "2", resultMap, tecWeight));
            resultVO.setBusWeights(busWeight);
            resultVO.setTecWeights(tecWeight);
            resultVO.setBidEva(supplier.getBidEva());
            resultVO.setRecommend(supplier.getRecommend());
            resultVO.setPriceScore(supplier.getPriceScore() == null ? BigDecimal.ZERO : supplier.getPriceScore());
            BigDecimal totalScore = resultVO.getBusScoreByWeights().add(resultVO.getTecScoreByWeights().add(resultVO.getPriceScore()));
            resultVO.setTotalScoreNew(totalScore);
            resultList.add(resultVO);
        }
        this.rankByTotalAmount(resultList);
        this.rankByBusScoreByWeights(resultList, busWeight);
        this.rankByTecScoreByWeights(resultList, tecWeight);
        return this.rankByTotalScore(resultList);
    }

    @Override
    public List<BiddingSupplierVO> bidEvaOfOffLine(List<BiddingSupplier> biddingSupplierList) {
        String headId = biddingSupplierList.get(0).getHeadId();
        LoginUserDTO user = SysUtil.getLoginUser();
        List resultList = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId)).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (!resultList.isEmpty()) {
            Map<String, List> collect = resultList.parallelStream().collect(Collectors.toMap(new Function<PurchaseBiddingEvaResult, String>(){

                @Override
                public String apply(PurchaseBiddingEvaResult p) {
                    return p.getToElsAccount();
                }
            }, p -> {
                ArrayList<PurchaseBiddingEvaResult> getNameList = new ArrayList<PurchaseBiddingEvaResult>();
                getNameList.add((PurchaseBiddingEvaResult)((Object)p));
                return getNameList;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }));
            ArrayList<BiddingSupplierVO> biddingSupplierVOS = new ArrayList<BiddingSupplierVO>();
            for (BiddingSupplier supplier : biddingSupplierList) {
                BiddingSupplierVO biddingSupplierVO = new BiddingSupplierVO();
                BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)biddingSupplierVO), (String[])new String[0]);
                if (collect.containsKey(supplier.getToElsAccount())) {
                    biddingSupplierVO.setPurchaseBiddingEvaResultList(collect.get(supplier.getToElsAccount()));
                }
                biddingSupplierVOS.add(biddingSupplierVO);
            }
            return biddingSupplierVOS;
        }
        List srmBidEvaOffLine = this.invokeBaseRpcService.queryDictItemsByCode("srmBidEvaOffLine", user.getElsAccount());
        if (CollectionUtils.isEmpty((Collection)srmBidEvaOffLine)) {
            srmBidEvaOffLine = this.invokeBaseRpcService.queryDictItemsByCode("srmBidEvaOffLine", "100000");
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectById((Serializable)((Object)((DictDTO)srmBidEvaOffLine.get(0)).getValue())));
        if (evaluationTemplateHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_evaluation_of_bids_template_no_found_template", (String)"\u8bc4\u6807\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        List<BiddingEvaluationTemplateItem> templateItemList = this.biddingEvaluationTemplateItemMapper.selectByMainId(evaluationTemplateHead.getId());
        ArrayList<BiddingSupplierVO> biddingSupplierVOS = new ArrayList<BiddingSupplierVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplierVO biddingSupplierVO = new BiddingSupplierVO();
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)biddingSupplierVO), (String[])new String[0]);
            ArrayList<PurchaseBiddingEvaResult> purchaseBiddingEvaResultList = new ArrayList<PurchaseBiddingEvaResult>();
            for (BiddingEvaluationTemplateItem item : templateItemList) {
                PurchaseBiddingEvaResult result = new PurchaseBiddingEvaResult();
                result.setToElsAccount(supplier.getToElsAccount());
                result.setSupplierCode(supplier.getSupplierCode());
                result.setSupplierName(supplier.getSupplierName());
                result.setFullMark(item.getFullMark());
                result.setRegulationDetail(item.getRegulationDetail());
                result.setRegulationId(item.getRegulationId());
                result.setRegulationName(item.getRegulationName());
                result.setRegulationType(item.getRegulationType());
                result.setInputType(item.getInputType());
                result.setInputValue(item.getInputValue());
                purchaseBiddingEvaResultList.add(result);
            }
            biddingSupplierVO.setPurchaseBiddingEvaResultList(purchaseBiddingEvaResultList);
            biddingSupplierVOS.add(biddingSupplierVO);
        }
        return biddingSupplierVOS;
    }

    @Override
    public void saveBidEvaOfOffLine(PurchaseBiddingHeadVO purchaseBiddingHeadVO) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)purchaseBiddingHeadVO.getId())));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        LoginUserDTO user = SysUtil.getLoginUser();
        List list = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)purchaseBiddingHeadVO.getId())).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_doc_score_repeat", (String)"\u5df2\u7ecf\u8bc4\u5206\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u8bc4\u5206\uff01"));
        }
        ArrayList<PurchaseBiddingEvaResult> insertList = new ArrayList<PurchaseBiddingEvaResult>();
        List<BiddingSupplierVO> biddingSupplierVOList = purchaseBiddingHeadVO.getBiddingSupplierVOList();
        for (BiddingSupplierVO biddingSupplierVO : biddingSupplierVOList) {
            List<PurchaseBiddingEvaResult> purchaseBiddingEvaResultList = biddingSupplierVO.getPurchaseBiddingEvaResultList();
            for (PurchaseBiddingEvaResult purchaseBiddingEvaResult : purchaseBiddingEvaResultList) {
                if (purchaseBiddingEvaResult.getScore() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_score_not_empty", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (purchaseBiddingEvaResult.getFullMark() != null && purchaseBiddingEvaResult.getScore().compareTo(purchaseBiddingEvaResult.getFullMark()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_score_no_gt_full marks", (String)"\u8bc4\u5206\u4e0d\u80fd\u5927\u4e8e\u6ee1\u5206\uff01"));
                }
                purchaseBiddingEvaResult.setHeadId(purchaseBiddingHeadVO.getId());
                purchaseBiddingEvaResult.setElsAccount(user.getElsAccount());
                purchaseBiddingEvaResult.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseBiddingEvaResult.setSubAccount(user.getSubAccount());
                purchaseBiddingEvaResult.setCreateBy(user.getSubAccount());
                purchaseBiddingEvaResult.setCreateTime(new Date());
                purchaseBiddingEvaResult.setScoreTime(new Date());
                purchaseBiddingEvaResult.setEvaBidIp(IPUtils.getIpAddr());
                insertList.add(purchaseBiddingEvaResult);
            }
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(biddingSupplierVO.getId());
            biddingSupplier.setBidEva(biddingSupplierVO.getBidEva());
            biddingSupplier.setRecommend(biddingSupplierVO.getRecommend());
            biddingSupplier.setTotalScore(biddingSupplierVO.getTotalScore());
            biddingSupplier.setPurchaseRemark(biddingSupplierVO.getPurchaseRemark());
            this.biddingSupplierMapper.update((Object)new BiddingSupplier(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)biddingSupplierVO.getId())).set(BiddingSupplier::getBidEva, (Object)biddingSupplierVO.getBidEva())).set(BiddingSupplier::getRecommend, (Object)biddingSupplierVO.getRecommend())).set(BiddingSupplier::getPriceScore, (Object)biddingSupplierVO.getPriceScore())).set(BiddingSupplier::getPurchaseRemark, (Object)biddingSupplierVO.getPurchaseRemark()));
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
            this.specialistInfoService.addByEvaResult(head);
        }
    }

    @Override
    public void exportProjectEvaResult(String id, String type, HttpServletResponse response) {
        ExcelWriter writer = new ExcelWriter(true, "\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868");
        List<BiddingEvaResultVO> evaBidList = this.findEvaBidList(id);
        List<List<String>> rows = null;
        rows = "project".equals(type) ? this.getBiddingProjectEvaResult(evaBidList) : this.getBiddingEvaResult(evaBidList);
        writer.write(rows, true);
        this.setSizeColumn(writer.getSheet(), rows.get(0).size());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=333");
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (Exception e) {
            this.log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<List<String>> getBiddingProjectEvaResult(List<BiddingEvaResultVO> evaBidList) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> head = new ArrayList<String>();
        head.add(I18nUtil.translate((String)"i18n_title_supplierAccount", (String)"\u4f9b\u5e94\u5546ELS\u8d26\u53f7"));
        head.add(I18nUtil.translate((String)"i18n_field_RdXRL_8e11f650", (String)"\u4f9b\u5e94\u5546\u540d\u79f0"));
        head.add(I18nUtil.translate((String)"i18n_field_QKeB_277f7b1f", (String)"\u662f\u5426\u51b3\u6295\u6807"));
        head.add(I18nUtil.translate((String)"i18n_field_KQLULYIL_88b87b1f", (String)"\u662f\u5426\u8bc4\u59d4\u63a8\u8350\u4eba"));
        head.add(I18nUtil.translate((String)"i18n_title_busScore", (String)"\u5546\u52a1\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_tecScore", (String)"\u6280\u672f\u5206"));
        head.add(I18nUtil.translate((String)"i18n_alert_umz_1355e81", (String)"\u4ef7\u683c\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_totalScore", (String)"\u603b\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_synthesisRank", (String)"\u7efc\u5408\u6392\u540d"));
        rows.add(head);
        for (BiddingEvaResultVO biddingEvaResultVO : evaBidList) {
            ArrayList<String> dataRow = new ArrayList<String>();
            dataRow.add(biddingEvaResultVO.getToElsAccount());
            dataRow.add(biddingEvaResultVO.getSupplierName());
            dataRow.add("1".equals(biddingEvaResultVO.getBidEva()) ? I18nUtil.translate((String)"i18n_title_yes", (String)"\u662f") : I18nUtil.translate((String)"i18n_title_no", (String)"\u5426"));
            dataRow.add("1".equals(biddingEvaResultVO.getRecommend()) ? I18nUtil.translate((String)"i18n_title_yes", (String)"\u662f") : I18nUtil.translate((String)"i18n_title_no", (String)"\u5426"));
            dataRow.add(biddingEvaResultVO.getBusScore() == null ? "" : biddingEvaResultVO.getBusScore().toString());
            dataRow.add(biddingEvaResultVO.getTecScore() == null ? "" : biddingEvaResultVO.getTecScore().toString());
            dataRow.add(biddingEvaResultVO.getPriceScore() == null ? "" : biddingEvaResultVO.getPriceScore().toString());
            dataRow.add(biddingEvaResultVO.getTotalScoreNew() == null ? "" : biddingEvaResultVO.getTotalScoreNew().toString());
            dataRow.add(biddingEvaResultVO.getSynthesisRank());
            rows.add(dataRow);
        }
        return rows;
    }

    private List<List<String>> getBiddingEvaResult(List<BiddingEvaResultVO> evaBidList) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> head = new ArrayList<String>();
        head.add(I18nUtil.translate((String)"i18n_title_supplierAccount", (String)"\u4f9b\u5e94\u5546ELS\u8d26\u53f7"));
        head.add(I18nUtil.translate((String)"i18n_field_RdXRL_8e11f650", (String)"\u4f9b\u5e94\u5546\u540d\u79f0"));
        head.add(I18nUtil.translate((String)"i18n_field_KHL_1f12c73", (String)"\u8054\u7cfb\u4eba"));
        head.add(I18nUtil.translate((String)"i18n_field_contactNumber", (String)"\u8054\u7cfb\u7535\u8bdd"));
        head.add(I18nUtil.translate((String)"i18n_field_email", (String)"\u90ae\u7bb1"));
        head.add(I18nUtil.translate((String)"i18n_title_quotationResponse", (String)"\u62a5\u4ef7\u54cd\u5e94"));
        head.add(I18nUtil.translate((String)"i18n_title_totalAmount", (String)"\u603b\u62a5\u4ef7"));
        head.add(I18nUtil.translate((String)"i18n_title_quoteRank", (String)"\u62a5\u4ef7\u6392\u540d"));
        head.add(I18nUtil.translate((String)"i18n_title_busScore", (String)"\u5546\u52a1\u5206"));
        head.add(I18nUtil.translate((String)"i18n_field_XSbsW_d8cd2a80", (String)"\u5546\u52a1\u6743\u91cd%"));
        head.add(I18nUtil.translate((String)"i18n_field_XSbsz_d8cd7c61", (String)"\u5546\u52a1\u6743\u91cd\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_busRank", (String)"\u5546\u52a1\u6392\u540d"));
        head.add(I18nUtil.translate((String)"i18n_title_tecScore", (String)"\u6280\u672f\u5206"));
        head.add(I18nUtil.translate((String)"i18n_field_tWbsW_9c88036c", (String)"\u6280\u672f\u6743\u91cd%"));
        head.add(I18nUtil.translate((String)"i18n_field_tWbsz_9c88554d", (String)"\u6280\u672f\u6743\u91cd\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_tecRank", (String)"\u6280\u672f\u6392\u540d"));
        head.add(I18nUtil.translate((String)"i18n_title_totalScore", (String)"\u603b\u5206"));
        head.add(I18nUtil.translate((String)"i18n_title_synthesisRank", (String)"\u7efc\u5408\u6392\u540d"));
        rows.add(head);
        for (BiddingEvaResultVO biddingEvaResultVO : evaBidList) {
            ArrayList<String> dataRow = new ArrayList<String>();
            dataRow.add(biddingEvaResultVO.getToElsAccount());
            dataRow.add(biddingEvaResultVO.getSupplierName());
            dataRow.add(biddingEvaResultVO.getContacts());
            dataRow.add(biddingEvaResultVO.getPhone());
            dataRow.add(biddingEvaResultVO.getEmail());
            dataRow.add(biddingEvaResultVO.getQuoteEcho());
            dataRow.add(biddingEvaResultVO.getTotalAmount() == null ? "" : biddingEvaResultVO.getTotalAmount().toString());
            dataRow.add(biddingEvaResultVO.getQuoteRank());
            dataRow.add(biddingEvaResultVO.getBusScore() == null ? "" : biddingEvaResultVO.getBusScore().toString());
            dataRow.add(biddingEvaResultVO.getBusWeights() == null ? "" : biddingEvaResultVO.getBusWeights().toString());
            dataRow.add(biddingEvaResultVO.getBusScoreByWeights() == null ? "" : biddingEvaResultVO.getBusScoreByWeights().toString());
            dataRow.add(biddingEvaResultVO.getBusRank());
            dataRow.add(biddingEvaResultVO.getTecScore() == null ? "" : biddingEvaResultVO.getTecScore().toString());
            dataRow.add(biddingEvaResultVO.getTecWeights() == null ? "" : biddingEvaResultVO.getTecWeights().toString());
            dataRow.add(biddingEvaResultVO.getTecScoreByWeights() == null ? "" : biddingEvaResultVO.getTecScoreByWeights().toString());
            dataRow.add(biddingEvaResultVO.getTecRank());
            dataRow.add(biddingEvaResultVO.getTotalScoreNew() == null ? "" : biddingEvaResultVO.getTotalScoreNew().toString());
            dataRow.add(biddingEvaResultVO.getSynthesisRank());
            rows.add(dataRow);
        }
        return rows;
    }

    public void setSizeColumn(Sheet sheet, int size) {
        for (int columnNum = 0; columnNum <= size; ++columnNum) {
            int columnWidth = sheet.getColumnWidth(columnNum) / 256;
            for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                int length;
                Cell currentCell;
                Row currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                if (currentRow.getCell(columnNum) == null || (currentCell = currentRow.getCell(columnNum)).getCellType() != CellType.STRING || columnWidth >= (length = currentCell.getStringCellValue().getBytes().length)) continue;
                columnWidth = length;
            }
            sheet.setColumnWidth(columnNum, columnWidth * 256);
        }
    }

    private BigDecimal getScoreByWeights(String toElsAccount, String type, Map<String, List<PurchaseBiddingEvaResult>> resultMap, BigDecimal weights) {
        List<PurchaseBiddingEvaResult> itemList = resultMap.get(toElsAccount);
        BigDecimal totalScore = BigDecimal.ZERO;
        if (itemList == null) {
            return totalScore;
        }
        if (weights == null) {
            return this.getScore(toElsAccount, type, resultMap, weights);
        }
        int count = 0;
        itemList = itemList.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        Map<String, List<PurchaseBiddingEvaResult>> listMap = itemList.parallelStream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getSubAccount));
        for (PurchaseBiddingEvaResult result2 : itemList) {
            BigDecimal score = result2.getScore();
            totalScore = totalScore.add(score.multiply(weights).multiply(new BigDecimal(0.01)));
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        return totalScore.divide(new BigDecimal(listMap.size()), 2, 4);
    }

    private void rankByBusScoreByWeights(List<BiddingEvaResultVO> resultList, BigDecimal weights) {
        if (weights == null) {
            this.rankByBusScore(resultList);
            return;
        }
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getBusScoreByWeights).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setBusRank("" + rank);
            ++rank;
        }
    }

    private void rankByTecScoreByWeights(List<BiddingEvaResultVO> resultList, BigDecimal weights) {
        if (weights == null) {
            this.rankByTecScore(resultList);
            return;
        }
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTecScoreByWeights).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setTecRank("" + rank);
            ++rank;
        }
    }

    @Override
    public BigDecimal getTotalAmount(List<PurchaseBiddingItem> itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (itemList == null) {
            return totalAmount;
        }
        for (PurchaseBiddingItem item : itemList) {
            if (item.getPrice() == null) continue;
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal amount = price.multiply(quantity);
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }

    @Override
    public BigDecimal getNoTaxTotalAmount(List<PurchaseBiddingItem> itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (itemList == null) {
            return totalAmount;
        }
        for (PurchaseBiddingItem item : itemList) {
            if (item.getNetPrice() == null) continue;
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            BigDecimal netPrice = item.getNetPrice();
            BigDecimal amount = netPrice.multiply(quantity);
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }
}

