/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.enums.ImBusinessTypeEnum;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@RpcService(value="ebiddingBuyImUserRecordServiceImpl")
public class EbiddingBuyUserRecordInvokeDubboServiceImpl
implements GroupChatRecordUserRpcService {
    @Resource
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        if (ImBusinessTypeEnum.EBIDDING_BUY.getValue().equals(imRecordDto.getBusinessType())) {
            PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            Assert.isTrue((!EbiddingStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_OutVIzEWShRe_d64caf4b", (String)"\u7ade\u4ef7\u5355\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            return this.queryAllUserWithGroupChat(accountInfoRpcService, supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImBusinessTypeEnum.SALE_EBIDDING_BUY.getValue().equals(imRecordDto.getBusinessType())) {
            SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)this.saleEbiddingHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            String toElsAccount = dbHead.getToElsAccount();
            String purchasePrincipal = dbHead.getPurchasePrincipal();
            String subAccount = dbHead.getUpdateBy().split("_")[0];
            if (CharSequenceUtil.isNotEmpty((CharSequence)purchasePrincipal)) {
                subAccount = purchasePrincipal.split("_")[0];
            }
            RecordUserDto e = new RecordUserDto();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

