/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.logisticspurchase.base.entity.DestinationAddressLibrary;
import com.els.modules.logisticspurchase.base.enumerate.AddressTypeEnum;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.mapper.DestinationAddressLibraryMapper;
import com.els.modules.logisticspurchase.base.service.DestinationAddressLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DestinationAddressLibraryServiceImpl
extends BaseServiceImpl<DestinationAddressLibraryMapper, DestinationAddressLibrary>
implements DestinationAddressLibraryService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void saveDestinationAddressLibrary(DestinationAddressLibrary destinationAddressLibrary) {
        this.check(destinationAddressLibrary);
        if (StrUtil.isBlank((CharSequence)destinationAddressLibrary.getArriveNumber())) {
            destinationAddressLibrary.setArriveNumber(this.baseRpcService.getNextCode("srmArriveNumber", (Object)destinationAddressLibrary));
        }
        destinationAddressLibrary.setDeleted(CommonConstant.DEL_FLAG_0);
        destinationAddressLibrary.setStatus(StatusEnum.EFFECTIVE.getValue());
        ((DestinationAddressLibraryMapper)this.baseMapper).insert((Object)destinationAddressLibrary);
    }

    private void check(DestinationAddressLibrary destinationAddressLibrary) {
        Assert.isNotBlank((String)destinationAddressLibrary.getArriveProvince(), (String)I18nUtil.translate((String)"i18n_field_ufbzxOLV_9776f3a", (String)"\u5230\u8fbe\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)destinationAddressLibrary.getArriveAddressType(), (String)I18nUtil.translate((String)"i18n_field_nRAcxOLV_da07d090", (String)"\u5730\u5740\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        if (AddressTypeEnum.HIGHWAY.getValue().equals(destinationAddressLibrary.getArriveAddressType())) {
            Assert.isNotBlank((String)destinationAddressLibrary.getArriveCity(), (String)I18nUtil.translate((String)"i18n_field_ufntKxOLV_349f56ad", (String)"\u5230\u8fbe\u5730\u7ea7\u5e02\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            Assert.isNotBlank((String)destinationAddressLibrary.getArriveCityStation(), (String)I18nUtil.translate((String)"i18n_field_nRAcxOLV_da07d090", (String)"\u5230\u8fbe\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    @Override
    public void updateDestinationAddressLibrary(DestinationAddressLibrary destinationAddressLibrary) {
        this.check(destinationAddressLibrary);
        ((DestinationAddressLibraryMapper)this.baseMapper).updateById((Object)destinationAddressLibrary);
    }

    @Override
    public void delDestinationAddressLibrary(String id) {
        ((DestinationAddressLibraryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchDestinationAddressLibrary(List<String> idList) {
        ((DestinationAddressLibraryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void frozenDestinationAddressLibrary(String id) {
        DestinationAddressLibrary destinationAddressLibrary = new DestinationAddressLibrary();
        destinationAddressLibrary.setId(id);
        destinationAddressLibrary.setStatus(StatusEnum.FROZEN.getValue());
        int count = ((DestinationAddressLibraryMapper)this.baseMapper).updateById((Object)destinationAddressLibrary);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawDestinationAddressLibrary(String id) {
        DestinationAddressLibrary destinationAddressLibrary = new DestinationAddressLibrary();
        destinationAddressLibrary.setId(id);
        destinationAddressLibrary.setStatus(StatusEnum.EFFECTIVE.getValue());
        int count = ((DestinationAddressLibraryMapper)this.baseMapper).updateById((Object)destinationAddressLibrary);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

