/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.excel.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnquiryPublishDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnquiryPublishDataListener.class);
    private List<PurchaseEnquiryItemLp> cachedDataList = Lists.newArrayList();
    private Map<Integer, ReadCellData<?>> headMap;
    private String itemNumber;
    private int row = 0;
    private ThreadLocal<Map<String, Integer>> itemNum = new ThreadLocal();

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        log.error("EnquiryPublishDataListener_onException:", (Throwable)exception);
        throw new ELSBootException((Throwable)exception);
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        this.headMap = headMap;
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        if (this.row == 0) {
            ++this.row;
            return;
        }
        JSONObject object = new JSONObject();
        for (Integer index : data.keySet()) {
            if (this.headMap.get(index) == null) continue;
            object.put(this.headMap.get(index).getStringValue(), (Object)data.get(index));
        }
        PurchaseEnquiryItemLp item = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)object.toJSONString(), PurchaseEnquiryItemLp.class));
        this.itemNumber = item.getSectionNumber();
        if (StrUtil.isBlank((CharSequence)this.itemNumber)) {
            if (!this.cachedDataList.isEmpty()) {
                return;
            }
            return;
        }
        Map<String, Integer> map = this.itemNum.get();
        if (ObjectUtil.isEmpty(map)) {
            map = new HashMap<String, Integer>();
        }
        if (map.containsKey(this.itemNumber)) {
            map.put(this.itemNumber, map.get(this.itemNumber) + 1);
        } else {
            map.put(this.itemNumber, 1);
        }
        this.itemNum.set(map);
        item.setItemNumber(this.itemNumber + "_" + this.formatItemNumber("" + map.get(this.itemNumber)));
        this.cachedDataList.add(item);
    }

    private String formatItemNumber(String itemNumber) {
        if (itemNumber.contains(".")) {
            return itemNumber.substring(0, itemNumber.indexOf("."));
        }
        return itemNumber;
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.row = 0;
    }

    public List<PurchaseEnquiryItemLp> getCachedDataList() {
        return this.cachedDataList;
    }
}

