/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.common.service.PurchaseTenderDataParse;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeItemService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.template.entity.PurchaseTenderVariableLibrary;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderDataParseBiddingImpl
implements PurchaseTenderDataParse {
    @Autowired
    private PurchaseTenderNoticeHeadService tenderNoticeHeadService;
    @Autowired
    private PurchaseTenderNoticeItemService purchaseTenderNoticeItemService;
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService purchaseTenderProjectAttachmentInfoService;

    @Override
    public void parse(String businessId, Map<String, Object> dataSource, List<String> variableList, List<PurchaseTenderVariableLibrary> lists, Map<String, Object> paramMap) {
        BigDecimal totalSaleAmount;
        List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfos;
        PurchaseTenderNoticeHead noticeHead = (PurchaseTenderNoticeHead)((Object)this.tenderNoticeHeadService.getById((Serializable)((Object)businessId)));
        if (noticeHead == null) {
            List<PurchaseTenderNoticeHead> purchaseTenderNoticeHeads = this.tenderNoticeHeadService.queryNoticeHeadBySubpackageId(businessId, null, null);
            noticeHead = CollectionUtil.isNotEmpty(purchaseTenderNoticeHeads) ? purchaseTenderNoticeHeads.get(0) : new PurchaseTenderNoticeHead();
        }
        this.putDataSource(dataSource, variableList, (Serializable)((Object)noticeHead));
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems = this.purchaseTenderNoticeItemService.selectByMainId(noticeHead.getId());
        if (CollectionUtil.isEmpty(purchaseTenderNoticeItems)) {
            dataSource.put("purchaseTenderNoticeItemList", Lists.newArrayList());
        } else {
            PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = new PurchaseTenderNoticeHeadVO();
            purchaseTenderNoticeHeadVO.setPurchaseTenderNoticeItemList(purchaseTenderNoticeItems);
            JSONObject jsonObject = this.translateDictText((Object)purchaseTenderNoticeHeadVO);
            dataSource.put("purchaseTenderNoticeItemList", jsonObject.get((Object)"purchaseTenderNoticeItemList"));
        }
        if (variableList.contains("preSaleAmount")) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.ONE_STEP.getValue(), null);
            purchaseTenderProjectAttachmentInfos = this.purchaseTenderProjectAttachmentInfoService.selectBySubpackageId(noticeHead.getSubpackageId());
            purchaseTenderProjectAttachmentInfos.forEach(attachmentInfo -> {
                if (attachmentInfo.getSaleAmount() == null) {
                    attachmentInfo.setSaleAmount(BigDecimal.ZERO);
                }
            });
            totalSaleAmount = purchaseTenderProjectAttachmentInfos.stream().map(PurchaseTenderProjectAttachmentInfo::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            dataSource.put("preSaleAmount", totalSaleAmount);
        }
        if (variableList.contains("saleAmount")) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.ONE_STEP.getValue(), null);
            purchaseTenderProjectAttachmentInfos = this.purchaseTenderProjectAttachmentInfoService.selectBySubpackageId(noticeHead.getSubpackageId());
            purchaseTenderProjectAttachmentInfos.forEach(attachmentInfo -> {
                if (attachmentInfo.getSaleAmount() == null) {
                    attachmentInfo.setSaleAmount(BigDecimal.ZERO);
                }
            });
            totalSaleAmount = purchaseTenderProjectAttachmentInfos.stream().map(PurchaseTenderProjectAttachmentInfo::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            dataSource.put("saleAmount", totalSaleAmount);
        }
    }
}

