/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.im;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingAttendees;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenderOpenBidUserRecord
implements GroupChatRecordUserRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTenderOpenBidUserRecord.class);

    public List<RecordUserDto> getRecordPurchasePersonInCharge(GroupChatRecordDto imRecordDto) {
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        TenderProjectSupplierService tenderProjectSupplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        PurchaseTenderProjectHeadService projectHeadService = (PurchaseTenderProjectHeadService)SpringContextUtils.getBean(PurchaseTenderProjectHeadService.class);
        PurchaseTenderProjectOpenSettingHeadService openSettingHeadService = (PurchaseTenderProjectOpenSettingHeadService)SpringContextUtils.getBean(PurchaseTenderProjectOpenSettingHeadService.class);
        PurchaseTenderProjectHeadVO purchaseTenderProjectHead = projectHeadService.queryProjectHeadBySubpackageId(imRecordDto.getBusinessId());
        RecordUserDto imExecutorUserDTO = new RecordUserDto();
        imExecutorUserDTO.setElsAccount(purchaseTenderProjectHead.getPurchaseExecutorAccount() + "_" + purchaseTenderProjectHead.getPurchaseExecutorSubAccount());
        resultList.add(imExecutorUserDTO);
        RecordUserDto imTendereeUserDTO = new RecordUserDto();
        imTendereeUserDTO.setElsAccount(purchaseTenderProjectHead.getElsAccount() + "_" + purchaseTenderProjectHead.getCreateBy());
        resultList.add(imTendereeUserDTO);
        PurchaseOpenSettingHeadVO settingHeadVO = openSettingHeadService.queryBySubpackageId(imRecordDto.getBusinessId());
        if (settingHeadVO == null) {
            log.warn("purchaseTenderOpenBidUserRecordServiceImpl:::{}", (Object)"\u5f00\u6807\u8bbe\u7f6e\u4e0d\u5b58\u5728\uff01");
            return resultList;
        }
        TenderFlagInjectionContext.setTenderCheckType(settingHeadVO.getCheckType());
        TenderFlagInjectionContext.setTenderProcessType(settingHeadVO.getProcessType());
        TenderFlagInjectionContext.setTenderCurrentStep(settingHeadVO.getCurrentStep());
        List<PurchaseTenderProjectOpenSettingAttendees> attendeesList = settingHeadVO.getAttendeesList();
        if (CollectionUtil.isNotEmpty(attendeesList)) {
            for (PurchaseTenderProjectOpenSettingAttendees attendees : attendeesList) {
                RecordUserDto imUserDTO = new RecordUserDto();
                imUserDTO.setElsAccount(attendees.getElsAccount() + "_" + attendees.getAttendeesElsSubAccount());
                resultList.add(imUserDTO);
            }
        }
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSubpackageId(imRecordDto.getBusinessId());
        List<TenderProjectSupplier> tenderProjectSuppliers = tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(tenderProjectSupplier.getPreResponseStatus()) || "1".equals(tenderProjectSupplier.getResponseStatus()) || "1".equals(tenderProjectSupplier.getResultResponseStatus())).forEach(tenderProjectSupplier -> {
            RecordUserDto imUserDTO = new RecordUserDto();
            String supplierSubAccount = StrUtil.isNotBlank((CharSequence)tenderProjectSupplier.getSupplierSubAccount()) ? tenderProjectSupplier.getSupplierSubAccount() : "1001";
            imUserDTO.setElsAccount(tenderProjectSupplier.getSupplierAccount() + "_" + supplierSubAccount);
            resultList.add(imUserDTO);
        });
        List<ElsSubAccountDTO> tenderProjectMember = TenderProjectMemberUtils.getTenderProjectMember(purchaseTenderProjectHead.getId());
        for (ElsSubAccountDTO elsSubAccountDTO : tenderProjectMember) {
            RecordUserDto imUserDTO = new RecordUserDto();
            String supplierSubAccount = StrUtil.isNotBlank((CharSequence)elsSubAccountDTO.getSubAccount()) ? elsSubAccountDTO.getSubAccount() : "1001";
            imUserDTO.setElsAccount(elsSubAccountDTO.getElsAccount() + "_" + supplierSubAccount);
            resultList.add(imUserDTO);
        }
        return resultList.stream().filter(AbstractTenderOpenBidUserRecord.distinctByKey(RecordUserDto::getElsAccount)).collect(Collectors.toList());
    }

    public List<RecordUserDto> getRecordSalePersonInCharge(GroupChatRecordDto imRecordDto) {
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        List<ElsSubAccountDTO> tenderProjectMemberList = TenderProjectMemberUtils.getTenderProjectMemberBySubpackageId(imRecordDto.getBusinessId());
        if (CollectionUtil.isNotEmpty(tenderProjectMemberList)) {
            for (ElsSubAccountDTO accountDTO : tenderProjectMemberList) {
                RecordUserDto imUserDTO = new RecordUserDto();
                imUserDTO.setElsAccount(accountDTO.getElsAccount() + "_" + accountDTO.getSubAccount());
                resultList.add(imUserDTO);
            }
        }
        return resultList.stream().filter(AbstractTenderOpenBidUserRecord.distinctByKey(RecordUserDto::getElsAccount)).collect(Collectors.toList());
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

