/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.project.entity.PurchaseTenderSubpackagePriceChange;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderSubpackagePriceChangeService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderSubpackagePriceChangeSubmitVo;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;

@RpcService(value="subpackagePriceChangeAuditCallBackServiceImpl")
public class PurchaseSubpackagePriceChangeAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseTenderSubpackagePriceChangeService priceChangeService;
    @Resource
    private PurchaseTenderProjectHeadService headService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseTenderSubpackagePriceChangeSubmitVo priceChangeSubmitVo = (PurchaseTenderSubpackagePriceChangeSubmitVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseTenderSubpackagePriceChangeSubmitVo.class));
        List<PurchaseTenderSubpackagePriceChange> subpackagePriceChanges = priceChangeSubmitVo.getSubpackagePriceChanges();
        this.priceChangeService.updateSubpackageInfoAndChangeInfo(subpackagePriceChanges);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderProjectHeadVO head = this.headService.queryById(id);
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderSubpackagePriceChangeSubmitVo priceChangeSubmitVo = (PurchaseTenderSubpackagePriceChangeSubmitVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseTenderSubpackagePriceChangeSubmitVo.class));
        List<PurchaseTenderSubpackagePriceChange> subpackagePriceChanges = priceChangeSubmitVo.getSubpackagePriceChanges();
        subpackagePriceChanges.forEach(x -> {
            x.setFlowId(flowCallbackDTO.getProcessInstanceId());
            x.setAuditStatus(auditStatus);
        });
        this.priceChangeService.saveOrUpdateBatch(subpackagePriceChanges);
    }
}

