/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.enumerate.BiddingEvaluationTemplateStatusEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="biddingEvaluationTemplateAuditCallBackServiceImpl")
public class BiddingEvaluationTemplateAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        evaluationTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        evaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.TAKE_EFFECT.getValue());
        this.biddingEvaluationTemplateHeadMapper.updateById((Object)evaluationTemplateHead);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        BiddingEvaluationTemplateHead head = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        biddingEvaluationTemplateHead.setAuditStatus(auditStatus);
        biddingEvaluationTemplateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.biddingEvaluationTemplateHeadMapper.updateById((Object)biddingEvaluationTemplateHead);
    }
}

