/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemHisMapper;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingItemHisServiceImpl
extends ServiceImpl<SaleEbiddingItemHisMapper, SaleEbiddingItemHis>
implements SaleEbiddingItemHisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingItemHisServiceImpl.class);
    @Resource
    private PurchaseEbiddingItemHisMapper purchaseEbiddingItemHisMapper;
    @Resource
    private SaleEbiddingItemHisMapper saleEbiddingItemHisMapper;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;

    @Override
    public List<SaleEbiddingItemHis> queryBidLobbyDetail(SaleEbiddingHead head) {
        List resultList;
        String supplierShow;
        String string = supplierShow = head.getSupplierShow() == null ? "" : head.getSupplierShow();
        if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue())) {
            List purchaseList = this.purchaseEbiddingItemHisMapper.selectByMainId(head.getRelationId()).stream().filter(itemHis -> {
                if (!EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                    return itemHis.getItemNumber().equals(head.getCurrentItemNumber());
                }
                return true;
            }).collect(Collectors.toList());
            resultList = SysUtil.copyProperties(purchaseList, SaleEbiddingItemHis.class);
            for (SaleEbiddingItemHis itemHis2 : resultList) {
                String elsAccount = itemHis2.getElsAccount();
                itemHis2.setElsAccount(itemHis2.getToElsAccount());
                itemHis2.setToElsAccount(elsAccount);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (!EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                queryWrapper.eq(SaleEbiddingItemHis::getItemNumber, (Object)head.getCurrentItemNumber());
            }
            queryWrapper.eq(SaleEbiddingItemHis::getHeadId, (Object)head.getId());
            queryWrapper.orderByDesc(SaleEbiddingItemHis::getQuoteTime);
            resultList = this.list((Wrapper)queryWrapper);
        }
        return resultList;
    }

    @Override
    public List<SaleEbiddingItemHis> queryQuoteDetail(SaleEbiddingHead dbHead, String itemNumber) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHis::getHeadId, (Object)dbHead.getId())).eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), SaleEbiddingItemHis::getItemNumber, (Object)itemNumber)).orderByAsc(SaleEbiddingItemHis::getQuoteTime));
    }

    @Override
    public void save(SaleEbiddingHead head, List<SaleEbiddingItem> quoteList, PurchaseEbiddingSupplier supplier) {
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
        executor.execute(() -> {
            List itemIdList = quoteList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            SaleEbiddingItemHis updateSale = new SaleEbiddingItemHis();
            updateSale.setLastQuote("0");
            ((SaleEbiddingItemHisMapper)this.baseMapper).update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().in(SaleEbiddingItemHis::getItemId, itemIdList));
            List purchaseItemIdList = quoteList.stream().map(SaleEbiddingItem::getRelationId).collect(Collectors.toList());
            PurchaseEbiddingItemHis updatePurchase = new PurchaseEbiddingItemHis();
            updatePurchase.setLastQuote("0");
            this.purchaseEbiddingItemHisMapper.update((Object)updatePurchase, (Wrapper)new LambdaQueryWrapper().in(PurchaseEbiddingItemHis::getItemId, purchaseItemIdList));
            for (SaleEbiddingItem quoteItem : quoteList) {
                SaleEbiddingItemHis his = new SaleEbiddingItemHis();
                BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)his));
                his.setId(null);
                his.setItemId(quoteItem.getId());
                his.setHeadId(head.getId());
                his.setLastQuote("1");
                his.setQuoteType(head.getQuoteType());
                his.setEbiddingWay(head.getEbiddingWay());
                his.setQuoteSubAccount(sysUser.getSubAccount());
                his.setQuoteUser(sysUser.getRealname());
                if (EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                    List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(head.getId());
                    String materialNumber = itemList.stream().map(SaleEbiddingItem::getMaterialNumber).distinct().collect(Collectors.joining(","));
                    his.setMaterialNumber(materialNumber);
                    his.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
                }
                ((SaleEbiddingItemHisMapper)this.baseMapper).insert((Object)his);
                PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
                BeanUtils.copyProperties((Object)((Object)his), (Object)((Object)purchaseHis));
                purchaseHis.setId(null);
                purchaseHis.setRelationId(his.getId());
                purchaseHis.setHeadId(head.getRelationId());
                purchaseHis.setItemId(quoteItem.getRelationId());
                purchaseHis.setElsAccount(head.getToElsAccount());
                purchaseHis.setToElsAccount(head.getElsAccount());
                purchaseHis.setSupplierName(supplier.getSupplierName());
                this.purchaseEbiddingItemHisMapper.insert((Object)purchaseHis);
            }
        });
    }

    @Override
    public void quoteAccept(SaleEbiddingItemHis dbItemHis) {
        dbItemHis.setAccept("1");
        this.updateById((Object)dbItemHis);
        PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
        purchaseHis.setId(dbItemHis.getRelationId());
        purchaseHis.setAccept("1");
        purchaseHis.setBidNumber(dbItemHis.getBidNumber());
        this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
    }

    @Override
    public long quoteReject(SaleEbiddingItemHis dbItemHis) {
        dbItemHis.setAccept("0");
        this.updateById((Object)dbItemHis);
        PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
        purchaseHis.setId(dbItemHis.getRelationId());
        purchaseHis.setAccept("0");
        this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
        List dbList = ((SaleEbiddingItemHisMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHis::getItemId, (Object)dbItemHis.getItemId()));
        return dbList.stream().filter(his -> "0".equals(his.getAccept())).count();
    }

    @Override
    public List<SaleEbiddingItemHis> selectWithoutElsAccountNotAccept(String ebiddingNumber) {
        return this.saleEbiddingItemHisMapper.selectWithoutElsAccountNotAccept(ebiddingNumber);
    }

    @Override
    public List<SaleEbiddingItemHis> selectWithoutElsAccountByHeadIdNotAccept(List<String> saleHeadIdList) {
        return this.saleEbiddingItemHisMapper.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
    }

    @Override
    public List<SaleEbiddingItemHis> queryAcceptDetail(SaleEbiddingHead dbHead) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHis::getHeadId, (Object)dbHead.getId())).eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), SaleEbiddingItemHis::getAccept, (Object)"1")).orderByAsc(SaleEbiddingItemHis::getQuoteTime));
    }

    @Override
    public void updateBidResultByNumber(List<SaleEbiddingItemHis> saleItemList) {
        this.saleEbiddingItemHisMapper.updateBidResultByNumber(saleItemList);
    }
}

