/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrate.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.aspect.DictTranslateAspect;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SpringContextUtils;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.integrate.service.IntegrateInvokeInquiryDataService;
import com.els.modules.integrated.api.dto.IntegratedSerachConditionDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegrateInvokeInquiryDataServiceImpl
implements IntegrateInvokeInquiryDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrateInvokeInquiryDataServiceImpl.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;

    @Override
    public JSONArray listInquiryData(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessDataType()) && "head".equals(integratedSerachConditionDTO.getBusinessDataType())) {
            String businessTypeCore = integratedSerachConditionDTO.getBusinessTypeCore();
            JSONArray objects = new JSONArray();
            if (StrUtil.isNotBlank((CharSequence)businessTypeCore)) {
                switch (businessTypeCore) {
                    case "purchaseRequest": {
                        ArrayList<PurchaseRequestHeadVO> headVOList = new ArrayList<PurchaseRequestHeadVO>();
                        List<PurchaseRequestHead> purchaseContractHeads = this.getRequestDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(purchaseContractHeads)) break;
                        List collect = purchaseContractHeads.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                        List list = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(PurchaseRequestItem::getHeadId, collect)).list();
                        Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseRequestItem::getHeadId, p -> {
                            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
                            getNameList.add((PurchaseRequestItem)((Object)p));
                            return getNameList;
                        }, (value1, value2) -> {
                            value1.addAll(value2);
                            return value1;
                        }));
                        for (PurchaseRequestHead head : purchaseContractHeads) {
                            PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
                            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)purchaseRequestHeadVO));
                            if (collectItem.containsKey(head.getId())) {
                                purchaseRequestHeadVO.setPurchaseRequestItemList(collectItem.get(head.getId()));
                            }
                            headVOList.add(purchaseRequestHeadVO);
                        }
                        objects = this.dictAspectVO(Result.ok(headVOList));
                        break;
                    }
                    case "bidding": {
                        ArrayList<PurchaseBiddingHeadVO> biddingHeadVOS = new ArrayList<PurchaseBiddingHeadVO>();
                        List<PurchaseBiddingHead> biddingDataByIntegraSerach = this.getBiddingDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(biddingDataByIntegraSerach)) break;
                        List collect = biddingDataByIntegraSerach.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                        List list = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().in(PurchaseBiddingItem::getHeadId, collect)).list();
                        Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseBiddingItem::getHeadId, p -> {
                            ArrayList<PurchaseBiddingItem> getNameList = new ArrayList<PurchaseBiddingItem>();
                            getNameList.add((PurchaseBiddingItem)((Object)p));
                            return getNameList;
                        }, (value1, value2) -> {
                            value1.addAll(value2);
                            return value1;
                        }));
                        for (PurchaseBiddingHead head : biddingDataByIntegraSerach) {
                            PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
                            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                            if (collectItem.containsKey(head.getId())) {
                                headVO.setPurchaseBiddingItemList(collectItem.get(head.getId()));
                            }
                            biddingHeadVOS.add(headVO);
                        }
                        return this.dictAspectVO(Result.ok(biddingHeadVOS));
                    }
                    case "ebidding": {
                        ArrayList<PurchaseEbiddingHeadVO> ebiddingHeadVOS = new ArrayList<PurchaseEbiddingHeadVO>();
                        List<PurchaseEbiddingHead> ebiddingDataByIntegraSerach = this.getEbiddingDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(ebiddingDataByIntegraSerach)) break;
                        List collect = ebiddingDataByIntegraSerach.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                        List list = ((LambdaQueryChainWrapper)this.purchaseEbiddingItemService.lambdaQuery().in(PurchaseEbiddingItem::getHeadId, collect)).list();
                        Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getHeadId, p -> {
                            ArrayList<PurchaseEbiddingItem> getNameList = new ArrayList<PurchaseEbiddingItem>();
                            getNameList.add((PurchaseEbiddingItem)((Object)p));
                            return getNameList;
                        }, (value1, value2) -> {
                            value1.addAll(value2);
                            return value1;
                        }));
                        for (PurchaseEbiddingHead head : ebiddingDataByIntegraSerach) {
                            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
                            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                            if (collectItem.containsKey(head.getId())) {
                                headVO.setPurchaseEbiddingItemList(collectItem.get(head.getId()));
                            }
                            ebiddingHeadVOS.add(headVO);
                        }
                        objects = this.dictAspectVO(Result.ok(ebiddingHeadVOS));
                        break;
                    }
                    case "enquiry": {
                        ArrayList<PurchaseEnquiryHeadVO> enquiryHeadVOS = new ArrayList<PurchaseEnquiryHeadVO>();
                        List<PurchaseEnquiryHead> enquiryDataByIntegraSerach = this.getEnquiryDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(enquiryDataByIntegraSerach)) break;
                        List collect = enquiryDataByIntegraSerach.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                        List list = ((LambdaQueryChainWrapper)this.purchaseEnquiryItemService.lambdaQuery().in(PurchaseEnquiryItem::getHeadId, collect)).list();
                        Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getHeadId, p -> {
                            ArrayList<PurchaseEnquiryItem> getNameList = new ArrayList<PurchaseEnquiryItem>();
                            getNameList.add((PurchaseEnquiryItem)((Object)p));
                            return getNameList;
                        }, (value1, value2) -> {
                            value1.addAll(value2);
                            return value1;
                        }));
                        for (PurchaseEnquiryHead head : enquiryDataByIntegraSerach) {
                            PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
                            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                            if (collectItem.containsKey(head.getId())) {
                                headVO.setPurchaseEnquiryItemList(collectItem.get(head.getId()));
                            }
                            enquiryHeadVOS.add(headVO);
                        }
                        objects = this.dictAspectVO(Result.ok(enquiryHeadVOS));
                    }
                }
            }
            log.info("Inquiry\u67e5\u8be2\u5355\u636e\u8fd4\u56de\u5b57\u8282\u957f\u5ea6:" + objects.size() + "jsonArray\u683c\u5f0f" + objects.toJSONString());
            return objects;
        }
        return new JSONArray();
    }

    private JSONArray dictAspectVO(Result<?> result) {
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate(result);
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)result.getResult()));
        return jsonArray;
    }

    private List<PurchaseRequestHead> getRequestDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseRequestHead::getRequestNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseRequestHead::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeInquiryDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(ParentEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseRequestHeadService.list((Wrapper)queryWrapper);
    }

    public static <T> void createQW(QueryWrapper<T> qw, List<String> collect) {
        int index = 0;
        for (String s : collect) {
            if (index == 0) {
                qw.nested(qw1 -> qw1.like((Object)"document_id", (Object)s));
                ++index;
                continue;
            }
            qw.or(qw1 -> qw1.eq((Object)"document_id", (Object)s));
        }
    }

    private List<PurchaseEnquiryHead> getEnquiryDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseEnquiryHead::getEnquiryNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseEnquiryHead::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeInquiryDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(ParentEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseBiddingHead> getBiddingDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseBiddingHead::getBiddingNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseBiddingHead::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeInquiryDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(ParentEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseBiddingHeadService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseEbiddingHead> getEbiddingDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseEbiddingHead::getEbiddingNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseEbiddingHead::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeInquiryDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(ParentEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseEbiddingHeadService.list((Wrapper)queryWrapper);
    }
}

