/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.notice.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeTypeEnum;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="noticeAuditCallBackServiceImpl")
public class PurchaseTenderNoticeAdapter
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderNoticeAdapter.class);
    @Resource
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = new PurchaseTenderNoticeHead();
        purchaseTenderNoticeHead.setAuditStatus(auditStatus);
        purchaseTenderNoticeHead.setId(flowCallbackDTO.getBusinessId());
        purchaseTenderNoticeHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseTenderNoticeHeadService.updateById((Object)purchaseTenderNoticeHead);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = this.purchaseTenderNoticeHeadService.queryById(flowCallbackDTO.getBusinessId());
        if (PurchaseTenderNoticeTypeEnum.hasPreTrial(purchaseTenderNoticeHeadVO.getNoticeType())) {
            TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue());
        } else {
            TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        }
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderNoticeHeadVO), PurchaseTenderNoticeHead.class));
        this.purchaseTenderNoticeHeadService.publish(purchaseTenderNoticeHead, purchaseTenderNoticeHeadVO.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadVO.getPurchaseTenderSupplierInvitation());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderNoticeHead head = (PurchaseTenderNoticeHead)((Object)this.purchaseTenderNoticeHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }
}

