/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateItem;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.PurchaseConfirmBiddingHis;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.service.BiddingEvaluationTemplateHeadService;
import com.els.modules.bidding.service.BiddingEvaluationTemplateItemService;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.PurchaseConfirmBiddingHisService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingEvaluationTemplateHeadVO;
import com.els.modules.bidding.vo.BiddingFileVO;
import com.els.modules.bidding.vo.BiddingMemberVO;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.ConfirmBidVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.SaleBiddingAttachmentVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.entity.ProbeResult;
import com.els.modules.ebidding.service.ProbeResultService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingHead"})
@Api(tags={"\u91c7\u8d2d\u62db\u6807\u5355"})
@BusinessModule(module="bidding")
public class PurchaseBiddingHeadController
extends BaseController<PurchaseBiddingHead, PurchaseBiddingHeadService> {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingEvaResultService purchaseBiddingEvaResultService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SearSourMaterValidService validService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Autowired
    private PurchaseConfirmBiddingHisService purchaseConfirmBiddingHisService;
    @Autowired
    private BiddingEvaluationTemplateHeadService biddingEvaluationTemplateHeadService;
    @Autowired
    private BiddingEvaluationTemplateItemService biddingEvaluationTemplateItemService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private ProbeResultService probeResultService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryPageList(PurchaseBiddingHead purchaseBiddingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"create_type", (Object)"bidding");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listProject"})
    @PermissionDataView(businessType="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryPageList(PurchaseBiddingProjectHead purchaseBiddingProjectHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingProjectHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryTabsCount(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"create_type", (Object)"bidding");
        queryWrapper.select(new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = ((PurchaseBiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807-\u8f6c\u5408\u540c")
    @ApiOperation(value="\u751f\u6210\u5408\u540c", notes="\u751f\u6210\u5408\u540c")
    @PostMapping(value={"/generateContract"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:generateContract"})
    public Result<?> generateContract(@RequestBody PurchaseBiddingHeadVO headVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)headVO.getTemplateNumber()), (String)I18nUtil.translate((String)"i18n_alert_ViFvKneIr_c1af30e5", (String)"\u8bf7\u9009\u62e9\u8303\u5f0f\u5408\u540c\u6a21\u677f"));
        List<PurchaseContractHeadDTO> strings = ((PurchaseBiddingHeadService)this.service).generateContract(headVO);
        if (!strings.isEmpty() && strings.size() == 1) {
            return Result.ok(strings);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractHeadDTO s : strings) {
            stringBuffer = stringBuffer.append(" " + s.getContractNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_bLneLRLRbLnetW0tyzqL_dd17f85e", (String)"\u751f\u6210\u5408\u540c\u6210\u529f,\u6210\u529f\u751f\u6210\u5408\u540c\u5355\u6570:${0},\u5355\u53f7\u5206\u522b\u4e3a:", (String[])new String[]{String.valueOf(strings.size())}) + stringBuffer));
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/contractQueryBidding"})
    @PermissionDataView(businessType="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> contractQueryBidding(PurchaseBiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((QueryWrapper)queryWrapper.inSql((Object)"bidding_number", "select bidding_number from purchase_bidding_head where bidding_status=5 ")).orderByDesc((Object)"create_time");
        queryWrapper.ne((Object)"material_number", (Object)"");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba2\u5355\u5206\u9875\u5217\u8868\u67e5\u8be2\u62db\u6807\u884c", notes="\u8ba2\u5355\u5206\u9875\u5217\u8868\u67e5\u8be2\u62db\u6807\u884c")
    @GetMapping(value={"/orderQueryBiddingByDesc"})
    @PermissionDataView(businessType="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> orderQueryBiddingByDesc(PurchaseBiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.inSql((Object)"bidding_number", "select bidding_number from purchase_bidding_head where bidding_status=5 ");
        queryWrapper.eq((Object)"item_status", (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        queryWrapper.eq((Object)"material_desc", (Object)item.getMaterialDesc());
        queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.isNull((Object)"material_number")).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"material_number", (Object)"");
            });
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> add(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        purchaseBiddingHead.setCreateType("bidding");
        this.purchaseBiddingHeadService.saveMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseBiddingHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> edit(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead dbPurchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)purchaseBiddingHeadPage.getId())));
        Assert.isTrue((boolean)BiddingStatusEnum.NEW.getValue().equals(dbPurchaseBiddingHead.getBiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_tFAPzExiTAt_329ae541", (String)"\u5355\u636e\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91"));
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.updateMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        String id = purchaseBiddingHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:publish"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> publish(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        this.validService.publishBidding(purchaseBiddingHeadPage.getPurchaseOrg(), purchaseBiddingHeadPage.getPurchaseBiddingItemList());
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getBiddingNumber())) {
            purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        }
        this.purchaseBiddingHeadService.publish(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807", notes="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @PostMapping(value={"/requestToBidding"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:requestToBidding"})
    public Result<?> requestToBidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String flag;
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        boolean allowMultipleSources = false;
        if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
            allowMultipleSources = true;
        }
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseBiddingHead head = new PurchaseBiddingHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        head.setCreateType("bidding");
        ArrayList<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List collect1 = requestItemList.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        List purchaseRequestItemDb = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, collect1)).list();
        ArrayList<PurchaseRequestItem> purchaseRequestItems = new ArrayList<PurchaseRequestItem>();
        block0: for (PurchaseRequestItem item2 : requestItemList) {
            for (Object item1 : purchaseRequestItemDb) {
                if (!Objects.equals(item2.getId(), item1.getId())) continue;
                purchaseRequestItems.add((PurchaseRequestItem)((Object)item1));
                continue block0;
            }
        }
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("2", ((PurchaseRequestItem)((Object)purchaseRequestItems.get(0))).getPurchaseOrg(), purchaseRequestItems);
        List<PurchaseRequestItem> mergeRequestList = this.purchaseRequestItemService.mergeRequest(purchaseRequestItems);
        Map<String, String> itemValueMap = DefaultValueInitUtil.getItemDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        for (PurchaseRequestItem requestItem : mergeRequestList) {
            if (!allowMultipleSources && !arrayList.contains(requestItem.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseBiddingItem item3 = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item3));
            item3.setId(null);
            item3.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item3.setSourceNumber(requestItem.getRequestNumber());
            item3.setSourceItemNumber(requestItem.getItemNumber());
            item3.setSourceItemId(requestItem.getId());
            item3.setPriceUnit(requestItem.getUnitPrice());
            String purchaseUnit = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseUnit", requestItem.getPurchaseUnit());
            String purchaseType = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseType", requestItem.getPurchaseType());
            item3.setPurchaseUnit(purchaseUnit);
            item3.setPurchaseType(purchaseType);
            item3.setRequireQuantity(requestItem.getQuantity());
            item3.setRequireDate(requestItem.getDeliveryDate());
            itemList.add(item3);
        }
        head.setDocumentId(requestItemList.get(0).getDocumentId());
        if (StringUtils.isNotBlank((CharSequence)requestItemList.get(0).getDocumentId())) {
            head.setDocumentParentId(requestItemList.get(0).getHeadId());
        }
        head.setCompany(requestItemList.get(0).getCompany());
        Map<String, String> headValueMap = DefaultValueInitUtil.getHeadDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        String purchaseGroup = DefaultValueInitUtil.getFieldValue(headValueMap, "purchaseGroup", mergeRequestList.get(0).getPurchaseGroup());
        head.setPurchaseGroup(purchaseGroup);
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)head));
        List headIds = requestHeadVO.getPurchaseRequestItemList().stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        Map headIdList = requestHeadVO.getPurchaseRequestItemList().stream().collect(Collectors.groupingBy(PurchaseRequestItem::getHeadId, Collectors.mapping(PurchaseRequestItem::getItemNumber, Collectors.toList())));
        List<PurchaseAttachmentDTO> requestAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(headIds);
        requestAttachmentDTOS = requestAttachmentDTOS.stream().filter(x -> {
            if (CharSequenceUtil.isEmpty((CharSequence)x.getItemNumber())) {
                return true;
            }
            List itemFileNnmber = (List)headIdList.get(x.getHeadId());
            if (CollectionUtil.isEmpty((Collection)itemFileNnmber)) {
                return false;
            }
            return itemFileNnmber.contains(x.getItemNumber());
        }).collect(Collectors.toList());
        HashMap<String, String> itemIndex = new HashMap<String, String>();
        for (int i = 0; i < itemList.size(); ++i) {
            PurchaseBiddingItem item4 = (PurchaseBiddingItem)((Object)itemList.get(i));
            itemIndex.put(item4.getHeadId() + "_" + item4.getSourceItemNumber(), i + 1 + "");
        }
        for (PurchaseAttachmentDTO dto : requestAttachmentDTOS) {
            if (itemIndex.containsKey(dto.getHeadId() + "_" + dto.getItemNumber())) {
                dto.setItemNumber((String)itemIndex.get(dto.getHeadId() + "_" + dto.getItemNumber()));
            }
            dto.setHeadId(null);
            dto.setId(null);
            dto.setRelationId(null);
            dto.setCreateBy(null);
            dto.setCreateById(null);
            dto.setCreateTime(null);
            dto.setUpdateTime(null);
            dto.setUpdateBy(null);
            dto.setUpdateById(null);
        }
        this.purchaseBiddingHeadService.saveMain(head, itemList, new ArrayList<BiddingSupplier>(), new ArrayList<PurchaseBiddingSpecialist>(), new ArrayList<PurchaseAttachmentDemandDTO>(), requestAttachmentDTOS);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_sYBLRWYBtyLWWWWWWW_48162811", (String)"\u8f6c\u62db\u6807\u6210\u529f,\u62db\u6807\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getBiddingNumber()}), Arrays.asList(head));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u5f00\u901a\u6743\u9650")
    @ApiOperation(value="\u5f00\u901a\u6743\u9650", notes="\u5f00\u901a\u6743\u9650")
    @PostMapping(value={"/openPermission"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:openPermission"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> openPermission(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.openPermission(purchaseBiddingHead, purchaseBiddingHeadPage.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:delete"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u4f5c\u5e9f\u62db\u6807\u5355")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f\u62db\u6807\u5355", notes="\u901a\u8fc7id\u4f5c\u5e9f\u62db\u6807\u5355")
    @GetMapping(value={"/abandoned"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:abandoned"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> abandoned(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.abandoned(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u6839\u636eid\u83b7\u53d6\u7ebf\u4e0b\u8bc4\u6807\u5185\u5bb9")
    @ApiOperation(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", notes="\u6839\u636eid\u83b7\u53d6\u7ebf\u4e0b\u8bc4\u6807\u5185\u5bb9")
    @GetMapping(value={"/bidEvaOfOffLine"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> bidEvaOfOffLine(@RequestParam(name="id") String id) {
        List srmFileTypeBidEva;
        LoginUser user = SysUtil.getLoginUser();
        List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType()) && MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).collect(Collectors.toList());
        List specialistList = purchaseBiddingSpecialistList.stream().filter(o -> o.getSubAccount().equals(user.getSubAccount())).collect(Collectors.toList());
        if (specialistList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjYBBFLqItkW_93b4c8b1", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
        PurchaseBiddingHead byId = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (BiddingStatusEnum.BIDDING.getValue().equals(byId.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(byId.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_status_can_not_view", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u67e5\u770b\uff01"));
        }
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)purchaseBiddingHeadVO));
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        if (biddingSupplierList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_PSIeBRdX_84681f27", (String)"\u6682\u65e0\u5df2\u6295\u6807\u4f9b\u5e94\u5546\uff01"));
        }
        List<BiddingSupplierVO> biddingSupplierVOS = this.purchaseBiddingEvaResultService.bidEvaOfOffLine(biddingSupplierList);
        purchaseBiddingHeadVO.setBiddingSupplierVOList(biddingSupplierVOS);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList) && !(srmFileTypeBidEva = this.invokeBaseRpcService.queryDictItemsByCode("srmFileTypeBidEva", TenantContext.getTenant())).isEmpty()) {
            List collect = srmFileTypeBidEva.stream().map(DictDTO::getValue).collect(Collectors.toList());
            List<PurchaseAttachmentDTO> collect1 = purchaseAttachmentList.stream().filter(item -> collect.contains(item.getFileType())).collect(Collectors.toList());
            purchaseBiddingHeadVO.setPurchaseAttachmentBidEvaList(collect1);
        }
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u5b9a\u6807\u53d8\u66f4", value="\u6839\u636eid\u91c7\u8d2d\u5b9a\u6807\u53d8\u66f4")
    @ApiOperation(value="\u91c7\u8d2d\u5b9a\u6807\u53d8\u66f4", notes="\u6839\u636eid\u91c7\u8d2d\u5b9a\u6807\u53d8\u66f4")
    @GetMapping(value={"/updateBidComfirmResult"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:edit"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> updateBidComfirmResult(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.updateBidComfirmResult(id);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="bidding")
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = this.queryDataById(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)id);
        queryWrapper.eq((Object)"relation_module", (Object)"bidding");
        List resultList = this.probeResultService.list((Wrapper)queryWrapper);
        purchaseBiddingHeadVO.setProbeResultList(resultList);
        purchaseBiddingHeadVO.setBiddingProjectStatus(purchaseBiddingHeadVO.getBiddingStatus());
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryBiddingAllFileById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryBiddingAllFileById(@RequestParam(name="id") String id) {
        List srmFileTypeBidEva;
        BiddingFileVO biddingFileVO = new BiddingFileVO();
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        biddingFileVO.setPurchaseAttachmentList(purchaseAttachmentList);
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList) && !(srmFileTypeBidEva = this.invokeBaseRpcService.queryDictItemsByCode("srmFileTypeBidEva", TenantContext.getTenant())).isEmpty()) {
            List collect = srmFileTypeBidEva.stream().map(DictDTO::getValue).collect(Collectors.toList());
            List<PurchaseAttachmentDTO> collect1 = purchaseAttachmentList.stream().filter(item -> collect.contains(item.getFileType())).collect(Collectors.toList());
            biddingFileVO.setPurchaseAttachmentBidEvaList(collect1);
        }
        return Result.ok((Object)biddingFileVO);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5")
    @GetMapping(value={"/queryQuoteById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryQuoteById(@RequestParam(name="id") String id) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458", notes="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458")
    @GetMapping(value={"/queryMemberById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryMemberById(@RequestParam(name="id") String id) {
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        return Result.ok(purchaseBiddingSpecialistList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @ApiOperation(value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458", notes="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @PostMapping(value={"/saveMember"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:save"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveMember(@RequestBody BiddingMemberVO memberVO) {
        this.purchaseBiddingSpecialistService.saveMember(memberVO.getId(), memberVO.getPurchaseBiddingSpecialistList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5f00\u6807")
    @ApiOperation(value="\u901a\u8fc7id\u5f00\u6807", notes="\u901a\u8fc7id\u5f00\u6807")
    @GetMapping(value={"/openBiddingById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:openBiddingById"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> openBiddingById(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.openBidding(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryConfirmBidById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryConfirmBidById(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, true);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u5386\u53f2\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u5386\u53f2\u4fe1\u606f")
    @GetMapping(value={"/queryConfirmBidHisById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryConfirmBidHisById(@RequestParam(name="id") String id) {
        ArrayList<ConfirmBidVO> arrayList = new ArrayList<ConfirmBidVO>();
        List<PurchaseConfirmBiddingHis> confirmBiddingHisList = this.purchaseConfirmBiddingHisService.selectByMainId(id);
        for (PurchaseConfirmBiddingHis purchaseConfirmBiddingHis : confirmBiddingHisList) {
            String dataJson = purchaseConfirmBiddingHis.getDataJson();
            ConfirmBidVO t = (ConfirmBidVO)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)dataJson), ConfirmBidVO.class);
            arrayList.add(t);
        }
        return Result.ok(arrayList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)")
    @GetMapping(value={"/queryConfirmBidByIdIgnore"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryConfirmBidByIdIgnore(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, false);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveConfirmBid"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:save"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveConfirmBid(@RequestBody ConfirmBidVO bidVO) {
        this.biddingSupplierService.confirmBid(bidVO.getId(), bidVO.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @ApiOperation(value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55", notes="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @GetMapping(value={"/manualCreatePrce"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:manualCreatePrce"})
    public Result<?> manualCreatePrce(@RequestParam(name="id") String id) {
        this.biddingSupplierService.manualCreatePrce(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @GetMapping(value={"/queryByAccount"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:list"}, logical=Logical.OR)
    public Result<?> queryByAccount(@RequestParam(name="toElsAccount") String toElsAccount) {
        List biddingSupplierList = this.biddingSupplierService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_els_account", (Object)toElsAccount)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        List biddingWinList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("participationCount", biddingSupplierList.size());
        resultMap.put("biddingWinCount", biddingWinList.size());
        return Result.ok(resultMap);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u5b9a\u6807\u65f6\u6821\u9a8c\u662f\u5426\u5b58\u5728\u65e0\u7269\u6599")
    @ApiOperation(value="\u5b9a\u6807\u65f6\u6821\u9a8c\u662f\u5426\u5b58\u5728\u65e0\u7269\u6599", notes="\u5b9a\u6807\u65f6\u6821\u9a8c\u662f\u5426\u5b58\u5728\u65e0\u7269\u6599")
    @GetMapping(value={"/checkMaterialNumber"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> checkMaterialNumber(@RequestParam(name="headId") String headId) {
        List<PurchaseBiddingItem> biddingItemList = this.purchaseBiddingItemService.selectByMainId(headId);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(biddingItemList), (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u884c\u4e0d\u5b58\u5728\uff01"));
        biddingItemList = biddingItemList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
        return Result.ok(biddingItemList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f-\u5217\u8868\u8df3\u8f6c", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f-\u5217\u8868\u8df3\u8f6c")
    @GetMapping(value={"/supplierPortraiTotList"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> supplierPortraiTotList(@RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="type") String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq("1".equals(type), (Object)"bidding_status", (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        List biddingSupplierList = this.biddingSupplierService.list((Wrapper)queryWrapper);
        List ids = biddingSupplierList.stream().map(BiddingSupplier::getHeadId).distinct().collect(Collectors.toList());
        String id = ids.isEmpty() ? "-1" : String.join((CharSequence)",", ids);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("id", id);
        returnMap.put("isMenu", true);
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u8865\u5145\u7269\u6599")
    @ApiOperation(value="\u8865\u5145\u7269\u6599", notes="\u8865\u5145\u7269\u6599")
    @PostMapping(value={"/replenishMaterialNumber"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:replenishMaterialNumber"})
    @SrmValidated
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> replenishMaterialNumber(@RequestBody PurchaseBiddingItem webItem) {
        Assert.notNull((Object)((Object)webItem), (String)I18nUtil.translate((String)"i18n_alert_xVcVHxOLV_dfd1238a", (String)"\u8865\u5145\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.biddingSupplierService.replenishMaterialNumber(webItem);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b", notes="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/queryRiskOld"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryRiskOld(@RequestParam(name="id") String id) {
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        Map<String, BiddingSupplier> biddingSupplierMap = biddingSupplierList.stream().collect(Collectors.toMap(BiddingSupplier::getToElsAccount, Function.identity()));
        List<SupplierRelationFindResultVO> relationFindResultVOS = this.biddingSupplierService.queryRiskRelationFind(biddingSupplierMap);
        return Result.ok(relationFindResultVOS);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b", notes="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/queryRisk"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryRisk(@RequestParam(name="id") String id) {
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        if (purchaseBiddingItemList == null || purchaseBiddingItemList.size() == 0) {
            return Result.ok(new ArrayList());
        }
        List<String> toElsAccounts = Optional.ofNullable(purchaseBiddingItemList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(PurchaseBiddingItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierRelationFindResultVO> resultList = this.ebiddingSupplierService.probeSupplier(toElsAccounts);
        if (purchaseBiddingItemList.size() > 1) {
            resultList.addAll(this.purchaseBiddingItemService.probeIP(purchaseBiddingItemList));
        }
        List supplierNameList = Optional.ofNullable(purchaseBiddingItemList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(PurchaseBiddingItem::getSupplierName).collect(Collectors.toList());
        ProbeResult probeResult = new ProbeResult();
        probeResult.setId(IdWorker.getIdStr());
        probeResult.setElsAccount(TenantContext.getTenant());
        probeResult.setSupplierName(StringUtils.join(supplierNameList, (String)","));
        probeResult.setRelationId(id);
        probeResult.setRelationModule("bidding");
        probeResult.setProbeResult(this.probeResultService.processProbeResult(resultList));
        probeResult.setDeleted(CommonConstant.DEL_FLAG_0);
        probeResult.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        probeResult.setCreateTime(new Date());
        this.probeResultService.save((Object)probeResult);
        return Result.ok(resultList);
    }

    @GetMapping(value={"/querySupplierList"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> querySupplierList(@RequestParam(name="id") String id) {
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        return Result.ok(biddingSupplierList);
    }

    @GetMapping(value={"/queryeValuationOfBidList"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryeValuationOfBidList(PurchaseBiddingHead purchaseBiddingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<PurchaseBiddingHead> queryWrapper = this.getValuationOfBidWrapper(purchaseBiddingHead, req);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8bc4\u6807\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8bc4\u6807\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/queryEvaBidTabsCount"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryEvaBidTabsCount(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper<PurchaseBiddingHead> queryWrapper = this.getValuationOfBidWrapper(purchaseBiddingHead, req);
        queryWrapper.select(new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = ((PurchaseBiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            if (!BiddingStatusEnum.EVA_BIDDING.getValue().equals(status.getValue()) && !BiddingStatusEnum.CONFIRM_ING.getValue().equals(status.getValue()) && !BiddingStatusEnum.CONFIRM_ED.getValue().equals(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    private QueryWrapper<PurchaseBiddingHead> getValuationOfBidWrapper(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        LoginUser currentUser = this.getCurrentUser();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getSubAccount, (Object)currentUser.getSubAccount())).eq(PurchaseBiddingSpecialist::getName, (Object)currentUser.getRealname())).list();
        List collect = list.parallelStream().map(PurchaseBiddingSpecialist::getHeadId).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)req.getParameterMap());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            queryWrapper.lambda().in(BaseEntity::getId, collect);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, (Object)"*****");
        }
        queryWrapper.lambda().eq(PurchaseBiddingHead::getBidEvaluationWay, (Object)"1");
        ArrayList<String> listStatus = new ArrayList<String>();
        listStatus.add(BiddingStatusEnum.EVA_BIDDING.getValue());
        listStatus.add(BiddingStatusEnum.CONFIRM_ED.getValue());
        listStatus.add(BiddingStatusEnum.CONFIRM_ING.getValue());
        queryWrapper.lambda().in(PurchaseBiddingHead::getBiddingStatus, listStatus);
        return queryWrapper;
    }

    @AutoLog(value="\u5bfc\u51fa\u5b9a\u6807\u8bf7\u793a-\u5bfc\u51fa\u5b9a\u6807\u8bf7\u793a")
    @ApiOperation(value="\u5bfc\u51fa\u5b9a\u6807\u8bf7\u793a", notes="\u5bfc\u51fa\u5b9a\u6807\u8bf7\u793a")
    @GetMapping(value={"/exportConfirmBidXls"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:export"})
    public void exportConfirmBidXls(HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("id");
        String quotaWay = request.getParameter("quotaWay");
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, true);
        List<BiddingEvaResultVO> resultList = this.purchaseBiddingEvaResultService.findEvaBidList(id);
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        this.biddingSupplierService.exportConfirmBidXls(quotaWay, biddingHead, supplierList, resultList, response);
    }

    @AutoLog(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u540d/\u6295\u6807\u9644\u4ef6\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u540d/\u6295\u6807\u9644\u4ef6\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u540d/\u6295\u6807\u9644\u4ef6\u4fe1\u606f")
    @GetMapping(value={"/queryAttachmentBySupplierAccount"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryAttachmentBySupplierAccount(@RequestParam(name="id") String id, @RequestParam(name="supplierAccount") String supplierAccount) {
        List<SaleBiddingAttachmentVO> attachmentVOList = this.purchaseBiddingHeadService.queryAttachmentBySupplierAccount(id, supplierAccount);
        return Result.ok(attachmentVOList);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u5355-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copyData"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:copyData"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> copyData(@RequestBody PurchaseBiddingHead head) {
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = this.queryDataById(head.getId());
        this.purchaseBiddingHeadService.copyData(purchaseBiddingHeadVO);
        return this.commonSuccessResult(3);
    }

    private PurchaseBiddingHeadVO queryDataById(String id) {
        ElsInitialTableDTO initInfo;
        List list;
        List srmFileTypeBidEva;
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        purchaseBiddingItemList.forEach(item -> {
            if (BiddingStatusEnum.BIDDING.getValue().equals(purchaseBiddingHead.getBiddingStatus())) {
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
            }
        });
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList) && !(srmFileTypeBidEva = this.invokeBaseRpcService.queryDictItemsByCode("srmFileTypeBidEva", TenantContext.getTenant())).isEmpty()) {
            List collect = srmFileTypeBidEva.stream().map(DictDTO::getValue).collect(Collectors.toList());
            List<PurchaseAttachmentDTO> collect1 = purchaseAttachmentList.stream().filter(item -> collect.contains(item.getFileType())).collect(Collectors.toList());
            purchaseBiddingHeadVO.setPurchaseAttachmentBidEvaList(collect1);
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseBiddingHead.getBidEvaluationNumber()) && !CollectionUtils.isEmpty((Collection)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.biddingEvaluationTemplateHeadService.lambdaQuery().eq(BiddingEvaluationTemplateHead::getEvaluationNumber, (Object)purchaseBiddingHead.getBidEvaluationNumber())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).list()))) {
            BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)list.get(0));
            BiddingEvaluationTemplateHeadVO biddingEvaluationTemplateHeadVO = new BiddingEvaluationTemplateHeadVO();
            BeanUtils.copyProperties((Object)((Object)biddingEvaluationTemplateHead), (Object)((Object)biddingEvaluationTemplateHeadVO));
            List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList = this.biddingEvaluationTemplateItemService.selectByMainId(biddingEvaluationTemplateHeadVO.getId());
            biddingEvaluationTemplateHeadVO.setBiddingEvaluationTemplateItemList(biddingEvaluationTemplateItemList);
            if (biddingEvaluationTemplateItemList != null && biddingEvaluationTemplateItemList.size() > 0) {
                ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
                for (BiddingEvaluationTemplateItem biddingEvaluationTemplateItem : biddingEvaluationTemplateItemList) {
                    List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(biddingEvaluationTemplateItem.getRegulationId());
                    if (attachments == null) continue;
                    for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                        purchaseAttachment.setFbk1(biddingEvaluationTemplateItem.getRegulationName());
                    }
                    purchaseAttachments.addAll(attachments);
                }
                biddingEvaluationTemplateHeadVO.setAttachments(purchaseAttachments);
            }
            purchaseBiddingHeadVO.setBiddingEvaluationTemplateHeadVO(biddingEvaluationTemplateHeadVO);
        }
        if (ObjectUtil.isNotEmpty((Object)(initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(purchaseBiddingHead.getId())))) {
            List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseBiddingItem.class);
            purchaseBiddingHeadVO.setInitItemList(initItemList);
        }
        return purchaseBiddingHeadVO;
    }

    @AutoLog(value="\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @ApiOperation(value="\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382", notes="\u62db\u6807-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @PostMapping(value={"/checkEnquirySameMaterial"})
    public Result<?> print(@RequestBody List<PurchaseBiddingItem> itemList) {
        ((PurchaseBiddingHeadService)this.service).checkEnquirySameMaterial(itemList);
        return Result.ok();
    }
}

