/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.entity.SaleMentoringItem;
import com.els.modules.bidding.enumerate.ClarificationBusinessTypeEnum;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleMentoringHeadMapper;
import com.els.modules.bidding.mapper.SaleMentoringItemMapper;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleMentoringHeadService;
import com.els.modules.bidding.vo.PurchaseMentoringHeadVO;
import com.els.modules.bidding.vo.SaleMentoringHeadVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.mapper.PurchaseEnquiryHeadMapper;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleMentoringHeadServiceImpl
extends BaseServiceImpl<SaleMentoringHeadMapper, SaleMentoringHead>
implements SaleMentoringHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleMentoringHeadServiceImpl.class);
    @Autowired
    private SaleMentoringHeadMapper saleMentoringHeadMapper;
    @Autowired
    private SaleMentoringItemMapper saleMentoringItemMapper;
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseEnquiryHeadMapper purchaseEnquiryHeadMapper;
    @Autowired
    private PurchaseEbiddingHeadMapper purchaseEbiddingHeadMapper;
    @Autowired
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleMentoringHead saleMentoringHead, List<SaleMentoringItem> saleMentoringItemList, List<SaleAttachmentDTO> attachments) {
        saleMentoringHead.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)saleMentoringHead.getSubmitStatus())) {
            saleMentoringHead.setSubmitStatus("0");
        }
        saleMentoringHead.setBusAccount(saleMentoringHead.getToElsAccount());
        saleMentoringHead.setMentoringNumber(this.invokeBaseRpcService.getNextCode("mentoringNumber", (Object)saleMentoringHead, saleMentoringHead.getBusAccount()));
        this.saleMentoringHeadMapper.insert((Object)saleMentoringHead);
        this.updateAttachments(saleMentoringHead, attachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleMentoringHead saleMentoringHead, List<SaleMentoringItem> saleMentoringItemList, List<SaleAttachmentDTO> attachments) {
        int count = this.saleMentoringHeadMapper.updateById((Object)saleMentoringHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleMentoringHead.getId());
        this.updateAttachments(saleMentoringHead, attachments);
    }

    private void updateAttachments(SaleMentoringHead saleMentoringHead, List<SaleAttachmentDTO> attachments) {
        if (attachments != null) {
            for (SaleAttachmentDTO saleAttachment : attachments) {
                if (StringUtils.isBlank((CharSequence)saleAttachment.getHeadId())) {
                    saleAttachment.setHeadId(saleMentoringHead.getId());
                }
                saleAttachment.setId(null);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleMentoringItemMapper.deleteByMainId(id);
        this.saleMentoringHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleMentoringItemMapper.deleteByMainId(serializable.toString());
            this.saleMentoringHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void submit(SaleMentoringHead mentoringHead, List<SaleAttachmentDTO> attachments) {
        mentoringHead.setSubmitStatus("1");
        if (StringUtils.isNotBlank((CharSequence)mentoringHead.getId())) {
            this.updateMain(mentoringHead, null, attachments);
        } else {
            this.saveMain(mentoringHead, null, attachments);
        }
        PurchaseMentoringHeadVO purchaseMentoringHead = new PurchaseMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)mentoringHead), (Object)((Object)purchaseMentoringHead));
        purchaseMentoringHead.setId(null);
        purchaseMentoringHead.setRelationId(mentoringHead.getId());
        purchaseMentoringHead.setElsAccount(mentoringHead.getToElsAccount());
        purchaseMentoringHead.setToElsAccount(mentoringHead.getElsAccount());
        purchaseMentoringHead.setReceiveTime(new Date());
        purchaseMentoringHead.setViewStatus("0");
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = null;
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(mentoringHead.getId());
        if (!CollectionUtils.isEmpty((Collection)saleAttachmentDTOList)) {
            saleAttachmentDTOList.forEach(e -> e.setSendStatus("1"));
            log.info("updateSaleAttachmentBatchById:{}", (Object)JSONObject.toJSONString((Object)saleAttachmentDTOList));
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentDTOList);
        }
        if (saleAttachmentDTOList != null) {
            purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
            for (SaleAttachmentDTO saleAttachment : saleAttachmentDTOList) {
                if (StringUtils.isBlank((CharSequence)saleAttachment.getHeadId()) || StringUtils.isNotBlank((CharSequence)saleAttachment.getHeadId()) && "undefined".equals(saleAttachment.getHeadId())) {
                    saleAttachment.setHeadId(mentoringHead.getId());
                    saleAttachments.add(saleAttachment);
                }
                PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
                purchaseAttachment.setId(null);
                purchaseAttachment.setRelationId(purchaseAttachment.getId());
                purchaseAttachment.setElsAccount(purchaseMentoringHead.getElsAccount());
                purchaseAttachment.setHeadId(purchaseMentoringHead.getId());
                purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseAttachments.add(purchaseAttachment);
            }
        }
        this.purchaseMentoringHeadService.saveMain(purchaseMentoringHead, null, purchaseAttachments);
        String createBy = null;
        if (ClarificationBusinessTypeEnum.ENQUIRY.getValue().equals(purchaseMentoringHead.getBusinessType())) {
            createBy = ((PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getBusinessId())))).getCreateBy();
        } else if (ClarificationBusinessTypeEnum.BIDDING_BUY.getValue().equals(purchaseMentoringHead.getBusinessType())) {
            createBy = ((PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getBusinessId())))).getCreateBy();
        } else if (ClarificationBusinessTypeEnum.BIDDING.getValue().equals(purchaseMentoringHead.getBusinessType())) {
            createBy = ((PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getBusinessId())))).getCreateBy();
        }
        super.sendMessage(TenantContext.getTenant(), "mentoring", "publish", mentoringHead.getId(), "mentoringBusDataServiceImpl", Arrays.asList(mentoringHead.getToElsAccount()));
    }

    private Map<String, List<String>> getReceiveElsAccountMap(String elsAccount, String createBy) {
        String subAccount = StringUtils.isBlank((CharSequence)createBy) ? "1001" : createBy;
        ArrayList<String> subAccountList = new ArrayList<String>();
        subAccountList.add(subAccount);
        HashMap<String, List<String>> receiveElsAccountMap = new HashMap<String, List<String>>();
        receiveElsAccountMap.put(elsAccount, subAccountList);
        return receiveElsAccountMap;
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleMentoringHeadVO messageById = this.getMessageById(id);
        if (messageById == null) {
            return null;
        }
        Result result = Result.ok((Object)((Object)messageById));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private SaleMentoringHeadVO getMessageById(String id) {
        SaleMentoringHead head = (SaleMentoringHead)((Object)this.getById((Serializable)((Object)id)));
        if (head == null) {
            return null;
        }
        SaleMentoringHeadVO headVO = new SaleMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<SaleMentoringItem> items = this.saleMentoringItemMapper.selectByMainId(id);
        headVO.setPurchaseMentoringItemList(items);
        return headVO;
    }
}

