/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestCreateOpenServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseRequestHead> headList = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestItem> headItem = new ArrayList<PurchaseRequestItem>();
        JSONArray headArray = new JSONArray();
        for (Object obj : array) {
            List purchaseRequestItems;
            JSONObject object = (JSONObject)obj;
            PurchaseRequestHead head = (PurchaseRequestHead)((Object)JSONObject.parseObject((String)object.toString(), PurchaseRequestHead.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setId(IdWorker.getIdStr());
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            head.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            if (CharSequenceUtil.isEmpty((CharSequence)head.getRequestStatus())) {
                head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getRequestStatus())) {
                head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            headList.add(head);
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)head));
            headArray.add((Object)headObj);
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseRequestItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseRequestItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (purchaseRequestItems = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseRequestItem.class)) || CollectionUtils.isEmpty((Collection)purchaseRequestItems)) continue;
            for (PurchaseRequestItem item : purchaseRequestItems) {
                item.setHeadId(head.getId());
                item.setElsAccount(account);
                item.setCreateTime(currentTime);
                item.setDeleted(CommonConstant.DEL_FLAG_0);
                headItem.add(item);
            }
        }
        if (!headList.isEmpty()) {
            PurchaseRequestHead entity = (PurchaseRequestHead)((Object)headList.get(0));
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getRequestNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPurchaseRequestNumber", (Object)entity, (int)size);
                int codeIndex = 0;
                for (PurchaseRequestHead e : headList) {
                    if (!CharSequenceUtil.isEmpty((CharSequence)e.getRequestNumber())) continue;
                    e.setRequestNumber((String)nextCodes.get(codeIndex++));
                }
            }
            this.purchaseRequestHeadService.saveBatch(headList, 200);
        }
        if (!headItem.isEmpty()) {
            this.purchaseRequestItemService.saveBatch(headItem, 200);
        }
        List collect = headList.stream().map(x -> (PurchaseRequestHeadVO)((Object)((Object)Convert.convert(PurchaseRequestHeadVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseRequestItem>> itemMap = headItem.stream().collect(Collectors.groupingBy(PurchaseRequestItem::getHeadId));
        for (PurchaseRequestHeadVO vo : collect) {
            vo.setPurchaseRequestItemList(itemMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        return resultObj;
    }

    public String getBusinessType() {
        return "purchaseRequest";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseRequestHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseRequestItemList"});
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }
}

