/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.api.dto.PriceRecordsDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.demand.entity.PurchaseOrderRequestInformation;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.entity.PurchaseRequestItemChild;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialCateRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialSourceLocalRpcService;
import com.els.modules.demand.rpc.PurchaseOrganizationInfoLocalRpcService;
import com.els.modules.demand.rpc.PurchaseProductInventoryLocalRpcService;
import com.els.modules.demand.service.PurchaseOrderRequestInformationService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.integrated.api.dto.IntegratedBusinessDataDTO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.api.dto.IntegratedSerachConditionDTO;
import com.els.modules.material.api.dto.PurchaseMaterialCodeDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadExtendDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.api.enumerate.MaterialDeliveryArrangeEnum;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.order.api.dto.DeliveryOrderAddressDTO;
import com.els.modules.order.api.dto.PurchaseOrderGenarateConfigDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.dto.PurchaseOrderPermissionConfigDTO;
import com.els.modules.order.api.dto.PurchaseOrderProgressTemplateDistributionDTO;
import com.els.modules.order.api.enumerate.OrderItemSendStatusEnum;
import com.els.modules.order.api.enumerate.OrderItemStatusEnum;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.pool.api.dto.PoolOrderHeadDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolHead;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolItem;
import com.els.modules.quotaProcotol.enumerate.PurchaseQuotaProcotolStatusEnum;
import com.els.modules.quotaProcotol.enumerate.PurchaseQuotaWayEnum;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolHeadService;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolItemService;
import com.els.modules.quotaProcotol.vo.PurchaseQuotaProtocolHeadVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.dto.SupplierOrgInfoDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestHeadServiceImpl
extends BaseOpenServiceImpl<PurchaseRequestHeadMapper, PurchaseRequestHead, PurchaseRequestHeadVO>
implements PurchaseRequestHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadServiceImpl.class);
    public static final String HAD_SOURCE = "HADSOURCE";
    public static final String NO_HAD_SOURCE = "NOHAHSOURCE";
    public static final String QUOTA_ITEM = "QUOTAITEM";
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Resource
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseMaterialCateRpcService purchaseMaterialCateRpcService;
    @Resource
    private PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService;
    @Resource
    private PurchaseOrganizationInfoLocalRpcService purchaseOrganizationInfoService;
    @Resource
    private PurchaseMaterialSourceLocalRpcService purchaseMaterialSourceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseOrderRequestInformationService purchaseOrderRequestInformationService;
    @Resource
    private PurchaseQuotaProtocolHeadService purchaseQuotaProtocolHeadService;
    @Resource
    private PurchaseQuotaProtocolItemService purchaseQuotaProtocolItemService;
    @Resource
    private PurchaseProductInventoryLocalRpcService purchaseProductInventoryLocalRpcService;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor srmPoolExecutor;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        Map<String, List> itemMap;
        List<PurchaseOrganizationInfoDTO> list;
        if (StringUtils.isBlank((CharSequence)purchaseRequestHead.getRequestNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmPurchaseRequestNumber", (Object)purchaseRequestHead);
            purchaseRequestHead.setRequestNumber(nextCode);
        }
        if (purchaseRequestHead.getApplyDate() == null) {
            purchaseRequestHead.setApplyDate(new Date());
        }
        purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
        purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseRequestHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length >= 1 && StrUtil.isEmpty((CharSequence)purchaseRequestHead.getApplyDept()) && !CollectionUtils.isEmpty(list = this.purchaseOrganizationInfoService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
            purchaseRequestHead.setApplyDept(list.get(0).getOrgCode());
        }
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList) && (itemMap = purchaseRequestItemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getMaterialNumber())).collect(Collectors.groupingBy(PurchaseRequestItem::getMaterialNumber)).entrySet().stream().filter(m -> ((List)m.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() > 0) {
            Set<Map.Entry<String, List>> entries = itemMap.entrySet();
            for (Map.Entry<String, List> entry : entries) {
                long factoryCount;
                List items = entry.getValue();
                int size = items.size();
                if ((long)size == (factoryCount = items.stream().map(x -> x.getMaterialNumber() + "_" + x.getFactory() + "_" + this.parseDateStr(x.getDeliveryDate())).distinct().count())) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_deSL0RHSJAlTxe_60526e5", (String)"\u76f8\u540c\u7269\u6599${0}\uff0c\u5de5\u5382\u6216\u4ea4\u671f\u5fc5\u987b\u4e0d\u540c", (String[])new String[]{entry.getKey()}));
            }
        }
        String idStr = IdWorker.getIdStr();
        purchaseRequestHead.setDocumentId(idStr);
        this.purchaseRequestHeadMapper.insert((Object)purchaseRequestHead);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setRequestHeadId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.saveIntegratedDocument(integratedDocument);
        IntegratedBusinessDataDTO integratedBusinessDataDTO = new IntegratedBusinessDataDTO();
        integratedBusinessDataDTO.setBusinessId(purchaseRequestHead.getId());
        integratedBusinessDataDTO.setBusinessType("purchaseRequest");
        integratedBusinessDataDTO.setIntegratedId(idStr);
        this.invokeBaseRpcService.saveIntegratedData(integratedBusinessDataDTO);
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList, true);
        String tenant = TenantContext.getTenant();
        this.srmPoolExecutor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUser)loginUser);
                TenantContext.setTenant((String)tenant);
                this.sendLink(purchaseRequestHead, purchaseRequestItemList);
            }
            catch (Throwable e) {
                log.error("\u91c7\u8d2d\u7533\u8bf7\u5f02\u6b65\u6267\u884c\u53d1\u9001\u6d88\u606f\u65b9\u6cd5\u5931\u8d25");
            }
            finally {
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
    }

    private String parseDateStr(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.formatDate((Date)date);
    }

    private void sendLink(PurchaseRequestHeadVO headVO, List<PurchaseRequestItem> purchaseRequestItemList) {
        JSONArray objects = new JSONArray();
        log.error("Send Request Link Message Begin");
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"purchaseRequest");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", null);
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            for (PurchaseRequestItem purchaseRequestItem : purchaseRequestItemList) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)purchaseRequestItem.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"purchaseRequest");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)purchaseRequestItem.getId());
                objectItem.put("businessParentId", (Object)purchaseRequestItem.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int count;
        Map<String, List> itemMap;
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseRequestHead.setTotalAmount(total);
        }
        if (PURCHASE_UNIT_TYPE.equals(purchaseRequestHead.getAudit())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if (REPERTORY_UNIT_TYPE.equals(purchaseRequestHead.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseRequestHead.getAuditStatus())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if (purchaseRequestHead.getExtendFields() == "") {
            purchaseRequestHead.setExtendFields(null);
        }
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList) && (itemMap = purchaseRequestItemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getMaterialNumber())).collect(Collectors.groupingBy(PurchaseRequestItem::getMaterialNumber)).entrySet().stream().filter(m -> ((List)m.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() > 0) {
            Set<Map.Entry<String, List>> entries = itemMap.entrySet();
            for (Map.Entry<String, List> entry : entries) {
                long factoryCount;
                List items = entry.getValue();
                int size = items.size();
                if ((long)size == (factoryCount = items.stream().map(x -> x.getMaterialNumber() + "_" + x.getFactory() + "_" + this.parseDateStr(x.getDeliveryDate())).distinct().count())) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_deSL0RHSJAlTxe_60526e5", (String)"\u76f8\u540c\u7269\u6599${0}\uff0c\u5de5\u5382\u6216\u4ea4\u671f\u5fc5\u987b\u4e0d\u540c", (String[])new String[]{entry.getKey()}));
            }
        }
        if ((count = this.purchaseRequestHeadMapper.updateById((Object)purchaseRequestHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.ne((Object)"item_status", (Object)PurchaseRequestStatusItemEnum.SEND_BACK.getValue())).eq((Object)"head_id", (Object)purchaseRequestHead.getId());
        List requestItems = this.purchaseRequestItemMapper.selectList((Wrapper)queryWrapper);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(purchaseRequestHead.getId());
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            List stringList = purchaseRequestItems.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        this.purchaseRequestItemMapper.deleteByMainId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseRequestHead.getId());
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList, false);
        String tenant = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        this.srmPoolExecutor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUser)loginUser);
                TenantContext.setTenant((String)tenant);
                this.sendLink(purchaseRequestHead, purchaseRequestItemList);
            }
            catch (Throwable e) {
                log.error("\u91c7\u8d2d\u7533\u8bf7\u5f02\u6b65\u6267\u884c\u53d1\u9001\u6d88\u606f\u65b9\u6cd5\u5931\u8d25");
            }
            finally {
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
    }

    private BigDecimal computeQuantity(PurchaseRequestItem entity, List<PurchaseMaterialUnitDTO> units) {
        log.info("purchaseMaterialHead id is:" + entity.getMaterialNumber());
        BigDecimal repertoryQuantity = entity.getRepertoryQuantity();
        if (repertoryQuantity == null || repertoryQuantity.compareTo(new BigDecimal(0)) == 0) {
            return repertoryQuantity;
        }
        String purchaseUnit = entity.getPurchaseUnit();
        String repertoryUnit = entity.getRepertoryUnit();
        if (purchaseUnit != null && purchaseUnit.equals(repertoryUnit) || purchaseUnit == null || repertoryUnit == null) {
            return repertoryQuantity;
        }
        if (units == null) {
            units = this.purchaseMaterialHeadLocalRpcService.selectByMaterialNumber(entity.getMaterialNumber());
        }
        ArrayList<PurchaseMaterialUnitDTO> purchaseUnits = new ArrayList<PurchaseMaterialUnitDTO>();
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            String basicUnit = unitDTO.getBasicUnit();
            if (!PURCHASE_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(purchaseUnit)) continue;
            if (basicUnit.equals(repertoryUnit)) {
                BigDecimal basicAmount = unitDTO.getBasicAmount();
                BigDecimal objectAmount = unitDTO.getObjectAmount();
                return repertoryQuantity.divide(basicAmount, 6, RoundingMode.HALF_UP).multiply(objectAmount).setScale(6, RoundingMode.HALF_UP);
            }
            purchaseUnits.add(unitDTO);
            break;
        }
        PurchaseMaterialUnitDTO repertoryUnitDto = this.getRePertoryUnit(units, repertoryUnit);
        for (PurchaseMaterialUnitDTO unitDTO : purchaseUnits) {
            if (!unitDTO.getBasicUnit().equals(repertoryUnitDto.getBasicUnit())) continue;
            return repertoryQuantity.multiply(repertoryUnitDto.getBasicAmount()).multiply(unitDTO.getObjectAmount()).divide(repertoryUnitDto.getObjectAmount().multiply(unitDTO.getBasicAmount()), 6, RoundingMode.HALF_UP);
        }
        return repertoryQuantity;
    }

    private PurchaseMaterialUnitDTO getRePertoryUnit(List<PurchaseMaterialUnitDTO> units, String repertoryUnit) {
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            if (!REPERTORY_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(repertoryUnit)) continue;
            return unitDTO;
        }
        return new PurchaseMaterialUnitDTO();
    }

    private void insertData(PurchaseRequestHead purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, boolean save) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(purchaseRequestItemList);
            List<String> collect1 = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialId).distinct().collect(Collectors.toList());
            Map<Object, Object> unitMap = new HashMap();
            if (CollectionUtil.isNotEmpty(collect1)) {
                List<PurchaseMaterialUnitDTO> materialUnitDTOS = this.purchaseMaterialHeadLocalRpcService.listUnitByMaterialIds(collect1);
                unitMap = materialUnitDTOS.stream().collect(Collectors.toMap(PurchaseMaterialUnitDTO::getHeadId, p -> {
                    ArrayList<PurchaseMaterialUnitDTO> objects = new ArrayList<PurchaseMaterialUnitDTO>();
                    objects.add((PurchaseMaterialUnitDTO)p);
                    return objects;
                }, (objects1, objects2) -> {
                    objects1.addAll(objects2);
                    return objects1;
                }));
            }
            int count = 1;
            for (PurchaseRequestItem entity : purchaseRequestItemList) {
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                if (null == entity.getId()) {
                    entity.setCreateBy(null);
                    entity.setCreateTime(null);
                }
                if (unitMap.containsKey(entity.getMaterialId())) {
                    entity.setQuantity(this.computeQuantity(entity, (List)unitMap.get(entity.getMaterialId())));
                } else {
                    entity.setQuantity(this.computeQuantity(entity, null));
                }
                entity.setPurchaseUnit(entity.getPurchaseUnit());
                entity.setAuditStatus(purchaseRequestHead.getAuditStatus());
                entity.setHeadId(purchaseRequestHead.getId());
                if (StringUtils.isBlank((CharSequence)entity.getItemNumber())) {
                    entity.setItemNumber(count + "");
                }
                if (PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(entity.getItemStatus())) {
                    entity.setItemStatus(PurchaseRequestStatusItemEnum.SEND_BACK.getValue());
                    entity.setRole(null);
                    entity.setPurchasePrincipal(null);
                    entity.setResponsibleGroup(null);
                }
                entity.setRequestNumber(purchaseRequestHead.getRequestNumber());
                entity.setRequestType(purchaseRequestHead.getRequestType());
                if (StringUtils.isBlank((CharSequence)entity.getPurchaseType())) {
                    entity.setPurchaseType(purchaseRequestHead.getPurchaseType());
                }
                if (StringUtils.isBlank((CharSequence)entity.getDocumentItemId())) {
                    entity.setDocumentItemId(IdWorker.getIdStr());
                }
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                entity.setDocumentId(purchaseRequestHead.getDocumentId());
                if (StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getFactory()) && StringUtils.isBlank((CharSequence)entity.getFactory())) {
                    entity.setFactory(purchaseRequestHead.getFactory());
                }
                if (StringUtils.isBlank((CharSequence)entity.getMaterialNumber()) && StringUtils.isBlank((CharSequence)entity.getPurchaseUnit())) {
                    entity.setPurchaseUnit(entity.getRepertoryUnit());
                }
                if (StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getPurchaseGroup()) && StringUtils.isBlank((CharSequence)entity.getPurchaseGroup())) {
                    entity.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                }
                if (orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()).getPurchaseOrg());
                } else if (orderPermissionConfigMap.get("_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get("_" + entity.getFactory()).getPurchaseOrg());
                } else if (!save) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVcWWWWWWVKnRbWERsLDRHIdjnRVR_c4de34bd", (String)"\u91c7\u8d2d\u7533\u8bf7\u884c[${0}]\u8bf7\u5728\u91c7\u8d2d\u7b56\u7565--\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7", (String[])new String[]{entity.getItemNumber()}));
                }
                if (StringUtils.isNotEmpty((CharSequence)entity.getFactory())) {
                    PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO;
                    if (StringUtils.isNotEmpty((CharSequence)entity.getCateCode())) {
                        List collect;
                        ArrayList<String> keyList = new ArrayList<String>();
                        keyList.add(entity.getCateCode() + "_" + entity.getFactory());
                        List<PurchaseOrderPermissionConfigDTO> config = this.inquiryInvokeOrderRpcService.getPurchaseOrderPermissionConfigList(keyList);
                        if (CollectionUtil.isNotEmpty(config) && CollectionUtil.isNotEmpty(collect = config.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getCentralizedDelivery()) && x.getCentralizedDelivery().equals(REPERTORY_UNIT_TYPE)).collect(Collectors.toList()))) {
                            entity.setReceivedAddress(((PurchaseOrderPermissionConfigDTO)collect.get(0)).getDeliveryAddress());
                            entity.setReceivedUser(((PurchaseOrderPermissionConfigDTO)collect.get(0)).getFbk9());
                            entity.setReceivedPhone(((PurchaseOrderPermissionConfigDTO)collect.get(0)).getFbk10());
                        }
                    }
                    if ((purchaseOrganizationInfoDTO = this.inquiryInvokeMainDataRpcService.selectByElsAccountAndCode(purchaseRequestHead.getElsAccount(), "factory", entity.getFactory())) != null) {
                        if (StringUtils.isEmpty((CharSequence)purchaseOrganizationInfoDTO.getSuperBusinessId())) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VRGRsnVRAoLWWWWWWBjLDXtESVRWVLD_55b504ba", (String)"\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7684\u7ec4\u7ec7\u7f16\u7801\u4e3a[${0}]\u6ca1\u6709\u7ef4\u62a4\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7,\u8bf7\u7ef4\u62a4", (String[])new String[]{entity.getFactory()}));
                        }
                        PurchaseOrganizationInfoDTO companyOrgInfo = this.inquiryInvokeMainDataRpcService.getById(purchaseOrganizationInfoDTO.getSuperBusinessId());
                        entity.setCompany(companyOrgInfo.getOrgCode());
                    } else {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HemhxuRHooLWWWWWWjVRuRVH_e920af2a", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u5de5\u5382\u4ee3\u7801\u4e3a[${0}]\u7684\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f", (String[])new String[]{entity.getFactory()}));
                    }
                }
                entity.setApplyDate(purchaseRequestHead.getApplyDate());
                entity.setApplicant(purchaseRequestHead.getApplicant());
                entity.setSourceNumber(purchaseRequestHead.getRequestNumber());
                if (StringUtils.isBlank((CharSequence)entity.getSourceItemNumber())) {
                    entity.setSourceItemNumber(count + "");
                }
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                if (StringUtils.isBlank((CharSequence)entity.getRemark())) {
                    entity.setRemark(purchaseRequestHead.getRemark());
                }
                entity.setSourceType(purchaseRequestHead.getSourceType());
                ++count;
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseRequestItemList.isEmpty()) {
                this.purchaseRequestItemService.saveBatch(purchaseRequestItemList, 2000);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setCreateTime(null);
                entity.setId(null);
                entity.setCreateBy(null);
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                entity.setHeadId(purchaseRequestHead.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Async
    void sendIntegratedHeadData(String id) {
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)((PurchaseRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        Result result = new Result();
        result = Result.ok((Object)((Object)purchaseRequestHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        MqUtil.sendIntegrateDataMsg((String)purchaseRequestHead.getDocumentId(), (String)"purchaseRequest", (String)id, (String)"head", (JSONObject)jsonObject);
    }

    @Async
    void sendIntegratedItemData(String id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)((PurchaseRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)this.purchaseRequestItemMapper.selectById((Serializable)((Object)id)));
        Result result = new Result();
        Result resultHead = new Result();
        result = Result.ok((Object)((Object)purchaseRequestItem));
        resultHead = Result.ok((Object)((Object)purchaseRequestHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        dictAspect.parseDictText((Object)resultHead);
        JSONObject jsonObject = (JSONObject)result.getResult();
        jsonObject.put("purchaseRequest_head", (Object)((JSONObject)resultHead.getResult()));
        MqUtil.sendIntegrateDataMsg((String)purchaseRequestItem.getDocumentItemId(), (String)"purchaseRequest", (String)id, (String)"item", (JSONObject)jsonObject);
    }

    private Map<String, PurchaseOrderPermissionConfigDTO> getOrderPermissionConfigMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<String> cateCodeAndFactoryKeys = new ArrayList<String>();
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            if (cateCodeAndFactoryKeys.contains(requestItem.getCateCode() + "_" + requestItem.getFactory())) continue;
            cateCodeAndFactoryKeys.add(requestItem.getCateCode() + "_" + requestItem.getFactory());
            cateCodeAndFactoryKeys.add("_" + requestItem.getFactory());
        }
        List<PurchaseOrderPermissionConfigDTO> purchaseOrderPermissionConfigDTOList = this.inquiryInvokeOrderRpcService.getPurchaseOrderPermissionConfigList(cateCodeAndFactoryKeys);
        HashMap<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigByCodeCategoryMap = new HashMap<String, PurchaseOrderPermissionConfigDTO>();
        for (PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO : purchaseOrderPermissionConfigDTOList) {
            orderPermissionConfigByCodeCategoryMap.put(purchaseOrderPermissionConfigDTO.getCateCode() + "_" + purchaseOrderPermissionConfigDTO.getPurchaseFactory(), purchaseOrderPermissionConfigDTO);
        }
        return orderPermissionConfigByCodeCategoryMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseRequestItemMapper.deleteByMainId(id);
        this.purchaseRequestHeadMapper.deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        ArrayList<String> objects = new ArrayList<String>();
        objects.add(id);
        List<Object> objectsItem = new ArrayList();
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(id);
        objectsItem = !CollectionUtils.isEmpty(purchaseRequestItems) ? purchaseRequestItems.stream().map(BaseEntity::getId).collect(Collectors.toList()) : null;
        this.sendMallDeleteEvent(purchaseRequestItems);
        MqUtil.sendIntegrateDataLinkMsg(null, objects, objectsItem);
    }

    private void sendMallDeleteEvent(List<PurchaseRequestItem> purchaseRequestItems) {
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            return;
        }
        List collect = purchaseRequestItems.stream().filter(x -> REPERTORY_UNIT_TYPE.equals(x.getCatalog())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        ArrayList list = SysUtil.copyProperties(collect, PurchaseRequestItemDTO.class);
        MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"purchaseRequest", (String)"delete", (String)"deletePurchaseRequestDataToMall", (Object)list);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRequestItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRequestHeadMapper.deleteById(serializable);
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
        }
        List<Object> objectsItem = new ArrayList();
        List list = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(PurchaseRequestItem::getHeadId, idList)).list();
        objectsItem = !CollectionUtils.isEmpty((Collection)list) ? list.stream().map(BaseEntity::getId).collect(Collectors.toList()) : null;
        this.sendMallDeleteEvent(list);
        MqUtil.sendIntegrateDataLinkMsg(null, idList, objectsItem);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseRequestHead head) {
        int count;
        PurchaseRequestHead updateBuyHead = new PurchaseRequestHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setRequestStatus(head.getRequestStatus());
        if (PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue().equals(head.getRequestStatus())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.CANCEL.getValue())).eq(PurchaseRequestItem::getHeadId, (Object)head.getId())).update((Object)new PurchaseRequestItem());
        }
        if ((count = this.purchaseRequestHeadMapper.updateById((Object)updateBuyHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void matchPrice(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        Map<String, List> requestItemMap = purchaseRequestItemList.stream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getPurchaseOrg(), p -> {
            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
            getNameList.add((PurchaseRequestItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        log.info("matchPrice,stringList:{}", requestItemMap.keySet());
        if (CollectionUtil.isNotEmpty(requestItemMap)) {
            List requestItemIds;
            ArrayList matchPriceRequestItemList = new ArrayList();
            ArrayList notMatchPriceRequestItemList = new ArrayList();
            for (String key : requestItemMap.keySet()) {
                List requestItemList = requestItemMap.get(key);
                String materialNumber = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getMaterialNumber();
                String purchaseOrg = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getPurchaseOrg();
                String factory = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getFactory();
                List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOS = this.purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, factory);
                if (CollectionUtil.isNotEmpty(purchaseInformationRecordsDTOS)) {
                    matchPriceRequestItemList.addAll(requestItemList);
                }
                if (!CollectionUtil.isEmpty(purchaseInformationRecordsDTOS)) continue;
                notMatchPriceRequestItemList.addAll(requestItemList);
            }
            log.info("matchPrice,\u5339\u914d\u4e0a\u4ef7\u683c\u7684\u5355\u636e\u6570\u91cf:{}", (Object)matchPriceRequestItemList.size());
            log.info("notMatchPrice,\u6ca1\u6709\u5339\u914d\u4e0a\u4ef7\u683c\u7684\u5355\u636e\u6570\u91cf:{}", (Object)notMatchPriceRequestItemList.size());
            if (CollectionUtil.isNotEmpty(matchPriceRequestItemList)) {
                requestItemIds = matchPriceRequestItemList.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue())).in(BaseEntity::getId, requestItemIds)).update((Object)new PurchaseRequestItem());
            }
            if (CollectionUtil.isNotEmpty(notMatchPriceRequestItemList)) {
                requestItemIds = notMatchPriceRequestItemList.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue())).in(BaseEntity::getId, requestItemIds)).update((Object)new PurchaseRequestItem());
            }
        }
    }

    @Override
    public List<RequestMatchInfomationVO> matchInformationRecords(List<PurchaseRequestItem> purchaseRequestItemList) {
        try {
            List<RequestMatchInfomationVO> requestMatchInfomationVOS1;
            List<RequestMatchInfomationVO> requestMatchInfomationVOS;
            List<PurchaseRequestItem> requestItemListByNumber = purchaseRequestItemList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
            List<PurchaseRequestItem> requestItemListByEmptyNumber = purchaseRequestItemList.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
            ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
            if (CollectionUtil.isNotEmpty(requestItemListByNumber) && CollectionUtil.isNotEmpty(requestMatchInfomationVOS = this.doRequestToRequestInfomation(requestItemListByNumber))) {
                requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
            }
            if (CollectionUtil.isNotEmpty(requestItemListByEmptyNumber) && CollectionUtil.isNotEmpty(requestMatchInfomationVOS1 = this.doRequestToRequestInfomationByNoNumber(requestItemListByEmptyNumber))) {
                requestMatchInfomationVOList.addAll(requestMatchInfomationVOS1);
            }
            return requestMatchInfomationVOList;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private List<RequestMatchInfomationVO> doRequestToRequestInfomationByNoNumber(List<PurchaseRequestItem> requestItemList) {
        List<String> materialDescs = requestItemList.stream().map(PurchaseRequestItem::getMaterialDesc).collect(Collectors.toList());
        List<PurchaseEnquiryItem> purchaseEnquiryItems = this.purchaseEnquiryItemService.queryEnquiryByDesc(materialDescs);
        List<PurchaseEbiddingItem> purchaseEbiddingItems = this.purchaseEbiddingItemService.queryEbiddingByDesc(materialDescs);
        List<PurchaseBiddingItem> purchaseBiddingItems = this.purchaseBiddingItemService.queryBiddingByDesc(materialDescs);
        Map<String, List<PurchaseEnquiryItem>> enquiryMapByDesc = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getMaterialDesc));
        Map<String, List<PurchaseEbiddingItem>> ebiddingMapByDesc = purchaseEbiddingItems.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getMaterialDesc));
        Map<String, List<PurchaseBiddingItem>> biddingMapByDesc = purchaseBiddingItems.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getMaterialDesc));
        List requestHeadIds = requestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List purchaseRequestHeadList = this.listByIds(requestHeadIds);
        ArrayList<String> toElsAccounts = new ArrayList<String>();
        ArrayList<String> orgAndToElsAccount = new ArrayList<String>();
        List enquiryToElsAccounts = purchaseEnquiryItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List ebiddingToElsAccounts = purchaseEbiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseEbiddingItem::getToElsAccount).collect(Collectors.toList());
        List biddingToElsAccounts = purchaseBiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseBiddingItem::getToElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(enquiryToElsAccounts)) {
            toElsAccounts.addAll(enquiryToElsAccounts);
        }
        if (CollectionUtil.isNotEmpty(ebiddingToElsAccounts)) {
            toElsAccounts.addAll(ebiddingToElsAccounts);
        }
        if (CollectionUtil.isNotEmpty(biddingToElsAccounts)) {
            toElsAccounts.addAll(biddingToElsAccounts);
        }
        if (CollectionUtil.isEmpty(toElsAccounts)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mYxujXjRdXWVWMLhjtkKsItW_ab891c0e", (String)"\u67e5\u627e\u4e0d\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u5148\u5b8c\u6210\u5bfb\u6e90\u64cd\u4f5c\u518d\u8f6c\u8ba2\u5355!"));
        }
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(requestItemList);
        Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap = this.queryOrderGenrateConfigByMap(purchaseRequestHeadList, requestItemList);
        List<PurchaseRequestItem> requestItemListByEmptyNumber = this.combinRequestItem(orderGenarateConfigMap);
        for (PurchaseRequestItem requestItem : requestItemListByEmptyNumber) {
            List biggindDescToElsAccounts;
            List ebiddingDescToElsAccounts;
            List enquiryDescToElsAccounts;
            if (CollectionUtil.isNotEmpty(purchaseEnquiryItems) && CollectionUtil.isNotEmpty(enquiryDescToElsAccounts = purchaseEnquiryItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList()))) {
                for (String toElsAccount : enquiryDescToElsAccounts) {
                    orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
                }
            }
            if (CollectionUtil.isNotEmpty(purchaseEbiddingItems) && CollectionUtil.isNotEmpty(ebiddingDescToElsAccounts = purchaseEbiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseEbiddingItem::getToElsAccount).collect(Collectors.toList()))) {
                for (String toElsAccount : ebiddingDescToElsAccounts) {
                    orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
                }
            }
            if (!CollectionUtil.isNotEmpty(purchaseBiddingItems) || !CollectionUtil.isNotEmpty(biggindDescToElsAccounts = purchaseBiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseBiddingItem::getToElsAccount).collect(Collectors.toList()))) continue;
            for (String toElsAccount : biggindDescToElsAccounts) {
                orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
            }
        }
        if (CollectionUtil.isEmpty(orgAndToElsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mYxujXjRdXWVWMLhjtkKsItW_ab891c0e", (String)"\u67e5\u627e\u4e0d\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u5148\u5b8c\u6210\u5bfb\u6e90\u64cd\u4f5c\u518d\u8f6c\u8ba2\u5355!"));
        }
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(toElsAccounts, TenantContext.getTenant());
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgInfoDTOS(orgAndToElsAccount);
        Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = this.getSupplierMasterDataMapByToElsAccount(supplierMasterDataDTOList);
        Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = this.getSupplierOrgDataInfoMapByKey(supplierOrgInfoDTOList);
        if (CollectionUtil.isEmpty(requestItemListByEmptyNumber)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nGTVSWstTVLV_cf88f1b9", (String)"\u5408\u5e76\u9700\u6c42\u540e,\u8f6c\u5355\u9700\u6c42\u4e3a\u7a7a"));
        }
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        for (PurchaseRequestItem requestItem : requestItemListByEmptyNumber) {
            RequestMatchInfomationVO requestMatchInfomationVO;
            RequestMatchInfomationVO paramRequestInfo;
            List<PurchaseEnquiryItem> enquiryItemList = enquiryMapByDesc.get(requestItem.getMaterialDesc());
            List<PurchaseEbiddingItem> ebiddingItemList = ebiddingMapByDesc.get(requestItem.getMaterialDesc());
            List<PurchaseBiddingItem> biddingItemList = biddingMapByDesc.get(requestItem.getMaterialDesc());
            PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getHeadId()));
            Map<PurchaseOrderGenarateConfigDTO, List> purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get(requestItem.getMaterialGroup() + "_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_");
            }
            if (purchaseOrderGenarateConfigMap == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWKItbLERsYxuIdjERdW_b6d049b4", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u9879!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig = purchaseOrderGenarateConfigMap.keySet().iterator().next();
            PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get(requestItem.getCateCode() + "_" + requestItem.getFactory());
            if (purchaseOrderPermissionConfigDTO == null) {
                purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get("_" + requestItem.getFactory());
            }
            if (CollectionUtil.isEmpty(enquiryItemList) && CollectionUtil.isEmpty(ebiddingItemList) && CollectionUtil.isEmpty(biddingItemList) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWKItbLERslumVRWtHeBjKhuWOuWYBszEuBnPVjWF_fe76a4ee", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u53d7\u4ef7\u683c\u63a7\u5236,\u4f46\u7cfb\u7edf\u6ca1\u6709\u5728\u8be2\u4ef7\u3001\u7ade\u4ef7\u3001\u62db\u6807\u4e2d\u5339\u914d\u5230\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            if (purchaseOrderPermissionConfigDTO == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWBjYuIdjItbWERWVWLDItbWWF_ecaf9b9e", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u914d\u7f6e,\u8bf7\u5148\u7ef4\u62a4\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u6570\u636e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            if (CollectionUtil.isNotEmpty(enquiryItemList)) {
                for (PurchaseEnquiryItem purchaseEnquiryItem : enquiryItemList) {
                    paramRequestInfo = new RequestMatchInfomationVO();
                    paramRequestInfo.setPrice(purchaseEnquiryItem.getPrice());
                    paramRequestInfo.setNetPrice(purchaseEnquiryItem.getNetPrice());
                    paramRequestInfo.setTaxCode(purchaseEnquiryItem.getTaxCode());
                    paramRequestInfo.setTaxRate(purchaseEnquiryItem.getTaxRate());
                    paramRequestInfo.setToElsAccount(purchaseEnquiryItem.getToElsAccount());
                    paramRequestInfo.setElsAccount(purchaseEnquiryItem.getElsAccount());
                    paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                    paramRequestInfo.setEffectiveDate(purchaseEnquiryItem.getEffectiveDate());
                    paramRequestInfo.setExpiryDate(purchaseEnquiryItem.getExpiryDate());
                    requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                    requestMatchInfomationVO.setRequestItemChildList(requestItem.getRequestItemChildList());
                    requestMatchInfomationVOList.add(requestMatchInfomationVO);
                }
            }
            if (CollectionUtil.isNotEmpty(ebiddingItemList)) {
                for (PurchaseEbiddingItem ebiddingItem : ebiddingItemList) {
                    paramRequestInfo = new RequestMatchInfomationVO();
                    paramRequestInfo.setPrice(ebiddingItem.getPrice());
                    paramRequestInfo.setNetPrice(ebiddingItem.getNetPrice());
                    paramRequestInfo.setTaxCode(ebiddingItem.getTaxCode());
                    paramRequestInfo.setTaxRate(ebiddingItem.getTaxRate());
                    paramRequestInfo.setToElsAccount(ebiddingItem.getToElsAccount());
                    paramRequestInfo.setElsAccount(ebiddingItem.getElsAccount());
                    paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                    requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                    requestMatchInfomationVO.setRequestItemChildList(requestItem.getRequestItemChildList());
                    requestMatchInfomationVOList.add(requestMatchInfomationVO);
                }
            }
            if (!CollectionUtil.isNotEmpty(biddingItemList)) continue;
            for (PurchaseBiddingItem biddingItem : biddingItemList) {
                paramRequestInfo = new RequestMatchInfomationVO();
                paramRequestInfo.setPrice(biddingItem.getPrice());
                paramRequestInfo.setNetPrice(biddingItem.getNetPrice());
                paramRequestInfo.setTaxCode(biddingItem.getTaxCode());
                paramRequestInfo.setTaxRate(biddingItem.getTaxRate());
                paramRequestInfo.setToElsAccount(biddingItem.getToElsAccount());
                paramRequestInfo.setElsAccount(biddingItem.getElsAccount());
                paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                requestMatchInfomationVO.setRequestItemChildList(requestItem.getRequestItemChildList());
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        }
        return requestMatchInfomationVOList;
    }

    private RequestMatchInfomationVO getRequestMatchInfomationVOByInquiry(Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, RequestMatchInfomationVO paramRequestMatchInfo, PurchaseRequestHead requestHead, PurchaseRequestItem requestItem, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO) {
        RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
        requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
        requestMatchInfomationVO.setRequestHeadId(requestItem.getHeadId());
        requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
        requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
        requestMatchInfomationVO.setMaterialName(requestItem.getMaterialName());
        requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
        requestMatchInfomationVO.setToOrderQuantity(requestMatchInfomationVO.getQuantity());
        requestMatchInfomationVO.setToOrderQuantity(BigDecimal.valueOf(0L));
        requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
        requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
        requestMatchInfomationVO.setCompany(requestItem.getCompany());
        requestMatchInfomationVO.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
        requestMatchInfomationVO.setFactory(requestItem.getFactory());
        requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
        requestMatchInfomationVO.setRequestItemId(requestItem.getId());
        requestMatchInfomationVO.setRequestType(requestHead.getRequestType());
        requestMatchInfomationVO.setRequestTypeName(requestHead.getRequestTypeName());
        requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseUnit(requestItem.getPurchaseUnit());
        requestMatchInfomationVO.setItemRequestTypeName(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
        if (StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
            requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
        }
        requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
        requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
        requestMatchInfomationVO.setCateName(requestItem.getCateName());
        requestMatchInfomationVO.setPreferredSupplier(PURCHASE_UNIT_TYPE);
        requestMatchInfomationVO.setSource(PURCHASE_UNIT_TYPE);
        requestMatchInfomationVO.setFreePrice(purchaseOrderGenarateConfig.getPriceInfo());
        requestMatchInfomationVO.setTemplateNumber(purchaseOrderGenarateConfig.getTemplateNumber());
        requestMatchInfomationVO.setTemplateName(purchaseOrderGenarateConfig.getTemplateName());
        requestMatchInfomationVO.setTemplateAccount(purchaseOrderGenarateConfig.getTemplateAccount());
        requestMatchInfomationVO.setTemplateVersion(Integer.parseInt(purchaseOrderGenarateConfig.getTemplateVersion()));
        requestMatchInfomationVO.setOrderType(purchaseOrderGenarateConfig.getOrderType());
        requestMatchInfomationVO.setPurchaseType(purchaseOrderGenarateConfig.getItemPurchaseType());
        if (paramRequestMatchInfo != null) {
            SupplierMasterDataDTO supplierMasterDataDTO = supplierMasterDataDTOMap.get(paramRequestMatchInfo.getToElsAccount());
            SupplierOrgInfoDTO supplierOrgInfoDTO = supplierOrgInfoDTOMap.get(paramRequestMatchInfo.getElsAccount() + "&&" + paramRequestMatchInfo.getToElsAccount() + "&&" + paramRequestMatchInfo.getPurchaseOrg());
            if (supplierMasterDataDTO != null) {
                requestMatchInfomationVO.setNeedCoordination(supplierMasterDataDTO.getNeedCoordination());
                requestMatchInfomationVO.setSupplierName(supplierMasterDataDTO.getSupplierName());
            }
            if (supplierOrgInfoDTO != null) {
                requestMatchInfomationVO.setPayWay(supplierOrgInfoDTO.getPaymentMethod());
                requestMatchInfomationVO.setPaymentClause(supplierOrgInfoDTO.getPayConditionCode());
            }
            requestMatchInfomationVO.setToElsAccount(paramRequestMatchInfo.getToElsAccount());
            requestMatchInfomationVO.setTaxRate(paramRequestMatchInfo.getTaxRate());
            requestMatchInfomationVO.setTaxCode(paramRequestMatchInfo.getTaxCode());
            requestMatchInfomationVO.setExpiryDate(paramRequestMatchInfo.getExpiryDate());
            requestMatchInfomationVO.setEffectiveDate(paramRequestMatchInfo.getEffectiveDate());
            BigDecimal taxRate = new BigDecimal(paramRequestMatchInfo.getTaxRate() == null ? PURCHASE_UNIT_TYPE : paramRequestMatchInfo.getTaxRate());
            BigDecimal price = paramRequestMatchInfo.getPrice() == null ? BigDecimal.ONE : paramRequestMatchInfo.getPrice();
            BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            requestMatchInfomationVO.setPrice(price);
            requestMatchInfomationVO.setNetPrice(netPrice);
            requestMatchInfomationVO.setCurrency(paramRequestMatchInfo.getCurrency());
            requestMatchInfomationVO.setEstimate(paramRequestMatchInfo.getEstimate());
            requestMatchInfomationVO.setPriceUnit(paramRequestMatchInfo.getPriceUnit());
            if (REPERTORY_UNIT_TYPE.equals(purchaseOrderPermissionConfigDTO.getCentralizedDelivery())) {
                requestMatchInfomationVO.setDeliveryAddress(purchaseOrderPermissionConfigDTO.getDeliveryAddress());
            }
            if (StringUtils.isEmpty((CharSequence)paramRequestMatchInfo.getPriceUnit())) {
                requestMatchInfomationVO.setPriceUnit(REPERTORY_UNIT_TYPE);
            }
        }
        return requestMatchInfomationVO;
    }

    private Map<String, List<PurchaseRequestItem>> classicByMaterialSource(List<PurchaseRequestItem> requestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        HashMap<String, List<PurchaseRequestItem>> goodsMaterialNumberMap = new HashMap<String, List<PurchaseRequestItem>>();
        if (purchaseMaterialHeadExtendMap != null) {
            goodsMaterialNumberMap.put(HAD_SOURCE, new ArrayList());
            goodsMaterialNumberMap.put(NO_HAD_SOURCE, new ArrayList());
            goodsMaterialNumberMap.put(QUOTA_ITEM, new ArrayList());
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
                if (REPERTORY_UNIT_TYPE.equals(purchaseMaterialHeadExtend.getQuotaStrategy())) {
                    ((List)goodsMaterialNumberMap.get(QUOTA_ITEM)).add(requestItem);
                    continue;
                }
                if (REPERTORY_UNIT_TYPE.equals(purchaseMaterialHeadExtend.getSource())) {
                    ((List)goodsMaterialNumberMap.get(HAD_SOURCE)).add(requestItem);
                    continue;
                }
                ((List)goodsMaterialNumberMap.get(NO_HAD_SOURCE)).add(requestItem);
            }
        }
        return goodsMaterialNumberMap;
    }

    private List<RequestMatchInfomationVO> doRequestToRequestInfomation(List<PurchaseRequestItem> purchaseRequestItemList) {
        List requestHeadIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List purchaseRequestHeadList = this.listByIds(requestHeadIds);
        Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap = this.queryOrderGenrateConfigByMap(purchaseRequestHeadList, purchaseRequestItemList);
        List<PurchaseRequestItem> requestItemList = this.combinRequestItem(orderGenarateConfigMap);
        if (CollectionUtil.isEmpty(requestItemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nGTVSWstTVLV_cf88f1b9", (String)"\u5408\u5e76\u9700\u6c42\u540e,\u8f6c\u5355\u9700\u6c42\u4e3a\u7a7a"));
        }
        Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(requestItemList);
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList = this.getMaterialHeadListByNumbers(requestItemList);
        List<PurchaseMaterialCodeDTO> purchaseMaterialCodeDTOList = this.getMaterialCodeListByNumbers(purchaseMaterialHeadDTOList);
        Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = this.getPurchaseMaterialHeadMap(requestItemList, purchaseMaterialHeadDTOList, purchaseMaterialCodeDTOList);
        Map<String, PurchaseQuotaProtocolHeadVO> quotaProtocolHeadVOMap = this.getQuotaProtocolHeadMap(purchaseMaterialHeadExtendMap);
        Map<String, List<PurchaseRequestItem>> requestItemClassicMap = this.classicByMaterialSource(requestItemList, purchaseMaterialHeadExtendMap);
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        HashMap<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap = new HashMap<String, List<PurchaseInformationRecordsDTO>>();
        HashMap<String, List<PurchaseMaterialSourceDTO>> sourceMap = new HashMap<String, List<PurchaseMaterialSourceDTO>>();
        Map<String, PurchaseRequestHead> requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
        this.addNoMaterialRequestInfoToMap(informationRecordsMap, requestItemClassicMap, purchaseMaterialHeadExtendMap);
        this.addHadMaterialRequestInfoToMap(informationRecordsMap, requestItemClassicMap, sourceMap, purchaseMaterialHeadExtendMap);
        this.addQuotaStrategyInfoToMap(informationRecordsMap, requestItemClassicMap, quotaProtocolHeadVOMap, purchaseMaterialHeadExtendMap);
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(informationRecordsMap);
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgDataInfoList(informationRecordsMap);
        Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = this.getSupplierMasterDataMapByToElsAccount(supplierMasterDataDTOList);
        Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = this.getSupplierOrgDataInfoMapByKey(supplierOrgInfoDTOList);
        Map<String, DeliveryOrderAddressDTO> deliveryOrderAddressDTOMap = this.getDeliveryOrderAddressMap(requestItemList);
        this.doHadSourceRequestItem(orderGenarateConfigMap, orderPermissionConfigMap, purchaseMaterialHeadExtendMap, requestMatchInfomationVOList, informationRecordsMap, sourceMap, requestItemList, requestHeadMap, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, deliveryOrderAddressDTOMap, quotaProtocolHeadVOMap);
        return requestMatchInfomationVOList;
    }

    private void addQuotaStrategyInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, Map<String, List<PurchaseRequestItem>> requestItemClassicMap, Map<String, PurchaseQuotaProtocolHeadVO> quotaProtocolHeadVOMap, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        List<PurchaseRequestItem> quotaRequestItemList = requestItemClassicMap.get(QUOTA_ITEM);
        if (CollectionUtil.isNotEmpty(quotaRequestItemList)) {
            HashSet<String> keys = new HashSet<String>();
            for (PurchaseRequestItem requestItem : quotaRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            if (CollectionUtil.isNotEmpty(keys)) {
                for (String key : keys) {
                    String materialNumber = key.split("_,")[0];
                    String purchaseOrg = key.split("_,")[1];
                    String factory = key.split("_,")[2];
                    PurchaseMaterialHeadExtendDTO materialHeadExtendDTO = purchaseMaterialHeadExtendMap.get(materialNumber + "_" + factory);
                    PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO = quotaProtocolHeadVOMap.get(materialHeadExtendDTO.getMaterialNumber() + "&_&");
                    if (purchaseQuotaProtocolHeadVO == null) {
                        purchaseQuotaProtocolHeadVO = quotaProtocolHeadVOMap.get("&_&" + materialHeadExtendDTO.getCateCode());
                    }
                    if (purchaseQuotaProtocolHeadVO == null) {
                        throw new ELSBootException("\u7269\u6599\u7f16\u53f7:" + materialNumber + "\u5f00\u542f\u4e86\u914d\u989d\u534f\u8bae\uff0c\u4f46\u662f\u914d\u989d\u534f\u8bae\u4e2d\u627e\u4e0d\u5230\u8be5\u7269\u6599\u7684\u6709\u6548\u6570\u636e!");
                    }
                    List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList = purchaseQuotaProtocolHeadVO.getPurchaseQuotaProtocolItemList();
                    if (CollectionUtil.isEmpty(purchaseQuotaProtocolItemList)) {
                        throw new ELSBootException("\u914d\u989d\u534f\u8bae\u53f7:" + purchaseQuotaProtocolHeadVO.getDocumentNumber() + "\u914d\u989d\u534f\u8bae\u884c\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    List<String> allToElsAccountList = purchaseQuotaProtocolItemList.stream().map(PurchaseQuotaProtocolItem::getToElsAccount).distinct().collect(Collectors.toList());
                    List<PurchaseInformationRecordsDTO> informationRecordsList = this.purchaseInformationRecordsService.selectList(allToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, factory);
                    if (!CollectionUtil.isNotEmpty(informationRecordsList)) continue;
                    informationRecordsMap.put(key, informationRecordsList);
                }
            }
        }
    }

    private void doHadSourceRequestItem(Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap, Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap, List<RequestMatchInfomationVO> requestMatchInfomationVOList, Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, Map<String, List<PurchaseMaterialSourceDTO>> sourceMap, List<PurchaseRequestItem> hadGoodsRequestItemList, Map<String, PurchaseRequestHead> requestHeadMap, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, Map<String, DeliveryOrderAddressDTO> deliveryOrderAddressDTOMap, Map<String, PurchaseQuotaProtocolHeadVO> quotaProtocolHeadVOMap) {
        for (PurchaseRequestItem requestItem : hadGoodsRequestItemList) {
            List<PurchaseInformationRecordsDTO> informationRecordsDTOList = informationRecordsMap.get(requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory());
            Map<PurchaseOrderGenarateConfigDTO, List> purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get(requestItem.getMaterialGroup() + "_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            if (purchaseOrderGenarateConfigMap == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWKItbLERsYxuIdjERdW_b6d049b4", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u9879!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig = purchaseOrderGenarateConfigMap.keySet().iterator().next();
            PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get(requestItem.getCateCode() + "_" + requestItem.getFactory());
            if (purchaseOrderPermissionConfigDTO == null) {
                purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get("_" + requestItem.getFactory());
            }
            if (CollectionUtil.isEmpty(informationRecordsDTOList) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWKItbLERslumVRWtHeBjzEujXjum_c426db7c", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u53d7\u4ef7\u683c\u63a7\u5236,\u4f46\u7cfb\u7edf\u6ca1\u6709\u5339\u914d\u5230\u6709\u6548\u7684\u4ef7\u683c", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            if (purchaseOrderPermissionConfigDTO == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWWEyWWWWWWWBjYuIdjItbWERWVWLDItbWWF_ecaf9b9e", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7:[${0}]\u884c\u53f7:[${1}]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7\u914d\u7f6e,\u8bf7\u5148\u7ef4\u62a4\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u6570\u636e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
            PurchaseRequestHead requestHead = requestHeadMap.get(requestItem.getRequestNumber());
            DeliveryOrderAddressDTO deliveryOrderAddressDTO = deliveryOrderAddressDTOMap.get(requestItem.getFactory());
            PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO = quotaProtocolHeadVOMap.get(requestItem.getMaterialNumber() + "&_&");
            if (purchaseQuotaProtocolHeadVO == null) {
                purchaseQuotaProtocolHeadVO = quotaProtocolHeadVOMap.get("&_&" + purchaseMaterialHeadExtend.getCateCode());
            }
            ArrayList<PurchaseMaterialSourceDTO> purchaseMaterialSourceDTOList = new ArrayList();
            purchaseMaterialSourceDTOList = sourceMap.get(requestItem.getMaterialNumber());
            List<RequestMatchInfomationVO> requestMatchInfomationList = this.getRequestMatchInfomationVO(purchaseQuotaProtocolHeadVO, requestItem, informationRecordsDTOList, purchaseMaterialSourceDTOList, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
            List firstSupplierRequestInfomationList = requestMatchInfomationList.stream().filter(item -> REPERTORY_UNIT_TYPE.equals(item.getPreferredSupplier())).collect(Collectors.toList());
            List otherSupplierRequestInfomationList = requestMatchInfomationList.stream().filter(item -> PURCHASE_UNIT_TYPE.equals(item.getPreferredSupplier())).collect(Collectors.toList());
            firstSupplierRequestInfomationList = firstSupplierRequestInfomationList.stream().sorted(Comparator.comparing(RequestMatchInfomationVO::getPrice)).collect(Collectors.toList());
            otherSupplierRequestInfomationList = otherSupplierRequestInfomationList.stream().sorted(Comparator.comparing(RequestMatchInfomationVO::getPrice)).collect(Collectors.toList());
            requestMatchInfomationVOList.addAll(firstSupplierRequestInfomationList);
            requestMatchInfomationVOList.addAll(otherSupplierRequestInfomationList);
        }
    }

    private Map<String, PurchaseQuotaProtocolHeadVO> getQuotaProtocolHeadMap(Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        Set<String> keys = purchaseMaterialHeadExtendMap.keySet();
        HashMap<String, PurchaseQuotaProtocolHeadVO> quotaProtocolHeadVOMap = new HashMap<String, PurchaseQuotaProtocolHeadVO>();
        ArrayList<String> materialNumbers = new ArrayList<String>();
        ArrayList<String> materialCateCodes = new ArrayList<String>();
        for (String key : keys) {
            PurchaseMaterialHeadExtendDTO materialHeadExtendDTO = purchaseMaterialHeadExtendMap.get(key);
            if (!REPERTORY_UNIT_TYPE.equals(materialHeadExtendDTO.getQuotaStrategy())) continue;
            materialNumbers.add(materialHeadExtendDTO.getMaterialNumber());
            if (!StringUtils.isNotEmpty((CharSequence)materialHeadExtendDTO.getCateCode())) continue;
            materialCateCodes.add(materialHeadExtendDTO.getCateCode());
        }
        if (CollectionUtil.isNotEmpty(materialNumbers)) {
            LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
            lambdaQueryWrapper.eq(PurchaseQuotaProtocolHead::getDocumentStatus, (Object)PurchaseQuotaProcotolStatusEnum.EFFECTIVE.getValue());
            lambdaQueryWrapper.in(PurchaseQuotaProtocolHead::getMaterialNumber, materialNumbers);
            List purchaseQuotaProtocolHeadList = this.purchaseQuotaProtocolHeadService.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty(materialCateCodes)) {
                LambdaQueryWrapper cateLambdaQueryWrapper = new QueryWrapper().lambda();
                cateLambdaQueryWrapper.eq(PurchaseQuotaProtocolHead::getDocumentStatus, (Object)PurchaseQuotaProcotolStatusEnum.EFFECTIVE.getValue());
                cateLambdaQueryWrapper.in(PurchaseQuotaProtocolHead::getCateCode, materialCateCodes);
                cateLambdaQueryWrapper.eq(PurchaseQuotaProtocolHead::getMaterialNumber, (Object)"");
                List cateQuotaProtocolHeadList = this.purchaseQuotaProtocolHeadService.list((Wrapper)cateLambdaQueryWrapper);
                purchaseQuotaProtocolHeadList.addAll(cateQuotaProtocolHeadList);
            }
            if (CollectionUtil.isNotEmpty((Collection)purchaseQuotaProtocolHeadList)) {
                List headIds = purchaseQuotaProtocolHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper itemLambdaQueryWrapper = new QueryWrapper().lambda();
                itemLambdaQueryWrapper.in(PurchaseQuotaProtocolItem::getHeadId, headIds);
                List quotaProtocolItems = this.purchaseQuotaProtocolItemService.list((Wrapper)itemLambdaQueryWrapper);
                Map<String, List<PurchaseQuotaProtocolItem>> quotaProtocolItemGroupByHeadIdMap = quotaProtocolItems.stream().collect(Collectors.groupingBy(PurchaseQuotaProtocolItem::getHeadId));
                for (PurchaseQuotaProtocolHead purchaseQuotaProtocolHead : purchaseQuotaProtocolHeadList) {
                    PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO = new PurchaseQuotaProtocolHeadVO();
                    BeanUtils.copyProperties((Object)((Object)purchaseQuotaProtocolHead), (Object)((Object)purchaseQuotaProtocolHeadVO));
                    List<PurchaseQuotaProtocolItem> quotaProtocolItemList = quotaProtocolItemGroupByHeadIdMap.get(purchaseQuotaProtocolHead.getId());
                    purchaseQuotaProtocolHeadVO.setPurchaseQuotaProtocolItemList(quotaProtocolItemList);
                    if (StringUtils.isNotEmpty((CharSequence)purchaseQuotaProtocolHead.getMaterialNumber())) {
                        quotaProtocolHeadVOMap.put(purchaseQuotaProtocolHead.getMaterialNumber() + "&_&", purchaseQuotaProtocolHeadVO);
                        continue;
                    }
                    quotaProtocolHeadVOMap.put("&_&" + purchaseQuotaProtocolHead.getCateCode(), purchaseQuotaProtocolHeadVO);
                }
            }
        }
        return quotaProtocolHeadVOMap;
    }

    private List<PurchaseMaterialCodeDTO> getMaterialCodeListByNumbers(List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseMaterialHeadDTOList)) {
            List<String> cateCodeList = purchaseMaterialHeadDTOList.stream().map(PurchaseMaterialHeadDTO::getCateCode).distinct().collect(Collectors.toList());
            List<PurchaseMaterialCodeDTO> purchaseMaterialCodeDTOList = this.purchaseMaterialCateRpcService.selectMaterialCateListByCodeList(cateCodeList);
            return purchaseMaterialCodeDTOList;
        }
        return null;
    }

    private List<PurchaseMaterialHeadDTO> getMaterialHeadListByNumbers(List<PurchaseRequestItem> requestItemList) {
        if (CollectionUtil.isEmpty(requestItemList)) {
            throw new ELSBootException("\u8bf7\u52fe\u9009\u6570\u636e!");
        }
        List<String> materialNumbers = requestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadList = this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumbers);
        return purchaseMaterialHeadList;
    }

    private Map<String, DeliveryOrderAddressDTO> getDeliveryOrderAddressMap(List<PurchaseRequestItem> requestItemList) {
        List<String> factoryList;
        if (CollectionUtil.isNotEmpty(requestItemList) && CollectionUtil.isNotEmpty(factoryList = requestItemList.stream().map(PurchaseRequestItem::getFactory).distinct().collect(Collectors.toList()))) {
            List deliveryOrderAddressDTOList = this.inquiryInvokeOrderRpcService.getDeliveryOrderAddressList(factoryList);
            deliveryOrderAddressDTOList = deliveryOrderAddressDTOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeliveryOrderAddressDTO>(Comparator.comparing(o -> o.getOrganizationNo()))), ArrayList::new));
            Map<String, DeliveryOrderAddressDTO> deliveryOrderAndAddressMap = deliveryOrderAddressDTOList.stream().collect(Collectors.toMap(DeliveryOrderAddressDTO::getOrganizationNo, Function.identity()));
            return deliveryOrderAndAddressMap;
        }
        return null;
    }

    private List<PurchaseRequestItem> combinRequestItem(Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap) {
        ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
        Set<String> keys = orderGenarateConfigMap.keySet();
        for (String key : keys) {
            ArrayList requestItems;
            PurchaseRequestItemChild requestItemChild;
            ArrayList<PurchaseRequestItemChild> requestItemChilds;
            PurchaseRequestItemChild requestItemChild2;
            BigDecimal toOrderQuantity;
            BigDecimal quantity;
            HashMap<String, PurchaseRequestItem> purchaseRequestItemMap;
            Map<PurchaseOrderGenarateConfigDTO, List> requestItemMap = orderGenarateConfigMap.get(key);
            if (requestItemMap.size() == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VLDItbLERW_a2eef7b5", (String)"\u8bf7\u7ef4\u62a4\u8ba2\u5355\u751f\u6210\u914d\u7f6e!"));
            }
            Set<PurchaseOrderGenarateConfigDTO> purchaseOrderGenarateConfigDTOS = requestItemMap.keySet();
            PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO = purchaseOrderGenarateConfigDTOS.iterator().next();
            List subRequestItemList = requestItemMap.get(purchaseOrderGenarateConfigDTO);
            if (StringUtils.isBlank((CharSequence)purchaseOrderGenarateConfigDTO.getQuantityCondition())) {
                for (PurchaseRequestItem requestItem : subRequestItemList) {
                    PurchaseRequestItemChild requestItemChild3 = new PurchaseRequestItemChild();
                    BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild3));
                    ArrayList requestItemChildList = new ArrayList();
                    requestItemChildList.add(requestItemChild3);
                    requestItem.setRequestItemChildList(requestItemChildList);
                }
                requestItemList.addAll(subRequestItemList);
                continue;
            }
            String quantityCondition = purchaseOrderGenarateConfigDTO.getQuantityCondition();
            String[] quantityConditionArray = quantityCondition.split(",");
            if (quantityConditionArray.length == 2) {
                purchaseRequestItemMap = new HashMap<String, PurchaseRequestItem>();
                for (PurchaseRequestItem requestItem : subRequestItemList) {
                    if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"))) {
                        quantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getQuantity().add(requestItem.getQuantity());
                        toOrderQuantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getToOrderQuantity().add(requestItem.getToOrderQuantity());
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).setToOrderQuantity(toOrderQuantity);
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).setQuantity(quantity);
                        requestItemChild2 = new PurchaseRequestItemChild();
                        BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild2));
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getRequestItemChildList().add(requestItemChild2);
                        continue;
                    }
                    purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"), requestItem);
                    requestItemChilds = new ArrayList();
                    requestItemChild = new PurchaseRequestItemChild();
                    BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild));
                    requestItemChilds.add(requestItemChild);
                    requestItem.setRequestItemChildList(requestItemChilds);
                }
                requestItems = new ArrayList(purchaseRequestItemMap.values());
                requestItemList.addAll(requestItems);
                continue;
            }
            if (quantityConditionArray.length != 1) continue;
            purchaseRequestItemMap = new HashMap();
            for (PurchaseRequestItem requestItem : subRequestItemList) {
                if ("factory".equals(quantityConditionArray[0])) {
                    if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory())) {
                        quantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).getQuantity().add(requestItem.getQuantity());
                        toOrderQuantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).getToOrderQuantity().add(requestItem.getToOrderQuantity());
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).setToOrderQuantity(toOrderQuantity);
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).setQuantity(quantity);
                        requestItemChild2 = new PurchaseRequestItemChild();
                        BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild2));
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).getRequestItemChildList().add(requestItemChild2);
                        continue;
                    }
                    purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory(), requestItem);
                    requestItemChilds = new ArrayList<PurchaseRequestItemChild>();
                    requestItemChild = new PurchaseRequestItemChild();
                    BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild));
                    requestItemChilds.add(requestItemChild);
                    requestItem.setRequestItemChildList(requestItemChilds);
                    continue;
                }
                if (!"requiryDate".equals(quantityConditionArray[0])) continue;
                if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"))) {
                    quantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getQuantity().add(requestItem.getQuantity());
                    toOrderQuantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getToOrderQuantity().add(requestItem.getToOrderQuantity());
                    ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).setToOrderQuantity(toOrderQuantity);
                    ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).setQuantity(quantity);
                    requestItemChild2 = new PurchaseRequestItemChild();
                    BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild2));
                    ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getRequestItemChildList().add(requestItemChild2);
                    continue;
                }
                purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"), requestItem);
                requestItemChilds = new ArrayList();
                requestItemChild = new PurchaseRequestItemChild();
                BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)requestItemChild));
                requestItemChilds.add(requestItemChild);
                requestItem.setRequestItemChildList(requestItemChilds);
            }
            requestItems = new ArrayList(purchaseRequestItemMap.values());
            requestItemList.addAll(requestItems);
        }
        return requestItemList;
    }

    private Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> queryOrderGenrateConfigByMap(List<PurchaseRequestHead> purchaseRequestHeadList, List<PurchaseRequestItem> requestItemList) {
        HashMap resultMap = new HashMap();
        HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenerateMap = new HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>>();
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(requestItemList)) {
            Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                if (keys.contains(requestHead.getRequestType())) continue;
                keys.add(requestHead.getRequestType());
            }
            List<PurchaseOrderGenarateConfigDTO> orderGenarateConfigDTOList = this.inquiryInvokeOrderRpcService.queryOrderGenrateConfigByRequestType(keys);
            if (CollectionUtil.isNotEmpty(orderGenarateConfigDTOList)) {
                for (PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO : orderGenarateConfigDTOList) {
                    String orderGenarateKey = purchaseOrderGenarateConfigDTO.getConfigTypeValue() + "_" + purchaseOrderGenarateConfigDTO.getPurchaseRequestType() + "_" + purchaseOrderGenarateConfigDTO.getItemPurchaseType();
                    HashMap orderGenarateConfigDTOListMap = new HashMap();
                    orderGenarateConfigDTOListMap.put(purchaseOrderGenarateConfigDTO, new ArrayList());
                    orderGenerateMap.put(orderGenarateKey, orderGenarateConfigDTOListMap);
                }
                for (PurchaseRequestItem purchaseRequestItem : requestItemList) {
                    List list;
                    Set purchaseOrderGenarateConfigDTOS;
                    Map orderGenarateConfigDTOListMap;
                    if (orderGenerateMap.containsKey(purchaseRequestItem.getMaterialGroup() + "_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get(purchaseRequestItem.getMaterialGroup() + "_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    if (orderGenerateMap.containsKey("_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get("_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    if (orderGenerateMap.containsKey("_" + purchaseRequestItem.getRequestType() + "_")) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get("_" + purchaseRequestItem.getRequestType() + "_");
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWBjIdjItbLER_2e968a29", (String)"\u7269\u6599\u7f16\u7801:[${0}]\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e", (String[])new String[]{purchaseRequestItem.getMaterialNumber()}));
                }
            } else {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RiujTVzEujItbLERLVWVImKQLDIdjItbLER_e66e10c9", (String)"\u52fe\u9009\u5230\u7684\u9700\u6c42\u5339\u914d\u5230\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e"));
            }
        }
        return orderGenerateMap;
    }

    private Map<String, SupplierOrgInfoDTO> getSupplierOrgDataInfoMapByKey(List<SupplierOrgInfoDTO> supplierOrgInfoDTOList) {
        HashMap<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = new HashMap<String, SupplierOrgInfoDTO>();
        for (SupplierOrgInfoDTO supplierOrgInfoDTO : supplierOrgInfoDTOList) {
            String key = supplierOrgInfoDTO.getToElsAccount() + "&&" + supplierOrgInfoDTO.getElsAccount() + "&&" + supplierOrgInfoDTO.getOrgCode();
            supplierOrgInfoDTOMap.put(key, supplierOrgInfoDTO);
        }
        return supplierOrgInfoDTOMap;
    }

    private Map<String, SupplierMasterDataDTO> getSupplierMasterDataMapByToElsAccount(List<SupplierMasterDataDTO> supplierMasterDataDTOList) {
        HashMap<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = new HashMap<String, SupplierMasterDataDTO>();
        if (CollectionUtil.isNotEmpty(supplierMasterDataDTOList)) {
            for (SupplierMasterDataDTO supplierMasterDataDTO : supplierMasterDataDTOList) {
                supplierMasterDataDTOMap.put(supplierMasterDataDTO.getToElsAccount(), supplierMasterDataDTO);
            }
        }
        return supplierMasterDataDTOMap;
    }

    private List<SupplierOrgInfoDTO> getSupplierOrgDataInfoList(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap) {
        Set<String> keys = informationRecordsMap.keySet();
        ArrayList<String> orgDataKeyList = new ArrayList<String>();
        for (String key : keys) {
            List<PurchaseInformationRecordsDTO> informayionRecordList = informationRecordsMap.get(key);
            for (PurchaseInformationRecordsDTO informationRecordsDTO : informayionRecordList) {
                orgDataKeyList.add(informationRecordsDTO.getElsAccount() + "&&" + informationRecordsDTO.getToElsAccount() + "&&" + informationRecordsDTO.getPurchaseOrg());
            }
        }
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgInfoDTOS(orgDataKeyList);
        return supplierOrgInfoDTOList;
    }

    private List<SupplierOrgInfoDTO> getSupplierOrgInfoDTOS(List<String> orgDataKeyList) {
        return this.inquiryInvokeSupplierRpcService.selectSupplierOrgInfoList(orgDataKeyList);
    }

    private List<SupplierMasterDataDTO> getSupplierMasterDataDTOList(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap) {
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = null;
        if (informationRecordsMap.size() > 0) {
            Set<String> keys = informationRecordsMap.keySet();
            ArrayList<String> toElsAccounts = new ArrayList<String>();
            for (String key : keys) {
                List<PurchaseInformationRecordsDTO> informayionRecordList = informationRecordsMap.get(key);
                List toElsAccountList = informayionRecordList.stream().map(PurchaseInformationRecordsDTO::getToElsAccount).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(toElsAccountList)) continue;
                toElsAccounts.addAll(toElsAccountList);
            }
            String elsAccount = TenantContext.getTenant();
            if (CollectionUtil.isNotEmpty(toElsAccounts)) {
                supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(toElsAccounts, elsAccount);
            } else {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RijTVmYxujXjum_5f8338f3", (String)"\u52fe\u9009\u7684\u9700\u6c42\u67e5\u627e\u4e0d\u5230\u6709\u6548\u7684\u4ef7\u683c"));
            }
        }
        return supplierMasterDataDTOList;
    }

    private List<SupplierMasterDataDTO> getSupplierMasterDataDTOList(List<String> toElsAccounts, String elsAccount) {
        return this.inquiryInvokeSupplierRpcService.selectSupplerList(elsAccount, toElsAccounts);
    }

    private void addHadMaterialRequestInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, Map<String, List<PurchaseRequestItem>> goodsMaterialNumberMap, Map<String, List<PurchaseMaterialSourceDTO>> sourceMap, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        List<PurchaseRequestItem> hadGoodsRequestItemList = goodsMaterialNumberMap.get(HAD_SOURCE);
        if (CollectionUtil.isNotEmpty(hadGoodsRequestItemList)) {
            List<String> materialNumbers = hadGoodsRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List<PurchaseMaterialSourceDTO> purchaseMaterialSourceList = this.purchaseMaterialSourceLocalRpcService.selectList(materialNumbers, MaterialSourceStatusEnum.EFFECTIVE.getValue(), new Date(), new Date());
            Map<String, List<PurchaseMaterialSourceDTO>> materialNumberMapToSource = purchaseMaterialSourceList.parallelStream().collect(Collectors.groupingBy(PurchaseMaterialSourceDTO::getMaterialNumber));
            HashSet<String> keys = new HashSet<String>();
            for (PurchaseRequestItem requestItem : hadGoodsRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            if (CollectionUtil.isNotEmpty(keys)) {
                for (String key : keys) {
                    String materialNumber = key.split("_,")[0];
                    String purchaseOrg = key.split("_,")[1];
                    String factory = key.split("_,")[2];
                    List<PurchaseMaterialSourceDTO> materialSources = materialNumberMapToSource.get(materialNumber);
                    sourceMap.put(materialNumber, materialSources);
                    if (CollectionUtil.isEmpty(materialSources)) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWjTVcKSjVtmhxuIdjRdXWFWVImSLERKQiR_48871347", (String)"\u7269\u6599\u7f16\u7801[${0}]\u7684\u9700\u6c42\u884c\u5728\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String[])new String[]{materialNumber}));
                    }
                    List<String> allToElsAccountList = materialSources.stream().map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
                    List<PurchaseInformationRecordsDTO> informationRecordsList = this.purchaseInformationRecordsService.selectList(allToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, factory);
                    if (!CollectionUtil.isNotEmpty(informationRecordsList)) continue;
                    informationRecordsMap.put(key, informationRecordsList);
                }
            }
        }
    }

    private void addNoMaterialRequestInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, Map<String, List<PurchaseRequestItem>> goodsMaterialNumberMap, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        List<PurchaseRequestItem> noHadRequestItemList = goodsMaterialNumberMap.get(NO_HAD_SOURCE);
        if (CollectionUtil.isNotEmpty(noHadRequestItemList)) {
            HashSet<String> keys = new HashSet<String>();
            for (PurchaseRequestItem requestItem : noHadRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            if (CollectionUtil.isNotEmpty(keys)) {
                for (String key : keys) {
                    String materialNumber = key.split("_,")[0];
                    String purchaseOrg = key.split("_,")[1];
                    String factory = key.split("_,")[2];
                    List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.EFFECTIVE.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, factory);
                    if (!CollectionUtil.isNotEmpty(purchaseInformationRecordsList)) continue;
                    informationRecordsMap.put(key, purchaseInformationRecordsList);
                }
            }
        }
    }

    private List<RequestMatchInfomationVO> getRequestMatchInfomationVO(PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO, PurchaseRequestItem requestItem, List<PurchaseInformationRecordsDTO> qualifiedPriceRecord, List<PurchaseMaterialSourceDTO> purchaseMaterialSourceDTOList, PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend, PurchaseRequestHead requestHead, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO, DeliveryOrderAddressDTO deliveryOrderAddressDTO) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        if (CollectionUtil.isNotEmpty(qualifiedPriceRecord) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
            Map<String, BigDecimal> supplierSuggestAllocQuantityMap = this.doSupplierSuggestAllocQuantity(purchaseMaterialHeadExtend, qualifiedPriceRecord, purchaseQuotaProtocolHeadVO, requestItem);
            for (PurchaseInformationRecordsDTO informationRecordsDTO : qualifiedPriceRecord) {
                RequestMatchInfomationVO requestMatchInfomationVO = this.getRequestMatchInfomationVO2(purchaseQuotaProtocolHeadVO, supplierSuggestAllocQuantityMap, requestItem, purchaseMaterialSourceDTOList, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, informationRecordsDTO, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        } else {
            RequestMatchInfomationVO requestMatchInfomationVO = this.getRequestMatchInfomationVO2(null, null, requestItem, purchaseMaterialSourceDTOList, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, null, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
            requestMatchInfomationVOList.add(requestMatchInfomationVO);
        }
        return requestMatchInfomationVOList;
    }

    private Map<String, BigDecimal> doSupplierSuggestAllocQuantity(PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend, List<PurchaseInformationRecordsDTO> qualifiedPriceRecord, PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO, PurchaseRequestItem requestItem) {
        HashMap<String, BigDecimal> supplierSuggestAllocQuantityMap = new HashMap<String, BigDecimal>();
        if (REPERTORY_UNIT_TYPE.equals(purchaseMaterialHeadExtend.getQuotaStrategy())) {
            List<String> toElsAccounts = qualifiedPriceRecord.stream().map(PurchaseInformationRecordsDTO::getToElsAccount).collect(Collectors.toList());
            String quotaWay = purchaseMaterialHeadExtend.getQuotaWay();
            List<PurchaseQuotaProtocolItem> quotaProtocolItemList = purchaseQuotaProtocolHeadVO.getPurchaseQuotaProtocolItemList();
            if (CollectionUtil.isEmpty(quotaProtocolItemList)) {
                throw new ELSBootException("\u914d\u989d\u534f\u8bae\u7f16\u53f7:" + purchaseQuotaProtocolHeadVO.getDocumentNumber() + "\u5bf9\u5e94\u7684\u914d\u989d\u534f\u8bae\u884c\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (PurchaseQuotaWayEnum.QUOTA_SPLIT.getValue().equals(quotaWay)) {
                this.doQuotaSplitLogic(purchaseQuotaProtocolHeadVO, requestItem, supplierSuggestAllocQuantityMap, toElsAccounts, quotaProtocolItemList);
            } else if (PurchaseQuotaWayEnum.QUOTA_UN_SPLIT.getValue().equals(quotaWay)) {
                this.doQuotaUnSplitLogic(purchaseQuotaProtocolHeadVO, requestItem, supplierSuggestAllocQuantityMap, toElsAccounts);
            }
        }
        return supplierSuggestAllocQuantityMap;
    }

    private void doQuotaUnSplitLogic(PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO, PurchaseRequestItem requestItem, Map<String, BigDecimal> supplierSuggestAllocQuantityMap, List<String> toElsAccounts) {
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        BigDecimal requesQuantity = requestItem.getQuantity().subtract(toOrderQuantity);
        List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList = purchaseQuotaProtocolHeadVO.getPurchaseQuotaProtocolItemList();
        if (CollectionUtil.isEmpty(purchaseQuotaProtocolItemList)) {
            throw new ELSBootException("\u914d\u989d\u534f\u8bae\u7f16\u53f7:" + purchaseQuotaProtocolHeadVO.getDocumentNumber() + "\u5bf9\u5e94\u7684\u914d\u989d\u534f\u8bae\u884c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List quotaProtocolItemFiltByToElsAccountList = purchaseQuotaProtocolItemList.stream().filter(item -> toElsAccounts.contains(item.getToElsAccount())).collect(Collectors.toList());
        for (PurchaseQuotaProtocolItem purchaseQuotaProtocolItem : quotaProtocolItemFiltByToElsAccountList) {
            BigDecimal quota;
            BigDecimal sumSuggestQuantity = purchaseQuotaProtocolItem.getSumSuggestQuantity() == null ? BigDecimal.ZERO : purchaseQuotaProtocolItem.getSumSuggestQuantity();
            BigDecimal baseQuotaQuantity = purchaseQuotaProtocolItem.getBaseQuota() == null ? BigDecimal.ZERO : purchaseQuotaProtocolItem.getBaseQuota();
            BigDecimal bigDecimal = quota = purchaseQuotaProtocolItem.getQuota() == null ? BigDecimal.ONE : purchaseQuotaProtocolItem.getQuota();
            if (BigDecimal.ZERO.compareTo(quota) == 0) {
                quota = BigDecimal.ONE;
            }
            purchaseQuotaProtocolItem.setQuotaPercen(sumSuggestQuantity.add(baseQuotaQuantity).divide(quota, 2, 4));
        }
        List purchaseQuotaProtocolItemsAsc = quotaProtocolItemFiltByToElsAccountList.stream().sorted(Comparator.comparing(PurchaseQuotaProtocolItem::getQuotaPercen)).collect(Collectors.toList());
        for (int i = 0; i < purchaseQuotaProtocolItemsAsc.size(); ++i) {
            PurchaseQuotaProtocolItem purchaseQuotaProtocolItem = (PurchaseQuotaProtocolItem)((Object)purchaseQuotaProtocolItemsAsc.get(i));
            supplierSuggestAllocQuantityMap.put(purchaseQuotaProtocolItem.getToElsAccount(), BigDecimal.ZERO);
        }
        for (PurchaseQuotaProtocolItem purchaseQuotaProtocolItem : purchaseQuotaProtocolItemsAsc) {
            int div;
            BigDecimal sumSuggestQuantity = purchaseQuotaProtocolItem.getSumSuggestQuantity();
            BigDecimal maxAllocQuantity = purchaseQuotaProtocolItem.getMaxAllocQuantity();
            BigDecimal minOrderQuantity = purchaseQuotaProtocolItem.getMinQuantity();
            BigDecimal minPackageQuantity = purchaseQuotaProtocolItem.getMinPackQuantity();
            BigDecimal supplierSuggestAllocQuantity = requesQuantity;
            if (maxAllocQuantity != null && BigDecimal.ZERO.compareTo(maxAllocQuantity) < 0 && (sumSuggestQuantity = sumSuggestQuantity.add(supplierSuggestAllocQuantity)).compareTo(maxAllocQuantity) > 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            if (minOrderQuantity != null && BigDecimal.ZERO.compareTo(minOrderQuantity) < 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) < 0 && supplierSuggestAllocQuantity.compareTo(minOrderQuantity) < 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            if (minPackageQuantity != null && BigDecimal.ZERO.compareTo(minPackageQuantity) < 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) < 0 && (div = supplierSuggestAllocQuantity.intValue() % minPackageQuantity.intValue()) != 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity = supplierSuggestAllocQuantity.divide(minPackageQuantity, 0, 1).subtract(BigDecimal.ONE).multiply(minPackageQuantity)) > 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            supplierSuggestAllocQuantityMap.put(purchaseQuotaProtocolItem.getToElsAccount(), supplierSuggestAllocQuantity);
            if (BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) == 0) continue;
            break;
        }
    }

    private void doQuotaSplitLogic(PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO, PurchaseRequestItem requestItem, Map<String, BigDecimal> supplierSuggestAllocQuantityMap, List<String> toElsAccounts, List<PurchaseQuotaProtocolItem> quotaProtocolItemList) {
        BigDecimal minSplitQuantity = purchaseQuotaProtocolHeadVO.getMinSplitQuantity();
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        BigDecimal requesQuantity = requestItem.getQuantity().subtract(toOrderQuantity);
        if (requesQuantity.compareTo(minSplitQuantity) >= 0) {
            for (String string : toElsAccounts) {
                List purchaseQuotaProtocolItemList = quotaProtocolItemList.stream().filter(item -> string.equals(item.getToElsAccount())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(purchaseQuotaProtocolItemList)) {
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + requestItem.getMaterialNumber() + "\u7269\u6599\u63cf\u8ff0:" + requestItem.getMaterialDesc() + "\u914d\u989d\u534f\u8bae\u4e2d\u6ca1\u6709\u4f9b\u5e94\u5546" + string);
                }
                PurchaseQuotaProtocolItem purchaseQuotaProtocolItem = (PurchaseQuotaProtocolItem)((Object)purchaseQuotaProtocolItemList.get(0));
                BigDecimal suggestAllocQuantity = purchaseQuotaProtocolItem.getQuota().divide(new BigDecimal("100")).multiply(requesQuantity);
                supplierSuggestAllocQuantityMap.put(string, suggestAllocQuantity);
            }
        } else {
            List descQuotaItem = quotaProtocolItemList.stream().sorted(Comparator.comparing(PurchaseQuotaProtocolItem::getQuota).reversed()).collect(Collectors.toList());
            for (String toElsAccount : toElsAccounts) {
                if (toElsAccount.equals(((PurchaseQuotaProtocolItem)((Object)descQuotaItem.get(0))).getToElsAccount())) {
                    supplierSuggestAllocQuantityMap.put(toElsAccount, requesQuantity);
                    continue;
                }
                supplierSuggestAllocQuantityMap.put(toElsAccount, BigDecimal.ZERO);
            }
        }
        for (String string : toElsAccounts) {
            int div;
            BigDecimal supplierSuggestAllocQuantity = supplierSuggestAllocQuantityMap.get(string);
            if (BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) == 0) continue;
            List purchaseQuotaProtocolItemList = quotaProtocolItemList.stream().filter(item -> string.equals(item.getToElsAccount())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(purchaseQuotaProtocolItemList)) {
                throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + requestItem.getMaterialNumber() + "\u7269\u6599\u63cf\u8ff0:" + requestItem.getMaterialDesc() + "\u914d\u989d\u534f\u8bae\u4e2d\u6ca1\u6709\u4f9b\u5e94\u5546" + string);
            }
            PurchaseQuotaProtocolItem purchaseQuotaProtocolItem = (PurchaseQuotaProtocolItem)((Object)purchaseQuotaProtocolItemList.get(0));
            BigDecimal sumSuggestQuantity = purchaseQuotaProtocolItem.getSumSuggestQuantity();
            BigDecimal maxAllocQuantity = purchaseQuotaProtocolItem.getMaxAllocQuantity();
            BigDecimal minOrderQuantity = purchaseQuotaProtocolItem.getMinQuantity();
            BigDecimal minPackageQuantity = purchaseQuotaProtocolItem.getMinPackQuantity();
            if (maxAllocQuantity != null && BigDecimal.ZERO.compareTo(maxAllocQuantity) < 0 && (sumSuggestQuantity = sumSuggestQuantity.add(supplierSuggestAllocQuantity)).compareTo(maxAllocQuantity) > 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            if (minOrderQuantity != null && BigDecimal.ZERO.compareTo(minOrderQuantity) < 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) < 0 && supplierSuggestAllocQuantity.compareTo(minOrderQuantity) < 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            if (minPackageQuantity != null && BigDecimal.ZERO.compareTo(minPackageQuantity) < 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity) < 0 && (div = supplierSuggestAllocQuantity.intValue() % minPackageQuantity.intValue()) != 0 && BigDecimal.ZERO.compareTo(supplierSuggestAllocQuantity = supplierSuggestAllocQuantity.divide(minPackageQuantity, 0, 1).subtract(BigDecimal.ONE).multiply(minPackageQuantity)) > 0) {
                supplierSuggestAllocQuantity = BigDecimal.ZERO;
            }
            supplierSuggestAllocQuantityMap.put(string, supplierSuggestAllocQuantity);
        }
    }

    private RequestMatchInfomationVO getRequestMatchInfomationVO2(PurchaseQuotaProtocolHeadVO purchaseQuotaProtocolHeadVO, Map<String, BigDecimal> suggestSupplierAllocQuantityMap, PurchaseRequestItem requestItem, List<PurchaseMaterialSourceDTO> purchaseMaterialSourceDTOList, PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend, PurchaseRequestHead requestHead, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseInformationRecordsDTO informationRecordsDTO, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO, DeliveryOrderAddressDTO deliveryOrderAddressDTO) {
        RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
        requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
        requestMatchInfomationVO.setRequestHeadId(requestItem.getHeadId());
        requestMatchInfomationVO.setMaterialID(requestItem.getMaterialId());
        requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
        requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
        requestMatchInfomationVO.setMaterialName(requestItem.getMaterialName());
        requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
        requestMatchInfomationVO.setMaterialSpec(requestItem.getMaterialSpec());
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
        requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
        requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
        requestMatchInfomationVO.setCompany(requestItem.getCompany());
        if (StringUtils.isBlank((CharSequence)purchaseMaterialHeadExtend.getDeliveryArrange())) {
            requestMatchInfomationVO.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
        } else {
            requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getDeliveryArrange());
        }
        requestMatchInfomationVO.setFactory(requestItem.getFactory());
        requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
        requestMatchInfomationVO.setRequestItemId(requestItem.getId());
        requestMatchInfomationVO.setRequestType(requestHead.getRequestType());
        requestMatchInfomationVO.setRequestTypeName(requestHead.getRequestTypeName());
        requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseUnit(requestItem.getPurchaseUnit());
        requestMatchInfomationVO.setItemRequestTypeName(requestItem.getPurchaseType());
        requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
        if (StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
            requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
        }
        requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
        requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
        requestMatchInfomationVO.setCateName(requestItem.getCateName());
        if (CollectionUtil.isNotEmpty(purchaseMaterialSourceDTOList) && informationRecordsDTO != null) {
            List materialSourceDTOS = purchaseMaterialSourceDTOList.stream().filter(item -> item.getToElsAccount().equals(informationRecordsDTO.getToElsAccount())).collect(Collectors.toList());
            requestMatchInfomationVO.setPreferredSupplier(((PurchaseMaterialSourceDTO)materialSourceDTOS.get(0)).getPreferredSupplier());
            if (!REPERTORY_UNIT_TYPE.equals(requestMatchInfomationVO.getPreferredSupplier())) {
                requestMatchInfomationVO.setPreferredSupplier(PURCHASE_UNIT_TYPE);
            }
        } else {
            requestMatchInfomationVO.setPreferredSupplier(PURCHASE_UNIT_TYPE);
        }
        List materialUnitDTOList = purchaseMaterialHeadExtend.getMaterialUnitDTOList();
        if (CollectionUtil.isEmpty((Collection)materialUnitDTOList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWBjLDtRtLjsSRHW_c0d1f41a", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u6ca1\u6709\u7ef4\u62a4\u8ba1\u91cf\u5355\u4f4d\u7684\u8f6c\u6362\u5173\u7cfb!", (String[])new String[]{purchaseMaterialHeadExtend.getMaterialNumber()}));
        }
        List<Object> requestItemMaterialUnitDTOList = new ArrayList();
        PurchaseMaterialUnitDTO requestItemMaterialUnitDTO = new PurchaseMaterialUnitDTO();
        if (CollectionUtil.isNotEmpty((Collection)materialUnitDTOList)) {
            requestItemMaterialUnitDTOList = materialUnitDTOList.stream().filter(item -> PURCHASE_UNIT_TYPE.equals(item.getType()) && requestItem.getPurchaseUnit().equals(item.getObjectUnit())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(requestItemMaterialUnitDTOList)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVSLAyWWWWWWWnRtLWWWWWWWKSLdWFWtRtLsYxusSRH_df08d186", (String)"\u91c7\u8d2d\u7533\u8bf7\u7269\u6599\u7f16\u53f7\uff1a[${0}]\u91c7\u8d2d\u5355\u4f4d\uff1a[${1}]\u5728\u7269\u6599\u4e3b\u6570\u636e-\u8ba1\u91cf\u5355\u4f4d\u4e2d\u627e\u4e0d\u5230\u8f6c\u6362\u5173\u7cfb", (String[])new String[]{requestItem.getMaterialNumber(), requestItem.getPurchaseUnit()}));
            }
            requestItemMaterialUnitDTO = (PurchaseMaterialUnitDTO)requestItemMaterialUnitDTOList.get(0);
        }
        if (StringUtils.isBlank((CharSequence)purchaseMaterialHeadExtend.getSource())) {
            requestMatchInfomationVO.setSource(PURCHASE_UNIT_TYPE);
        } else {
            requestMatchInfomationVO.setSource(purchaseMaterialHeadExtend.getSource());
        }
        requestMatchInfomationVO.setFreePrice(purchaseOrderGenarateConfig.getPriceInfo());
        requestMatchInfomationVO.setTemplateNumber(purchaseOrderGenarateConfig.getTemplateNumber());
        requestMatchInfomationVO.setTemplateName(purchaseOrderGenarateConfig.getTemplateName());
        requestMatchInfomationVO.setTemplateAccount(purchaseOrderGenarateConfig.getTemplateAccount());
        requestMatchInfomationVO.setTemplateVersion(Integer.parseInt(purchaseOrderGenarateConfig.getTemplateVersion()));
        requestMatchInfomationVO.setOrderType(purchaseOrderGenarateConfig.getOrderType());
        requestMatchInfomationVO.setPurchaseType(purchaseOrderGenarateConfig.getItemPurchaseType());
        if (REPERTORY_UNIT_TYPE.equals(purchaseOrderPermissionConfigDTO.getCentralizedDelivery())) {
            requestMatchInfomationVO.setDeliveryAddress(purchaseOrderPermissionConfigDTO.getDeliveryAddress());
        } else if (deliveryOrderAddressDTO != null) {
            requestMatchInfomationVO.setDeliveryAddress(deliveryOrderAddressDTO.getAddress());
        }
        if (informationRecordsDTO != null) {
            SupplierMasterDataDTO supplierMasterDataDTO = supplierMasterDataDTOMap.get(informationRecordsDTO.getToElsAccount());
            SupplierOrgInfoDTO supplierOrgInfoDTO = supplierOrgInfoDTOMap.get(informationRecordsDTO.getElsAccount() + "&&" + informationRecordsDTO.getToElsAccount() + "&&" + informationRecordsDTO.getPurchaseOrg());
            if (supplierMasterDataDTO == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_RdXdWFsYxurSLumIdjRdX_7a5b23de", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u4e2d\u627e\u4e0d\u5230\u8be5\u7269\u6599\u4ef7\u683c\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546"));
            }
            requestMatchInfomationVO.setNeedCoordination(supplierMasterDataDTO.getNeedCoordination());
            if (supplierOrgInfoDTO != null) {
                requestMatchInfomationVO.setPayWay(supplierOrgInfoDTO.getPaymentMethod());
                requestMatchInfomationVO.setPaymentClause(supplierOrgInfoDTO.getPayConditionCode());
            }
            requestMatchInfomationVO.setToElsAccount(informationRecordsDTO.getToElsAccount());
            String cateCode = requestItem.getCateCode();
            String toElsAccount = informationRecordsDTO.getToElsAccount();
            String orderType = purchaseOrderGenarateConfig.getOrderType();
            List<PurchaseOrderProgressTemplateDistributionDTO> purchaseOrderProgressTemplateDistributionDTO = this.inquiryInvokeOrderRpcService.selectOrderProgressTemplateList(cateCode, toElsAccount, orderType);
            if (CollectionUtil.isNotEmpty(purchaseOrderProgressTemplateDistributionDTO)) {
                requestMatchInfomationVO.setOrderProgressTemplateName(purchaseOrderProgressTemplateDistributionDTO.get(0).getProgressTemplateName());
                requestMatchInfomationVO.setOrderProgressTemplateNumber(purchaseOrderProgressTemplateDistributionDTO.get(0).getProgressTemplateNumber());
                requestMatchInfomationVO.setOrderProgressTemplateId(purchaseOrderProgressTemplateDistributionDTO.get(0).getHeadId());
            } else {
                requestMatchInfomationVO.setOrderProgressTemplateName("");
                requestMatchInfomationVO.setOrderProgressTemplateNumber("");
                requestMatchInfomationVO.setOrderProgressTemplateId("");
            }
            requestMatchInfomationVO.setSupplierName(informationRecordsDTO.getSupplierName());
            requestMatchInfomationVO.setTaxRate(informationRecordsDTO.getTaxRate());
            requestMatchInfomationVO.setTaxCode(informationRecordsDTO.getTaxCode());
            requestMatchInfomationVO.setLadderPriceJson(informationRecordsDTO.getLadderPriceJson());
            BigDecimal price = BigDecimal.valueOf(0L);
            if (!StringUtils.isEmpty((CharSequence)informationRecordsDTO.getLadderPriceJson())) {
                this.parseLadderJsonPriceToPirceRecord(requestMatchInfomationVO, requestItem.getQuantity());
                price = requestMatchInfomationVO.getPrice();
            } else {
                price = informationRecordsDTO.getPrice();
            }
            if (StringUtils.isEmpty((CharSequence)informationRecordsDTO.getPurchaseUnit())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAyWWWWWWWzEjumWumVHtHyWWWWWWjnRtLLVWVImxVW_20fc6e4f", (String)"\u7269\u6599\u7f16\u53f7:[${0}]\u5339\u914d\u7684\u4ef7\u683c,\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55\u53f7[${1}]\u7684\u91c7\u8d2d\u5355\u4f4d\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u8865\u5145!", (String[])new String[]{informationRecordsDTO.getMaterialNumber(), informationRecordsDTO.getInfoRecordNumber()}));
            }
            List infomationMaterialUnitDTOList = materialUnitDTOList.stream().filter(item -> PURCHASE_UNIT_TYPE.equals(item.getType()) && requestItem.getPurchaseUnit().equals(item.getObjectUnit())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(infomationMaterialUnitDTOList)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHyWWWWWWWnRtLWWWWWWWKSLdWFWtRtLsYxusSRH_16efeaf4", (String)"\u4ef7\u683c\u8bb0\u5f55\u53f7\uff1a[${0}]\u91c7\u8d2d\u5355\u4f4d\uff1a[${1}]\u5728\u7269\u6599\u4e3b\u6570\u636e-\u8ba1\u91cf\u5355\u4f4d\u4e2d\u627e\u4e0d\u5230\u8f6c\u6362\u5173\u7cfb", (String[])new String[]{informationRecordsDTO.getInfoRecordNumber(), informationRecordsDTO.getPurchaseUnit()}));
            }
            PurchaseMaterialUnitDTO informationMaterialUnit = (PurchaseMaterialUnitDTO)infomationMaterialUnitDTOList.get(0);
            price = price.divide(informationMaterialUnit.getBasicAmount(), 6, RoundingMode.HALF_UP).multiply(informationMaterialUnit.getObjectAmount());
            price = price.divide(requestItemMaterialUnitDTO.getObjectAmount(), 6, RoundingMode.HALF_UP).multiply(requestItemMaterialUnitDTO.getBasicAmount());
            BigDecimal taxRate = new BigDecimal(informationRecordsDTO.getTaxRate());
            BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            requestMatchInfomationVO.setPrice(price);
            requestMatchInfomationVO.setNetPrice(netPrice);
            requestMatchInfomationVO.setEffectiveDate(informationRecordsDTO.getEffectiveDate());
            requestMatchInfomationVO.setExpiryDate(informationRecordsDTO.getExpiryDate());
            requestMatchInfomationVO.setCurrency(informationRecordsDTO.getCurrencyCode());
            requestMatchInfomationVO.setEstimate(informationRecordsDTO.getTemporaryPrice());
            requestMatchInfomationVO.setPriceUnit(informationRecordsDTO.getPriceUnit());
            if (StringUtils.isEmpty((CharSequence)informationRecordsDTO.getPriceUnit())) {
                requestMatchInfomationVO.setPriceUnit(REPERTORY_UNIT_TYPE);
            }
            BigDecimal suggestAllocQuantity = suggestSupplierAllocQuantityMap.get(informationRecordsDTO.getToElsAccount()) == null ? BigDecimal.ZERO : suggestSupplierAllocQuantityMap.get(informationRecordsDTO.getToElsAccount());
            requestMatchInfomationVO.setSuggestAllocQuantity(suggestAllocQuantity);
            requestMatchInfomationVO.setQuota(BigDecimal.ZERO);
            requestMatchInfomationVO.setSumSuggestQuantity(BigDecimal.ZERO);
            requestMatchInfomationVO.setMinOrderQuantity(BigDecimal.ZERO);
            requestMatchInfomationVO.setMinPackageQuantity(BigDecimal.ZERO);
            requestMatchInfomationVO.setMaxAllocQuantity(BigDecimal.ZERO);
            if (purchaseQuotaProtocolHeadVO != null) {
                List purchaseQuotaProtocolItemList = purchaseQuotaProtocolHeadVO.getPurchaseQuotaProtocolItemList().stream().filter(item -> toElsAccount.equals(item.getToElsAccount())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(purchaseQuotaProtocolItemList)) {
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + requestItem.getMaterialNumber() + "\u7269\u6599\u63cf\u8ff0:" + requestItem.getMaterialDesc() + "\u914d\u989d\u534f\u8bae\u4e2d\u6ca1\u6709\u4f9b\u5e94\u5546" + toElsAccount);
                }
                PurchaseQuotaProtocolItem purchaseQuotaProtocolItem = (PurchaseQuotaProtocolItem)((Object)purchaseQuotaProtocolItemList.get(0));
                requestMatchInfomationVO.setQuota(purchaseQuotaProtocolItem.getQuota());
                requestMatchInfomationVO.setSumSuggestQuantity(purchaseQuotaProtocolItem.getSumSuggestQuantity());
                requestMatchInfomationVO.setMinOrderQuantity(purchaseQuotaProtocolItem.getMinQuantity());
                requestMatchInfomationVO.setMinPackageQuantity(purchaseQuotaProtocolItem.getMinPackQuantity());
                requestMatchInfomationVO.setQuotaProcotolId(purchaseQuotaProtocolItem.getId());
                requestMatchInfomationVO.setMaxAllocQuantity(purchaseQuotaProtocolItem.getMaxAllocQuantity());
            }
        }
        requestMatchInfomationVO.setRequestItemChildList(requestItem.getRequestItemChildList());
        requestMatchInfomationVO.setQuantityReturn(purchaseOrderGenarateConfig.getQuantityReturn());
        if (StringUtils.isNotEmpty((CharSequence)requestMatchInfomationVO.getQuotaProcotolId())) {
            requestMatchInfomationVO.setToOrderQuantity(requestMatchInfomationVO.getSuggestAllocQuantity());
        } else {
            requestMatchInfomationVO.setToOrderQuantity(requestMatchInfomationVO.getQuantity());
        }
        return requestMatchInfomationVO;
    }

    private Map<String, PurchaseMaterialHeadExtendDTO> getPurchaseMaterialHeadMap(List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseMaterialHeadDTO> purchaseMaterialHeadList, List<PurchaseMaterialCodeDTO> purchaseMaterialCodeDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            HashMap<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = new HashMap<String, PurchaseMaterialHeadExtendDTO>();
            List<String> materialIds = purchaseMaterialHeadList.stream().map(BaseDTO::getId).collect(Collectors.toList());
            List<PurchaseMaterialUnitDTO> materialUnitDTOList = this.purchaseMaterialHeadLocalRpcService.listUnitByMaterialIds(materialIds);
            Map<String, List<PurchaseMaterialUnitDTO>> materialUnitClassicByHeadId = materialUnitDTOList.stream().collect(Collectors.groupingBy(PurchaseMaterialUnitDTO::getHeadId));
            Map materialByNumberMap = purchaseMaterialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
            Map materialCateByCodeMap = purchaseMaterialCodeDTOList.stream().collect(Collectors.toMap(PurchaseMaterialCodeDTO::getCateCode, Function.identity(), (o1, o2) -> o1));
            List<String> headIds = purchaseMaterialHeadList.stream().map(BaseDTO::getId).collect(Collectors.toList());
            List<PurchaseMaterialItemDTO> materialItemList = this.purchaseMaterialHeadLocalRpcService.selectByMainIds(headIds);
            Map<String, List<PurchaseMaterialItemDTO>> itemMap = materialItemList.stream().filter(i -> StringUtils.isNotEmpty((CharSequence)i.getFactory())).collect(Collectors.groupingBy(i -> i.getHeadId() + "_" + i.getFactory()));
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                if (purchaseMaterialHeadExtendMap.containsKey(key)) continue;
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = new PurchaseMaterialHeadExtendDTO();
                PurchaseMaterialHeadDTO purchaseMaterialHead = (PurchaseMaterialHeadDTO)materialByNumberMap.get(requestItem.getMaterialNumber());
                PurchaseMaterialCodeDTO purchaseMaterialCode = (PurchaseMaterialCodeDTO)materialCateByCodeMap.get(requestItem.getCateCode());
                com.els.common.util.Assert.isNotNull((Object)purchaseMaterialHead, (String)I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWKSLdWFsBjrTSLWVIm_98828133", (String)"\u7269\u6599\u7f16\u7801:[${0}]\u5728\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u6ca1\u6709\u8be5\u6761\u7269\u6599,\u8bf7\u68c0\u67e5", (String[])new String[]{requestItem.getMaterialNumber()}));
                BeanUtils.copyProperties((Object)purchaseMaterialHead, (Object)purchaseMaterialHeadExtend);
                if (StringUtils.isNotBlank((CharSequence)requestItem.getFactory())) {
                    List<PurchaseMaterialItemDTO> purchaseMaterialItemList = itemMap.get(purchaseMaterialHead.getId() + "_" + requestItem.getFactory());
                    PurchaseMaterialItemDTO purchaseMaterialItem = null;
                    if (CollectionUtil.isNotEmpty(purchaseMaterialItemList) && (purchaseMaterialItem = purchaseMaterialItemList.get(0)) != null) {
                        purchaseMaterialHeadExtend.setSource(purchaseMaterialItem.getSource());
                        purchaseMaterialHeadExtend.setItemJit(purchaseMaterialItem.getJit());
                        purchaseMaterialHeadExtend.setItemFactory(purchaseMaterialItem.getFactory());
                        purchaseMaterialHeadExtend.setDeliveryArrange(purchaseMaterialItem.getDeliveryArrange());
                    }
                }
                if (StringUtils.isEmpty((CharSequence)purchaseMaterialHead.getQuotaStrategy()) && purchaseMaterialCode != null) {
                    purchaseMaterialHeadExtend.setQuotaStrategy(purchaseMaterialCode.getQuotaStrategy());
                    purchaseMaterialHeadExtend.setQuotaWay(purchaseMaterialCode.getQuotaWay());
                } else if (StringUtils.isEmpty((CharSequence)purchaseMaterialHead.getQuotaStrategy()) && purchaseMaterialCode == null) {
                    purchaseMaterialHeadExtend.setQuotaStrategy(PURCHASE_UNIT_TYPE);
                }
                List<PurchaseMaterialUnitDTO> materialUnitDTOS = materialUnitClassicByHeadId.get(purchaseMaterialHead.getId());
                purchaseMaterialHeadExtend.setMaterialUnitDTOList(materialUnitDTOS);
                purchaseMaterialHeadExtendMap.put(key, purchaseMaterialHeadExtend);
            }
            return purchaseMaterialHeadExtendMap;
        }
        return null;
    }

    @Override
    public void syncRequestToOrderQuantity(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            List requestItemIds = purchaseRequestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper purchaseOrderRequestInformationLambdaQueryWrapper = new QueryWrapper().lambda();
            purchaseOrderRequestInformationLambdaQueryWrapper.in(PurchaseOrderRequestInformation::getRequestItemId, requestItemIds);
            List orderRequestInformationList = this.purchaseOrderRequestInformationService.list((Wrapper)purchaseOrderRequestInformationLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)orderRequestInformationList)) {
                Map<String, List<PurchaseOrderRequestInformation>> orderRequestInformationGroupByRequestIdMap = orderRequestInformationList.stream().collect(Collectors.groupingBy(PurchaseOrderRequestInformation::getRequestItemId));
                Set<String> keys = orderRequestInformationGroupByRequestIdMap.keySet();
                ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
                for (String key : keys) {
                    List<PurchaseOrderRequestInformation> requestInformationList = orderRequestInformationGroupByRequestIdMap.get(key);
                    BigDecimal toOrderQuantitySum = requestInformationList.stream().map(PurchaseOrderRequestInformation::getToOrderQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal relaseOrderQuantitySum = requestInformationList.stream().map(PurchaseOrderRequestInformation::getRelaseOrderQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    PurchaseRequestItem requestItem = new PurchaseRequestItem();
                    requestItem.setId(key);
                    requestItem.setToOrderQuantity(toOrderQuantitySum.subtract(relaseOrderQuantitySum));
                    requestItemList.add(requestItem);
                }
                this.purchaseRequestItemMapper.updateBatchById(requestItemList);
            }
        }
    }

    @Override
    public void syncRequestatus(List<PurchaseRequestItem> requestItemList) {
        List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List purchaseRequestItems = this.purchaseRequestItemMapper.selectBatchIds(ids);
        if (CollectionUtil.isNotEmpty((Collection)purchaseRequestItems)) {
            ArrayList<PurchaseRequestItem> purchaseRequestItems1 = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItems) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                purchaseRequestItem.setId(requestItem.getId());
                if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) == 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                } else if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) < 0 && requestItem.getToOrderQuantity().compareTo(requestItem.getQuantity()) < 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_PAETIAL_TRANSFER.getValue());
                } else {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_ALL_TRANSFER.getValue());
                }
                purchaseRequestItems1.add(purchaseRequestItem);
            }
            this.purchaseRequestItemService.updateBatchById(purchaseRequestItems1);
        }
    }

    @Override
    @SrmTransaction
    public void toDemandPool(String id) {
        List<PurchaseRequestItem> collect;
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DJuTVuRRjImcdI_442c1b0e", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cWRXUEUW_778b1ee1", (String)"\u884c\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItems);
        if (CollectionUtil.isNotEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadVO);
        }
        if (CollectionUtil.isNotEmpty(purchaseRequestItems)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List ids = items.stream().filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                if ("mall".equals(purchaseRequestItems.get(0).getSourceType())) {
                    updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                } else {
                    updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                }
                updateWrapper.in(BaseEntity::getId, ids);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        if (!CollectionUtils.isEmpty(collect = purchaseRequestItems.parallelStream().filter(item -> !StringUtils.isBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList()))) {
            this.matchPrice(collect);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadVO.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update((Object)new PurchaseRequestHead());
        List<PurchaseRequestItem> purchaseRequestItemsNew = this.purchaseRequestItemMapper.selectByMainId(id);
        List collect1 = purchaseRequestItemsNew.parallelStream().filter(item -> "sumit".equals(item.getTacticsEntity()) || "person".equals(item.getTacticsEntity())).map(PurchaseRequestItem::getTacticsObject).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            for (String s : collect1) {
                if (!s.contains("_")) continue;
                String[] s1 = s.split("_");
                super.sendMsg(purchaseRequestHead.getElsAccount(), s1[1], (Object)purchaseRequestHead, "", "purchaseRequest", "publish");
            }
        }
    }

    @Override
    public List<PurchaseRequestItemDTO> selectPurchaseRequestItemByItemIds(List<String> itemIds) {
        List list = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, itemIds)).list();
        return SysUtil.copyProperties((List)list, PurchaseRequestItemDTO.class);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseOrderHeadDTO> requestToCreateOrder(List<RequestMatchInfomationVO> requestMatchInfomationList) {
        List<PurchaseOrderHeadDTO> orderHeadDTOList = this.packageRequestToOrder(requestMatchInfomationList);
        List<PurchaseOrderHeadDTO> purchaseOrderHeadDTOList = this.inquiryInvokeOrderRpcService.requestToCreateOrder(orderHeadDTOList);
        ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationList) {
            List<PurchaseRequestItemChild> requestItemChildList = requestMatchInfomationVO.getRequestItemChildList();
            for (PurchaseRequestItemChild requestItemChild : requestItemChildList) {
                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                requestItem.setRequestNumber(requestItemChild.getRequestNumber());
                requestItem.setItemNumber(requestItemChild.getItemNumber());
                requestItem.setId(requestItemChild.getId());
                requestItem.setElsAccount(requestItemChild.getElsAccount());
                purchaseRequestItemList.add(requestItem);
            }
        }
        this.syncRequestToOrderQuantity(purchaseRequestItemList);
        this.syncRequestatus(purchaseRequestItemList);
        this.syncQuotaProcotolQuantity(orderHeadDTOList);
        return purchaseOrderHeadDTOList;
    }

    private void syncQuotaProcotolQuantity(List<PurchaseOrderHeadDTO> orderHeadDTOList) {
        if (CollectionUtil.isNotEmpty(orderHeadDTOList)) {
            ArrayList purchaseOrderItemDTOList = new ArrayList();
            for (PurchaseOrderHeadDTO purchaseOrderHeadDTO : orderHeadDTOList) {
                if (!CollectionUtil.isNotEmpty((Collection)purchaseOrderHeadDTO.getPurchaseOrderItemList())) continue;
                purchaseOrderItemDTOList.addAll(purchaseOrderHeadDTO.getPurchaseOrderItemList());
            }
            HashMap<String, BigDecimal> orderQuantityByQuotaItemIdMap = new HashMap<String, BigDecimal>();
            for (PurchaseOrderItemDTO purchaseOrderItemDTO : purchaseOrderItemDTOList) {
                if (orderQuantityByQuotaItemIdMap.containsKey(purchaseOrderItemDTO.getQuotaProcotolId())) {
                    BigDecimal quotaQuantity = (BigDecimal)orderQuantityByQuotaItemIdMap.get(purchaseOrderItemDTO.getQuotaProcotolId());
                    quotaQuantity = quotaQuantity.add(purchaseOrderItemDTO.getQuantity());
                    orderQuantityByQuotaItemIdMap.put(purchaseOrderItemDTO.getQuotaProcotolId(), quotaQuantity);
                    continue;
                }
                orderQuantityByQuotaItemIdMap.put(purchaseOrderItemDTO.getQuotaProcotolId(), purchaseOrderItemDTO.getQuantity());
            }
            List list = purchaseOrderItemDTOList.stream().map(PurchaseOrderItemDTO::getQuotaProcotolId).collect(Collectors.toList());
            List purchaseQuotaProtocolItemList = this.purchaseQuotaProtocolItemService.listByIds(list);
            ArrayList<PurchaseQuotaProtocolItem> paramPurchaseQuotaProtocolItemList = new ArrayList<PurchaseQuotaProtocolItem>();
            if (CollectionUtil.isNotEmpty((Collection)purchaseQuotaProtocolItemList)) {
                for (PurchaseQuotaProtocolItem purchaseQuotaProtocolItem : purchaseQuotaProtocolItemList) {
                    BigDecimal orderQuantity = orderQuantityByQuotaItemIdMap.get(purchaseQuotaProtocolItem.getId()) == null ? BigDecimal.ZERO : (BigDecimal)orderQuantityByQuotaItemIdMap.get(purchaseQuotaProtocolItem.getId());
                    BigDecimal sumSuggestQuantity = purchaseQuotaProtocolItem.getSumSuggestQuantity() == null ? BigDecimal.ZERO : purchaseQuotaProtocolItem.getSumSuggestQuantity();
                    sumSuggestQuantity = sumSuggestQuantity.add(orderQuantity);
                    PurchaseQuotaProtocolItem paramPurchaseQuotaProtocolItem = new PurchaseQuotaProtocolItem();
                    paramPurchaseQuotaProtocolItem.setId(purchaseQuotaProtocolItem.getId());
                    paramPurchaseQuotaProtocolItem.setSumSuggestQuantity(sumSuggestQuantity);
                    paramPurchaseQuotaProtocolItemList.add(paramPurchaseQuotaProtocolItem);
                }
                this.purchaseQuotaProtocolItemService.updateBatchById(paramPurchaseQuotaProtocolItemList);
            }
        }
    }

    public List<PurchaseOrderHeadDTO> packageRequestToOrder(List<RequestMatchInfomationVO> requestMatchInfomationVOList) {
        Map<String, List<RequestMatchInfomationVO>> requestMatchInfumationMapByCondition = this.getRequestMatchInformationMap(requestMatchInfomationVOList);
        List requestItemIds = requestMatchInfomationVOList.stream().map(item -> item.getRequestItemId()).collect(Collectors.toList());
        List requestItemVoList = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, requestItemIds)).list();
        Map<String, PurchaseRequestItem> requestItemMapById = requestItemVoList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (v1, v2) -> v2));
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadVOList = new ArrayList<PurchaseOrderHeadDTO>();
        Set<String> keys = requestMatchInfumationMapByCondition.keySet();
        for (String key : keys) {
            List<RequestMatchInfomationVO> requestMatchInfomationVOSubList = requestMatchInfumationMapByCondition.get(key);
            ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
            ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
            BigDecimal totalNetAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            int i = 1;
            String orderHeadId = IdWorker.getIdStr();
            for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationVOSubList) {
                PurchaseOrderItemDTO purchaseOrderItem = this.doPackageOrderItem(orderHeadId, requestMatchInfomationVO, requestItemMapById);
                purchaseOrderItem.setItemNumber("" + i++);
                totalNetAmount = totalNetAmount.add(purchaseOrderItem.getNetAmount());
                totalTaxAmount = totalTaxAmount.add(purchaseOrderItem.getTaxAmount());
                purchaseOrderItemList.add(purchaseOrderItem);
                this.doRelationData(requestMatchInfomationVO, purchaseOrderItem);
            }
            if (CollectionUtil.isNotEmpty(purchaseOrderItemList)) {
                int deliveryItemCount = 1;
                for (PurchaseOrderItemDTO orderItem : purchaseOrderItemList) {
                    PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = this.doPackageOrderDeliveryItem(orderItem);
                    if (orderDeliveryPlan == null) continue;
                    orderDeliveryPlan.setItemNumber(deliveryItemCount + "");
                    ++deliveryItemCount;
                    purchaseOrderDeliveryPlanList.add(orderDeliveryPlan);
                }
            }
            PurchaseOrderHeadDTO purchaseOrderHead = this.doPackageOrderHead(orderHeadId, requestItemMapById, requestItemVoList, requestMatchInfomationVOSubList, purchaseOrderItemList, purchaseOrderDeliveryPlanList, totalNetAmount, totalTaxAmount);
            if (CollectionUtil.isNotEmpty(purchaseOrderItemList)) {
                List list = purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getDocumentId).distinct().collect(Collectors.toList());
                purchaseOrderHead.setDocumentId(StringUtils.join(list, (String)","));
                List strings = purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getSourceId).distinct().collect(Collectors.toList());
                purchaseOrderHead.setDocumentParentId(StringUtils.join(strings, (String)","));
            }
            purchaseOrderHeadVOList.add(purchaseOrderHead);
        }
        return purchaseOrderHeadVOList;
    }

    private void doRelationData(RequestMatchInfomationVO requestMatchInfomationVO, PurchaseOrderItemDTO purchaseOrderItem) {
        List<PurchaseRequestItemChild> requestItemChildList = requestMatchInfomationVO.getRequestItemChildList();
        ArrayList<PurchaseOrderRequestInformation> orderRequestInformations = new ArrayList<PurchaseOrderRequestInformation>();
        BigDecimal toOrderSumQuantity = requestMatchInfomationVO.getToOrderQuantity();
        for (PurchaseRequestItemChild requestItemChild : requestItemChildList) {
            if (BigDecimal.ZERO.compareTo(toOrderSumQuantity) >= 0) break;
            BigDecimal toOrderQuantity = requestItemChild.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItemChild.getToOrderQuantity();
            BigDecimal remainToOrderQuantity = requestItemChild.getQuantity().subtract(toOrderQuantity);
            BigDecimal tempToOrderQuantity = toOrderSumQuantity.subtract(remainToOrderQuantity);
            PurchaseOrderRequestInformation requestInformation = new PurchaseOrderRequestInformation();
            if (BigDecimal.ZERO.compareTo(tempToOrderQuantity) > 0) {
                requestInformation.setToOrderQuantity(toOrderSumQuantity);
            } else if (BigDecimal.ZERO.compareTo(tempToOrderQuantity) <= 0) {
                requestInformation.setToOrderQuantity(remainToOrderQuantity);
            }
            toOrderSumQuantity = tempToOrderQuantity;
            requestInformation.setId(IdWorker.getIdStr());
            requestInformation.setElsAccount(requestItemChild.getElsAccount());
            requestInformation.setOrderHeadId(purchaseOrderItem.getHeadId());
            requestInformation.setOrderItemId(purchaseOrderItem.getId());
            requestInformation.setRequestHeadId(requestItemChild.getHeadId());
            requestInformation.setRequestItemId(requestItemChild.getId());
            requestInformation.setRelaseOrderQuantity(BigDecimal.ZERO);
            requestInformation.setRequestQuantity(requestItemChild.getQuantity());
            SysUtil.setSysParam((BaseEntity)requestInformation, (BaseDTO)purchaseOrderItem);
            orderRequestInformations.add(requestInformation);
        }
        this.purchaseOrderRequestInformationService.saveBatch(orderRequestInformations);
    }

    private PurchaseOrderHeadDTO doPackageOrderHead(String orderId, Map<String, PurchaseRequestItem> requestItemMapById, List<PurchaseRequestItem> requestItemVoList, List<RequestMatchInfomationVO> requestMatchInfomationVOSubList, List<PurchaseOrderItemDTO> purchaseOrderItemList, List<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList, BigDecimal totalNetAmount, BigDecimal totalTaxAmount) {
        String documentId = null;
        String documenParenttId = null;
        if (!CollectionUtils.isEmpty(requestMatchInfomationVOSubList)) {
            List requestItemSubIds = requestMatchInfomationVOSubList.stream().map(item -> item.getRequestItemId()).collect(Collectors.toList());
            ArrayList<PurchaseRequestItem> requestItemSubList = new ArrayList<PurchaseRequestItem>();
            for (String requestItemId : requestItemSubIds) {
                requestItemSubList.add(requestItemMapById.get(requestItemId));
            }
            List collect = requestItemVoList.stream().map(i -> i.getDocumentId()).collect(Collectors.toList());
            List collectHeadId = requestItemVoList.stream().map(i -> i.getHeadId()).collect(Collectors.toList());
            documentId = StringUtils.join(collect, (char)',');
            documenParenttId = StringUtils.join(collectHeadId, (char)',');
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseOrderHeadDTO purchaseOrderHead = new PurchaseOrderHeadDTO();
        purchaseOrderHead.setDocumentParentId(documenParenttId);
        purchaseOrderHead.setDocumentId(documentId);
        purchaseOrderHead.setId(orderId);
        purchaseOrderHead.setSupplierName(requestMatchInfomationVOSubList.get(0).getSupplierName());
        purchaseOrderHead.setToElsAccount(requestMatchInfomationVOSubList.get(0).getToElsAccount());
        purchaseOrderHead.setPurchaseGroup(requestMatchInfomationVOSubList.get(0).getPurchaseGroup());
        purchaseOrderHead.setPurchaseOrg(requestMatchInfomationVOSubList.get(0).getPurchaseOrg());
        purchaseOrderHead.setCompany(requestMatchInfomationVOSubList.get(0).getCompany());
        purchaseOrderHead.setCurrency(requestMatchInfomationVOSubList.get(0).getCurrency());
        purchaseOrderHead.setTemplateName(requestMatchInfomationVOSubList.get(0).getTemplateName());
        purchaseOrderHead.setTemplateNumber(requestMatchInfomationVOSubList.get(0).getTemplateNumber());
        purchaseOrderHead.setTemplateVersion(requestMatchInfomationVOSubList.get(0).getTemplateVersion() + "");
        purchaseOrderHead.setTemplateAccount(requestMatchInfomationVOSubList.get(0).getTemplateAccount());
        purchaseOrderHead.setOrderType(requestMatchInfomationVOSubList.get(0).getOrderType());
        if (PURCHASE_UNIT_TYPE.equals(requestMatchInfomationVOSubList.get(0).getFreePrice())) {
            purchaseOrderHead.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
        } else {
            purchaseOrderHead.setSourceType(OrderSourceTypeEnum.PURCHASE_REQUEST.getValue());
        }
        purchaseOrderHead.setBusAccount(TenantContext.getTenant());
        purchaseOrderHead.setPurchasePrincipal(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        purchaseOrderHead.setPurchaseOrderItemList(purchaseOrderItemList);
        purchaseOrderHead.setPurchaseOrderDeliveryPlanList(purchaseOrderDeliveryPlanList);
        purchaseOrderHead.setPaymentWay(requestMatchInfomationVOSubList.get(0).getPayWay());
        purchaseOrderHead.setPaymentClause(requestMatchInfomationVOSubList.get(0).getPaymentClause());
        purchaseOrderHead.setIsTeamwork(requestMatchInfomationVOSubList.get(0).getNeedCoordination());
        purchaseOrderHead.setTotalNetAmount(totalNetAmount);
        purchaseOrderHead.setTotalTaxAmount(totalTaxAmount);
        try {
            this.setDefualtValue(purchaseOrderHead);
        }
        catch (Exception e) {
            throw new ELSBootException("\u8bbe\u7f6e\u8ba2\u5355\u9ed8\u8ba4\u503c\u5931\u8d25!", (Throwable)e, new String[0]);
        }
        return purchaseOrderHead;
    }

    private void setDefualtValue(PurchaseOrderHeadDTO purchaseOrderHead) {
        Map defualtMap = this.invokeBaseRpcService.getHeadDefaultValuetMap(purchaseOrderHead.getTemplateAccount(), purchaseOrderHead.getTemplateNumber(), purchaseOrderHead.getTemplateVersion() + "");
        HashMap defaultMap1 = new HashMap();
        Set keys = defualtMap.keySet();
        if (CollectionUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)defualtMap.get(key)))) continue;
                defaultMap1.put(key, defualtMap.get(key));
            }
        }
        Class<?> clazz = purchaseOrderHead.getClass();
        Set fieldNames = defaultMap1.keySet();
        for (String name : fieldNames) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                String value = (String)field.get(purchaseOrderHead);
                if (!StringUtils.isEmpty((CharSequence)value)) continue;
                field.set(purchaseOrderHead, defaultMap1.get(name));
            }
            catch (Exception e) {}
        }
    }

    private PurchaseOrderDeliveryPlanDTO doPackageOrderDeliveryItem(PurchaseOrderItemDTO orderItem) {
        if (!MaterialDeliveryArrangeEnum.DELIVERY_PLAN.getValue().equals(orderItem.getJit())) {
            return null;
        }
        PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
        orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
        orderDeliveryPlan.setDocumentId(orderItem.getDocumentId());
        orderDeliveryPlan.setDocumentItemId(orderItem.getDocumentItemId());
        orderDeliveryPlan.setDocumentParentId(orderItem.getId());
        orderDeliveryPlan.setQuantity(orderItem.getQuantity());
        orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
        orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
        orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
        orderDeliveryPlan.setPurchaseUnit(orderItem.getPurchaseUnit());
        return orderDeliveryPlan;
    }

    private PurchaseOrderItemDTO doPackageOrderItem(String orderHeadId, RequestMatchInfomationVO requestMatchInfomationVO, Map<String, PurchaseRequestItem> requestItemMapById) {
        PurchaseOrderItemDTO purchaseOrderItem = new PurchaseOrderItemDTO();
        if (StringUtils.isNotBlank((CharSequence)requestMatchInfomationVO.getLadderPriceJson()) && REPERTORY_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
            this.parseLadderJsonPriceToPirceRecord(requestMatchInfomationVO, requestMatchInfomationVO.getToOrderQuantity());
        }
        purchaseOrderItem.setHeadId(orderHeadId);
        purchaseOrderItem.setMaterialNumber(requestMatchInfomationVO.getMaterialNumber());
        purchaseOrderItem.setMaterialId(requestMatchInfomationVO.getMaterialID());
        purchaseOrderItem.setMaterialDesc(requestMatchInfomationVO.getMaterialDesc());
        purchaseOrderItem.setMaterialGroup(requestMatchInfomationVO.getMaterialGroup());
        purchaseOrderItem.setMaterialSpec(requestMatchInfomationVO.getMaterialSpec());
        purchaseOrderItem.setCateCode(requestMatchInfomationVO.getCateCode());
        purchaseOrderItem.setCateName(requestMatchInfomationVO.getCateName());
        purchaseOrderItem.setQuantity(requestMatchInfomationVO.getToOrderQuantity());
        purchaseOrderItem.setPurchaseUnit(requestMatchInfomationVO.getPurchaseUnit());
        purchaseOrderItem.setPrice(requestMatchInfomationVO.getPrice());
        purchaseOrderItem.setNetPrice(requestMatchInfomationVO.getNetPrice());
        purchaseOrderItem.setTaxRate(requestMatchInfomationVO.getTaxRate());
        purchaseOrderItem.setTaxCode(requestMatchInfomationVO.getTaxCode());
        purchaseOrderItem.setRequestToOrderQuantity(requestMatchInfomationVO.getToOrderQuantity());
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal netAmount = BigDecimal.ZERO;
        taxAmount = requestMatchInfomationVO.getPrice().multiply(requestMatchInfomationVO.getToOrderQuantity());
        netAmount = requestMatchInfomationVO.getNetPrice().multiply(requestMatchInfomationVO.getToOrderQuantity());
        if (REPERTORY_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
            if (BigDecimal.ZERO.compareTo(taxAmount) != 0) {
                taxAmount = taxAmount.divide(new BigDecimal(requestMatchInfomationVO.getPriceUnit())).setScale(6, 4);
            }
            if (BigDecimal.ZERO.compareTo(netAmount) != 0) {
                netAmount = netAmount.divide(new BigDecimal(requestMatchInfomationVO.getPriceUnit())).setScale(6, 4);
            }
        }
        purchaseOrderItem.setTaxAmount(taxAmount);
        purchaseOrderItem.setNetAmount(netAmount);
        purchaseOrderItem.setRequireDate(requestMatchInfomationVO.getRequireDate());
        purchaseOrderItem.setDeliveryAddress(requestMatchInfomationVO.getRequestItemChildList().get(0).getReceivedAddress());
        purchaseOrderItem.setReceiveContact(requestMatchInfomationVO.getRequestItemChildList().get(0).getReceivedUser());
        purchaseOrderItem.setReceivePhone(requestMatchInfomationVO.getRequestItemChildList().get(0).getReceivedPhone());
        purchaseOrderItem.setMaterialName(requestMatchInfomationVO.getMaterialName());
        purchaseOrderItem.setCurrency(requestMatchInfomationVO.getCurrency());
        purchaseOrderItem.setReceiveQuantity(BigDecimal.ZERO);
        purchaseOrderItem.setOnWayQuantity(BigDecimal.ZERO);
        purchaseOrderItem.setDeliveryQuantity(BigDecimal.ZERO);
        purchaseOrderItem.setClose(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
        purchaseOrderItem.setFreeze(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
        purchaseOrderItem.setItemStatus(OrderItemStatusEnum.UN_CONFIRM.getValue());
        purchaseOrderItem.setSendStatus(OrderItemSendStatusEnum.NO_PUBLISH.getValue());
        if (StringUtils.isBlank((CharSequence)requestMatchInfomationVO.getJit())) {
            purchaseOrderItem.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
        } else {
            purchaseOrderItem.setJit(requestMatchInfomationVO.getJit());
        }
        purchaseOrderItem.setDeleteOrder(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
        purchaseOrderItem.setFactory(requestMatchInfomationVO.getFactory());
        purchaseOrderItem.setReturned(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
        if (StringUtils.isNotEmpty((CharSequence)requestMatchInfomationVO.getEstimate())) {
            purchaseOrderItem.setEstimate(Integer.valueOf(Integer.parseInt(requestMatchInfomationVO.getEstimate())));
        } else {
            purchaseOrderItem.setEstimate(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
        }
        purchaseOrderItem.setCheckQuality(requestMatchInfomationVO.getCheckQuality());
        purchaseOrderItem.setStorageLocation(requestMatchInfomationVO.getStorageLocation());
        if (PURCHASE_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
            purchaseOrderItem.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
        } else {
            purchaseOrderItem.setSourceType(OrderSourceTypeEnum.PURCHASE_REQUEST.getValue());
        }
        if (!CollectionUtils.isEmpty(requestMatchInfomationVO.getRequestItemChildList())) {
            List<PurchaseRequestItemChild> requestItemChildList = requestMatchInfomationVO.getRequestItemChildList();
            List collect = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getRequestNumber())).map(PurchaseRequestItem::getRequestNumber).distinct().collect(Collectors.toList());
            purchaseOrderItem.setSourceNumber(CollectionUtils.isEmpty(collect) ? requestMatchInfomationVO.getRequestNumber() : StringUtils.join(collect, (String)","));
            List collectHeadId = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getHeadId())).map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
            purchaseOrderItem.setSourceId(CollectionUtils.isEmpty(collectHeadId) ? requestMatchInfomationVO.getRequestHeadId() : StringUtils.join(collectHeadId, (String)","));
            List collectSourceItemNumber = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getItemNumber())).map(PurchaseRequestItem::getItemNumber).distinct().collect(Collectors.toList());
            purchaseOrderItem.setSourceItemNumber(CollectionUtils.isEmpty(collectSourceItemNumber) ? requestMatchInfomationVO.getRequestItemNumber() : StringUtils.join(collectSourceItemNumber, (String)","));
            List collectSourceItemId = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getId())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
            purchaseOrderItem.setSourceItemId(CollectionUtils.isEmpty(collectSourceItemId) ? requestMatchInfomationVO.getRequestItemId() : StringUtils.join(collectSourceItemId, (String)","));
            List collectDocId = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getDocumentId())).map(PurchaseRequestItem::getDocumentId).distinct().collect(Collectors.toList());
            purchaseOrderItem.setDocumentId(CollectionUtils.isEmpty(collectDocId) ? requestMatchInfomationVO.getDocumentId() : StringUtils.join(collectDocId, (String)","));
            List collectDocItemId = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getDocumentItemId())).map(PurchaseRequestItem::getDocumentItemId).distinct().collect(Collectors.toList());
            purchaseOrderItem.setDocumentItemId(CollectionUtils.isEmpty(collectDocItemId) ? requestMatchInfomationVO.getDocumentItemId() : StringUtils.join(collectDocItemId, (String)","));
            List collectId = requestItemChildList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getId())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
            purchaseOrderItem.setDocumentParentId(CollectionUtils.isEmpty(collectId) ? requestMatchInfomationVO.getId() : StringUtils.join(collectId, (String)","));
        } else {
            purchaseOrderItem.setSourceNumber(requestMatchInfomationVO.getRequestNumber());
            purchaseOrderItem.setSourceItemNumber(requestMatchInfomationVO.getRequestItemNumber());
            if (requestItemMapById.containsKey(requestMatchInfomationVO.getRequestItemId())) {
                PurchaseRequestItem purchaseRequestItem = requestItemMapById.get(requestMatchInfomationVO.getRequestItemId());
                purchaseOrderItem.setSourceId(purchaseRequestItem.getHeadId());
                purchaseOrderItem.setSourceNumber(purchaseRequestItem.getItemNumber());
                purchaseOrderItem.setSourceItemId(purchaseRequestItem.getId());
                purchaseOrderItem.setDocumentId(purchaseRequestItem.getDocumentId());
                purchaseOrderItem.setDocumentItemId(purchaseRequestItem.getDocumentItemId());
                purchaseOrderItem.setDocumentParentId(purchaseRequestItem.getId());
            }
        }
        purchaseOrderItem.setId(IdWorker.getIdStr());
        purchaseOrderItem.setPurchaseType(requestMatchInfomationVO.getItemRequestType());
        purchaseOrderItem.setOrderProgressTemplateNumber(requestMatchInfomationVO.getOrderProgressTemplateNumber());
        purchaseOrderItem.setOrderProgressTemplateName(requestMatchInfomationVO.getOrderProgressTemplateName());
        purchaseOrderItem.setOrderProgressTemplateId(requestMatchInfomationVO.getOrderProgressTemplateId());
        purchaseOrderItem.setSuggestQuotaQuantity(requestMatchInfomationVO.getSuggestAllocQuantity());
        purchaseOrderItem.setQuotaProcotolId(requestMatchInfomationVO.getQuotaProcotolId());
        purchaseOrderItem.setQuantityReturn(requestMatchInfomationVO.getQuantityReturn());
        return purchaseOrderItem;
    }

    private Map<String, List<RequestMatchInfomationVO>> getRequestMatchInformationMap(List<RequestMatchInfomationVO> requestMatchInfomationVOList) {
        HashMap<String, List<RequestMatchInfomationVO>> requestMatchInfumationMapByCondition = new HashMap<String, List<RequestMatchInfomationVO>>();
        for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationVOList) {
            List<RequestMatchInfomationVO> requestMatchInfomationVOS;
            String key = requestMatchInfomationVO.getToElsAccount() + "&&" + requestMatchInfomationVO.getPurchaseOrg() + "&&" + requestMatchInfomationVO.getPurchaseGroup() + "&&" + requestMatchInfomationVO.getCompany() + "&&" + requestMatchInfomationVO.getFreePrice() + "&&" + requestMatchInfomationVO.getOrderType() + "&&" + requestMatchInfomationVO.getTemplateNumber() + requestMatchInfomationVO.getTemplateAccount() + "&&" + requestMatchInfomationVO.getCurrency();
            if (requestMatchInfumationMapByCondition.containsKey(key)) {
                requestMatchInfomationVOS = (List)requestMatchInfumationMapByCondition.get(key);
                requestMatchInfomationVOS.add(requestMatchInfomationVO);
                requestMatchInfumationMapByCondition.put(key, requestMatchInfomationVOS);
                continue;
            }
            requestMatchInfomationVOS = new ArrayList();
            requestMatchInfomationVOS.add(requestMatchInfomationVO);
            requestMatchInfumationMapByCondition.put(key, requestMatchInfomationVOS);
        }
        return requestMatchInfumationMapByCondition;
    }

    private void parseLadderJsonPriceToPirceRecord(RequestMatchInfomationVO requestMatchInfomationVO, BigDecimal quantity) {
        JSONArray ladderPriceArray = JSONArray.parseArray((String)requestMatchInfomationVO.getLadderPriceJson());
        BigDecimal price = requestMatchInfomationVO.getPrice();
        BigDecimal netPrice = requestMatchInfomationVO.getNetPrice();
        BigDecimal baseQuantity = BigDecimal.ZERO;
        for (Object obj : ladderPriceArray) {
            JSONObject ladderPriceJson = (JSONObject)obj;
            BigDecimal ladderPrice = ladderPriceJson.getBigDecimal("price");
            BigDecimal ladderNetPrice = ladderPriceJson.getBigDecimal("netPrice");
            BigDecimal ladderQuantity = ladderPriceJson.getBigDecimal("ladderQuantity");
            Assert.notNull((Object)ladderQuantity, (String)I18nUtil.translate((String)"i18n_alert_yDWRxOV_8ad66f92", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u7a7a"));
            ladderPriceJson.put("price", (Object)ladderPrice.setScale(6, 4));
            ladderPriceJson.put("netPrice", (Object)ladderNetPrice.setScale(6, 4));
            if (quantity.compareTo(ladderQuantity) < 0 || ladderQuantity.compareTo(baseQuantity) < 0) continue;
            price = ladderPrice;
            netPrice = ladderNetPrice;
            baseQuantity = ladderQuantity;
        }
        requestMatchInfomationVO.setPrice(price);
        requestMatchInfomationVO.setNetPrice(netPrice);
    }

    @Override
    public void getPurchaseRequestByERP() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseRequestData", (Object)new JSONObject());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copy(PurchaseRequestHeadVO purchaseRequestHeadVO) {
        this.builderHead(purchaseRequestHeadVO);
        List<PurchaseRequestItem> purchaseRequestItemList = purchaseRequestHeadVO.getPurchaseRequestItemList();
        purchaseRequestItemList.forEach(item -> item.setId(null));
        purchaseRequestItemList.forEach(item -> item.setRequestNumber(null));
        purchaseRequestItemList.forEach(item -> item.setCreateBy(null));
        purchaseRequestItemList.forEach(item -> item.setCreateById(null));
        purchaseRequestItemList.forEach(item -> item.setCreateTime(null));
        purchaseRequestItemList.forEach(item -> item.setUpdateBy(null));
        purchaseRequestItemList.forEach(item -> item.setUpdateById(null));
        purchaseRequestItemList.forEach(item -> item.setUpdateTime(null));
        purchaseRequestItemList.forEach(item -> item.setTacticsEntity(null));
        purchaseRequestItemList.forEach(item -> item.setTacticsObject(null));
        purchaseRequestItemList.forEach(item -> item.setItemStatus(PURCHASE_UNIT_TYPE));
        purchaseRequestItemList.forEach(item -> item.setToOrderQuantity(BigDecimal.ZERO));
        purchaseRequestItemList.forEach(item -> item.setToEbiddingQuantity(BigDecimal.ZERO));
        purchaseRequestItemList.forEach(item -> item.setToEnquiryQuantity(BigDecimal.ZERO));
        purchaseRequestItemList.forEach(item -> item.setToBiddingQuantity(BigDecimal.ZERO));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = purchaseRequestHeadVO.getPurchaseAttachmentList();
        purchaseAttachmentList.forEach(item -> item.setId(null));
        this.saveMain(purchaseRequestHeadVO, purchaseRequestItemList, purchaseAttachmentList);
    }

    public void builderHead(PurchaseRequestHeadVO purchaseBiddingHead) {
        purchaseBiddingHead.setId(null);
        purchaseBiddingHead.setRequestNumber(null);
        purchaseBiddingHead.setCreateBy(null);
        purchaseBiddingHead.setCreateById(null);
        purchaseBiddingHead.setCreateTime(null);
        purchaseBiddingHead.setUpdateBy(null);
        purchaseBiddingHead.setUpdateById(null);
        purchaseBiddingHead.setPaymentStatus(PURCHASE_UNIT_TYPE);
        purchaseBiddingHead.setUpdateTime(null);
        purchaseBiddingHead.setFlowId(null);
    }

    @Override
    public void pushPurchaseRequestData(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseRequestHeadList = this.listByIds(idList).stream().filter(head -> !REPERTORY_UNIT_TYPE.equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseRequestHead head2 : purchaseRequestHeadList) {
            this.pushPurchaseRequest(head2);
        }
    }

    @Override
    public List<String> generatePoolOrder(List<PurchaseRequestItem> purchaseRequestItemList) {
        List collect = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).collect(Collectors.toList());
        List purchaseRequestHeads = this.listByIds(collect);
        if (CollectionUtil.isNotEmpty((Collection)purchaseRequestHeads)) {
            ArrayList<PoolOrderHeadDTO> poolOrderHeadDTOS1 = new ArrayList<PoolOrderHeadDTO>();
            ArrayList<String> strings = new ArrayList<String>();
            for (PurchaseRequestHead purchaseRequestHead : purchaseRequestHeads) {
                String interfaceMessage;
                List<PoolOrderHeadDTO> poolOrderHeadDTOS;
                if (!StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getInterfaceMessage()) || REPERTORY_UNIT_TYPE.equals(purchaseRequestHead.getInterfaceStatus()) || !CollectionUtil.isNotEmpty(poolOrderHeadDTOS = this.purchaseProductInventoryLocalRpcService.generatePoolOrder(JSONObject.parseObject((String)(interfaceMessage = purchaseRequestHead.getInterfaceMessage()))))) continue;
                poolOrderHeadDTOS1.addAll(poolOrderHeadDTOS);
                strings.add(purchaseRequestHead.getId());
            }
            if (CollectionUtil.isNotEmpty(poolOrderHeadDTOS1)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseRequestHead::getInterfaceStatus, (Object)REPERTORY_UNIT_TYPE)).in(BaseEntity::getId, strings)).update((Object)new PurchaseRequestHead());
                return poolOrderHeadDTOS1.stream().map(PoolOrderHeadDTO::getOrderNumber).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchaseRequestHeadVO purchaseRequestHeadVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchaseRequestHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    @Override
    public JSONArray getRequestDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseRequestHead::getRequestNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        ArrayList headVOArrayList = new ArrayList();
        List purchaseRequestHeads = ((PurchaseRequestHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)purchaseRequestHeads)) {
            purchaseRequestHeads.forEach(item -> headVOArrayList.add(this.getMessageById(item.getId())));
        }
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    @Override
    @Transactional
    public void refreshRequestItemToWaitOrder(List<PriceRecordsDTO> dtoList) {
        List<String> materialNumber = dtoList.stream().map(PriceRecordsDTO::getMaterialNumber).distinct().filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumber)) {
            return;
        }
        List<PurchaseRequestItem> mList = this.purchaseRequestItemService.selectWithoutElsAccountToList(materialNumber, Lists.newArrayList((Object[])new String[]{PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue(), PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue()}));
        if (CollectionUtils.isEmpty(mList)) {
            return;
        }
        String tenant = TenantContext.getTenant();
        Map<String, List<PurchaseRequestItem>> itemMap = mList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
        for (String elsAccount : itemMap.keySet()) {
            TenantContext.setTenant((String)elsAccount);
            this.matchPrice(itemMap.get(elsAccount));
            TenantContext.clear();
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)tenant)) {
            TenantContext.setTenant((String)tenant);
        }
    }

    private PurchaseRequestHeadVO getMessageById(String id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemMapper.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        return purchaseRequestHeadVO;
    }

    private void pushPurchaseRequest(PurchaseRequestHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseRequestData", (Object)head);
    }

    public void deleteDetailByOpenApi(List<String> headIds, String halfDelete) {
        ((PurchaseRequestHeadMapper)this.baseMapper).deleteBatchIds(headIds);
        for (String id : headIds) {
            this.purchaseRequestItemService.deleteByMainId(id);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(headIds);
    }

    protected List<PurchaseRequestHeadVO> queryDetailByOpenApi(List<PurchaseRequestHead> headList) {
        List headIds = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapperItem = Wrappers.lambdaQuery();
        wrapperItem.in(PurchaseRequestItem::getHeadId, headIds);
        List itemList = this.purchaseRequestItemService.list((Wrapper)wrapperItem);
        Map<String, List<PurchaseRequestItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseRequestItem::getHeadId));
        ArrayList<PurchaseRequestHeadVO> result = new ArrayList<PurchaseRequestHeadVO>();
        for (PurchaseRequestHead head : headList) {
            PurchaseRequestHeadVO vo = new PurchaseRequestHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)vo));
            vo.setPurchaseRequestItemList(itemMap.get(vo.getId()));
            result.add(vo);
        }
        return result;
    }
}

