/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemHisMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingItemHisServiceImpl
extends ServiceImpl<PurchaseEbiddingItemHisMapper, PurchaseEbiddingItemHis>
implements PurchaseEbiddingItemHisService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingItemHisServiceImpl.class);
    @Resource
    private SaleEbiddingItemHisMapper saleEbiddingItemHisMapper;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;

    @Override
    public List<PurchaseEbiddingItemHis> queryBidLobbyDetail(PurchaseEbiddingHead dbHead, String itemNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHis::getItemNumber, (Object)itemNumber);
        wrapper.eq(PurchaseEbiddingItemHis::getHeadId, (Object)dbHead.getId());
        wrapper.orderByDesc(PurchaseEbiddingItemHis::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<PurchaseEbiddingItemHis> queryAcceptDetail(PurchaseEbiddingHead dbHead) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHis::getAccept, (Object)"1");
        wrapper.eq(PurchaseEbiddingItemHis::getHeadId, (Object)dbHead.getId());
        wrapper.orderByDesc(PurchaseEbiddingItemHis::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void queryAddQuoteSite(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem) {
        BigDecimal quotePrice;
        String tenant = TenantContext.getTenant();
        if (!tenant.equals(dbHead.getElsAccount())) {
            TenantContext.setTenant((String)dbHead.getElsAccount());
        }
        List dbHisList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHis::getQuoteTime));
        TenantContext.setTenant((String)tenant);
        if (CollectionUtil.isNotEmpty((Collection)dbHisList)) {
            String relationId = dbItem.getRelationId();
            String id = dbItem.getId();
            BeanUtils.copyProperties(dbHisList.get(0), (Object)((Object)dbItem));
            dbItem.setId(id);
            dbItem.setRelationId(relationId);
        }
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal netTotalAmount = dbItem.getNetTotalAmount();
                quotePrice = netTotalAmount == null ? dbHead.getStartTotalAmount() : this.getQuotePrice(netTotalAmount, dbHead);
                dbItem.setNetTotalAmount(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
                dbItem.setTotalAmount(EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getNetTotalAmount()));
            } else {
                BigDecimal totalAmount = dbItem.getTotalAmount();
                quotePrice = totalAmount == null ? dbHead.getStartTotalAmount() : this.getQuotePrice(totalAmount, dbHead);
                dbItem.setTotalAmount(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
                dbItem.setNetTotalAmount(EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getTotalAmount()));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal netPrice = dbItem.getNetPrice();
            quotePrice = netPrice == null || netPrice.compareTo(BigDecimal.ZERO) == 0 ? dbItem.getStartPrice() : this.getQuotePrice(netPrice, dbHead);
            dbItem.setNetPrice(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
            dbItem.setPrice(EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getNetPrice()));
        } else {
            BigDecimal price = dbItem.getPrice();
            log.info("queryAddQuoteSite->price:{}", (Object)price);
            quotePrice = price == null || price.compareTo(BigDecimal.ZERO) == 0 ? dbItem.getStartPrice() : this.getQuotePrice(price, dbHead);
            log.info("queryAddQuoteSite->quotePrice:{}", (Object)quotePrice);
            dbItem.setPrice(quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) < 0 ? null : quotePrice);
            dbItem.setNetPrice(EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(dbItem.getTaxRate(), dbItem.getPrice()));
            log.info("queryAddQuoteSite->dbItem:{}", (Object)JSONObject.toJSONString((Object)((Object)dbItem)));
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            dbItem.setBidNumber(dbItem.getRemainingQuantity());
        }
    }

    private BigDecimal getQuotePrice(BigDecimal lastPrice, PurchaseEbiddingHead dbHead) {
        BigDecimal changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? lastPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 6, 4)) : dbHead.getChangeRange();
        return EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? lastPrice.add(changeRange) : lastPrice.subtract(changeRange);
    }

    @Override
    public List<PurchaseEbiddingItemHis> queryQuoteSite(PurchaseEbiddingHead dbHead, String itemNumber, String toElsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseEbiddingItemHis::getHeadId, (Object)dbHead.getId());
        wrapper.eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), PurchaseEbiddingItemHis::getItemNumber, (Object)itemNumber);
        wrapper.eq(PurchaseEbiddingItemHis::getToElsAccount, (Object)toElsAccount);
        wrapper.orderByAsc(PurchaseEbiddingItemHis::getQuoteTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void save(PurchaseEbiddingItem quoteItem, SaleEbiddingHead saleHead) {
        LoginUser sysUser = SysUtil.getLoginUser();
        Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
        executor.execute(() -> {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)quoteItem.getId())).set(PurchaseEbiddingItemHis::getLastQuote, (Object)"0"));
            SaleEbiddingItemHis updateSale = new SaleEbiddingItemHis();
            updateSale.setLastQuote("0");
            this.saleEbiddingItemHisMapper.update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHis::getItemId, (Object)quoteItem.getRelationId()));
            PurchaseEbiddingItemHis purchase = new PurchaseEbiddingItemHis();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchase));
            purchase.setId(IdWorker.getIdStr());
            purchase.setRelationId(IdWorker.getIdStr());
            purchase.setHeadId(quoteItem.getHeadId());
            purchase.setItemId(quoteItem.getId());
            purchase.setLastQuote("1");
            purchase.setQuoteType(saleHead.getQuoteType());
            purchase.setEbiddingWay(saleHead.getEbiddingWay());
            purchase.setQuoteSubAccount(sysUser == null ? "System" : sysUser.getSubAccount());
            purchase.setQuoteUser(sysUser == null ? "System" : sysUser.getRealname());
            if (EbiddingWayEnum.PACKAGE.getValue().equals(saleHead.getEbiddingWay())) {
                List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(quoteItem.getHeadId());
                String materialNumber = itemList.stream().map(PurchaseEbiddingItem::getMaterialNumber).distinct().collect(Collectors.joining(","));
                purchase.setMaterialNumber(materialNumber);
                purchase.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
            }
            purchase.setBidNumber(quoteItem.getBidNumber());
            ((PurchaseEbiddingItemHisMapper)this.baseMapper).insert((Object)purchase);
            SaleEbiddingItemHis sale = new SaleEbiddingItemHis();
            BeanUtils.copyProperties((Object)((Object)purchase), (Object)((Object)sale));
            sale.setId(purchase.getRelationId());
            sale.setRelationId(purchase.getId());
            sale.setHeadId(saleHead.getId());
            sale.setItemId(quoteItem.getRelationId());
            sale.setElsAccount(purchase.getToElsAccount());
            sale.setToElsAccount(purchase.getElsAccount());
            sale.setBidNumber(quoteItem.getBidNumber());
            this.saleEbiddingItemHisMapper.insert((Object)sale);
        });
    }

    @Override
    public void updateBidByHeadId(List<PurchaseEbiddingItemHis> purchaseItemList) {
        ((PurchaseEbiddingItemHisMapper)this.baseMapper).updateBidByHeadId(purchaseItemList);
    }

    @Override
    public List<PurchaseEbiddingItemHis> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemHisMapper)this.baseMapper).selectByMainId(mainId);
    }
}

