/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.priceEvaluationManagement.entity.PurchaseProcessingProcedurePrice;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseProcessingProduceStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchaseProcessingProcedurePriceService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseProcessProduceExcelHandler")
public class PurchaseProcessProduceExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseProcessProduceExcelHandler.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseProcessingProcedurePriceService purchaseProcessingProcedurePriceService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("purchaseProcessingProcedurePrice");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_uRRTumBjCLjESIrPKxOuNcIuRRTum_29290c96", (String)"\u52a0\u5de5\u5de5\u5e8f\u4ef7\u683c\u6ca1\u6709\u9ed8\u8ba4\u7684\u4e1a\u52a1\u6a21\u677f,\u6682\u65f6\u4e0d\u80fd\u5bfc\u5165\u521b\u5efa\u52a0\u5de5\u5de5\u5e8f\u4ef7\u683c!"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        ArrayList<PurchaseProcessingProcedurePrice> processingProcedurePriceList = new ArrayList<PurchaseProcessingProcedurePrice>();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("purchaseProcessingProcedurePriceNumber", null, totalCount);
        for (Map data : dataList) {
            PurchaseProcessingProcedurePrice processingProcedurePrice = (PurchaseProcessingProcedurePrice)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseProcessingProcedurePrice.class));
            processingProcedurePriceList.add(processingProcedurePrice);
        }
        int i = 0;
        for (PurchaseProcessingProcedurePrice processingProcedurePrice : processingProcedurePriceList) {
            processingProcedurePrice.setTemplateAccount(templateHeadDTO.getElsAccount());
            processingProcedurePrice.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
            processingProcedurePrice.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            processingProcedurePrice.setTemplateName(templateHeadDTO.getTemplateName());
            processingProcedurePrice.setDocumentNumber((String)nextCodes.get(i));
            processingProcedurePrice.setDocumentStatus(PurchaseProcessingProduceStatusEnum.NEW.getValue());
            processingProcedurePrice.setBusAccount(loginUser.getElsAccount());
            BigDecimal taxRate = BigDecimal.ONE.add(new BigDecimal(processingProcedurePrice.getTaxRate()).divide(new BigDecimal("100")));
            BigDecimal netPrice = processingProcedurePrice.getPrice().divide(taxRate, 6, 4);
            processingProcedurePrice.setNetPrice(netPrice);
            ++i;
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        this.purchaseProcessingProcedurePriceService.saveBatch(processingProcedurePriceList, 200);
        return dataList;
    }
}

