/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.socket.handler;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.els.modules.socket.service.SocketIOService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SocketIOHandler {
    private static final Logger log = LoggerFactory.getLogger(SocketIOHandler.class);
    @Autowired
    private SocketIOServer socketIoServer;

    @PostConstruct
    private void autoStartup() throws Exception {
        try {
            this.socketIoServer.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("SocketIOServer\u542f\u52a8\u5931\u8d25");
        }
    }

    @PreDestroy
    private void autoStop() throws Exception {
        this.socketIoServer.stop();
    }

    @OnConnect
    public void onConnect(SocketIOClient client) {
        String businessType = client.getHandshakeData().getSingleUrlParam("businessType");
        String businessId = client.getHandshakeData().getSingleUrlParam("businessId");
        SocketIOService.clientMap.put(businessType + "_" + businessId, client);
        log.info("\u5ba2\u6237\u7aef:" + client.getRemoteAddress() + "  sessionId:" + client.getSessionId() + " businessType: " + businessType + " businessId: " + businessId + "\u5df2\u8fde\u63a5");
    }

    @OnDisconnect
    public void onDisconnect(SocketIOClient client) {
        log.info("\u5ba2\u6237\u7aef:" + client.getSessionId() + "\u65ad\u5f00\u8fde\u63a5");
    }
}

