/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplierCapacity.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.supplierCapacity.entity.SaleSupplierCapacityHead;
import com.els.modules.supplierCapacity.entity.SaleSupplierCapacityItem;
import com.els.modules.supplierCapacity.mapper.SaleSupplierCapacityHeadMapper;
import com.els.modules.supplierCapacity.mapper.SaleSupplierCapacityItemMapper;
import com.els.modules.supplierCapacity.service.SaleSupplierCapacityHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleSupplierCapacityHeadServiceImpl
extends BaseServiceImpl<SaleSupplierCapacityHeadMapper, SaleSupplierCapacityHead>
implements SaleSupplierCapacityHeadService {
    @Autowired
    private SaleSupplierCapacityHeadMapper saleSupplierCapacityHeadMapper;
    @Autowired
    private SaleSupplierCapacityItemMapper saleSupplierCapacityItemMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleSupplierCapacityHead saleSupplierCapacityHead, List<SaleSupplierCapacityItem> saleSupplierCapacityItemList) {
        this.saleSupplierCapacityHeadMapper.insert((Object)saleSupplierCapacityHead);
        super.setHeadDefaultValue((BaseEntity)saleSupplierCapacityHead);
        this.insertData(saleSupplierCapacityHead, saleSupplierCapacityItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleSupplierCapacityHead saleSupplierCapacityHead, List<SaleSupplierCapacityItem> saleSupplierCapacityItemList) {
        this.saleSupplierCapacityHeadMapper.updateById((Object)saleSupplierCapacityHead);
        this.saleSupplierCapacityItemMapper.deleteByMainId(saleSupplierCapacityHead.getId());
        this.insertData(saleSupplierCapacityHead, saleSupplierCapacityItemList);
    }

    private void insertData(SaleSupplierCapacityHead saleSupplierCapacityHead, List<SaleSupplierCapacityItem> saleSupplierCapacityItemList) {
        if (!CollectionUtils.isEmpty(saleSupplierCapacityItemList)) {
            for (SaleSupplierCapacityItem entity : saleSupplierCapacityItemList) {
                entity.setHeadId(saleSupplierCapacityHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleSupplierCapacityHead);
            }
            if (!saleSupplierCapacityItemList.isEmpty()) {
                this.saleSupplierCapacityItemMapper.insertBatchSomeColumn(saleSupplierCapacityItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleSupplierCapacityItemMapper.deleteByMainId(id);
        this.saleSupplierCapacityHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleSupplierCapacityItemMapper.deleteByMainId(serializable.toString());
            this.saleSupplierCapacityHeadMapper.deleteById(serializable);
        }
    }
}

