/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateItem;
import com.els.modules.bidding.enumerate.BiddingEvaluationTemplateStatusEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateItemMapper;
import com.els.modules.bidding.service.BiddingEvaluationTemplateHeadService;
import com.els.modules.bidding.service.BiddingEvaluationTemplateItemService;
import com.els.modules.bidding.vo.BiddingEvaluationTemplateHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BiddingEvaluationTemplateHeadServiceImpl
extends ServiceImpl<BiddingEvaluationTemplateHeadMapper, BiddingEvaluationTemplateHead>
implements BiddingEvaluationTemplateHeadService {
    @Autowired
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Autowired
    private BiddingEvaluationTemplateItemMapper biddingEvaluationTemplateItemMapper;
    @Autowired
    private BiddingEvaluationTemplateItemService biddingEvaluationTemplateItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(BiddingEvaluationTemplateHead biddingEvaluationTemplateHead, List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList) {
        biddingEvaluationTemplateHead.setEvaluationNumber(this.invokeBaseRpcService.getNextCode("biddingEvaluationTemplate", (Object)biddingEvaluationTemplateHead));
        if ("0".equals(biddingEvaluationTemplateHead.getNeedAudit())) {
            biddingEvaluationTemplateHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            biddingEvaluationTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        biddingEvaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.INVALID.getValue());
        this.biddingEvaluationTemplateHeadMapper.insert((Object)biddingEvaluationTemplateHead);
        this.insertData(biddingEvaluationTemplateHead, biddingEvaluationTemplateItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(BiddingEvaluationTemplateHead biddingEvaluationTemplateHead, List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList) {
        if ("0".equals(biddingEvaluationTemplateHead.getNeedAudit())) {
            biddingEvaluationTemplateHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            biddingEvaluationTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        biddingEvaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.INVALID.getValue());
        int count = this.biddingEvaluationTemplateHeadMapper.updateById((Object)biddingEvaluationTemplateHead);
        this.biddingEvaluationTemplateItemMapper.deleteByMainId(biddingEvaluationTemplateHead.getId());
        this.insertData(biddingEvaluationTemplateHead, biddingEvaluationTemplateItemList);
    }

    private void insertData(BiddingEvaluationTemplateHead biddingEvaluationTemplateHead, List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList) {
        if (biddingEvaluationTemplateItemList != null) {
            int i = 1;
            for (BiddingEvaluationTemplateItem entity : biddingEvaluationTemplateItemList) {
                entity.setHeadId(biddingEvaluationTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)biddingEvaluationTemplateHead);
                entity.setItemNumber(String.valueOf(i));
                ++i;
            }
            if (!biddingEvaluationTemplateItemList.isEmpty()) {
                this.biddingEvaluationTemplateItemService.saveBatch(biddingEvaluationTemplateItemList, 2000);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.biddingEvaluationTemplateItemMapper.deleteByMainId(id);
        this.biddingEvaluationTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.biddingEvaluationTemplateItemMapper.deleteByMainId(serializable.toString());
            this.biddingEvaluationTemplateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void publish(BiddingEvaluationTemplateHead biddingEvaluationTemplateHead, List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList) {
        this.updateMain(biddingEvaluationTemplateHead, biddingEvaluationTemplateItemList);
        biddingEvaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.TAKE_EFFECT.getValue());
        this.updateById((Object)biddingEvaluationTemplateHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(BiddingEvaluationTemplateHeadVO evaluationTemplateHeadVO) {
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)SysUtil.copyProperties((Object)((Object)evaluationTemplateHeadVO), BiddingEvaluationTemplateHead.class));
        this.builderHead(evaluationTemplateHead);
        List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItems = evaluationTemplateHeadVO.getBiddingEvaluationTemplateItemList();
        if (CollectionUtil.isNotEmpty(biddingEvaluationTemplateItems)) {
            biddingEvaluationTemplateItems.parallelStream().forEach(item -> item.setId(null));
        }
        this.saveMain(evaluationTemplateHead, biddingEvaluationTemplateItems);
    }

    private void builderHead(BiddingEvaluationTemplateHead evaluationTemplateHead) {
        evaluationTemplateHead.setId(null);
        evaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.INVALID.getValue());
        evaluationTemplateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        evaluationTemplateHead.setNeedAudit("0");
        evaluationTemplateHead.setCreateBy(null);
        evaluationTemplateHead.setCreateTime(null);
        evaluationTemplateHead.setUpdateBy(null);
        evaluationTemplateHead.setUpdateTime(null);
    }
}

