/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.PurchaseBiddingTalkPriceContinue;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingEvaResultMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingTalkPriceContinueService;
import com.els.modules.bidding.service.SaleBiddingItemService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.SupplierInvesttreeInfoVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.bidding.vo.TalkPriceSupplierVo;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.specialist.entity.SpecialistHistoryBiddingInfo;
import com.els.modules.specialist.service.SpecialistHistoryBiddingInfoService;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierCompanyHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierHumanHoldingDTO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BiddingSupplierServiceImpl
extends ServiceImpl<BiddingSupplierMapper, BiddingSupplier>
implements BiddingSupplierService {
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Resource
    private SaleBiddingItemService saleBiddingItemService;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private SpecialistHistoryBiddingInfoService specialistHistoryBiddingInfoService;
    @Resource
    private PurchaseBiddingEvaResultMapper purchaseBiddingEvaResultMapper;
    @Resource
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Resource
    private PurchaseBiddingEvaResultService purchaseBiddingEvaResultService;

    @Override
    public List<BiddingSupplier> selectByMainId(String mainId) {
        return this.biddingSupplierMapper.selectByMainId(mainId);
    }

    @Override
    public void checkPermission(String id) {
        this.check(id);
    }

    private void check(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    private void checkParam(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        this.check(head.getId());
        String quoteWay = head.getQuotaWay();
        HashMap<String, BigDecimal> checkQuotaMap = new HashMap<String, BigDecimal>();
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if ("1".equals(quoteWay)) {
                    if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                        if (item.getPrice() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                        }
                        if (item.getQuota() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_no_input_split_proportion_bidding", (String)"\u8bf7\u8f93\u5165\u5bf9\u5e94\u4e2d\u6807\u9879\u7684\u62c6\u5206\u6bd4\u7387%\uff01"));
                        }
                        if (checkQuotaMap.containsKey(item.getItemNumber())) {
                            checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                            continue;
                        }
                        checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                        continue;
                    }
                    if (!"1".equals(head.getBidEvaluationWay()) || item.getQuota() == null || item.getQuota().compareTo(BigDecimal.ZERO) == 0) continue;
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
                }
                if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    if (item.getPrice() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                    }
                    item.setQuota(BigDecimal.valueOf(100L));
                    if (checkQuotaMap.containsKey(item.getItemNumber())) {
                        checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                        continue;
                    }
                    checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                    continue;
                }
                if (!"1".equals(head.getBidEvaluationWay()) || item.getQuota() == null || item.getQuota().compareTo(BigDecimal.ZERO) == 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
            }
        }
        for (String itemNumber : checkQuotaMap.keySet()) {
            BigDecimal quota = (BigDecimal)checkQuotaMap.get(itemNumber);
            if (quota == null || quota.compareTo(BigDecimal.valueOf(100L)) == 0) continue;
            if ("1".equals(quoteWay)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_split_proportion_no_eq_100_bidding", (String)"\u4e2d\u6807\u6bd4\u7387\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100%"));
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xvzlBndIeImSLRiTiFIusBtL_dc497e10", (String)"\u4e0d\u62c6\u5206\u6388\u6807\u7684\u9879\u76ee\u540c\u4e00\u4e2a\u7269\u6599\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u5bb6\u4e2d\u6807\u5355\u4f4d\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(head.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        this.optConfirmBid(head, list);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveConfirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        this.optConfirmBid(head, list);
    }

    private void optConfirmBid(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        if (!(BiddingStatusEnum.EVA_BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.CONFIRM_ING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.TALK_PRICE.getValue().equals(head.getBiddingStatus()))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_determine_bid_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5b9a\u6807\uff01"));
        }
        this.checkParam(head, list);
        ArrayList<PurchaseBiddingItem> batchUpdate = new ArrayList<PurchaseBiddingItem>();
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if (!BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    item.setItemStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
                }
                if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    BigDecimal taxAmount;
                    if ("1".equals(head.getQuotaWay())) {
                        BigDecimal multiply = item.getRequireQuantity().multiply(item.getQuota().divide(BigDecimal.valueOf(100L), 6, 5));
                        item.setQuotaQuantity(multiply);
                    } else {
                        item.setQuotaQuantity(item.getRequireQuantity());
                    }
                    BigDecimal divide = taxAmount = item.getQuotaQuantity().multiply(item.getPrice());
                    if (StringUtils.isNotBlank((CharSequence)item.getTaxRate())) {
                        divide = taxAmount.divide(BigDecimal.ONE.add(new BigDecimal(item.getTaxRate()).divide(BigDecimal.valueOf(100L), 2, 5)), 6, 5);
                    }
                    item.setQuotaTaxAmount(taxAmount);
                    item.setQuotaNetAmount(divide);
                }
                this.log.error("\u66f4\u65b0\u4e2d\u6807\u4fe1\u606f\u62c6\u5206\u91d1\u989d,\u62db\u6807\u5355\u53f7:" + head.getBiddingNumber() + "\u884c\u53f7:" + item.getItemNumber() + ",\u62c6\u5206\u6570\u91cf:" + item.getQuotaQuantity() + ",\u542b\u7a0e\u91d1\u989d" + item.getQuotaTaxAmount() + ",\u4e0d\u542b\u7a0e\u91d1\u989d" + item.getQuotaNetAmount());
            }
            batchUpdate.addAll(purchaseBiddingItemList);
        }
        if (!batchUpdate.isEmpty()) {
            this.purchaseBiddingItemService.updateBatchById(batchUpdate, 2000);
        }
        LoginUser user = SysUtil.getLoginUser();
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        purchaseBiddingHead.setId(head.getId());
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        purchaseBiddingHead.setConfirmBidIp(IPUtils.getIpAddr());
        purchaseBiddingHead.setConfirmBidBy(user.getSubAccount());
        int count = this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saleBiddingHeadMapper.updateByMainId(head.getId(), BiddingStatusEnum.CONFIRM_ED.getValue());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(SpecialistHistoryBiddingInfo::getBiddingNumber, (Object)head.getBiddingNumber());
        updateWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount());
        updateWrapper.lambda().set(SpecialistHistoryBiddingInfo::getBiddingStatus, (Object)BiddingStatusEnum.CONFIRM_ED.getValue());
        this.specialistHistoryBiddingInfoService.update((Object)new SpecialistHistoryBiddingInfo(), (Wrapper)updateWrapper);
        String resultAudit = head.getResultAudit();
        if (!"1".equals(resultAudit)) {
            this.publish(head.getId());
        }
    }

    @Override
    public List<BiddingSupplierVO> findConfirmBidList(String headId, boolean isCheck) {
        if (isCheck) {
            this.check(headId);
        }
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        List<PurchaseBiddingItem> purchaseBiddingItems = this.purchaseBiddingItemMapper.selectByMainId(headId);
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        purchaseBiddingItemList = this.handleBiddingItem(purchaseBiddingItemList);
        Map<String, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().filter(purchaseBiddingItem -> StringUtils.isNotBlank((CharSequence)purchaseBiddingItem.getToElsAccount())).collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        List biddingEvaResultList = this.purchaseBiddingEvaResultMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId));
        Map<Object, Object> hashMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)biddingEvaResultList)) {
            hashMap = biddingEvaResultList.stream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getToElsAccount));
        }
        Map<Object, Object> hashMapItem = new HashMap();
        if (!CollectionUtils.isEmpty(purchaseBiddingItems)) {
            hashMapItem = purchaseBiddingItems.stream().filter(purchaseBiddingItem -> StringUtils.isNotBlank((CharSequence)purchaseBiddingItem.getToElsAccount())).collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        }
        BigDecimal busWeight = new BigDecimal(100);
        BigDecimal tecWeight = new BigDecimal(100);
        if (!StringUtils.isEmpty((CharSequence)purchaseBiddingHead.getBidEvaluationNumber())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getEvaluationNumber, (Object)purchaseBiddingHead.getBidEvaluationNumber());
            lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getTemplateStatus, (Object)"1")).last(" limit 1");
            BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectOne((Wrapper)lambdaQueryWrapper));
            if (biddingEvaluationTemplateHead != null) {
                busWeight = biddingEvaluationTemplateHead.getBusWeight();
                tecWeight = biddingEvaluationTemplateHead.getTecWeight();
            }
        }
        ArrayList<BiddingSupplierVO> resultList = new ArrayList<BiddingSupplierVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplierVO supplierVO = new BiddingSupplierVO();
            if (StringUtils.isNotBlank((CharSequence)supplier.getBidEva()) && "1".equals(supplier.getBidEva())) continue;
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO), (String[])new String[0]);
            supplierVO.setPurchaseBiddingItemList(itemMap.get(supplier.getToElsAccount()));
            if (hashMap.containsKey(supplierVO.getToElsAccount())) {
                List purchaseBiddingEvaResults = (List)hashMap.get(supplierVO.getToElsAccount());
                supplierVO.setPurchaseBiddingEvaResultList(purchaseBiddingEvaResults);
                List biddingItemList = (List)hashMapItem.get(supplierVO.getToElsAccount());
                BigDecimal totalSource = this.getTotalSource(purchaseBiddingHead, biddingItemList, purchaseBiddingEvaResults, busWeight, tecWeight);
                supplierVO.setTotalScoreNew(totalSource);
                if ("0".equals(purchaseBiddingHead.getBidEvaluationWay())) {
                    BigDecimal scoreBus = this.getOnlyAddScore("1", purchaseBiddingEvaResults);
                    BigDecimal scoreTec = this.getOnlyAddScore("2", purchaseBiddingEvaResults);
                    supplierVO.setTotalScore(scoreBus.add(scoreTec).add(supplier.getPriceScore() == null ? BigDecimal.ZERO : supplier.getPriceScore()).toString());
                } else {
                    supplierVO.setTotalScore(totalSource.add(supplier.getPriceScore() == null ? BigDecimal.ZERO : supplier.getPriceScore()).toString());
                }
            }
            resultList.add(supplierVO);
        }
        return this.rankByTotalScore(resultList, purchaseBiddingHead.getConfirmBidWay());
    }

    private List<PurchaseBiddingItem> handleBiddingItem(List<PurchaseBiddingItem> purchaseBiddingItemList) {
        ArrayList<PurchaseBiddingItem> offerItem = new ArrayList<PurchaseBiddingItem>();
        if (CollectionUtil.isNotEmpty(purchaseBiddingItemList)) {
            Map<String, List<PurchaseBiddingItem>> itemMaps = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
            for (String key : itemMaps.keySet()) {
                List<PurchaseBiddingItem> initList = itemMaps.get(key);
                List finalItem = initList.stream().filter(x -> "1".equals(x.getFinalPrice())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(finalItem)) {
                    offerItem.addAll(finalItem);
                    continue;
                }
                offerItem.addAll(initList);
            }
            purchaseBiddingItemList = offerItem;
        }
        return purchaseBiddingItemList;
    }

    private BigDecimal getTotalSource(PurchaseBiddingHead head, List<PurchaseBiddingItem> itemList, List<PurchaseBiddingEvaResult> evaList, BigDecimal busWeight, BigDecimal tecWeight) {
        BigDecimal totalSource = BigDecimal.ZERO;
        if ("1".equals(head.getConfirmBidWay())) {
            return this.getTotalAmount(itemList);
        }
        if ("2".equals(head.getConfirmBidWay())) {
            BigDecimal scoreBus = this.getScore("1", evaList, busWeight);
            BigDecimal scoreTec = this.getScore("2", evaList, tecWeight);
            totalSource = scoreBus.add(scoreTec);
        }
        return totalSource;
    }

    private BigDecimal getTotalAmount(List<PurchaseBiddingItem> itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (itemList == null) {
            return totalAmount;
        }
        for (PurchaseBiddingItem item : itemList) {
            if (item.getPrice() == null) continue;
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal amount = price.multiply(quantity);
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }

    private BigDecimal getOnlyAddScore(String type, List<PurchaseBiddingEvaResult> resultMap) {
        BigDecimal totalScore = BigDecimal.ZERO;
        if (resultMap == null) {
            return totalScore;
        }
        resultMap = resultMap.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        int count = 0;
        for (PurchaseBiddingEvaResult result2 : resultMap) {
            totalScore = totalScore.add(result2.getScore());
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        return totalScore.setScale(2, 4);
    }

    private BigDecimal getScore(String type, List<PurchaseBiddingEvaResult> resultMap, BigDecimal weight) {
        BigDecimal totalScore = BigDecimal.ZERO;
        if (resultMap == null) {
            return totalScore;
        }
        resultMap = resultMap.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        int count = 0;
        for (PurchaseBiddingEvaResult result2 : resultMap) {
            totalScore = totalScore.add(result2.getScore());
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        if (weight == null) {
            return totalScore.divide(new BigDecimal(count), 2, 4);
        }
        Map<String, List<PurchaseBiddingEvaResult>> listMap = resultMap.parallelStream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getSubAccount));
        return totalScore.divide(new BigDecimal(listMap.size()), 2, 4);
    }

    private List<BiddingSupplierVO> rankByTotalScore(List<BiddingSupplierVO> resultList, String confirmBidWay) {
        List<BiddingSupplierVO> list = null;
        resultList.parallelStream().forEach(biddingSupplierVO -> {
            biddingSupplierVO.setTotalScore(StringUtils.isBlank((CharSequence)biddingSupplierVO.getTotalScore()) ? "0" : biddingSupplierVO.getTotalScore());
            biddingSupplierVO.setTotalScoreNew(biddingSupplierVO.getTotalScoreNew() == null ? BigDecimal.ZERO : biddingSupplierVO.getTotalScoreNew());
        });
        list = "1".equals(confirmBidWay) ? resultList.stream().sorted(Comparator.comparing(BiddingSupplierVO::getTotalScoreNew)).collect(Collectors.toList()) : resultList.stream().sorted(Comparator.comparing(BiddingSupplier::getTotalScore, Comparator.comparingDouble(Double::parseDouble)).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingSupplierVO resultVO : list) {
            resultVO.setSynthesisRank(rank + "");
            ++rank;
        }
        return list;
    }

    @Override
    public void delete(Wrapper<BiddingSupplier> queryWrapper) {
        this.biddingSupplierMapper.delete(queryWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String headId) {
        BigDecimal budgetAmount;
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId);
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        purchaseBiddingItemList = this.handleBiddingItem(purchaseBiddingItemList);
        SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
        saleBiddingHead.setRelationId(headId);
        saleBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        this.saleBiddingHeadMapper.update((Object)saleBiddingHead, (Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)headId));
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<Object> batchUpdateSaleBiddingItemList = new ArrayList<Object>();
        ArrayList<PurchaseRequestItem> batchUpdatePurchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (PurchaseBiddingItem item : purchaseBiddingItemList) {
            String[] split;
            SaleBiddingItem saleItem = new SaleBiddingItem();
            saleItem.setId(item.getRelationId());
            saleItem.setItemStatus(item.getItemStatus());
            saleItem.setQuota(item.getQuota());
            batchUpdateSaleBiddingItemList.add((Object)saleItem);
            if (!BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) continue;
            supplierMap.put(item.getToElsAccount(), "true");
            BigDecimal price = item.getPrice();
            BigDecimal quota = item.getQuota();
            BigDecimal quantity = item.getRequireQuantity() == null ? BigDecimal.valueOf(1L) : item.getRequireQuantity();
            BigDecimal amount = price.multiply(quota.divide(BigDecimal.valueOf(100L)).multiply(quantity));
            totalAmount = totalAmount.add(amount);
            if (!StringUtils.isNotBlank((CharSequence)item.getSourceItemId())) continue;
            for (String id : split = item.getSourceItemId().split(",")) {
                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                requestItem.setMaterialNumber(item.getMaterialNumber());
                requestItem.setMaterialId(item.getMaterialId());
                requestItem.setMaterialName(item.getMaterialName());
                requestItem.setMaterialDesc(item.getMaterialDesc());
                requestItem.setMaterialSpec(item.getMaterialSpec());
                requestItem.setBrand(item.getBrand());
                requestItem.setMaterialGroup(item.getMaterialGroup());
                requestItem.setCateCode(item.getCateCode());
                requestItem.setCateName(item.getCateName());
                requestItem.setId(id);
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
                batchUpdatePurchaseRequestItemList.add(requestItem);
            }
        }
        Date dateTime = new Date();
        if (CollectionUtil.isNotEmpty(purchaseBiddingItemList)) {
            purchaseBiddingItemList.forEach(biddingItem -> biddingItem.setConfirmBidTime(dateTime));
            this.purchaseBiddingItemService.updateBatchById(purchaseBiddingItemList, 1000);
        }
        if (!batchUpdateSaleBiddingItemList.isEmpty()) {
            this.saleBiddingItemService.updateBatchById(batchUpdateSaleBiddingItemList, 2000);
        }
        if (!batchUpdatePurchaseRequestItemList.isEmpty()) {
            this.purchaseRequestItemService.updateBatchById(batchUpdatePurchaseRequestItemList, 2000);
        }
        ArrayList<BiddingSupplier> batchUpdateBiddingSupplierList = new ArrayList<BiddingSupplier>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplier updateSupplier = new BiddingSupplier();
            updateSupplier.setId(supplier.getId());
            updateSupplier.setConfirmBidTime(dateTime);
            if (supplierMap.containsKey(supplier.getToElsAccount())) {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_WIN.getValue());
            } else {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
            }
            batchUpdateBiddingSupplierList.add(updateSupplier);
        }
        if (!batchUpdateBiddingSupplierList.isEmpty()) {
            this.updateBatchById(batchUpdateBiddingSupplierList, 2000);
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        String priceCreateWay = head.getPriceCreateWay();
        if (PriceCreateWayEnum.AUTO.getValue().equals(priceCreateWay)) {
            this.createPriceInfo(head, purchaseBiddingItemList);
        }
        if ((budgetAmount = head.getBudgetAmount()) != null && budgetAmount.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal economyAmount = budgetAmount.subtract(totalAmount);
            BigDecimal economyRate = economyAmount.divide(budgetAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
            PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
            updateHead.setEconomyAmount(economyAmount);
            updateHead.setEconomyRate(economyRate);
            updateHead.setId(head.getId());
            int count = this.purchaseBiddingHeadMapper.updateById((Object)updateHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
        }
    }

    private void createPriceInfo(PurchaseBiddingHead head, List<PurchaseBiddingItem> purchaseBiddingItemList) {
        List<PurchaseBiddingItem> acceptList = purchaseBiddingItemList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getItemStatus())).collect(Collectors.toList());
        acceptList.forEach(item -> {
            if (!PriceCreateWayEnum.NOT.getValue().equals(head.getPriceCreateWay())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_bLumdWFlTjSLAoWVnRBFLxVSLAoW_570cdbcd", (String)"\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e\u5fc5\u987b\u6709\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u91c7\u8d2d\u8d1f\u8d23\u4eba\u8865\u5145\u7269\u6599\u7f16\u7801\u3002"));
            }
        });
        ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
        for (PurchaseBiddingItem item2 : acceptList) {
            PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)records);
            records.setSourceType(PriceSourceTypeEnum.BIDDING.getValue());
            records.setSourceNumber(head.getBiddingNumber());
            records.setPurchaseUnit(item2.getPurchaseUnit());
            records.setSourceItemNumber(item2.getItemNumber());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
            records.setCompany(head.getCompany());
            records.setPurchaseOrg(head.getPurchaseOrg());
            records.setPurchaseGroup(head.getPurchaseGroup());
            records.setCurrencyCode(item2.getCurrency());
            try {
                this.inquiryInvokeMainDataRpcService.checkPriceIfExistByBidding(records);
            }
            catch (ELSBootException exception) {
                this.log.error("\u4ef7\u683c\u4e3b\u6570\u636e\u5df2\u5b58\u5728\u66f4\u6539\u4e3a\u4f5c\u5e9f\u72b6\u6001\uff0c\u62db\u6807\u5355\u53f7\u4e3a\uff1a" + head.getBiddingNumber() + " \u884c\u53f7\u4e3a\uff1a" + item2.getItemNumber());
                this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.BIDDING.getValue(), head.getBiddingNumber(), Arrays.asList(item2.getItemNumber()));
            }
            recordsList.add(records);
        }
        this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
        this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
    }

    @Override
    public void manualCreatePrce(String headId) {
        this.check(headId);
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(head.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        if (!BiddingStatusEnum.CONFIRM_ED.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_add_price_record", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        String resultAudit = head.getResultAudit();
        if ("1".equals(resultAudit) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_add_price_record_by_approved", (String)"\u5b9a\u4ef7\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        this.createPriceInfo(head, purchaseBiddingItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void replenishMaterialNumber(PurchaseBiddingItem webItem) {
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemMapper.selectByMainId(webItem.getHeadId());
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)webItem.getHeadId())));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(biddingHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        this.checkMaterialNumber(webItem, itemList);
        List<String> itemIds = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleBiddingItem> saleBiddingItemList = this.saleBiddingItemMapper.selectByBiddingNumber(itemList.get(0).getBiddingNumber());
        List<String> saleItemIds = saleBiddingItemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).map(BaseEntity::getId).collect(Collectors.toList());
        this.purchaseBiddingItemMapper.updateMaterialBatchById(webItem, itemIds);
        this.saleBiddingItemMapper.updateMaterialBatchById(webItem, saleItemIds);
    }

    private void checkMaterialNumber(PurchaseBiddingItem webItem, List<PurchaseBiddingItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseBiddingItem::getMaterialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public List<SupplierRelationFindResultVO> queryRiskRelationFind(Map<String, BiddingSupplier> biddingSupplierMap) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        Set<String> elsAccountList = biddingSupplierMap.keySet();
        List<EnterpriseRiskDTO> riskDTOS = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(elsAccountList);
        if (riskDTOS.isEmpty()) {
            return relationFindResultList;
        }
        Map riskDTOMap = riskDTOS.parallelStream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
        HashMap<String, Map<String, String>> supplierInvesttreeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
        for (String elsAccount : riskDTOMap.keySet()) {
            EnterpriseRiskDTO enterpriseRiskDTO = (EnterpriseRiskDTO)riskDTOMap.get(elsAccount);
            HashMap supplierMap = new HashMap();
            enterpriseRiskDTO.getSupplierInvesttreeList().parallelStream().forEach(supplierInvesttreeDTO -> {
                supplierMap.put(supplierInvesttreeDTO.getCreditCode(), supplierInvesttreeDTO.getSupplierName());
                this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeDTO.getChildren());
            });
            supplierInvesttreeMap.put(elsAccount, supplierMap);
            Map<String, String> humanHoldingMap = enterpriseRiskDTO.getSupplierHumanHoldingList().parallelStream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
            supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
            Map<String, String> companyHoldingMap = enterpriseRiskDTO.getSupplierCompanyHoldingList().parallelStream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
            supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
        }
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierInvesttreeMap, RiskTypeEnum.INVESTTREE.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        return relationFindResultList;
    }

    @Override
    public Map<String, Integer> getSupplierPortraitCount(String toElsAccount) {
        List biddingSupplierList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_els_account", (Object)toElsAccount)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        List biddingWinList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("participationCount", biddingSupplierList.size());
        resultMap.put("biddingWinCount", biddingWinList.size());
        return resultMap;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRisk(Map<String, BiddingSupplier> biddingSupplierMap, Map<String, Map<String, String>> supplierInvesttreeMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedSupplierElsAccount = new ArrayList<String>();
        for (String elsAccount : supplierInvesttreeMap.keySet()) {
            Map<String, String> supplierMap = supplierInvesttreeMap.get(elsAccount);
            hadCheckedSupplierElsAccount.add(elsAccount);
            for (String nextElsAccount : supplierInvesttreeMap.keySet()) {
                if (hadCheckedSupplierElsAccount.contains(nextElsAccount)) continue;
                Map<String, String> nextSupplierMap = supplierInvesttreeMap.get(nextElsAccount);
                Set<String> compareKeySet = nextSupplierMap.keySet();
                for (String compareKey : compareKeySet) {
                    if (!supplierMap.containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(biddingSupplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(biddingSupplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setResult(nextSupplierMap.get(compareKey));
                    findResultVO.setType(type);
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    private void getAllSupplierCreditCode(Map<String, String> supplierMap, String children) {
        if (StringUtils.isBlank((CharSequence)children) || "[]".equals(children)) {
            return;
        }
        List supplierInvesttreeInfos = JSON.parseArray((String)children, SupplierInvesttreeInfoVO.class);
        supplierInvesttreeInfos.parallelStream().forEach(supplierInvesttreeInfo -> {
            if (StringUtils.isNotBlank((CharSequence)supplierInvesttreeInfo.getCreditCode())) {
                supplierMap.put(supplierInvesttreeInfo.getCreditCode(), supplierInvesttreeInfo.getName());
            }
            this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeInfo.getChildren());
        });
    }

    @Override
    public void exportConfirmBidXls(String quotaWay, PurchaseBiddingHead biddingHead, List<BiddingSupplierVO> supplierList, List<BiddingEvaResultVO> resultList, HttpServletResponse response) {
        ExcelWriter writer = new ExcelWriter(true, "\u5b9a\u6807\u8bf7\u793a");
        List<List<String>> rows = null;
        rows = "project".equals(biddingHead.getCreateType()) ? this.biddingProjectExportExcel(quotaWay, biddingHead, supplierList, resultList, writer) : this.biddingExportExcel(quotaWay, biddingHead, supplierList, resultList, writer);
        writer.write(rows, true);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=333");
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            this.log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<List<String>> biddingExportExcel(String quotaWay, PurchaseBiddingHead biddingHead, List<BiddingSupplierVO> supplierList, List<BiddingEvaResultVO> resultList, ExcelWriter writer) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> commonElement = new ArrayList<String>();
        List<String> titleElement = Arrays.asList(I18nUtil.translate((String)"i18n_title_seq", (String)"\u5e8f\u53f7"), I18nUtil.translate((String)"i18n_title_supplierELSAccount", (String)"\u4f9b\u5e94\u5546ELS\u8d26\u53f7"), I18nUtil.translate((String)"i18n_massProdHead88b_supplierErpCode", (String)"\u4f9b\u5e94\u5546ERP\u7f16\u7801"), I18nUtil.translate((String)"i18n_massProdHeade95_supplierName", (String)"\u4f9b\u5e94\u5546\u540d\u79f0"));
        commonElement.addAll(titleElement);
        ArrayList<String> head = new ArrayList<String>(commonElement);
        ArrayList<String> headCopy = new ArrayList<String>(commonElement);
        rows.add(head);
        rows.add(headCopy);
        for (int i = 0; i < supplierList.size(); ++i) {
            if (0 == i) {
                for (int j = 0; j < commonElement.size(); ++j) {
                    writer.merge(0, 1, j, j, (Object)"", false);
                }
            }
            ArrayList<String> paramRow = new ArrayList<String>();
            paramRow.add(i + 1 + "");
            paramRow.add(supplierList.get(i).getToElsAccount());
            paramRow.add(supplierList.get(i).getSupplierCode());
            paramRow.add(supplierList.get(i).getSupplierName());
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierList.get(i).getPurchaseBiddingItemList();
            for (int j = 0; j < purchaseBiddingItemList.size(); ++j) {
                if (0 == i) {
                    headCopy.add(I18nUtil.translate((String)"i18n_title_offer", (String)"\u62a5\u4ef7"));
                    headCopy.add(I18nUtil.translate((String)"i18n_title_contractAward", (String)"\u6388\u6807"));
                    head.add(purchaseBiddingItemList.get(j).getMaterialDesc());
                    head.add("");
                    if ("1".equals(quotaWay)) {
                        head.add("");
                        headCopy.add(I18nUtil.translate((String)"i18n_title_splitRatio", (String)"\u62c6\u5206\u6bd4\u4f8b(%)"));
                    }
                    int filedCount = "1".equals(quotaWay) ? 3 : 2;
                    int index = j * filedCount + commonElement.size();
                    writer.merge(0, 0, index, index + filedCount - 1, (Object)"", false);
                }
                paramRow.add(purchaseBiddingItemList.get(j).getPrice().stripTrailingZeros().toPlainString());
                paramRow.add("3".equals(purchaseBiddingItemList.get(j).getItemStatus()) ? I18nUtil.translate((String)"i18n_title_wonTheBid", (String)"\u5df2\u4e2d\u6807") : I18nUtil.translate((String)"i18n_title_notWonTheBid", (String)"\u672a\u4e2d\u6807"));
                if (!"1".equals(quotaWay)) continue;
                String quota = "";
                quota = null == purchaseBiddingItemList.get(j).getQuota() ? "" : purchaseBiddingItemList.get(j).getQuota().setScale(2, 4).stripTrailingZeros().toPlainString();
                paramRow.add(quota);
            }
            rows.add(paramRow);
        }
        return rows;
    }

    private List<List<String>> biddingProjectExportExcel(String quotaWay, PurchaseBiddingHead biddingHead, List<BiddingSupplierVO> supplierList, List<BiddingEvaResultVO> resultList, ExcelWriter writer) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> commonElement = new ArrayList<String>();
        List<String> titleElement = Arrays.asList(I18nUtil.translate((String)"i18n_title_seq", (String)"\u5e8f\u53f7"), I18nUtil.translate((String)"i18n_title_supplierELSAccount", (String)"\u4f9b\u5e94\u5546ELS\u8d26\u53f7"), I18nUtil.translate((String)"i18n_massProdHead88b_supplierErpCode", (String)"\u4f9b\u5e94\u5546ERP\u7f16\u7801"), I18nUtil.translate((String)"i18n_massProdHeade95_supplierName", (String)"\u4f9b\u5e94\u5546\u540d\u79f0"), I18nUtil.translate((String)"i18n_field_KQLULYIL_88b87b1f", (String)"\u662f\u5426\u4e3a\u8bc4\u59d4\u63a8\u8350\u4eba"), I18nUtil.translate((String)"i18n_title_busScore", (String)"\u5546\u52a1\u5206"), I18nUtil.translate((String)"i18n_title_tecScore", (String)"\u6280\u672f\u5206"), I18nUtil.translate((String)"i18n_alert_umz_1355e81", (String)"\u4ef7\u683c\u5206"), I18nUtil.translate((String)"i18n_field_Mksz_32ad7d23", (String)"\u6c47\u603b\u5f97\u5206"));
        commonElement.addAll(titleElement);
        commonElement.add(I18nUtil.translate((String)"i18n_field_ksu_1757e6d", (String)"\u603b\u62a5\u4ef7"));
        commonElement.add(I18nUtil.translate((String)"i18n_title_synthesisRank", (String)"\u7efc\u5408\u6392\u540d"));
        ArrayList<String> head = new ArrayList<String>(commonElement);
        ArrayList<String> headCopy = new ArrayList<String>(commonElement);
        rows.add(head);
        rows.add(headCopy);
        for (int i = 0; i < supplierList.size(); ++i) {
            if (0 == i) {
                for (int j = 0; j < commonElement.size(); ++j) {
                    writer.merge(0, 1, j, j, (Object)"", false);
                }
            }
            ArrayList<String> paramRow = new ArrayList<String>();
            paramRow.add(i + 1 + "");
            paramRow.add(supplierList.get(i).getToElsAccount());
            paramRow.add(supplierList.get(i).getSupplierCode());
            paramRow.add(supplierList.get(i).getSupplierName());
            paramRow.add("1".equals(supplierList.get(i).getRecommend()) ? I18nUtil.translate((String)"i18n_title_yes", (String)"\u662f") : I18nUtil.translate((String)"i18n_title_no", (String)"\u5426"));
            String totalScore = supplierList.get(i).getTotalScore();
            for (BiddingEvaResultVO evaResultVO : resultList) {
                if (!supplierList.get(i).getToElsAccount().equals(evaResultVO.getToElsAccount())) continue;
                paramRow.add(evaResultVO.getBusScore() == null ? "" : evaResultVO.getBusScore().setScale(2, 4).stripTrailingZeros().toPlainString());
                paramRow.add(evaResultVO.getTecScore() == null ? "" : evaResultVO.getTecScore().setScale(2, 4).stripTrailingZeros().toPlainString());
                paramRow.add(evaResultVO.getPriceScore() == null ? "" : evaResultVO.getPriceScore().setScale(2, 4).stripTrailingZeros().toPlainString());
                paramRow.add(StringUtils.isBlank((CharSequence)totalScore) ? "" : new BigDecimal(totalScore).setScale(2, 4).stripTrailingZeros().toPlainString());
                paramRow.add(evaResultVO.getTotalAmount().setScale(2, 4).stripTrailingZeros().toPlainString());
                break;
            }
            paramRow.add(supplierList.get(i).getSynthesisRank());
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierList.get(i).getPurchaseBiddingItemList();
            for (int j = 0; j < purchaseBiddingItemList.size(); ++j) {
                if (0 == i) {
                    headCopy.add(I18nUtil.translate((String)"i18n_title_offer", (String)"\u62a5\u4ef7"));
                    headCopy.add(I18nUtil.translate((String)"i18n_title_contractAward", (String)"\u6388\u6807"));
                    head.add(purchaseBiddingItemList.get(j).getMaterialDesc());
                    head.add("");
                    if ("1".equals(quotaWay)) {
                        head.add("");
                        headCopy.add(I18nUtil.translate((String)"i18n_title_splitRatio", (String)"\u62c6\u5206\u6bd4\u4f8b(%)"));
                    }
                    int filedCount = "1".equals(quotaWay) ? 3 : 2;
                    int index = j * filedCount + commonElement.size();
                    writer.merge(0, 0, index, index + filedCount - 1, (Object)"", false);
                }
                paramRow.add(purchaseBiddingItemList.get(j).getPrice().stripTrailingZeros().toPlainString());
                paramRow.add("3".equals(purchaseBiddingItemList.get(j).getItemStatus()) ? I18nUtil.translate((String)"i18n_title_wonTheBid", (String)"\u5df2\u4e2d\u6807") : I18nUtil.translate((String)"i18n_title_notWonTheBid", (String)"\u672a\u4e2d\u6807"));
                if (!"1".equals(quotaWay)) continue;
                String quota = "";
                quota = null == purchaseBiddingItemList.get(j).getQuota() ? "" : purchaseBiddingItemList.get(j).getQuota().setScale(2, 4).stripTrailingZeros().toPlainString();
                paramRow.add(quota);
            }
            rows.add(paramRow);
        }
        return rows;
    }

    @Override
    public List<TalkPriceSupplierVo> queryTalkPriceRecord(String headId) {
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        List purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId).stream().collect(Collectors.toMap(item -> item.getToElsAccount() + "_" + item.getItemNumber() + "_" + item.getTalkPriceStage(), Function.identity(), (o1, o2) -> o2, LinkedHashMap::new)).values().stream().collect(Collectors.toList());
        Map<Integer, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(x -> x.getTalkPriceStage() == null ? 1 : x.getTalkPriceStage()));
        List talkPriceStage = purchaseBiddingItemList.stream().map(x -> x.getTalkPriceStage() == null ? 1 : x.getTalkPriceStage()).distinct().sorted().collect(Collectors.toList());
        PurchaseBiddingTalkPriceContinueService talkPriceContinueService = (PurchaseBiddingTalkPriceContinueService)SpringContextUtils.getBean(PurchaseBiddingTalkPriceContinueService.class);
        List<PurchaseBiddingTalkPriceContinue> talkPriceRecord = talkPriceContinueService.selectByMainId(headId);
        Map<Object, Object> talkPriceInfo = new HashMap();
        ArrayList<TalkPriceSupplierVo> talkPriceSupplierVoList = new ArrayList<TalkPriceSupplierVo>();
        if (CollectionUtil.isEmpty(talkPriceRecord)) {
            return talkPriceSupplierVoList;
        }
        talkPriceInfo = talkPriceRecord.stream().collect(Collectors.toMap(PurchaseBiddingTalkPriceContinue::getTalkPriceStage, Function.identity()));
        talkPriceStage = talkPriceRecord.stream().map(x -> Integer.valueOf(x.getTalkPriceStage() == null ? "1" : x.getTalkPriceStage())).distinct().sorted().collect(Collectors.toList());
        for (Integer stage : talkPriceStage) {
            List<PurchaseBiddingItem> currentBiddingItemList;
            TalkPriceSupplierVo talkPriceSupplierVo = new TalkPriceSupplierVo();
            ArrayList<BiddingSupplierVO> biddingSupplierVOList = new ArrayList<BiddingSupplierVO>();
            for (BiddingSupplier supplier : biddingSupplierList) {
                List<PurchaseBiddingItem> currentBiddingItemList2 = itemMap.get(stage);
                if (CollectionUtil.isEmpty(currentBiddingItemList2) || !CollectionUtil.isNotEmpty(currentBiddingItemList2 = currentBiddingItemList2.stream().filter(x -> x.getToElsAccount().equals(supplier.getToElsAccount())).collect(Collectors.toList()))) continue;
                BiddingSupplierVO supplierVO = new BiddingSupplierVO();
                BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO), (String[])new String[0]);
                Map<String, List<PurchaseBiddingItem>> supplierBiddingItemMap = currentBiddingItemList2.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
                List<PurchaseBiddingItem> item2 = supplierBiddingItemMap.get(supplier.getToElsAccount());
                supplierVO.setPurchaseBiddingItemList(item2);
                if (CollectionUtil.isNotEmpty(item2)) {
                    BigDecimal totalAmount = this.purchaseBiddingEvaResultService.getTotalAmount(item2);
                    supplierVO.setTotalAmount(totalAmount);
                    BigDecimal noTaxTotalAmount = this.purchaseBiddingEvaResultService.getNoTaxTotalAmount(item2);
                    supplierVO.setNoTaxTotalAmount(noTaxTotalAmount);
                }
                biddingSupplierVOList.add(supplierVO);
            }
            PurchaseBiddingTalkPriceContinue priceContinue = (PurchaseBiddingTalkPriceContinue)((Object)Optional.of(talkPriceInfo.get(stage.toString())).orElse((Object)new PurchaseBiddingTalkPriceContinue()));
            talkPriceSupplierVo.setTalkPriceStage(stage);
            talkPriceSupplierVo.setBiddingSupplierVOList(biddingSupplierVOList);
            talkPriceSupplierVo.setEndTime(priceContinue.getEndTime());
            talkPriceSupplierVo.setOpenFlg(priceContinue.getOpenFlg());
            if (!"1".equals(priceContinue.getOpenFlg()) && CollectionUtil.isNotEmpty(currentBiddingItemList = itemMap.get(stage))) {
                Map<String, List<PurchaseBiddingItem>> supplierBiddingItemMap = currentBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
                if (priceContinue.getEndTime() != null && new Date().after(priceContinue.getEndTime()) || StringUtils.isNotBlank((CharSequence)priceContinue.getQuotaNumber()) && Integer.valueOf(priceContinue.getQuotaNumber()).intValue() == supplierBiddingItemMap.size()) {
                    talkPriceSupplierVo.setEndOfQuotation("1");
                }
            }
            talkPriceSupplierVoList.add(talkPriceSupplierVo);
        }
        return talkPriceSupplierVoList;
    }
}

