/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.SubAccountOrgDTO;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseDemandPoolExportServiceImpl")
public class PurchaseDemandPoolExportServiceImpl
extends BaseExportService<PurchaseRequestItem, PurchaseRequestItem, PurchaseRequestItem>
implements ExportDataLoaderService {
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<PurchaseRequestItem> queryExportData(QueryWrapper<PurchaseRequestItem> queryWrapper, PurchaseRequestItem param, Map<String, String[]> paramMap) {
        queryWrapper.notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue(), "12"));
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            LoginUser loginUser = SysUtil.getLoginUser();
            Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
            List subAccountOrgList = this.invokeAccountRpcService.getSubAccountOrgList(loginUser.getId());
            List userPurchaseGroupCodeList = subAccountOrgList.stream().filter(org -> "purchaseGroup".equals(org.getOrgCategoryCode())).map(SubAccountOrgDTO::getOrgCode).collect(Collectors.toList());
            queryWrapper.and(i -> {
                i.or(person -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)person.like((Object)"tactics_entity", (Object)loginUser.getSubAccount())).eq((Object)"tactics_object", (Object)"person");
                });
                if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"role")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", rolesSet) + "_'", new Object[0]);
                    });
                }
                if (CollectionUtil.isNotEmpty((Collection)subAccountOrgList)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"group")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", userPurchaseGroupCodeList) + "_'", new Object[0]);
                    });
                }
                i.or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)j.isNull((Object)"tactics_entity")).or()).eq((Object)"tactics_entity", (Object)"");
                });
            });
        }
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        return this.purchaseRequestItemService.list((Wrapper)queryWrapper);
    }

    public long queryExportDataCount(QueryWrapper<PurchaseRequestItem> queryWrapper, PurchaseRequestItem map, Map<String, String[]> paramMap) {
        queryWrapper.notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue(), "12"));
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            LoginUser loginUser = SysUtil.getLoginUser();
            Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
            List subAccountOrgList = this.invokeAccountRpcService.getSubAccountOrgList(loginUser.getId());
            List userPurchaseGroupCodeList = subAccountOrgList.stream().filter(org -> "purchaseGroup".equals(org.getOrgCategoryCode())).map(SubAccountOrgDTO::getOrgCode).collect(Collectors.toList());
            queryWrapper.and(i -> {
                i.or(person -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)person.like((Object)"tactics_entity", (Object)loginUser.getSubAccount())).eq((Object)"tactics_object", (Object)"person");
                });
                if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"role")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", rolesSet) + "_'", new Object[0]);
                    });
                }
                if (CollectionUtil.isNotEmpty((Collection)subAccountOrgList)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"group")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", userPurchaseGroupCodeList) + "_'", new Object[0]);
                    });
                }
                i.or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)j.isNull((Object)"tactics_entity")).or()).eq((Object)"tactics_entity", (Object)"");
                });
            });
        }
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        return this.purchaseRequestItemService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "purchaseDemandPoolList";
    }

    public String getBeanName() {
        return "purchaseDemandPoolExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        queryWrapper.notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue(), "12"));
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            LoginUser loginUser = SysUtil.getLoginUser();
            Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
            List subAccountOrgList = this.invokeAccountRpcService.getSubAccountOrgList(loginUser.getId());
            List userPurchaseGroupCodeList = subAccountOrgList.stream().filter(org -> "purchaseGroup".equals(org.getOrgCategoryCode())).map(SubAccountOrgDTO::getOrgCode).collect(Collectors.toList());
            queryWrapper.and(i -> {
                i.or(person -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)person.like((Object)"tactics_entity", (Object)loginUser.getSubAccount())).eq((Object)"tactics_object", (Object)"person");
                });
                if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"role")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", rolesSet) + "_'", new Object[0]);
                    });
                }
                if (CollectionUtil.isNotEmpty((Collection)subAccountOrgList)) {
                    i.or(role -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)role.eq((Object)"tactics_object", (Object)"group")).apply("tactics_entity REGEXP '^" + String.join((CharSequence)"_|^", userPurchaseGroupCodeList) + "_'", new Object[0]);
                    });
                }
                i.or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)j.isNull((Object)"tactics_entity")).or()).eq((Object)"tactics_entity", (Object)"");
                });
            });
        }
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        return JSON.toJSONString((Object)((Page)this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper)).getRecords());
    }
}

