/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.searchSourceConfig.entity.PurchaseSearchSourceConfigHead;
import com.els.modules.searchSourceConfig.entity.PurchaseSearchSourceConfigItem;
import com.els.modules.searchSourceConfig.enums.I18nSearSourEnum;
import com.els.modules.searchSourceConfig.mapper.PurchaseSearchSourceConfigHeadMapper;
import com.els.modules.searchSourceConfig.mapper.PurchaseSearchSourceConfigItemMapper;
import com.els.modules.searchSourceConfig.service.PurchaseSearchSourceConfigHeadService;
import com.els.modules.searchSourceConfig.service.PurchaseSearchSourceConfigItemService;
import com.els.modules.searchSourceConfig.vo.PurSearSourConHeadSaveVo;
import com.els.modules.searchSourceConfig.vo.PurSearSourConHeadSubmitVo;
import com.els.modules.searchSourceConfig.vo.PurSearSourConItemVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSearchSourceConfigHeadServiceImpl
extends BaseServiceImpl<PurchaseSearchSourceConfigHeadMapper, PurchaseSearchSourceConfigHead>
implements PurchaseSearchSourceConfigHeadService {
    private static final int BATCH_SIZE = 2000;
    @Resource
    private PurchaseSearchSourceConfigItemMapper itemMapper;
    @Resource
    private PurchaseSearchSourceConfigItemService purchaseSearchSourceConfigItemService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    private String getSerialNumber(Object businessObj) {
        return this.baseRpcService.getNextCode("searchSourceConfigNumber", businessObj);
    }

    private void setBaseEntity(BaseEntity baseEntity) {
        Date now = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        baseEntity.setElsAccount(TenantContext.getTenant()).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount()).setCreateTime(now).setUpdateTime(now).setDeleted(CommonConstant.DEL_FLAG_0).setId(IdWorker.getIdStr());
    }

    private void delByMainId(String headId) {
        this.itemMapper.delByMainId(headId);
    }

    private void saveItem(String headId, List<PurSearSourConItemVo> configItemVoList) {
        if (CollectionUtils.isEmpty(configItemVoList)) {
            return;
        }
        List itemList = configItemVoList.stream().map(configItemVo -> {
            PurchaseSearchSourceConfigItem configItem = new PurchaseSearchSourceConfigItem();
            BeanUtils.copyProperties((Object)configItemVo, (Object)((Object)configItem));
            configItem.setHeadId(headId);
            this.setBaseEntity(configItem);
            return configItem;
        }).collect(Collectors.toList());
        this.purchaseSearchSourceConfigItemService.saveBatch(itemList, 2000);
    }

    private void validMaterialTypeRepeat(List<PurchaseSearchSourceConfigItem> itemList) {
        Map<String, Long> mapGroup = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode())).collect(Collectors.groupingBy(PurchaseSearchSourceConfigItem::getCateCode, Collectors.counting()));
        for (Map.Entry<String, Long> map : mapGroup.entrySet()) {
            AssertI18nUtil.isTrue((map.getValue() > 1L ? 1 : 0) != 0, (Enum)I18nSearSourEnum.MATERIAL_TYPE_CONFIG_REPEAT, (String[])new String[]{map.getKey()});
        }
    }

    private void validStatisticalType(List<PurchaseSearchSourceConfigItem> itemList) {
        List filterList = itemList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getCateCode())).collect(Collectors.toList());
        AssertI18nUtil.isTrue((filterList.size() > 1 ? 1 : 0) != 0, (Enum)I18nSearSourEnum.MATERIAL_TYPE_NULL_ONLY_ONE);
        AssertI18nUtil.isTrue((filterList.size() == 1 && !"2".equals(((PurchaseSearchSourceConfigItem)((Object)filterList.get(0))).getStatisticalType()) ? 1 : 0) != 0, (Enum)I18nSearSourEnum.MATERIAL_TYPE_NULL_ALL);
        filterList = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode()) && !"1".equals(item.getStatisticalType())).collect(Collectors.toList());
        AssertI18nUtil.isTrue((filterList.size() > 0 ? 1 : 0) != 0, (Enum)I18nSearSourEnum.MATERIAL_TYPE_NOT_NULL_ALL);
    }

    private void submitItem(String headId, List<PurchaseSearchSourceConfigItem> configItemList) {
        configItemList.forEach(configItem -> {
            configItem.setHeadId(headId);
            this.setBaseEntity((BaseEntity)configItem);
        });
        this.purchaseSearchSourceConfigItemService.saveBatch(configItemList, 2000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWithNoId(PurSearSourConHeadSaveVo headSaveVo) {
        PurchaseSearchSourceConfigHead configHead = new PurchaseSearchSourceConfigHead();
        BeanUtils.copyProperties((Object)headSaveVo, (Object)((Object)configHead));
        configHead.setSerialNumber(this.getSerialNumber((Object)configHead)).setStatus("0").setDataVersion(0).setId(IdWorker.getIdStr());
        ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).insert((Object)configHead);
        this.saveItem(configHead.getId(), headSaveVo.getConfigItemList());
        headSaveVo.setId(configHead.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWithId(PurSearSourConHeadSaveVo headSaveVo) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)headSaveVo.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)headSaveVo.getId())));
        AssertI18nUtil.isTrue((configHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)"1".equals(configHead.getStatus()), (Enum)I18nSearSourEnum.STATUS_ENABLE_NOT_OPER);
        this.delByMainId(headSaveVo.getId());
        this.saveItem(headSaveVo.getId(), headSaveVo.getConfigItemList());
        PurchaseSearchSourceConfigHead updateEntity = new PurchaseSearchSourceConfigHead();
        BeanUtils.copyProperties((Object)headSaveVo, (Object)((Object)updateEntity));
        int count = ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).updateById((Object)updateEntity);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitWithNoId(PurSearSourConHeadSubmitVo submitVo) {
        AssertI18nUtil.isTrue((((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).countByOrgCode(null, submitVo.getPurchaseOrg()) > 0 ? 1 : 0) != 0, (Enum)I18nSearSourEnum.ORG_CODE_RECODE_EXIST);
        this.validMaterialTypeRepeat(submitVo.getConfigItemList());
        this.validStatisticalType(submitVo.getConfigItemList());
        submitVo.setSerialNumber(this.getSerialNumber((Object)submitVo)).setStatus("1").setDataVersion(0).setId(IdWorker.getIdStr());
        ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).insert((Object)submitVo);
        this.submitItem(submitVo.getId(), submitVo.getConfigItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitWithId(PurSearSourConHeadSubmitVo submitVo) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)submitVo.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)submitVo.getId())));
        AssertI18nUtil.isTrue((configHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)"1".equals(configHead.getStatus()), (Enum)I18nSearSourEnum.STATUS_ENABLE_NOT_OPER);
        AssertI18nUtil.isTrue((((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).countByOrgCode(submitVo.getId(), submitVo.getPurchaseOrg()) > 0 ? 1 : 0) != 0, (Enum)I18nSearSourEnum.ORG_CODE_RECODE_EXIST);
        this.validMaterialTypeRepeat(submitVo.getConfigItemList());
        this.validStatisticalType(submitVo.getConfigItemList());
        submitVo.setStatus("1");
        int count = ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).updateById((Object)submitVo);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.delByMainId(submitVo.getId());
        this.submitItem(submitVo.getId(), submitVo.getConfigItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(String id) {
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        boolean bool = configHead == null || !"2".equals(configHead.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSearSourEnum.RECORD_NULL_NOT_DISABLE);
        if (configHead == null) {
            return;
        }
        configHead.setStatus("1");
        int count = ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).updateById((Object)configHead);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(String id) {
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        boolean bool = configHead == null || !"1".equals(configHead.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSearSourEnum.RECORD_NULL_NOT_ENABLE);
        if (configHead == null) {
            return;
        }
        configHead.setStatus("2");
        int count = ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).updateById((Object)configHead);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copySearSourConfig(String id) {
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((configHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        configHead.setSerialNumber(this.getSerialNumber((Object)configHead)).setStatus("0").setPurchaseOrg(null).setRemark(null).setDataVersion(0).setCreateTime(new Date()).setId(IdWorker.getIdStr());
        ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).insert((Object)configHead);
        List<PurchaseSearchSourceConfigItem> itemList = this.itemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> item.setHeadId(configHead.getId()).setRemark(null).setId(IdWorker.getIdStr()));
        this.purchaseSearchSourceConfigItemService.saveBatch(itemList, 2000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delConfig(String id) {
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((configHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"0".equals(configHead.getStatus()) ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_IS_NOT_NEW);
        ((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.delByMainId(id);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public PurSearSourConHeadSubmitVo getById(String id) {
        PurchaseSearchSourceConfigHead configHead = (PurchaseSearchSourceConfigHead)((Object)((PurchaseSearchSourceConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((configHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        PurSearSourConHeadSubmitVo res = new PurSearSourConHeadSubmitVo();
        BeanUtils.copyProperties((Object)((Object)configHead), (Object)((Object)res));
        res.setConfigItemList(this.itemMapper.selectByMainId(id));
        return res;
    }
}

