/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.specialist.entity.SpecialistHistoryBiddingInfo;
import com.els.modules.specialist.entity.SpecialistInfo;
import com.els.modules.specialist.service.SpecialistHistoryBiddingInfoService;
import com.els.modules.specialist.service.SpecialistInfoService;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetterFormatGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.entity.SaleTenderQuoteMaterial;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.enumerate.PricePointsCalFormualEnum;
import com.els.modules.tender.attachment.enumerate.ReviewOrderEnum;
import com.els.modules.tender.attachment.enumerate.ShortlistedRulesEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.SaleTenderQuoteMaterialService;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderOfflineBidEvaSupplierRecord;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaGroupSummaryResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaSupplierResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaBidAttachmentInfo;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaInfo;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaSettingHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidEvaStatusEnum;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidWinningCandidateStatusEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceHeadStatusEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaHeadMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderOfflineBidEvaSupplierRecordService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaSupplierResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaBidAttachmentInfoService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaSettingHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceItemService;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.strategy.shortlisted.ShortlistedRulesStrategy;
import com.els.modules.tender.evaluation.utils.HtmlToPdfUtil;
import com.els.modules.tender.evaluation.vo.EvaGroupRegulationResultVO;
import com.els.modules.tender.evaluation.vo.EvaGroupVO;
import com.els.modules.tender.evaluation.vo.EvaJudgesVO;
import com.els.modules.tender.evaluation.vo.EvaLeaderOpinionVO;
import com.els.modules.tender.evaluation.vo.EvaResultVO;
import com.els.modules.tender.evaluation.vo.OfflineBidEvaluationVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaHeadVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectEvaInfoVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectEvaSettingHeadVO;
import com.els.modules.tender.evaluation.vo.SummaryEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import com.els.modules.tender.evaluation.vo.SupplierVO;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.price.entity.PurchaseTenderControlPriceSetting;
import com.els.modules.tender.price.service.PurchaseTenderControlPriceHeadService;
import com.els.modules.tender.price.vo.PurchaseTenderControlPriceHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectSubpackageInfoVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderProjectBidEvaHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaHeadMapper, PurchaseTenderProjectBidEvaHead>
implements PurchaseTenderProjectBidEvaHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectBidEvaHeadServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService evaExpertTaskService;
    @Autowired
    private PurchaseTenderEvaluationGroupService evaluationGroupService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService evaRegulationResultService;
    @Autowired
    private PurchaseTenderProjectBidWinningCandidateService bidWinningCandidateService;
    @Autowired
    private PurchaseTenderProjectEvaBidAttachmentInfoService evaBidAttachmentInfoService;
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService principlesService;
    @Autowired
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectBidEvaGroupSummaryResultService evaGroupSummaryResultService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectEvaSettingHeadService evaSettingHeadService;
    @Autowired
    private PurchaseTenderProjectEvaInfoService evaInfoService;
    @Autowired
    @Lazy
    private TenderEvaQuotedPriceHeadService tenderEvaQuotedPriceHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderBidLetterFormatGroupService bidLetterFormatGroupService;
    @Autowired
    @Lazy
    private SaleTenderQuoteMaterialService saleQuoteMaterialService;
    @Autowired
    @Lazy
    private PurchaseTenderOfflineBidEvaSupplierRecordService bidEvaSupplierRecordService;
    @Autowired
    @Lazy
    private TenderEvaQuotedPriceItemService tenderEvaQuotedPriceItemService;
    @Autowired
    @Lazy
    private PurchaseTenderControlPriceHeadService controlPriceHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectBidEvaSupplierResultService supplierResultService;
    @Autowired
    private SpecialistHistoryBiddingInfoService specialistHistoryBiddingInfoService;
    @Autowired
    private SpecialistInfoService specialistInfoService;

    @Override
    public PurchaseTenderProjectBidEvaHeadVO queryById(String id) {
        PurchaseTenderProjectBidEvaHead bidEvaHead = (PurchaseTenderProjectBidEvaHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = (PurchaseTenderProjectBidEvaHeadVO)((Object)SysUtil.copyProperties((Object)((Object)bidEvaHead), PurchaseTenderProjectBidEvaHeadVO.class));
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectByEvaInfoId(bidEvaHead.getEvaInfoId());
        PurchaseTenderProjectEvaInfo tenderProjectEvaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)bidEvaHead.getEvaInfoId())));
        bidEvaHeadVO.setStageQuote(tenderProjectEvaInfo.getStageQuote());
        bidEvaHeadVO.setStageQuoteOperator(tenderProjectEvaInfo.getStageQuoteOperator());
        if ("1".equals(tenderProjectEvaInfo.getStageQuote())) {
            PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)tenderProjectEvaInfo.getTenderProjectId())));
            bidEvaHeadVO.setPurchaseExecutorAccount(projectHead.getPurchaseExecutorAccount());
        }
        Map<String, List<PurchaseTenderProjectEvaExpertTask>> resultList = bidEvaGroupResultList.stream().collect(Collectors.groupingBy(x -> x.getJudgesName() + "_" + x.getJudgesElsAccount() + "_" + x.getJudgesElsSubAccount(), Collectors.toList()));
        bidEvaHeadVO.setExpertTaskList(resultList);
        return bidEvaHeadVO;
    }

    @Override
    public PurchaseTenderProjectBidEvaHeadVO queryBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = this.selectBySubpackageId(subpackageId);
        if (bidEvaHeadList.isEmpty()) {
            return null;
        }
        PurchaseTenderProjectBidEvaHead bidEvaHead = bidEvaHeadList.get(0);
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = (PurchaseTenderProjectBidEvaHeadVO)((Object)SysUtil.copyProperties((Object)((Object)bidEvaHead), PurchaseTenderProjectBidEvaHeadVO.class));
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectByEvaInfoId(bidEvaHead.getEvaInfoId());
        Map<String, List<PurchaseTenderProjectEvaExpertTask>> resultList = bidEvaGroupResultList.stream().collect(Collectors.groupingBy(x -> x.getJudgesName() + "_" + x.getJudgesElsAccount() + "_" + x.getJudgesElsSubAccount(), Collectors.toList()));
        bidEvaHeadVO.setExpertTaskList(resultList);
        return bidEvaHeadVO;
    }

    @Override
    public boolean isAllowEva(String evaGroupId, String judgesTaskItemId) {
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)judgesTaskItemId)));
        if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) {
            this.checkQuotedPrice(evaExpertTask);
        }
        this.validSupplier(evaGroupId, evaluationGroupVO, evaExpertTask);
        this.checkEvaOrder(evaExpertTask.getSubpackageId(), evaExpertTask.getEvaInfoId(), evaluationPrinciples.getReviewOrder(), evaGroupId);
        return true;
    }

    private void validSupplier(String evaGroupId, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        ArrayList<String> saleTenderPriceOpeningIdList;
        List<String> supplierAccountList;
        Map<String, SaleTenderPriceOpenings> priceOpeningsMap;
        List<SupplierVO> supplierList = this.generateSupplierList(evaGroupId, evaluationGroupVO, 20, evaExpertTask.getEvaInfoId(), evaExpertTask.getId());
        Assert.isTrue((!supplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RdXIbxQKWxiTtkWqUBsRSVVUBSHcdIQBW_5e61ee5a", (String)"\u4f9b\u5e94\u5546\u5df2\u5168\u90e8\u5426\u51b3\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u53ef\u8bc4\u6807\u7ec8\u6b62\u540e\u91cd\u65b0\u8bc4\u6807\u6216\u8fdb\u884c\u9879\u76ee\u6d41\u6807!"));
        if ((evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) && (priceOpeningsMap = this.getSupplierPriceOpenings(supplierAccountList = supplierList.stream().map(SupplierVO::getSupplierAccount).collect(Collectors.toList()), evaluationGroupVO, saleTenderPriceOpeningIdList = new ArrayList<String>())) != null) {
            for (SupplierVO supplierVO : supplierList) {
                if ("1".equals(supplierVO.getInvalid())) continue;
                SaleTenderPriceOpenings saleTenderPriceOpenings = priceOpeningsMap.get(supplierVO.getSupplierAccount());
                Assert.isTrue((saleTenderPriceOpenings != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RdX0LpeBxmKddquGrRdXSNhAVIVsu_227860f1", (String)"\u4f9b\u5e94\u5546\u3010{0}\u3011\u672a\u6309\u6295\u6807\u51fd\u683c\u5f0f\u54cd\u5e94\uff0c\u53ef\u5e9f\u9664\u8be5\u4f9b\u5e94\u5546\u6216\u8005\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7", (String[])new String[]{supplierVO.getSupplierName()}));
            }
        }
    }

    @Override
    public SupplierEvaGroupResultVO querySupplierResultByGroupId(String evaGroupId, String judgesTaskItemId) {
        SupplierEvaGroupResultVO resultVO = new SupplierEvaGroupResultVO();
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.bidLetterFormatGroupService.selectByMainId(evaluationGroupVO.getHeadId());
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.evaRegulationResultService.selectByMainId(judgesTaskItemId, evaGroupId);
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)judgesTaskItemId)));
        if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) {
            this.checkQuotedPrice(evaExpertTask);
        }
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        resultVO.setEvaluationGroupType(evaluationGroupVO.getGroupType());
        resultVO.setEvaluationGroupVO(evaluationGroupVO);
        resultVO.setBidLetterFormatGroup(bidLetterFormatGroup);
        List<SupplierVO> supplierList = this.generateSupplierList(evaGroupId, evaluationGroupVO, summaryScorePrecision, evaExpertTask.getEvaInfoId(), evaExpertTask.getId());
        resultVO.setSupplierList(supplierList);
        List<String> supplierAccountList = supplierList.stream().map(SupplierVO::getSupplierAccount).collect(Collectors.toList());
        ArrayList<String> saleTenderPriceOpeningIdList = new ArrayList<String>();
        Map<String, SaleTenderPriceOpenings> priceOpeningsMap = this.getSupplierPriceOpenings(supplierAccountList, evaluationGroupVO, saleTenderPriceOpeningIdList);
        Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId = this.getMaterialDataAllList(bidLetterFormatGroup, saleTenderPriceOpeningIdList);
        if (regulationResultList.isEmpty()) {
            this.generateInitResult(resultVO, summaryScorePrecision, priceOpeningsMap, materialDataAllListByBidLetterId);
            for (SupplierVO supplierVO : resultVO.getSupplierList()) {
                List<PurchaseTenderProjectBidEvaRegulationResultVO> bidEvaRegulationResultVOList = resultVO.getEvaResultListMap().getOrDefault(supplierVO.getSupplierAccount(), Collections.emptyList());
                supplierVO.setBidEvaRegulationResultList(bidEvaRegulationResultVOList);
            }
            return resultVO;
        }
        if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) {
            if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType())) {
                this.calItemizedQuotationPriceTotalScore(resultVO, summaryScorePrecision, regulationResultList, priceOpeningsMap, materialDataAllListByBidLetterId);
            } else {
                this.calTotalItemQuotaionPriceTotalscore(resultVO, summaryScorePrecision, regulationResultList, priceOpeningsMap, materialDataAllListByBidLetterId);
            }
        } else {
            this.calOtherEvaItemTotalScore(resultVO, summaryScorePrecision, regulationResultList);
        }
        for (SupplierVO supplierVO : resultVO.getSupplierList()) {
            List<PurchaseTenderProjectBidEvaRegulationResultVO> bidEvaRegulationResultVOList = resultVO.getEvaResultListMap().getOrDefault(supplierVO.getSupplierAccount(), Collections.emptyList());
            supplierVO.setBidEvaRegulationResultList(bidEvaRegulationResultVOList);
        }
        return resultVO;
    }

    private void checkEvaOrder(String subpackageId, String evaInfoId, String reviewOrder, String evaGroupId) {
        List<EvaGroupVO> evaGroupVOList;
        if (ReviewOrderEnum.ORDER.getValue().equals(reviewOrder) && CollectionUtil.isNotEmpty(evaGroupVOList = this.evaSettingHeadService.queryEvaGroupBySubpackageId(subpackageId, "0"))) {
            EvaGroupVO fisrtEvaGroupVO = evaGroupVOList.get(0);
            if (fisrtEvaGroupVO.getId().equals(evaGroupId)) {
                return;
            }
            List<PurchaseTenderProjectBidEvaGroupSummaryResult> summaryResultList = this.evaGroupSummaryResultService.selectByMainId(evaInfoId);
            Map<String, List<PurchaseTenderProjectBidEvaGroupSummaryResult>> summaryResultListMap = summaryResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaGroupSummaryResult::getEvaGroupId));
            for (int i = 0; i < evaGroupVOList.size(); ++i) {
                EvaGroupVO evaGroupVO = evaGroupVOList.get(i);
                if (evaGroupVO.getId().equals(evaGroupId)) {
                    return;
                }
                List<PurchaseTenderProjectBidEvaGroupSummaryResult> resultList = summaryResultListMap.get(evaGroupVO.getId());
                if (!CollectionUtil.isEmpty(resultList)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XImSyWWWWWLMLUBWxiTtkW_5203e2db", (String)"\u4e0a\u4e00\u4e2a\u73af\u8282\u3010{0}\u3011\u672a\u5b8c\u6210\u8bc4\u6807\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01", (String[])new String[]{evaGroupVO.getName()}));
            }
        }
    }

    private void generateInitResult(SupplierEvaGroupResultVO resultVO, int summaryScorePrecision, Map<String, SaleTenderPriceOpenings> priceOpeningsMap, Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId) {
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = resultVO.getEvaluationGroupVO();
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = resultVO.getBidLetterFormatGroup();
        List<SupplierVO> supplierList = resultVO.getSupplierList();
        ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> resultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
        for (SupplierVO supplier : supplierList) {
            if ("1".equals(supplier.getInvalid())) continue;
            if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) {
                this.buildPriceOpenings(evaluationGroupVO, resultList, priceOpeningsMap, bidLetterFormatGroup, materialDataAllListByBidLetterId, supplier, summaryScorePrecision);
                continue;
            }
            this.buildRegulation(evaluationGroupVO, resultList, supplier);
        }
        Map listMap = resultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount, LinkedHashMap::new, Collectors.toList()));
        resultVO.setEvaResultListMap(listMap);
    }

    private Map<String, List<SaleTenderQuoteMaterial>> getMaterialDataAllList(PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup, List<String> saleTenderPriceOpeningIdList) {
        Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId = new LinkedHashMap<String, List<SaleTenderQuoteMaterial>>(0);
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType())) {
            List<SaleTenderQuoteMaterial> materialDataAllList = this.saleQuoteMaterialService.selectByMainIds(saleTenderPriceOpeningIdList, null);
            materialDataAllListByBidLetterId = materialDataAllList.stream().collect(Collectors.groupingBy(saleTenderQuoteMaterial -> saleTenderQuoteMaterial.getSupplierAccount() + "_" + saleTenderQuoteMaterial.getBidLetterId()));
        }
        return materialDataAllListByBidLetterId;
    }

    private Map<String, SaleTenderPriceOpenings> getSupplierPriceOpenings(List<String> supplierAccountList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<String> saleTenderPriceOpeningIdList) {
        Map<String, SaleTenderPriceOpenings> priceOpeningsMap = null;
        if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) || evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue())) {
            PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
            String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
            List<SaleTenderPriceOpenings> allSupplierPriceOpeningsList = this.saleTenderPriceOpeningsService.getLatestQuoteSaleTenderPriceOpeningList(Collections.emptyList(), supplierAccountList, true, Arrays.asList(tenderBidLetterId), "0");
            priceOpeningsMap = allSupplierPriceOpeningsList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, saleTenderPriceOpenings -> saleTenderPriceOpenings, (o1, o2) -> o1));
            saleTenderPriceOpeningIdList.addAll(allSupplierPriceOpeningsList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList()));
        }
        return priceOpeningsMap;
    }

    private void calItemizedQuotationPriceTotalScore(SupplierEvaGroupResultVO resultVO, int summaryScorePrecision, List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList, Map<String, SaleTenderPriceOpenings> priceOpeningsMap, Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId) {
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = resultVO.getEvaluationGroupVO();
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = resultVO.getBidLetterFormatGroup();
        List<SupplierVO> supplierList = resultVO.getSupplierList();
        LinkedHashMap<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> supplierEvaResultListMap = new LinkedHashMap<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>>();
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> suppilerMaterialListMap = regulationResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (SupplierVO supplier : supplierList) {
            ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> supplierMaterialListVO;
            List<PurchaseTenderProjectBidEvaRegulationResult> supplierMaterialList = suppilerMaterialListMap.get(supplier.getSupplierAccount());
            PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = new PurchaseTenderProjectBidEvaRegulationResultVO();
            this.buildSupplierRegulationVo(evaluationGroupVO, supplier, summaryScorePrecision, regulationResultVO);
            if (!CollectionUtils.isEmpty(supplierMaterialList)) {
                supplierMaterialListVO = SysUtil.copyProperties(supplierMaterialList, PurchaseTenderProjectBidEvaRegulationResultVO.class);
                this.calMaterialListTotalScore(summaryScorePrecision, regulationResultVO, (List<PurchaseTenderProjectBidEvaRegulationResultVO>)supplierMaterialListVO);
            } else if ("0".equals(supplier.getInvalid())) {
                supplierMaterialListVO = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
                this.buildPriceOpenings(evaluationGroupVO, supplierMaterialListVO, priceOpeningsMap, bidLetterFormatGroup, materialDataAllListByBidLetterId, supplier, summaryScorePrecision);
                regulationResultVO = (PurchaseTenderProjectBidEvaRegulationResultVO)((Object)supplierMaterialListVO.get(0));
            }
            if (!"0".equals(supplier.getInvalid())) continue;
            supplierEvaResultListMap.put(supplier.getSupplierAccount(), Arrays.asList(regulationResultVO));
        }
        resultVO.setEvaResultListMap(supplierEvaResultListMap);
    }

    private void calTotalItemQuotaionPriceTotalscore(SupplierEvaGroupResultVO resultVO, int summaryScorePrecision, List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList, Map<String, SaleTenderPriceOpenings> priceOpeningsMap, Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId) {
        List<SupplierVO> supplierList = resultVO.getSupplierList();
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = resultVO.getEvaluationGroupVO();
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = resultVO.getBidLetterFormatGroup();
        ArrayList resultList = SysUtil.copyProperties(regulationResultList, PurchaseTenderProjectBidEvaRegulationResultVO.class);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> listMap = resultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (SupplierVO supplier : supplierList) {
            List<PurchaseTenderProjectBidEvaRegulationResultVO> resultVOList = listMap.get(supplier.getSupplierAccount());
            if (CollectionUtil.isNotEmpty(resultVOList)) {
                for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : resultVOList) {
                    BigDecimal score = regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore();
                    BigDecimal weightScore = regulationResultVO.getWeightScore() == null ? BigDecimal.ZERO : regulationResultVO.getWeightScore();
                    regulationResultVO.setScore(score.setScale(summaryScorePrecision, 4));
                    regulationResultVO.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
                    if (regulationResultVO.getBasePrice() != null) {
                        regulationResultVO.setBasePrice(regulationResultVO.getBasePrice().setScale(6, 4));
                    }
                    if (regulationResultVO.getEvaPrice() != null) {
                        regulationResultVO.setEvaPrice(regulationResultVO.getEvaPrice().setScale(6, 4));
                    }
                    if (regulationResultVO.getQuote() == null) continue;
                    regulationResultVO.setQuote(regulationResultVO.getQuote().setScale(6, 4));
                }
                continue;
            }
            if (!"0".equals(supplier.getInvalid())) continue;
            resultVOList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
            this.buildPriceOpenings(evaluationGroupVO, resultVOList, priceOpeningsMap, bidLetterFormatGroup, materialDataAllListByBidLetterId, supplier, summaryScorePrecision);
            listMap.put(supplier.getSupplierAccount(), resultVOList);
        }
        resultVO.setEvaResultListMap(listMap);
    }

    private void calOtherEvaItemTotalScore(SupplierEvaGroupResultVO resultVO, int summaryScorePrecision, List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList) {
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = resultVO.getEvaluationGroupVO();
        List<SupplierVO> supplierList = resultVO.getSupplierList();
        ArrayList resultList = SysUtil.copyProperties(regulationResultList, PurchaseTenderProjectBidEvaRegulationResultVO.class);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> listMap = resultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (SupplierVO supplier : supplierList) {
            BigDecimal total = BigDecimal.ZERO;
            List<PurchaseTenderProjectBidEvaRegulationResultVO> resultVOList = listMap.get(supplier.getSupplierAccount());
            if (CollectionUtil.isNotEmpty(resultVOList)) {
                for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : resultVOList) {
                    total = total.add(regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore());
                    BigDecimal score = regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore();
                    BigDecimal weightScore = regulationResultVO.getWeightScore() == null ? BigDecimal.ZERO : regulationResultVO.getWeightScore();
                    regulationResultVO.setScore(score.setScale(summaryScorePrecision, 4));
                    regulationResultVO.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
                }
                if (!evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.SCORE.getValue())) continue;
                supplier.setTotalScore(total.setScale(summaryScorePrecision, 4));
                continue;
            }
            if (!"0".equals(supplier.getInvalid())) continue;
            resultVOList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
            this.buildRegulation(evaluationGroupVO, resultVOList, supplier);
            listMap.put(supplier.getSupplierAccount(), resultVOList);
        }
        resultVO.setEvaResultListMap(listMap);
    }

    private List<SupplierVO> generateSupplierList(String evaGroupId, PurchaseTenderEvaluationGroupVO evaluationGroupVO, int summaryScorePrecision, String evaInfoId, String judgesTaskItemId) {
        ArrayList<SupplierVO> supplierList = new ArrayList<SupplierVO>();
        List<PurchaseTenderProjectBidEvaSupplierResult> supplierResultList = this.supplierResultService.selectByMainId(evaInfoId);
        if (CollectionUtil.isEmpty(supplierResultList)) {
            List<TenderProjectSupplier> tenderProjectSupplier = this.tenderProjectSupplierService.getDecryptSupplier(evaluationGroupVO.getSubpackageId(), null, null);
            Iterator iterator = tenderProjectSupplier.iterator();
            while (iterator.hasNext()) {
                TenderProjectSupplier supplier = (TenderProjectSupplier)((Object)iterator.next());
                SupplierVO supplierVO = new SupplierVO();
                supplierVO.setSupplierAccount(supplier.getSupplierAccount());
                supplierVO.setSupplierName(supplier.getSupplierName());
                supplierVO.setInvalid(supplier.getInvalid());
                supplierVO.setJudgesTaskItemId(judgesTaskItemId);
                supplierVO.setWeights(evaluationGroupVO.getWeights());
                supplierList.add(supplierVO);
            }
            this.supplierResultService.saveBatchEvaSupplierResult(tenderProjectSupplier, evaInfoId);
        } else {
            for (PurchaseTenderProjectBidEvaSupplierResult evaSupplierResult : supplierResultList) {
                SupplierVO supplierVO = new SupplierVO();
                supplierVO.setSupplierAccount(evaSupplierResult.getSupplierAccount());
                supplierVO.setSupplierName(evaSupplierResult.getSupplierName());
                supplierVO.setInvalid(evaSupplierResult.getInvalid());
                supplierVO.setJudgesTaskItemId(judgesTaskItemId);
                supplierVO.setWeights(evaluationGroupVO.getWeights());
                supplierList.add(supplierVO);
            }
        }
        Map bidEvaGroupSummaryResultListMap = this.evaGroupSummaryResultService.selectEvaGroupSummaryResultByMainId(Arrays.asList(evaInfoId), evaGroupId).stream().collect(Collectors.toMap(SupplierEvaRankingVO::getSupplierAccount, Function.identity()));
        for (SupplierVO supplierVO : supplierList) {
            SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult;
            SupplierEvaRankingVO evaRankingVO = (SupplierEvaRankingVO)bidEvaGroupSummaryResultListMap.get(supplierVO.getSupplierAccount());
            if (evaRankingVO == null || (evaGroupSummaryResult = evaRankingVO.getResult().get(evaGroupId)) == null) continue;
            supplierVO.setEvaGroupResult(evaGroupSummaryResult.getEvaGroupResult());
            if (evaGroupSummaryResult.getTotalScore() == null) continue;
            BigDecimal totalScore = evaGroupSummaryResult.getTotalScore();
            supplierVO.setTotalScore(evaGroupSummaryResult.getTotalScore().setScale(summaryScorePrecision, 4));
            supplierVO.setWeightScore(totalScore.multiply(evaluationGroupVO.getWeights()).divide(BigDecimal.valueOf(100L), 20, 4).setScale(summaryScorePrecision, 4));
            evaGroupSummaryResult.setWeightScore(evaGroupSummaryResult.getTotalScore().multiply(evaluationGroupVO.getWeights()).divide(BigDecimal.valueOf(100L), 20, 4));
        }
        return supplierList;
    }

    @Override
    public EvaGroupRegulationResultVO querySupplierByEvaGroupId(String evaGroupId, String evaInfoId, String supplierAccount) {
        EvaGroupRegulationResultVO result = new EvaGroupRegulationResultVO();
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        ArrayList<EvaJudgesVO> evaJudgesVOList = new ArrayList<EvaJudgesVO>();
        HashSet<String> distinct = new HashSet<String>();
        List<PurchaseTenderProjectEvaExpertTask> evaExpertTaskList = this.evaExpertTaskService.selectByEvaInfoId(evaInfoId);
        for (PurchaseTenderProjectEvaExpertTask evaExpertTask : evaExpertTaskList) {
            String key = evaExpertTask.getJudgesElsAccount() + "_" + evaExpertTask.getJudgesElsSubAccount();
            if (!distinct.contains(key)) {
                EvaJudgesVO evaJudgesVO = (EvaJudgesVO)((Object)SysUtil.copyProperties((Object)((Object)evaExpertTask), EvaJudgesVO.class));
                evaJudgesVOList.add(evaJudgesVO);
            }
            distinct.add(key);
        }
        result.setEvaJudgesVOList(evaJudgesVOList);
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.evaRegulationResultService.querySupplierByEvaGroupId(supplierAccount, evaGroupId, evaInfoId);
        if (!regulationResultList.isEmpty()) {
            for (PurchaseTenderProjectBidEvaRegulationResult evaRegulationResult : regulationResultList) {
                BigDecimal score = evaRegulationResult.getScore() == null ? BigDecimal.ZERO : evaRegulationResult.getScore();
                BigDecimal weightScore = evaRegulationResult.getWeightScore() == null ? BigDecimal.ZERO : evaRegulationResult.getWeightScore();
                evaRegulationResult.setScore(score.setScale(summaryScorePrecision, 4));
                evaRegulationResult.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
            }
            result.setEvaRegulationResultList(regulationResultList);
        }
        return result;
    }

    @Override
    public List<PurchaseTenderProjectBidEvaHead> selectByMainId(String evaInfoId) {
        return ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectByEvaInfoId(evaInfoId);
    }

    @Override
    public SummaryEvaGroupResultVO querySummaryEvaGroupResultByGroupId(String evaGroupId, String evaInfoId) {
        SummaryEvaGroupResultVO result = new SummaryEvaGroupResultVO();
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        result.setElsAccount(evaluationGroupVO.getElsAccount());
        result.setBusAccount(evaluationGroupVO.getElsAccount());
        result.setEvaluationGroup(evaluationGroupVO);
        result.setEvaluationPrinciples(evaluationPrinciples);
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        List<SupplierVO> supplierList = this.generateSupplierList(evaGroupId, evaluationGroupVO, summaryScorePrecision, evaInfoId, null);
        result.setSupplierList(supplierList);
        List<PurchaseTenderProjectBidEvaRegulationResult> summaryRegulationResultList = this.evaRegulationResultService.summaryEvaRegulationResult(evaInfoId, evaGroupId);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> supplierAccountListMap = summaryRegulationResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (SupplierVO supplierVO : supplierList) {
            List<PurchaseTenderProjectBidEvaRegulationResult> resultList = supplierAccountListMap.get(supplierVO.getSupplierAccount());
            if (!CollectionUtil.isEmpty(resultList)) continue;
            supplierVO.setTotalScore(null);
            supplierVO.setWeights(null);
            supplierVO.setWeightScore(null);
        }
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> summaryRegulationResultListMap = null;
        summaryRegulationResultListMap = TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaluationGroupVO.getGroupType()) && "0".equals(evaluationPrinciples.getSummaryCalType()) ? summaryRegulationResultList.stream().collect(Collectors.groupingBy(regulationResult -> regulationResult.getJudgesElsAccount() + "_" + regulationResult.getJudgesElsSubAccount())) : summaryRegulationResultList.stream().collect(Collectors.groupingBy(regulationResult -> regulationResult.getRegulationId()));
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (List<PurchaseTenderProjectBidEvaRegulationResult> value : summaryRegulationResultListMap.values()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            PurchaseTenderProjectBidEvaRegulationResult firstColumn = value.get(0);
            if (TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaluationGroupVO.getGroupType()) && "0".equals(evaluationPrinciples.getSummaryCalType())) {
                item.put("name", firstColumn.getJudgesName());
                item.put("id", firstColumn.getJudgesElsAccount() + "_" + firstColumn.getJudgesElsSubAccount());
            } else {
                item.put("name", firstColumn.getRegulationName());
                item.put("id", firstColumn.getRegulationId());
            }
            for (PurchaseTenderProjectBidEvaRegulationResult otherColumn : value) {
                item.put(otherColumn.getSupplierAccount() + "_result", otherColumn.getResult());
                item.put(otherColumn.getSupplierAccount() + "_weight", evaluationGroupVO.getWeights());
                BigDecimal weightScore = null;
                if (otherColumn.getScore() == null || evaluationGroupVO.getWeights() == null) continue;
                item.put(otherColumn.getSupplierAccount() + "_totalScope", otherColumn.getScore().setScale(summaryScorePrecision, 4).toString());
                weightScore = otherColumn.getScore().multiply(evaluationGroupVO.getWeights()).divide(BigDecimal.valueOf(100L), summaryScorePrecision, 4);
                item.put(otherColumn.getSupplierAccount() + "_weightScore", weightScore.toString());
            }
            resultList.add(item);
        }
        result.setResultList(resultList);
        return result;
    }

    private void buildRegulation(PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<PurchaseTenderProjectBidEvaRegulationResultVO> resultList, SupplierVO supplier) {
        List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = evaluationGroupVO.getTenderEvaluationTemplateRegulationInfoList();
        for (PurchaseTenderEvaluationRegulationInfo regulationInfo : regulationInfoList) {
            PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = new PurchaseTenderProjectBidEvaRegulationResultVO();
            regulationResultVO.setSupplierAccount(supplier.getSupplierAccount());
            regulationResultVO.setSupplierName(supplier.getSupplierName());
            regulationResultVO.setTenderProjectId(regulationInfo.getTenderProjectId());
            regulationResultVO.setSubpackageId(regulationInfo.getSubpackageId());
            regulationResultVO.setEvaGroupId(evaluationGroupVO.getId());
            regulationResultVO.setEvaGroupType(evaluationGroupVO.getGroupType());
            regulationResultVO.setRegulationId(regulationInfo.getId());
            regulationResultVO.setRegulationName(regulationInfo.getRegulationName());
            regulationResultVO.setWeight(evaluationGroupVO.getWeights());
            resultList.add(regulationResultVO);
        }
    }

    private void buildPriceOpenings(PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<PurchaseTenderProjectBidEvaRegulationResultVO> resultList, Map<String, SaleTenderPriceOpenings> priceOpeningsMap, PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup, Map<String, List<SaleTenderQuoteMaterial>> materialDataAllListByBidLetterId, SupplierVO supplier, int summaryScorePrecision) {
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        String quoteColumnName = priceRegulationInfo.getQuoteColumnName();
        SaleTenderPriceOpenings saleTenderPriceOpenings = priceOpeningsMap.get(supplier.getSupplierAccount());
        Assert.isTrue((saleTenderPriceOpenings != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RdX0LpeBxmKddquGrRdXSNhAVIVsu_227860f1", (String)"\u4f9b\u5e94\u5546\u3010{0}\u3011\u672a\u6309\u6295\u6807\u51fd\u683c\u5f0f\u54cd\u5e94\uff0c\u53ef\u5e9f\u9664\u8be5\u4f9b\u5e94\u5546\u6216\u8005\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7", (String[])new String[]{supplier.getSupplierName()}));
        String customizeFieldData = saleTenderPriceOpenings.getCustomizeFieldData();
        JSONArray customizeFieldDataList = JSON.parseArray((String)customizeFieldData);
        PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = new PurchaseTenderProjectBidEvaRegulationResultVO();
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType())) {
            List<SaleTenderQuoteMaterial> quoteMaterialList = materialDataAllListByBidLetterId.get(supplier.getSupplierAccount() + "_" + saleTenderPriceOpenings.getBidLetterId());
            Map<Object, Object> quoteMaterialMapByMaterialId = new LinkedHashMap(0);
            Map<Object, Object> quoteMaterialMapByMaterialNumber = new LinkedHashMap(0);
            if (CollectionUtil.isNotEmpty(quoteMaterialList)) {
                quoteMaterialMapByMaterialId = quoteMaterialList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getMaterialId));
                quoteMaterialMapByMaterialNumber = quoteMaterialList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getMaterialNumber));
            }
            ArrayList<String> usedRegulationIdList = new ArrayList<String>();
            ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> supplierMaterialList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
            for (Object o : customizeFieldDataList) {
                JSONObject jsonObject = (JSONObject)o;
                PurchaseTenderProjectBidEvaRegulationResultVO regulationResult = new PurchaseTenderProjectBidEvaRegulationResultVO();
                String materialId = jsonObject.getString("materialId");
                String materialNumber = jsonObject.getString("materialNumber");
                List saleTenderQuoteMaterialList = (List)quoteMaterialMapByMaterialId.get(materialId);
                if ((StringUtils.isBlank((CharSequence)materialId) || CollectionUtil.isEmpty((Collection)saleTenderQuoteMaterialList)) && CollectionUtil.isEmpty((Collection)(saleTenderQuoteMaterialList = (List)quoteMaterialMapByMaterialNumber.get(materialNumber)))) continue;
                SaleTenderQuoteMaterial saleTenderQuoteMaterial = null;
                for (SaleTenderQuoteMaterial quoteMaterial : saleTenderQuoteMaterialList) {
                    if (usedRegulationIdList.contains(quoteMaterial.getId())) continue;
                    saleTenderQuoteMaterial = quoteMaterial;
                    break;
                }
                if (saleTenderQuoteMaterial == null) continue;
                usedRegulationIdList.add(saleTenderQuoteMaterial.getId());
                regulationResult.setRegulationId(saleTenderQuoteMaterial.getId());
                regulationResult.setMaterialId(saleTenderQuoteMaterial.getMaterialId());
                regulationResult.setMaterialName(saleTenderQuoteMaterial.getMaterialName());
                String quoteValue = jsonObject.getString(quoteColumnName);
                if (StringUtils.isNotBlank((CharSequence)quoteValue)) {
                    regulationResult.setQuote(new BigDecimal(quoteValue));
                    BigDecimal priceCorrection = regulationResult.getPriceCorrection() == null ? BigDecimal.ZERO : regulationResult.getPriceCorrection();
                    regulationResult.setEvaPrice(regulationResult.getQuote().subtract(priceCorrection));
                }
                this.buildSupplierRegulationVo(evaluationGroupVO, supplier, summaryScorePrecision, regulationResult);
                supplierMaterialList.add(regulationResult);
            }
            regulationResultVO.setSupplierMaterialList(supplierMaterialList);
            this.buildSupplierRegulationVo(evaluationGroupVO, supplier, summaryScorePrecision, regulationResultVO);
            resultList.add(regulationResultVO);
        } else {
            JSONObject jsonObject = customizeFieldDataList.getJSONObject(0);
            String quoteValue = jsonObject.getString(quoteColumnName);
            if (StringUtils.isNotBlank((CharSequence)quoteValue)) {
                regulationResultVO.setQuote(new BigDecimal(quoteValue));
                BigDecimal priceCorrection = regulationResultVO.getPriceCorrection() == null ? BigDecimal.ZERO : regulationResultVO.getPriceCorrection();
                regulationResultVO.setEvaPrice(regulationResultVO.getQuote().subtract(priceCorrection));
            }
            this.buildSupplierRegulationVo(evaluationGroupVO, supplier, summaryScorePrecision, regulationResultVO);
            resultList.add(regulationResultVO);
        }
    }

    private void buildSupplierRegulationVo(PurchaseTenderEvaluationGroupVO evaluationGroupVO, SupplierVO supplier, int summaryScorePrecision, PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO) {
        BigDecimal score = regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore();
        BigDecimal weightScore = regulationResultVO.getWeightScore() == null ? BigDecimal.ZERO : regulationResultVO.getWeightScore();
        regulationResultVO.setScore(score.setScale(summaryScorePrecision, 4));
        regulationResultVO.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
        regulationResultVO.setSupplierAccount(supplier.getSupplierAccount());
        regulationResultVO.setSupplierName(supplier.getSupplierName());
        regulationResultVO.setTenderProjectId(evaluationGroupVO.getTenderProjectId());
        regulationResultVO.setSubpackageId(evaluationGroupVO.getSubpackageId());
        regulationResultVO.setEvaGroupId(evaluationGroupVO.getId());
        regulationResultVO.setEvaGroupType(evaluationGroupVO.getGroupType());
        regulationResultVO.setWeight(evaluationGroupVO.getWeights());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveSupplierEvaGroupResult(String evaluationGroupType, List<SupplierVO> supplierList) {
        String evaTaskId = supplierList.get(0).getJudgesTaskItemId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)evaTaskId)));
        List<PurchaseTenderProjectBidEvaRegulationResult> allRegulationResultList = this.getRegulationResultList(supplierList, evaExpertTask);
        this.checkQuotedPrice(evaExpertTask);
        this.saveOrUpdateResult(allRegulationResultList, evaExpertTask);
    }

    private void checkQuotedPrice(PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        String evaInfoId = evaExpertTask.getEvaInfoId();
        if (StringUtils.isBlank((CharSequence)evaInfoId)) {
            return;
        }
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)evaInfoId)));
        if ("1".equals(evaInfo.getStageQuote())) {
            TenderEvaQuotedPriceHead queryQuotedPrice = new TenderEvaQuotedPriceHead();
            queryQuotedPrice.setSubpackageId(evaExpertTask.getSubpackageId()).setEvaInfoId(evaExpertTask.getEvaInfoId());
            List<TenderEvaQuotedPriceHead> tenderEvaQuotedPriceItems = this.tenderEvaQuotedPriceHeadService.selectBySubpackageId(queryQuotedPrice);
            tenderEvaQuotedPriceItems.forEach(evaQuotedPriceHead -> Assert.isTrue((boolean)TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE_FINISH.getValue().equals(evaQuotedPriceHead.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_MKLyWjsuVmWShHcumztdW_34cfe159", (String)"\u5b58\u5728\u672a\u7ed3\u675f\u7684\u62a5\u4ef7\u8f6e\u6b21\uff0c\u65e0\u6cd5\u8fdb\u884c\u4ef7\u683c\u5206\u8ba1\u7b97\uff01")));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSupplierEvaGroupResult(String evaluationGroupType, List<SupplierVO> supplierList) {
        List<PurchaseTenderProjectEvaExpertTask> evaExpertTaskList;
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo;
        String evaTaskId = supplierList.get(0).getJudgesTaskItemId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)evaTaskId)));
        Assert.isTrue((boolean)"0".equals(evaExpertTask.getEvaGroupStatus()), (String)I18nUtil.translate((String)"i18n_field_xiTVBUBW_c617f2da", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u8bc4\u6807\uff01"));
        List<PurchaseTenderProjectBidEvaRegulationResult> allRegulationResultList = this.getRegulationResultList(supplierList, evaExpertTask);
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaExpertTask.getEvaGroupId());
        if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue()) && "1".equals((priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo()).getCalType())) {
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : allRegulationResultList) {
                regulationResult.setWeightScore(regulationResult.getScore().multiply(evaluationGroupVO.getWeights()).divide(BigDecimal.valueOf(100L), 20, 4));
            }
        }
        this.checkQuotedPrice(evaExpertTask);
        evaExpertTask.setEvaGroupStatus("1");
        List<PurchaseTenderProjectBidEvaRegulationResult> bidEvaRegulationResultList = this.saveOrUpdateResult(allRegulationResultList, evaExpertTask);
        this.evaExpertTaskService.updateById((Object)evaExpertTask);
        this.checkObjectiveEva(evaExpertTask, evaluationGroupVO, allRegulationResultList);
        if (CollectionUtil.isNotEmpty(bidEvaRegulationResultList)) {
            List<String> saleMaterialRecordsIdList = bidEvaRegulationResultList.stream().map(PurchaseTenderProjectBidEvaRegulationResult::getRegulationId).collect(Collectors.toList());
            Map evaRegulationResultMap = bidEvaRegulationResultList.stream().collect(Collectors.toMap(PurchaseTenderProjectBidEvaRegulationResult::getRegulationId, Function.identity()));
            List<SaleTenderQuoteMaterial> quoteMaterialList = this.saleQuoteMaterialService.selectByIds(saleMaterialRecordsIdList);
            for (SaleTenderQuoteMaterial saleTenderQuoteMaterial : quoteMaterialList) {
                PurchaseTenderProjectBidEvaRegulationResult regulationResult = (PurchaseTenderProjectBidEvaRegulationResult)((Object)evaRegulationResultMap.get(saleTenderQuoteMaterial.getId()));
                saleTenderQuoteMaterial.setOrderBy(regulationResult.getOrderBy());
                saleTenderQuoteMaterial.setEvaPrice(regulationResult.getEvaPrice());
            }
            this.saleQuoteMaterialService.updateBatchById(quoteMaterialList, 1000);
        }
        if (CollectionUtil.isEmpty(evaExpertTaskList = this.evaExpertTaskService.selectByEvaGroupIdAndStatus(evaExpertTask.getEvaGroupId(), "0", evaExpertTask.getEvaInfoId()))) {
            this.saveSummaryResult(evaExpertTask);
        }
    }

    private void saveSummaryResult(PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        List<SupplierEvaRankingVO> summaryEvaSupplierResultList = this.evaRegulationResultService.summaryEvaResult(evaExpertTask.getEvaInfoId(), evaExpertTask.getEvaGroupId());
        ArrayList<PurchaseTenderProjectBidEvaGroupSummaryResult> bidEvaGroupSummaryResultList = new ArrayList<PurchaseTenderProjectBidEvaGroupSummaryResult>();
        ArrayList<String> invalidSupplierAccountList = new ArrayList<String>();
        for (SupplierEvaRankingVO supplierEvaRankingVO : summaryEvaSupplierResultList) {
            PurchaseTenderProjectBidEvaGroupSummaryResult summaryResult = new PurchaseTenderProjectBidEvaGroupSummaryResult();
            SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = supplierEvaRankingVO.getResult().get(evaExpertTask.getEvaGroupId());
            summaryResult.setSupplierAccount(supplierEvaRankingVO.getSupplierAccount());
            summaryResult.setSupplierName(supplierEvaRankingVO.getSupplierName());
            summaryResult.setInvalid(supplierEvaRankingVO.getInvalid());
            summaryResult.setSubpackageId(evaExpertTask.getSubpackageId());
            summaryResult.setEvaInfoId(evaExpertTask.getEvaInfoId());
            summaryResult.setEvaGroupId(evaExpertTask.getEvaGroupId());
            summaryResult.setGroupOrderBy(supplierEvaRankingVO.getGroupOrder());
            summaryResult.setJudgesTaskHeadId(evaExpertTask.getHeadId());
            summaryResult.setTenderProjectId(evaExpertTask.getTenderProjectId());
            summaryResult.setEvaGroupType(evaGroupSummaryResult.getEvaGroupType());
            summaryResult.setScore(evaGroupSummaryResult.getTotalScore());
            summaryResult.setResult(evaGroupSummaryResult.getEvaGroupResult());
            summaryResult.setWeight(evaGroupSummaryResult.getWeight());
            summaryResult.setWeightScore(evaGroupSummaryResult.getWeightScore());
            summaryResult.setOrderBy(evaGroupSummaryResult.getOrderBy());
            summaryResult.setGroupOrderBy(evaGroupSummaryResult.getGroupOrder());
            summaryResult.setTotalQuote(evaGroupSummaryResult.getTotalQuote());
            summaryResult.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            summaryResult.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            summaryResult.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
            if ("1".equals(supplierEvaRankingVO.getInvalid())) {
                invalidSupplierAccountList.add(supplierEvaRankingVO.getSupplierAccount());
            }
            bidEvaGroupSummaryResultList.add(summaryResult);
        }
        this.tenderProjectSupplierService.updateInvalidStatusByMainId(evaExpertTask.getEvaInfoId(), invalidSupplierAccountList);
        this.supplierResultService.updateInvalidStatusByMainId(evaExpertTask.getEvaInfoId(), invalidSupplierAccountList);
        this.evaGroupSummaryResultService.deleteByMainId(evaExpertTask.getEvaInfoId(), evaExpertTask.getEvaGroupId());
        this.evaGroupSummaryResultService.saveBatch(bidEvaGroupSummaryResultList);
    }

    private void checkObjectiveEva(PurchaseTenderProjectEvaExpertTask evaExpertTask, PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList) {
        List<PurchaseTenderProjectEvaExpertTask> expertTaskList = this.evaExpertTaskService.selectByEvaGroupIdAndStatus(evaExpertTask.getEvaGroupId(), "1", evaExpertTask.getEvaInfoId());
        PurchaseTenderProjectEvaExpertTask expertTask = expertTaskList.get(0);
        String jugesAccount = expertTask.getJudgesElsAccount() + "_" + expertTask.getJudgesElsSubAccount();
        List resultList = this.evaRegulationResultService.selectByEvaInfoId(evaExpertTask.getEvaInfoId(), evaExpertTask.getEvaGroupId()).stream().filter(result -> jugesAccount.equals(result.getJudgesElsAccount() + "_" + result.getJudgesElsSubAccount())).collect(Collectors.toList());
        List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = evaluationGroupVO.getTenderEvaluationTemplateRegulationInfoList();
        List regulationInfoIdList = regulationInfoList.stream().filter(regulationInfo -> "1".equals(regulationInfo.getObjective())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(regulationInfoIdList)) {
            return;
        }
        Map regulationResultMap = regulationResultList.stream().filter(result -> regulationInfoIdList.contains(result.getRegulationId())).collect(Collectors.toMap(regulationResult -> regulationResult.getRegulationId() + "_" + regulationResult.getSupplierAccount(), Function.identity(), (o1, o2) -> o1));
        resultList = resultList.stream().filter(result -> regulationInfoIdList.contains(result.getRegulationId())).collect(Collectors.toList());
        for (PurchaseTenderProjectBidEvaRegulationResult regulationResult2 : resultList) {
            PurchaseTenderProjectBidEvaRegulationResult result2 = (PurchaseTenderProjectBidEvaRegulationResult)((Object)regulationResultMap.get(regulationResult2.getRegulationId() + "_" + regulationResult2.getSupplierAccount()));
            if (result2 == null) continue;
            if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaluationGroupVO.getGroupType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaluationGroupVO.getGroupType())) {
                Assert.isTrue((boolean)regulationResult2.getResult().equals(result2.getResult()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWLqRdWdjsuUUyRTsuIR_5bc8f7c6", (String)"[{0}]\u4e3a\u5ba2\u89c2\u9879\uff0c\u6240\u6709\u4e13\u5bb6\u8bc4\u5ba1\u7ed3\u679c\u9700\u4fdd\u6301\u4e00\u81f4", (String[])new String[]{regulationResult2.getRegulationName()}));
                continue;
            }
            Assert.isTrue((regulationResult2.getScore().compareTo(result2.getScore()) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_WWWWWWLqRdWdjsuUUyRTsuIR_5bc8f7c6", (String)"[{0}]\u4e3a\u5ba2\u89c2\u9879\uff0c\u6240\u6709\u4e13\u5bb6\u8bc4\u5ba1\u7ed3\u679c\u9700\u4fdd\u6301\u4e00\u81f4", (String[])new String[]{regulationResult2.getRegulationName()}));
        }
    }

    private List<PurchaseTenderProjectBidEvaRegulationResult> saveOrUpdateResult(List<PurchaseTenderProjectBidEvaRegulationResult> allRegulationResultList, PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        this.evaRegulationResultService.deleteByMainId(evaExpertTask.getEvaGroupId(), evaExpertTask.getId());
        this.evaRegulationResultService.saveBatch(allRegulationResultList, 1000);
        return allRegulationResultList.stream().filter(result -> StringUtils.isNotBlank((CharSequence)result.getRegulationId()) && StringUtils.isNotBlank((CharSequence)result.getMaterialId())).collect(Collectors.toList());
    }

    private List<PurchaseTenderProjectBidEvaRegulationResult> getRegulationResultList(List<SupplierVO> supplierList, PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> allRegulationResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = this.getPurchaseTenderBidLetterFormatGroup(evaExpertTask.getSubpackageId());
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaExpertTask.getEvaGroupId());
        LoginUser loginUser = SysUtil.getLoginUser();
        for (SupplierVO supplierResultVO : supplierList) {
            List<PurchaseTenderProjectBidEvaRegulationResultVO> resultList = supplierResultVO.getBidEvaRegulationResultList();
            if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType()) && (TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaluationGroupVO.getGroupType()) || TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaluationGroupVO.getGroupType()))) {
                resultList.stream().forEach(bidEvaRegulationResultVo -> {
                    List<PurchaseTenderProjectBidEvaRegulationResultVO> supplierMaterialList = bidEvaRegulationResultVo.getSupplierMaterialList();
                    ArrayList temp = SysUtil.copyProperties(supplierMaterialList, PurchaseTenderProjectBidEvaRegulationResult.class);
                    allRegulationResultList.addAll(temp);
                });
            } else {
                ArrayList arrayList = SysUtil.copyProperties(resultList, PurchaseTenderProjectBidEvaRegulationResult.class);
                allRegulationResultList.addAll(arrayList);
            }
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : allRegulationResultList) {
                regulationResult.setId(IdWorker.getIdStr());
                regulationResult.setJudgesName(loginUser.getRealname());
                regulationResult.setJudgesElsSubAccount(loginUser.getSubAccount());
                regulationResult.setJudgesElsAccount(loginUser.getElsAccount());
                if (StringUtils.isBlank((CharSequence)regulationResult.getInvalid())) {
                    regulationResult.setInvalid("0");
                }
                regulationResult.setJudgesTaskHeadId(evaExpertTask.getHeadId());
                regulationResult.setJudgesTaskItemId(evaExpertTask.getId());
                regulationResult.setEvaInfoId(evaExpertTask.getEvaInfoId());
            }
        }
        return allRegulationResultList;
    }

    @Override
    public boolean isEvaFinish(String evaInfoId) {
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectByEvaInfoId(evaInfoId);
        long count = bidEvaGroupResultList.parallelStream().filter(result -> "0".equals(result.getEvaGroupStatus())).count();
        return count == 0L;
    }

    @Override
    public EvaResultVO getSupplierEvaRanking(String evaInfoId) {
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectByEvaInfoId(evaInfoId);
        long count = bidEvaGroupResultList.parallelStream().filter(result -> "0".equals(result.getEvaGroupStatus())).count();
        Assert.isTrue((!bidEvaGroupResultList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UULSxMKW_5f300cc7", (String)"\u8bc4\u5ba1\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_MKLMLjUULSW_dba0bdb8", (String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8bc4\u5ba1\u4efb\u52a1!"));
        PurchaseTenderProjectEvaExpertTask expertTask = bidEvaGroupResultList.get(0);
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(expertTask.getEvaGroupId());
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.bidLetterFormatGroupService.selectByMainId(evaluationGroupVO.getHeadId());
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        EvaResultVO evaResultVO = new EvaResultVO();
        evaResultVO.setBidLetterFormatGroup(bidLetterFormatGroup);
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        List<String> evaInfoIdList = new ArrayList<String>();
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            List<PurchaseTenderProjectEvaInfo> evaInfoList = this.evaInfoService.selectBySubpackageId(expertTask.getSubpackageId(), TenderFlagInjectionContext.getTenderCheckType());
            evaInfoIdList = evaInfoList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isEmpty(evaInfoIdList)) {
            evaInfoIdList.add(evaInfoId);
        }
        List<SupplierEvaRankingVO> supplierEvaRankingList = this.evaGroupSummaryResultService.getSupplierEvaRanking(evaInfoIdList);
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            TenderFlagInjectionContext.setTenderCurrentStep(null);
        }
        List<TenderProjectSupplier> supplierList = this.tenderProjectSupplierService.getDecryptSupplier(evaluationGroupVO.getSubpackageId(), null, null);
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            List<EvaGroupVO> evaGroupVOList = this.evaSettingHeadService.queryEvaGroupBySubpackageId(expertTask.getSubpackageId(), "1");
            Map supplierEvaRankingVOMap = supplierEvaRankingList.stream().collect(Collectors.toMap(SupplierEvaRankingVO::getSupplierAccount, Function.identity()));
            List<Object> groupName = new ArrayList();
            for (TenderProjectSupplier supplier : supplierList) {
                SupplierEvaRankingVO supplierEvaRankingVO = (SupplierEvaRankingVO)supplierEvaRankingVOMap.get(supplier.getSupplierAccount());
                if (supplierEvaRankingVO == null || "1".equals(supplierEvaRankingVO.getInvalid())) continue;
                groupName.clear();
                if (supplierEvaRankingVO == null) {
                    groupName = evaGroupVOList.stream().map(EvaGroupVO::getName).collect(Collectors.toList());
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_RdXWWWWWRRUBSyWWWWWjMkyRWVImW_b5f5ef11", (String)"\u4f9b\u5e94\u5546\u3010{0}\u3011\u7f3a\u5c11\u8bc4\u6807\u73af\u8282\u3010{1}\u3011\u7684\u6c47\u603b\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\uff01", (String[])new String[]{supplier.getSupplierName(), StringUtils.join(groupName, (String)",")}));
                }
                Set<String> groupIds = supplierEvaRankingVO.getResult().keySet();
                Iterator iterator = evaGroupVOList.iterator();
                while (iterator.hasNext()) {
                    EvaGroupVO evaGroupVO = (EvaGroupVO)iterator.next();
                    if (groupIds.contains(evaGroupVO.getId())) continue;
                    groupName.add(evaGroupVO.getName());
                }
                if (!CollectionUtil.isNotEmpty(groupName)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_RdXWWWWWRRUBSyWWWWWjMkyRWVImW_b5f5ef11", (String)"\u4f9b\u5e94\u5546\u3010{0}\u3011\u7f3a\u5c11\u8bc4\u6807\u73af\u8282\u3010{1}\u3011\u7684\u6c47\u603b\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\uff01", (String[])new String[]{supplier.getSupplierName(), StringUtils.join(groupName, (String)",")}));
            }
        }
        for (SupplierEvaRankingVO supplierEvaRankingVO : supplierEvaRankingList) {
            Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> result2;
            supplierEvaRankingVO.setCandidate("0");
            supplierEvaRankingVO.setTotalScore(supplierEvaRankingVO.getTotalScore().setScale(summaryScorePrecision, 4));
            if (supplierEvaRankingVO.getWeightScore() != null) {
                supplierEvaRankingVO.setWeightScore(supplierEvaRankingVO.getWeightScore().setScale(summaryScorePrecision, 4));
            }
            if ((result2 = supplierEvaRankingVO.getResult()) == null) continue;
            for (SupplierEvaRankingVO.EvaGroupSummaryResult value : result2.values()) {
                if (value.getTotalScore() != null) {
                    value.setTotalScore(value.getTotalScore().setScale(summaryScorePrecision, 4));
                }
                if (value.getWeightScore() != null) {
                    value.setWeightScore(value.getWeightScore().setScale(summaryScorePrecision, 4));
                }
                if (value.getTotalQuote() == null) continue;
                value.setTotalQuote(value.getTotalQuote().setScale(summaryScorePrecision, 4));
            }
        }
        List<PurchaseTenderProjectBidWinningCandidate> winningCandidates = this.bidWinningCandidateService.selectByEvaInfoId(evaInfoId);
        if (winningCandidates.isEmpty()) {
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType) || SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
                ShortlistedRulesEnum shortlistedRulesEnum;
                ShortlistedRulesStrategy rulesStrategy;
                PurchaseTenderProjectEvaExpertTask purchaseTenderProjectEvaExpertTask;
                LoginUser loginUser = SysUtil.getLoginUser();
                List expertTasks = bidEvaGroupResultList.stream().filter(evaExpertTask -> {
                    String judgesAccount = evaExpertTask.getJudgesElsAccount() + "_" + evaExpertTask.getJudgesElsSubAccount();
                    String currentUser = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
                    return currentUser.equals(judgesAccount);
                }).collect(Collectors.toList());
                if (!expertTasks.isEmpty() && "1".equals((purchaseTenderProjectEvaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)expertTasks.get(0))).getJudgesGroupLeader()) && StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getShortlistedRules()) && (rulesStrategy = (ShortlistedRulesStrategy)SpringContextUtils.getBean((String)(shortlistedRulesEnum = ShortlistedRulesEnum.getPurchaseTenderShortlistedRulesEnum(evaluationPrinciples.getShortlistedRules())).getBeanName(), ShortlistedRulesStrategy.class)) != null) {
                    rulesStrategy.execute(evaluationPrinciples, supplierEvaRankingList);
                }
            }
        } else {
            Map<String, PurchaseTenderProjectBidWinningCandidate> winningCandidateMap = winningCandidates.parallelStream().collect(Collectors.toMap(PurchaseTenderProjectBidWinningCandidate::getSupplierAccount, bidWinningCandidate -> bidWinningCandidate, (o1, o2) -> o1));
            supplierEvaRankingList.parallelStream().forEach(supplierEvaRanking -> supplierEvaRanking.setCandidate(winningCandidateMap.containsKey(supplierEvaRanking.getSupplierAccount()) ? "1" : "0"));
        }
        evaResultVO.setSupplierEvaRanking(supplierEvaRankingList);
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList = this.evaBidAttachmentInfoService.selectByEvaInfoId(evaInfoId);
        evaResultVO.setEvaBidAttachmentInfoList(evaBidAttachmentInfoList);
        return evaResultVO;
    }

    @Override
    @SrmTransaction
    public void saveEvaResult(EvaResultVO evaResultVO) {
        boolean flag;
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList = evaResultVO.getEvaBidAttachmentInfoList();
        List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidateList = evaResultVO.getBidWinningCandidateList();
        Assert.isTrue((!bidWinningCandidateList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__YIRdXxOLVW_9d450bac", (String)"\u63a8\u8350\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        String evaInfoId = bidWinningCandidateList.get(0).getEvaInfoId();
        String subpackageId = bidWinningCandidateList.get(0).getSubpackageId();
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        List evaHeadList = this.selectByMainId(evaInfoId).stream().filter(evaHead -> "1".equals(evaHead.getJudgesGroupLeader())).collect(Collectors.toList());
        PurchaseTenderProjectBidEvaHead projectBidEvaHead = (PurchaseTenderProjectBidEvaHead)((Object)evaHeadList.get(0));
        bidWinningCandidateList = bidWinningCandidateList.stream().filter(bidWinningCandidate -> !"1".equals(bidWinningCandidate.getInvalid())).collect(Collectors.toList());
        bidWinningCandidateList.forEach(bidWinningCandidate -> {
            bidWinningCandidate.setCheckType(tenderCheckType);
            bidWinningCandidate.setProcessType(tenderProcessType);
            bidWinningCandidate.setCurrentStep(tenderCurrentStep);
            bidWinningCandidate.setSubpackageId(subpackageInfo.getId());
            bidWinningCandidate.setTenderProjectId(subpackageInfo.getHeadId());
            bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.NEW.getValue());
        });
        this.bidWinningCandidateService.deleteByMainId(evaInfoId);
        this.bidWinningCandidateService.saveBatch(bidWinningCandidateList, 1000);
        if (!evaBidAttachmentInfoList.isEmpty()) {
            evaBidAttachmentInfoList.forEach(bidAttachmentInfo -> {
                bidAttachmentInfo.setCheckType(tenderCheckType);
                bidAttachmentInfo.setEvaInfoId(evaInfoId);
                bidAttachmentInfo.setHeadId(projectBidEvaHead.getId());
                bidAttachmentInfo.setSubpackageId(subpackageId);
                bidAttachmentInfo.setTenderProjectId(subpackageInfo.getHeadId());
                bidAttachmentInfo.setProcessType(tenderProcessType);
                bidAttachmentInfo.setCurrentStep(tenderCurrentStep);
            });
            this.evaBidAttachmentInfoService.deleteByMainId(evaInfoId);
            this.evaBidAttachmentInfoService.saveBatch(evaBidAttachmentInfoList, 1000);
            List<PurchaseAttachmentDTO> purchaseAttachmentDTOList = this.buildPurchaseAttachment(evaBidAttachmentInfoList);
            ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, evaInfoId, subpackageId, subpackageInfo.getHeadId(), TenderProjectArchiveAttachmentEnum.PROJECT_JURY_PREFIX.getValue());
        }
        if ("1".equals(evaResultVO.getSave())) {
            return;
        }
        List<String> shortlistedSupplierAccountList = bidWinningCandidateList.stream().map(PurchaseTenderProjectBidWinningCandidate::getSupplierAccount).collect(Collectors.toList());
        this.tenderProjectSupplierService.updateShortlistedStatus(subpackageId, shortlistedSupplierAccountList);
        List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = this.selectBySubpackageId(subpackageId);
        for (PurchaseTenderProjectBidEvaHead bidEvaHead : bidEvaHeadList) {
            bidEvaHead.setEvaStatus(PurchaseTenderProjectBidEvaStatusEnum.BID_EVA_END.getValue());
        }
        this.updateBatchById(bidEvaHeadList);
        if (StringUtils.isNotBlank((CharSequence)evaInfoId)) {
            PurchaseTenderProjectEvaInfo purchaseTenderProjectEvaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)evaInfoId)));
            purchaseTenderProjectEvaInfo.setEvaStatus(PurchaseTenderProjectBidEvaStatusEnum.BID_EVA_END.getValue());
            purchaseTenderProjectEvaInfo.setEvaBidEndTime(new Date());
            this.evaInfoService.updateById((Object)purchaseTenderProjectEvaInfo);
        }
        Integer subpackageStatus = TenderOperationFieldUtils.getEndEvaBidSubpackageStatus();
        boolean bl = flag = SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(tenderCurrentStep);
        if (flag && PurchaseOpenBidStatusEnum.END_BID.getValue().equals(subpackageInfo.getResultOpenBidStatus())) {
            subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.RE_FIRST_STEP_BID_EVA_END.getValue());
        } else {
            subpackageInfo.setStatus(subpackageStatus);
        }
        this.subpackageInfoService.updateById((Object)subpackageInfo);
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectByEvaInfoId(evaInfoId);
        Set judgesGroupLeaderSet = bidEvaGroupResultList.stream().filter(item -> "1".equals(item.getJudgesGroupLeader())).map(item -> item.getJudgesName() + "_" + item.getJudgesElsSubAccount()).collect(Collectors.toSet());
        Set expertAccountSet = bidEvaGroupResultList.parallelStream().map(PurchaseTenderProjectEvaExpertTask::getJudgesElsSubAccount).collect(Collectors.toSet());
        PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
        List specialistInfoList = ((LambdaQueryChainWrapper)this.specialistInfoService.lambdaQuery().in(SpecialistInfo::getSubAccount, expertAccountSet)).list();
        LoginUser user = SysUtil.getLoginUser();
        ArrayList<SpecialistHistoryBiddingInfo> biddingInfoList = new ArrayList<SpecialistHistoryBiddingInfo>();
        for (SpecialistInfo specialistInfo : specialistInfoList) {
            SpecialistHistoryBiddingInfo biddingInfo = new SpecialistHistoryBiddingInfo();
            biddingInfo.setBiddingNumber(subpackageInfo.getSubpackageNumber());
            biddingInfo.setBiddingName(subpackageInfo.getSubpackageName());
            biddingInfo.setBiddingStatus("4");
            biddingInfo.setPurchaseName(projectBidEvaHead.getPurchaseEnterpriseName());
            biddingInfo.setBiddingDate(projectBidEvaHead.getCreateTime());
            biddingInfo.setEvaluationBiddingDate(new Date());
            biddingInfo.setPurchaseName(user.getEnterpriseName());
            biddingInfo.setCompany(projectHead.getCompany());
            biddingInfo.setEvaluationLeader(CollectionUtil.isNotEmpty(judgesGroupLeaderSet) ? CollectionUtil.join(judgesGroupLeaderSet, (CharSequence)";") : null);
            biddingInfo.setElsAccount(specialistInfo.getElsAccount());
            biddingInfo.setSubAccount(specialistInfo.getSubAccount());
            biddingInfo.setHeadId(specialistInfo.getId());
            biddingInfoList.add(biddingInfo);
        }
        this.specialistHistoryBiddingInfoService.saveBatch(biddingInfoList);
    }

    private List<PurchaseAttachmentDTO> buildPurchaseAttachment(List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList) {
        List<PurchaseAttachmentDTO> attachmentDTOList = evaBidAttachmentInfoList.stream().map(info -> {
            PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
            purchaseAttachmentDTO.setId(info.getAttachmentId());
            purchaseAttachmentDTO.setHeadId(info.getHeadId());
            purchaseAttachmentDTO.setFileType(info.getFileType());
            purchaseAttachmentDTO.setFileName(info.getFileName());
            purchaseAttachmentDTO.setUploadElsAccount(info.getElsAccount());
            purchaseAttachmentDTO.setUploadSubAccount(info.getUpdateBy());
            return purchaseAttachmentDTO;
        }).collect(Collectors.toList());
        return attachmentDTOList;
    }

    @Override
    public List<PurchaseTenderProjectBidEvaHead> selectBySubpackageId(String subpackageId) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep);
        return bidEvaHeadList;
    }

    @Override
    @SrmTransaction
    public void deleteBySubpackageId(String subpackageId) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).deleteBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResultVO> priceScoreCalculation(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList) {
        PurchaseTenderProjectBidEvaRegulationResultVO resultVO = regulationCalList.get(0);
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(resultVO.getEvaGroupId());
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.bidLetterFormatGroupService.selectByMainId(evaluationGroupVO.getHeadId());
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        PurchaseTenderControlPriceHeadVO controlPriceHeadVO = this.controlPriceHeadService.selectBySubpackageId(priceRegulationInfo.getSubpackageId());
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType())) {
            ArrayList resultAllList = new ArrayList();
            regulationCalList.stream().forEach(regulationVO -> resultAllList.addAll(regulationVO.getSupplierMaterialList()));
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> regulationCalListByMaterialId = resultAllList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getMaterialId));
            HashSet<String> invalidSupplierAccount = new HashSet<String>();
            for (List<PurchaseTenderProjectBidEvaRegulationResultVO> value : regulationCalListByMaterialId.values()) {
                ArrayList temp = SysUtil.copyProperties(value, PurchaseTenderProjectBidEvaRegulationResultVO.class);
                List<PurchaseTenderProjectBidEvaRegulationResultVO> controlResultList = this.controlPriceHandler(controlPriceHeadVO, evaluationGroupVO, summaryScorePrecision, temp, Collections.emptySet());
                Set supplierAccount = controlResultList.stream().filter(vo -> "1".equals(vo.getInvalid())).map(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount).collect(Collectors.toSet());
                if (!CollectionUtil.isNotEmpty(supplierAccount)) continue;
                invalidSupplierAccount.addAll(supplierAccount);
            }
            for (List<PurchaseTenderProjectBidEvaRegulationResultVO> value : regulationCalListByMaterialId.values()) {
                List<PurchaseTenderProjectBidEvaRegulationResultVO> controlResultList = this.controlPriceHandler(controlPriceHeadVO, evaluationGroupVO, summaryScorePrecision, value, invalidSupplierAccount);
                this.priceScoreCalculate(value, evaluationGroupVO, evaluationPrinciples, priceRegulationInfo);
                if (!CollectionUtil.isNotEmpty(controlResultList)) continue;
                value.addAll(controlResultList);
            }
            Map resultVOMap = regulationCalList.stream().collect(Collectors.toMap(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount, Function.identity()));
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> supplierAccountEvaRegulationListMap = resultAllList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
            regulationCalList.clear();
            for (String key : supplierAccountEvaRegulationListMap.keySet()) {
                PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = (PurchaseTenderProjectBidEvaRegulationResultVO)((Object)resultVOMap.get(key));
                regulationResultVO.setInvalid("0");
                List<PurchaseTenderProjectBidEvaRegulationResultVO> supplierMaterialList = supplierAccountEvaRegulationListMap.get(key);
                this.calMaterialListTotalScore(summaryScorePrecision, regulationResultVO, supplierMaterialList);
                if (invalidSupplierAccount.contains(key)) {
                    regulationResultVO.setInvalid("1");
                }
                regulationCalList.add(regulationResultVO);
            }
            return regulationCalList;
        }
        List<PurchaseTenderProjectBidEvaRegulationResultVO> controlResultList = this.controlPriceHandler(controlPriceHeadVO, evaluationGroupVO, summaryScorePrecision, regulationCalList, Collections.emptySet());
        this.priceScoreCalculate(regulationCalList, evaluationGroupVO, evaluationPrinciples, priceRegulationInfo);
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            regulationResultVO.setScore(regulationResultVO.getScore().setScale(summaryScorePrecision, 4));
            regulationResultVO.setWeightScore(regulationResultVO.getWeightScore().setScale(summaryScorePrecision, 4));
            regulationResultVO.setBasePrice(regulationResultVO.getBasePrice().setScale(6, 4));
            regulationResultVO.setEvaPrice(regulationResultVO.getEvaPrice().setScale(6, 4));
            regulationResultVO.setQuote(regulationResultVO.getQuote().setScale(6, 4));
        }
        if (CollectionUtil.isNotEmpty(controlResultList)) {
            regulationCalList.addAll(controlResultList);
        }
        return regulationCalList;
    }

    private List<PurchaseTenderProjectBidEvaRegulationResultVO> controlPriceHandler(PurchaseTenderControlPriceHeadVO controlPriceHeadVO, PurchaseTenderEvaluationGroupVO evaluationGroupVO, int summaryScorePrecision, List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, Set<String> invalidSupplierAccount) {
        if (controlPriceHeadVO == null) {
            return Collections.emptyList();
        }
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        String quoteColumnName = priceRegulationInfo.getQuoteColumnName();
        String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
        String quoteType = controlPriceHeadVO.getQuoteType();
        PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = regulationCalList.get(0);
        List<PurchaseTenderControlPriceSetting> priceSettingList = controlPriceHeadVO.getControlPriceSettingList().stream().filter(controlPriceSetting -> {
            boolean flag;
            boolean bl = flag = tenderBidLetterId.equals(controlPriceSetting.getTenderBidLetterId()) && quoteColumnName.equals(controlPriceSetting.getQuoteColumnField());
            if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(quoteType)) {
                return controlPriceSetting.getMaterialId().equals(regulationResultVO.getMaterialId()) && flag;
            }
            return flag;
        }).filter(controlPriceSetting -> controlPriceSetting.getHighestPrice() != null || controlPriceSetting.getLowestPrice() != null).collect(Collectors.toList());
        ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> result = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
        Iterator<PurchaseTenderProjectBidEvaRegulationResultVO> iterator = regulationCalList.iterator();
        while (iterator.hasNext()) {
            PurchaseTenderProjectBidEvaRegulationResultVO next = iterator.next();
            if (invalidSupplierAccount.contains(next.getSupplierAccount())) {
                next.setBasePrice(BigDecimal.ZERO);
                next.setInvalid("1");
                next.setScore(BigDecimal.ZERO.setScale(summaryScorePrecision, 4));
                next.setWeightScore(BigDecimal.ZERO.setScale(summaryScorePrecision, 4));
                result.add(next);
                iterator.remove();
                continue;
            }
            if (!this.handlerControlPriceStrategy(controlPriceHeadVO, priceSettingList, next)) continue;
            if (TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaluationGroupVO.getGroupType())) {
                next.setInvalid("1");
            }
            next.setBasePrice(BigDecimal.ZERO);
            next.setScore(BigDecimal.ZERO.setScale(summaryScorePrecision, 4));
            next.setWeightScore(BigDecimal.ZERO.setScale(summaryScorePrecision, 4));
            result.add(next);
            iterator.remove();
        }
        return result;
    }

    private boolean handlerControlPriceStrategy(PurchaseTenderControlPriceHeadVO controlPriceHeadVO, List<PurchaseTenderControlPriceSetting> priceSettingList, PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO) {
        String aboveHighPriceStrategy = controlPriceHeadVO.getAboveHighPriceStrategy();
        String belowThePriceStrategy = controlPriceHeadVO.getBelowThePriceStrategy();
        BigDecimal quote = regulationResultVO.getQuote();
        for (PurchaseTenderControlPriceSetting priceSetting : priceSettingList) {
            if (priceSetting.getHighestPrice() != null) {
                if ("0".equals(aboveHighPriceStrategy)) {
                    if (quote.compareTo(priceSetting.getHighestPrice()) == 1) {
                        regulationResultVO.setInvalid("1");
                        return true;
                    }
                } else if (quote.compareTo(priceSetting.getHighestPrice()) == 1) {
                    regulationResultVO.setInvalid("0");
                    return true;
                }
            }
            if (priceSetting.getLowestPrice() == null) continue;
            if ("0".equals(belowThePriceStrategy)) {
                if (quote.compareTo(priceSetting.getLowestPrice()) != -1) continue;
                regulationResultVO.setInvalid("1");
                return true;
            }
            if (quote.compareTo(priceSetting.getLowestPrice()) != -1) continue;
            regulationResultVO.setInvalid("0");
            return true;
        }
        return false;
    }

    private void priceScoreCalculate(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderEvaluationPrinciples evaluationPrinciples, PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo) {
        if (CollectionUtil.isEmpty(regulationCalList)) {
            return;
        }
        regulationCalList.parallelStream().forEach(evaSupplierResultVO -> {
            BigDecimal priceCorrection = evaSupplierResultVO.getPriceCorrection() == null ? BigDecimal.valueOf(0L) : evaSupplierResultVO.getPriceCorrection();
            evaSupplierResultVO.setEvaPrice(evaSupplierResultVO.getQuote().add(priceCorrection));
        });
        this.calBasePrice(regulationCalList, priceRegulationInfo);
        TemplatePriceStrategy priceStrategy = null;
        priceStrategy = TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaluationGroupVO.getGroupType()) && StringUtils.isNotBlank((CharSequence)priceRegulationInfo.getPricePointsCalFormula()) ? (TemplatePriceStrategy)SpringContextUtils.getBean((String)priceRegulationInfo.getPricePointsCalFormula(), TemplatePriceStrategy.class) : (TemplatePriceStrategy)SpringContextUtils.getBean((String)PricePointsCalFormualEnum.OPERATION_PRICE_COMPARISON_STRATEGY.getValue(), TemplatePriceStrategy.class);
        priceStrategy.priceScoreCalculate(regulationCalList, evaluationGroupVO, evaluationPrinciples);
    }

    private void calMaterialListTotalScore(int summaryScorePrecision, PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO, List<PurchaseTenderProjectBidEvaRegulationResultVO> supplierMaterialList) {
        BigDecimal totalScore = BigDecimal.ZERO;
        BigDecimal weightScore = BigDecimal.ZERO;
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResult : supplierMaterialList) {
            BigDecimal itemScore = regulationResult.getScore() == null ? BigDecimal.ZERO : regulationResult.getScore();
            BigDecimal itemWeightScore = itemScore.multiply(regulationResult.getWeight()).divide(BigDecimal.valueOf(100L), 20, 4);
            totalScore = totalScore.add(itemScore);
            weightScore = weightScore.add(itemWeightScore);
            regulationResult.setScore(itemScore.setScale(summaryScorePrecision, 4));
            regulationResult.setWeightScore(itemWeightScore.setScale(summaryScorePrecision, 4));
            if (regulationResult.getBasePrice() != null) {
                regulationResult.setBasePrice(regulationResult.getBasePrice().setScale(6, 4));
            }
            if (regulationResult.getEvaPrice() != null) {
                regulationResult.setEvaPrice(regulationResult.getEvaPrice().setScale(6, 4));
            }
            if (regulationResult.getQuote() == null) continue;
            regulationResult.setQuote(regulationResult.getQuote().setScale(6, 4));
        }
        BigDecimal proportionRate = BigDecimal.valueOf(1L).divide(BigDecimal.valueOf(supplierMaterialList.size()), 20, 4);
        regulationResultVO.setScore(totalScore.multiply(proportionRate).setScale(summaryScorePrecision, 4));
        regulationResultVO.setWeightScore(weightScore.multiply(proportionRate).setScale(summaryScorePrecision, 4));
        regulationResultVO.setSupplierMaterialList(supplierMaterialList);
    }

    private PurchaseTenderBidLetterFormatGroup getPurchaseTenderBidLetterFormatGroup(String subpackageId) {
        PurchaseTenderProjectAttachmentHead attachmentHead = this.attachmentHeadService.getAttachmentHeadBySubpackageId(subpackageId);
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.bidLetterFormatGroupService.selectByMainId(attachmentHead.getId());
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        return bidLetterFormatGroup;
    }

    private void calBasePrice(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo) {
        BigDecimal basePrice = BigDecimal.ZERO;
        String baseCalRules = priceRegulationInfo.getBaseCalRules();
        if ("0".equals(baseCalRules)) {
            BigDecimal minQuote = BigDecimal.valueOf(Integer.MAX_VALUE);
            for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
                if (minQuote.compareTo(regulationResultVO.getEvaPrice()) < 0) continue;
                minQuote = regulationResultVO.getEvaPrice();
            }
            basePrice = minQuote;
        } else {
            for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
                basePrice = basePrice.add(regulationResultVO.getEvaPrice());
            }
            basePrice = basePrice.divide(new BigDecimal(regulationCalList.size()), 20, 4);
        }
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            regulationResultVO.setBasePrice(basePrice);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void termination(PurchaseTenderProjectBidEvaHead bidEvaHead) {
        List<PurchaseTenderProjectBidEvaHead> evaHeadList = ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectByEvaInfoId(bidEvaHead.getEvaInfoId());
        Assert.isTrue((!evaHeadList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UULSxMKW_5f300cc7", (String)"\u8bc4\u5ba1\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)PurchaseTenderProjectBidEvaStatusEnum.UNDER_BID_EVA.getValue().equals(evaHeadList.get(0).getEvaStatus()), (String)I18nUtil.translate((String)"i18n_alert_UBIsRWxiTHcUUWNTVVUBWqjnRRcLHcWVVUBWtkW_3bcf8f", (String)"\u8bc4\u6807\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8bc4\u5ba1\u3002\u5982\u9700\u91cd\u65b0\u8bc4\u6807\uff0c\u53ef\u7531\u91c7\u8d2d\u6267\u884c\u4eba\u8fdb\u884c\u201c\u91cd\u65b0\u8bc4\u6807\u201d\u64cd\u4f5c\u3002"));
        Assert.isTrue((boolean)"1".equals(this.projectHeadService.getExecutorAuthority(evaHeadList.get(0).getTenderProjectId())), (String)I18nUtil.translate((String)"i18n_alert_APeyBjbWtkW_413583d2", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c!"));
        evaHeadList.stream().forEach(item -> item.setEvaStatus(PurchaseTenderProjectBidEvaStatusEnum.BID_EVA_TERMINATION.getValue()));
        this.updateBatchById(evaHeadList);
        List<PurchaseTenderProjectEvaExpertTask> evaExpertTaskList = this.evaExpertTaskService.selectByEvaInfoId(bidEvaHead.getEvaInfoId());
        evaExpertTaskList.stream().forEach(item -> item.setTerminate("1"));
        this.evaExpertTaskService.updateBatchById(evaExpertTaskList);
        String evaInfoId = evaExpertTaskList.get(0).getEvaInfoId();
        if (StringUtils.isNotBlank((CharSequence)evaInfoId)) {
            PurchaseTenderProjectEvaInfo purchaseTenderProjectEvaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)evaInfoId)));
            purchaseTenderProjectEvaInfo.setEvaStatus(PurchaseTenderProjectBidEvaStatusEnum.BID_EVA_TERMINATION.getValue());
            this.evaInfoService.updateById((Object)purchaseTenderProjectEvaInfo);
            List<TenderEvaQuotedPriceItem> evaQuotedPriceItemList = this.tenderEvaQuotedPriceItemService.selectByEvaInfoId(evaInfoId, null);
            List<String> quotedPriceItemIdList = evaQuotedPriceItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.saleTenderPriceOpeningsService.removeByQuotedPriceItemIdList(quotedPriceItemIdList);
        }
        Integer subpackageStatus = TenderOperationFieldUtils.getTerminationEvaBidSubpackageStatus();
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)evaHeadList.get(0)).subpackageId(bidEvaHead.getSubpackageId()).subpackageStatus(subpackageStatus + "").build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    public void terminationBySubpackageInfo(String subpackageId) {
        ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).updateTerminatBySubpackageId(subpackageId);
        this.evaExpertTaskService.updateTerminatBySubpackageId(subpackageId);
        this.evaInfoService.updateTerminatBySubpackageId(subpackageId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reEvaluate(PurchaseTenderProjectBidEvaHead bidEvaHead) {
        List<PurchaseTenderProjectBidEvaHead> evaHeadList = ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectByEvaInfoId(bidEvaHead.getEvaInfoId());
        Assert.isTrue((!evaHeadList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UULSxMKW_5f300cc7", (String)"\u8bc4\u5ba1\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)PurchaseTenderProjectBidEvaStatusEnum.BID_EVA_TERMINATION.getValue().equals(evaHeadList.get(0).getEvaStatus()), (String)I18nUtil.translate((String)"i18n_alert_UBIsRWxiTHcUUWNTVVUBWqjnRRcLHcWVVUBWtkW_3bcf8f", (String)"\u8bc4\u6807\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8bc4\u5ba1\u3002\u5982\u9700\u91cd\u65b0\u8bc4\u6807\uff0c\u53ef\u7531\u91c7\u8d2d\u6267\u884c\u4eba\u8fdb\u884c\u201c\u91cd\u65b0\u8bc4\u6807\u201d\u64cd\u4f5c\u3002"));
        PurchaseTenderProjectHeadVO tenderProjectHeadVO = this.projectHeadService.queryProjectHeadBySubpackageId(bidEvaHead.getSubpackageId());
        Assert.isTrue((boolean)"1".equals(this.projectHeadService.getExecutorAuthority(evaHeadList.get(0).getTenderProjectId())), (String)I18nUtil.translate((String)"i18n_alert_APeyBjbWtkW_413583d2", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c!"));
        PurchaseTenderProjectBidEvaHead evaHead = evaHeadList.get(0);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(evaHead.getCheckType())) {
            TenderFlagInjectionContext.setTenderCheckType(evaHead.getCheckType());
            List<TenderProjectSupplier> tenderProjectSupplier = this.tenderProjectSupplierService.getDecryptSupplier(bidEvaHead.getSubpackageId(), null, "1");
            for (TenderProjectSupplier tenderProjectSupplier2 : tenderProjectSupplier) {
                tenderProjectSupplier2.setInvalid("0");
            }
            this.tenderProjectSupplierService.updateBatchById(tenderProjectSupplier);
        } else {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(TenderProjectSupplier::getInvalid, (Object)"1")).eq(TenderProjectSupplier::getSubpackageId, (Object)bidEvaHead.getSubpackageId())).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.and(wrapper1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper1.eq(TenderProjectSupplier::getDecrypt, (Object)"1");
                })).or(wrapper2 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper2.eq(TenderProjectSupplier::getResultDecrypt, (Object)"1");
                });
            });
            List tenderProjectSupplier = this.tenderProjectSupplierService.list((Wrapper)lambdaQueryWrapper);
            for (TenderProjectSupplier supplier : tenderProjectSupplier) {
                supplier.setInvalid("0");
            }
            this.tenderProjectSupplierService.updateBatchById(tenderProjectSupplier);
        }
        List subpackageInfoVOS = tenderProjectHeadVO.getSubpackageInfoVOList().stream().filter(subpackageInfo -> subpackageInfo.getId().equals(bidEvaHead.getSubpackageId())).collect(Collectors.toList());
        PurchaseTenderProjectSubpackageInfoVO subpackageInfoVO = (PurchaseTenderProjectSubpackageInfoVO)((Object)subpackageInfoVOS.get(0));
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(subpackageInfoVO.getCheckType())) {
            TenderFlagInjectionContext.setTenderProcessType(null);
            TenderFlagInjectionContext.setTenderCurrentStep(null);
        }
        PurchaseTenderProjectEvaInfoVO purchaseTenderProjectEvaInfoVO = this.evaSettingHeadService.queryBySubpackageId(bidEvaHead.getSubpackageId());
        List<PurchaseTenderProjectEvaSettingHeadVO> settingHeadVOList = purchaseTenderProjectEvaInfoVO.getHeadVOList();
        ArrayList evaSettingHeadList = SysUtil.copyProperties(settingHeadVOList, PurchaseTenderProjectEvaSettingHead.class);
        evaSettingHeadList.stream().forEach(evaSettingHead -> evaSettingHead.setHeadStatus("0"));
        this.evaSettingHeadService.updateBatchById(evaSettingHeadList);
        Integer subpackageStatus = TenderOperationFieldUtils.getReEvaBidSubpackageStatus();
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)evaHeadList.get(0)).subpackageId(bidEvaHead.getSubpackageId()).subpackageStatus(subpackageStatus + "").build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    public OfflineBidEvaluationVO queryOfflineBidEvaluationBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectEvaInfo> evaInfoList = this.evaInfoService.selectBySubpackageId(subpackageId);
        OfflineBidEvaluationVO offlineBidEvaluationVO = new OfflineBidEvaluationVO();
        if (CollectionUtil.isEmpty(evaInfoList)) {
            PurchaseTenderProjectInfoVO projectInfoVO = this.projectHeadService.queryProjectInfoBySubpackageId(subpackageId);
            offlineBidEvaluationVO.setTenderProjectName(projectInfoVO.getTenderProjectName());
            offlineBidEvaluationVO.setTenderProjectNumber(projectInfoVO.getTenderProjectNumber());
            offlineBidEvaluationVO.setSubpackageName(projectInfoVO.getSubpackageName());
            offlineBidEvaluationVO.setSubpackageId(projectInfoVO.getSubpackageId());
            offlineBidEvaluationVO.setTenderProjectId(projectInfoVO.getTenderProjectId());
            offlineBidEvaluationVO.setElsAccount(TenantContext.getTenant());
            offlineBidEvaluationVO.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            offlineBidEvaluationVO.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            offlineBidEvaluationVO.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
            offlineBidEvaluationVO.setEvaStatus("0");
            offlineBidEvaluationVO.setDeleted(CommonConstant.DEL_FLAG_0);
            ArrayList<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList = new ArrayList<PurchaseTenderOfflineBidEvaSupplierRecord>();
            List<TenderProjectSupplier> tenderProjectSupplier = this.tenderProjectSupplierService.getDecryptSupplier(subpackageId, null, null);
            for (TenderProjectSupplier supplier : tenderProjectSupplier) {
                PurchaseTenderOfflineBidEvaSupplierRecord bidEvaSupplierRecord = new PurchaseTenderOfflineBidEvaSupplierRecord();
                bidEvaSupplierRecord.setSubpackageId(supplier.getSubpackageId());
                bidEvaSupplierRecord.setTenderProjectId(supplier.getTenderProjectId());
                bidEvaSupplierRecord.setSupplierAccount(supplier.getSupplierAccount());
                bidEvaSupplierRecord.setSupplierName(supplier.getSupplierName());
                bidEvaSupplierRecord.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                bidEvaSupplierRecord.setInvalid(supplier.getInvalid());
                bidEvaSupplierRecord.setElsAccount(TenantContext.getTenant());
                bidEvaSupplierRecord.setCandidate("0");
                bidEvaSupplierRecord.setQuote(supplier.getQuote());
                bidEvaSupplierRecordList.add(bidEvaSupplierRecord);
            }
            offlineBidEvaluationVO.setBidEvaSupplierRecordList(bidEvaSupplierRecordList);
            return offlineBidEvaluationVO;
        }
        PurchaseTenderProjectEvaInfo purchaseTenderProjectEvaInfo = evaInfoList.get(0);
        offlineBidEvaluationVO = (OfflineBidEvaluationVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderProjectEvaInfo), OfflineBidEvaluationVO.class));
        List<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList = this.bidEvaSupplierRecordService.selectByEvaInfoId(offlineBidEvaluationVO.getId());
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList = this.evaBidAttachmentInfoService.selectByEvaInfoId(offlineBidEvaluationVO.getId());
        offlineBidEvaluationVO.setBidEvaSupplierRecordList(bidEvaSupplierRecordList);
        offlineBidEvaluationVO.setEvaBidAttachmentInfoList(evaBidAttachmentInfoList);
        return offlineBidEvaluationVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOfflineBidEvaluationResult(PurchaseTenderProjectEvaInfo evaInfo, List<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList, List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList) {
        this.evaInfoService.save((Object)evaInfo);
        this.insertOfflineBidEvaluationData(evaInfo, bidEvaSupplierRecordList, evaBidAttachmentInfoList);
    }

    private void insertOfflineBidEvaluationData(PurchaseTenderProjectEvaInfo evaInfo, List<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList, List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList) {
        if (CollectionUtil.isNotEmpty(bidEvaSupplierRecordList)) {
            bidEvaSupplierRecordList.stream().forEach(bidEvaSupplierRecord -> {
                if (bidEvaSupplierRecord.getTotalScore() == null) {
                    bidEvaSupplierRecord.setTotalScore(BigDecimal.ZERO);
                }
            });
            bidEvaSupplierRecordList = bidEvaSupplierRecordList.stream().sorted(Comparator.comparing(PurchaseTenderOfflineBidEvaSupplierRecord::getTotalScore).reversed()).collect(Collectors.toList());
            LinkedHashMap orderByMap = new LinkedHashMap();
            Integer orderBy = 1;
            for (PurchaseTenderOfflineBidEvaSupplierRecord bidEvaSupplierRecord2 : bidEvaSupplierRecordList) {
                Integer index = (Integer)orderByMap.get(bidEvaSupplierRecord2.getTotalScore().doubleValue());
                if (index == null) {
                    index = orderBy;
                }
                bidEvaSupplierRecord2.setOrderBy(index);
                orderByMap.put(bidEvaSupplierRecord2.getTotalScore().doubleValue(), index);
                orderBy = index = Integer.valueOf(index + 1);
                bidEvaSupplierRecord2.setInvalid(StringUtils.isBlank((CharSequence)bidEvaSupplierRecord2.getInvalid()) ? "0" : bidEvaSupplierRecord2.getInvalid());
                bidEvaSupplierRecord2.setCandidate("1".equals(bidEvaSupplierRecord2.getInvalid()) ? "0" : bidEvaSupplierRecord2.getCandidate());
                bidEvaSupplierRecord2.setEvaInfoId(evaInfo.getId());
                bidEvaSupplierRecord2.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                bidEvaSupplierRecord2.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
                bidEvaSupplierRecord2.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
            }
            this.bidEvaSupplierRecordService.saveBatch(bidEvaSupplierRecordList, 1000);
        }
        if (CollectionUtil.isNotEmpty(evaBidAttachmentInfoList)) {
            for (PurchaseTenderProjectEvaBidAttachmentInfo evaBidAttachmentInfo : evaBidAttachmentInfoList) {
                evaBidAttachmentInfo.setEvaInfoId(evaInfo.getId());
                evaBidAttachmentInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                evaBidAttachmentInfo.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
                evaBidAttachmentInfo.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
            }
            this.evaBidAttachmentInfoService.saveBatch(evaBidAttachmentInfoList, 1000);
        }
        Integer subpackageStatus = TenderOperationFieldUtils.getEvaBiddingSubpackageStatus();
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)evaInfo).subpackageId(evaInfo.getSubpackageId()).subpackageStatus(subpackageStatus + "").build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editOfflineBidEvaluationResult(PurchaseTenderProjectEvaInfo evaInfo, List<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList, List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList) {
        boolean flag = this.evaInfoService.updateById((Object)evaInfo);
        Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.bidEvaSupplierRecordService.deleteByMainId(evaInfo.getId());
        this.evaBidAttachmentInfoService.deleteByMainId(evaInfo.getId());
        this.insertOfflineBidEvaluationData(evaInfo, bidEvaSupplierRecordList, evaBidAttachmentInfoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishOfflineBidEvaluationResult(PurchaseTenderProjectEvaInfo evaInfo, List<PurchaseTenderOfflineBidEvaSupplierRecord> bidEvaSupplierRecordList, List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList) {
        for (PurchaseTenderOfflineBidEvaSupplierRecord bidEvaSupplierRecord2 : bidEvaSupplierRecordList) {
            if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
                Assert.isTrue((bidEvaSupplierRecord2.getEvaPrice() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UBuxOLVW_d5766dd", (String)"\u8bc4\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                Assert.isTrue((bidEvaSupplierRecord2.getQuote() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suxOLVW_8249033f", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            Assert.isTrue((bidEvaSupplierRecord2.getTotalScore() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_MkszxOLVW_82aabdae", (String)"\u6c47\u603b\u5f97\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        evaInfo.setEvaStatus("1");
        if (StringUtils.isBlank((CharSequence)evaInfo.getId())) {
            this.saveOfflineBidEvaluationResult(evaInfo, bidEvaSupplierRecordList, evaBidAttachmentInfoList);
        } else {
            this.editOfflineBidEvaluationResult(evaInfo, bidEvaSupplierRecordList, evaBidAttachmentInfoList);
        }
        Map invalidSupplierRecordMap = bidEvaSupplierRecordList.stream().filter(bidEvaSupplierRecord -> "1".equals(bidEvaSupplierRecord.getInvalid())).collect(Collectors.toMap(PurchaseTenderOfflineBidEvaSupplierRecord::getSupplierAccount, Function.identity()));
        Map candidateSupplierRecordMap = bidEvaSupplierRecordList.stream().filter(bidEvaSupplierRecord -> "1".equals(bidEvaSupplierRecord.getCandidate())).collect(Collectors.toMap(PurchaseTenderOfflineBidEvaSupplierRecord::getSupplierAccount, Function.identity()));
        List<TenderProjectSupplier> tenderProjectSupplier = this.tenderProjectSupplierService.getDecryptSupplier(evaInfo.getSubpackageId(), null, null);
        for (Object supplier : tenderProjectSupplier) {
            PurchaseTenderOfflineBidEvaSupplierRecord bidEvaSupplierRecord3 = (PurchaseTenderOfflineBidEvaSupplierRecord)((Object)invalidSupplierRecordMap.get(supplier.getSupplierAccount()));
            if (bidEvaSupplierRecord3 != null) {
                supplier.setInvalid("1");
                continue;
            }
            bidEvaSupplierRecord3 = (PurchaseTenderOfflineBidEvaSupplierRecord)((Object)candidateSupplierRecordMap.get(supplier.getSupplierAccount()));
            if (bidEvaSupplierRecord3 == null) continue;
            TenderOperationFieldUtils.setFieldValue(supplier, "1", "shortlisted");
        }
        this.tenderProjectSupplierService.updateBatchById(tenderProjectSupplier);
        ArrayList<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidateList = new ArrayList<PurchaseTenderProjectBidWinningCandidate>();
        for (PurchaseTenderOfflineBidEvaSupplierRecord supplierRecord : candidateSupplierRecordMap.values()) {
            PurchaseTenderProjectBidWinningCandidate bidWinningCandidate = new PurchaseTenderProjectBidWinningCandidate();
            bidWinningCandidate.setSupplierAccount(supplierRecord.getSupplierAccount());
            bidWinningCandidate.setSupplierName(supplierRecord.getSupplierName());
            bidWinningCandidate.setEvaInfoId(evaInfo.getId());
            bidWinningCandidate.setEvaPrice(supplierRecord.getEvaPrice());
            bidWinningCandidate.setTotalScore(supplierRecord.getTotalScore());
            bidWinningCandidate.setQuote(supplierRecord.getQuote());
            bidWinningCandidate.setSubpackageId(evaInfo.getSubpackageId());
            bidWinningCandidate.setTenderProjectId(evaInfo.getTenderProjectId());
            bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.NEW.getValue());
            bidWinningCandidate.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            bidWinningCandidate.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            bidWinningCandidate.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
            bidWinningCandidateList.add(bidWinningCandidate);
        }
        this.bidWinningCandidateService.deleteByMainId(evaInfo.getId());
        this.bidWinningCandidateService.saveBatch(bidWinningCandidateList, 1000);
        Integer subpackageStatus = TenderOperationFieldUtils.getEndEvaBidSubpackageStatus();
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)evaInfo).subpackageId(evaInfo.getSubpackageId()).subpackageStatus(subpackageStatus + "").build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
        if (CollectionUtil.isNotEmpty(evaBidAttachmentInfoList)) {
            List<PurchaseAttachmentDTO> purchaseAttachmentDTOS = evaBidAttachmentInfoList.stream().map(evaBidAttachmentInfo -> {
                PurchaseAttachmentDTO purchaseAttachmentDTO = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)evaBidAttachmentInfo, PurchaseAttachmentDTO.class);
                purchaseAttachmentDTO.setId(evaBidAttachmentInfo.getAttachmentId());
                return purchaseAttachmentDTO;
            }).collect(Collectors.toList());
            ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, evaInfo.getId(), evaInfo.getSubpackageId(), evaInfo.getSubpackageId(), TenderProjectArchiveAttachmentEnum.EVA_RECORD_PREFIX.getValue());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void downloadWord(String id, HttpServletRequest request, HttpServletResponse response) {
        PurchaseTenderProjectEvaBidAttachmentInfo evaAttachmentInfo = (PurchaseTenderProjectEvaBidAttachmentInfo)((Object)this.evaBidAttachmentInfoService.getById((Serializable)((Object)id)));
        String html = evaAttachmentInfo.getContent();
        if (StringUtils.isBlank((CharSequence)html)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CcxOLVW_60c5e69d", (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        log.info("\u62db\u6807html" + html);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)evaAttachmentInfo.getSubpackageId())));
        String fileName = subpackageInfo.getSubpackageName();
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("tenderEvaFileType", TenantContext.getTenant());
        Map dictMaps = dictDTOList.stream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()));
        DictDTO dictDTO = (DictDTO)dictMaps.get(evaAttachmentInfo.getFileType());
        if (dictDTO != null) {
            fileName = fileName + "_" + dictDTO.getText();
        }
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String nowday = dtf.format(time);
        fileName = fileName + nowday;
        fileName = fileName + ".pdf";
        String filePathParent = File.separator + "files" + File.separator + TenantContext.getTenant() + File.separator + nowday;
        String filePath = filePathParent + File.separator + fileName;
        if (filePathParent.contains("\\")) {
            filePathParent = filePathParent.replace("\\", "/");
            filePath = filePath.replace("\\", "/");
        }
        byte[] outByteArray = new byte[]{};
        outByteArray = HtmlToPdfUtil.htmlToPdf(html, fileName, true, "", null);
        String uploadFilePath = this.invokeBaseRpcService.uploadFiles(outByteArray, filePath, fileName, "oss");
        if (StringUtils.isNotBlank((CharSequence)evaAttachmentInfo.getAttachmentId())) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(Arrays.asList(evaAttachmentInfo.getAttachmentId()));
        }
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        purchaseAttachmentDTO.setId(IdWorker.getIdStr());
        purchaseAttachmentDTO.setBusinessType("tender");
        purchaseAttachmentDTO.setHeadId(evaAttachmentInfo.getEvaInfoId());
        purchaseAttachmentDTO.setFileType(evaAttachmentInfo.getFileType());
        purchaseAttachmentDTO.setSourceNumber(subpackageInfo.getSubpackageNumber());
        purchaseAttachmentDTO.setActionRoutePath("/srm/bidder/BidEvaluationManagerList");
        purchaseAttachmentDTO.setFileName(fileName);
        purchaseAttachmentDTO.setFilePath(filePath);
        purchaseAttachmentDTO.setSaveType("oss");
        purchaseAttachmentDTO.setUploadElsAccount(SysUtil.getLoginUser().getElsAccount());
        purchaseAttachmentDTO.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        purchaseAttachmentDTO.setFileSize(String.valueOf(outByteArray.length));
        this.invokeBaseRpcService.insertPurchaseAttachment(purchaseAttachmentDTO);
        evaAttachmentInfo.setFileName(fileName);
        evaAttachmentInfo.setAttachmentId(purchaseAttachmentDTO.getId());
        this.evaBidAttachmentInfoService.updateById((Object)evaAttachmentInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveEvaAttachmentInfo(PurchaseTenderProjectEvaBidAttachmentInfo attachmentInfo) {
        this.evaBidAttachmentInfoService.saveOrUpdate((Object)attachmentInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteEvaAttachmentInfo(String id) {
        PurchaseTenderProjectEvaBidAttachmentInfo bidAttachmentInfo = (PurchaseTenderProjectEvaBidAttachmentInfo)((Object)this.evaBidAttachmentInfoService.getById((Serializable)((Object)id)));
        this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(Arrays.asList(bidAttachmentInfo.getAttachmentId()));
        this.evaBidAttachmentInfoService.deleteById(bidAttachmentInfo.getId());
    }

    @Override
    public PurchaseTenderProjectEvaBidAttachmentInfo queryAttachmentInfo(String evaInfoId, String fileType) {
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfos = this.evaBidAttachmentInfoService.selectByEvaInfoId(evaInfoId);
        if (CollectionUtil.isNotEmpty(evaBidAttachmentInfos)) {
            for (PurchaseTenderProjectEvaBidAttachmentInfo evaBidAttachmentInfo : evaBidAttachmentInfos) {
                if (!evaBidAttachmentInfo.getFileType().equals(fileType)) continue;
                return evaBidAttachmentInfo;
            }
        }
        return new PurchaseTenderProjectEvaBidAttachmentInfo();
    }

    @Override
    public EvaLeaderOpinionVO queryLeaderOpinion(String evaInfoId, String evaGroupId) {
        EvaLeaderOpinionVO evaLeaderOpinionVO = new EvaLeaderOpinionVO();
        List<PurchaseTenderProjectBidEvaGroupSummaryResult> evaGroupSummaryResultList = this.evaGroupSummaryResultService.selectByMainId(evaInfoId, evaGroupId);
        if (CollectionUtil.isNotEmpty(evaGroupSummaryResultList)) {
            PurchaseTenderProjectBidEvaGroupSummaryResult summaryResult = evaGroupSummaryResultList.get(0);
            evaLeaderOpinionVO.setOpinion(summaryResult.getRemark());
            evaLeaderOpinionVO.setEvaInfoId(summaryResult.getEvaInfoId());
            evaLeaderOpinionVO.setGroupId(summaryResult.getEvaGroupId());
            return evaLeaderOpinionVO;
        }
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveLeaderOpinion(EvaLeaderOpinionVO evaLeaderOpinionVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        boolean flag = this.evaGroupSummaryResultService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(PurchaseTenderProjectBidEvaGroupSummaryResult::getRemark, (Object)evaLeaderOpinionVO.getOpinion())).eq(PurchaseTenderProjectBidEvaGroupSummaryResult::getEvaGroupId, (Object)evaLeaderOpinionVO.getGroupId())).eq(PurchaseTenderProjectBidEvaGroupSummaryResult::getEvaInfoId, (Object)evaLeaderOpinionVO.getEvaInfoId()));
        Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_suLbxMLUUWxiTSuyVW_27b38d75", (String)"\u4e13\u5bb6\u672a\u5168\u90e8\u5b8c\u6210\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u7ed3\u8bba\uff01"));
    }
}

