/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.price.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.price.entity.PurchaseTenderControlPriceHead;
import com.els.modules.tender.price.service.PurchaseTenderControlPriceHeadService;
import com.els.modules.tender.price.vo.PurchaseTenderControlPriceHeadVO;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/price/purchaseTenderControlPriceHead"})
@Api(tags={"\u91c7\u8d2d\u63a7\u5236\u4ef7\u7ba1\u7406\u5934\u4fe1\u606f"})
public class PurchaseTenderControlPriceHeadController
extends BaseController<PurchaseTenderControlPriceHead, PurchaseTenderControlPriceHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderControlPriceHeadController.class);
    @Autowired
    private PurchaseTenderControlPriceHeadService controlPriceHeadService;

    @AutoLog(busModule="\u91c7\u8d2d\u63a7\u5236\u4ef7\u7ba1\u7406\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody PurchaseTenderControlPriceHeadVO controlPriceHeadVO) {
        PurchaseTenderControlPriceHead purchaseTenderControlPriceHead = new PurchaseTenderControlPriceHead();
        BeanUtils.copyProperties((Object)((Object)controlPriceHeadVO), (Object)((Object)purchaseTenderControlPriceHead));
        purchaseTenderControlPriceHead.setStatus("0");
        this.controlPriceHeadService.saveMain(purchaseTenderControlPriceHead, controlPriceHeadVO.getControlPriceSettingList());
        return Result.ok((Object)((Object)purchaseTenderControlPriceHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u63a7\u5236\u4ef7\u7ba1\u7406\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody PurchaseTenderControlPriceHeadVO controlPriceHead) {
        PurchaseTenderControlPriceHead purchaseTenderControlPriceHead = new PurchaseTenderControlPriceHead();
        BeanUtils.copyProperties((Object)((Object)controlPriceHead), (Object)((Object)purchaseTenderControlPriceHead));
        purchaseTenderControlPriceHead.setStatus("0");
        this.controlPriceHeadService.updateMain(purchaseTenderControlPriceHead, controlPriceHead.getControlPriceSettingList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u63a7\u5236\u4ef7\u7ba1\u7406\u5934\u4fe1\u606f", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestBody PurchaseTenderControlPriceHeadVO controlPriceHeadVO) {
        PurchaseTenderControlPriceHead purchaseTenderControlPriceHead = new PurchaseTenderControlPriceHead();
        BeanUtils.copyProperties((Object)((Object)controlPriceHeadVO), (Object)((Object)purchaseTenderControlPriceHead));
        purchaseTenderControlPriceHead.setStatus("1");
        if (StringUtils.isNotBlank((CharSequence)controlPriceHeadVO.getId())) {
            this.controlPriceHeadService.updateMain(purchaseTenderControlPriceHead, controlPriceHeadVO.getControlPriceSettingList());
        } else {
            this.controlPriceHeadService.saveMain(purchaseTenderControlPriceHead, controlPriceHeadVO.getControlPriceSettingList());
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", notes="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderControlPriceHeadVO controlPriceHeadVO = this.controlPriceHeadService.queryBySubpackageId(subpackageId);
        return Result.ok((Object)((Object)controlPriceHeadVO));
    }
}

