/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.advice;

import com.tencent.supersonic.common.pojo.ResultData;
import com.tencent.supersonic.common.pojo.enums.ReturnCode;
import com.tencent.supersonic.common.pojo.exception.AccessException;
import com.tencent.supersonic.common.pojo.exception.CommonException;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.pojo.exception.InvalidPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultData<String> exception(Exception e) {
        log.error("default global exception", (Throwable)e);
        return ResultData.fail((int)ReturnCode.SYSTEM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={AccessException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultData<String> accessException(Exception e) {
        log.error("default global exception", (Throwable)e);
        return ResultData.fail((int)ReturnCode.ACCESS_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={InvalidPermissionException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultData<String> invalidPermissionException(Exception e) {
        log.error("default global exception", (Throwable)e);
        return ResultData.fail((int)ReturnCode.INVALID_PERMISSION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={InvalidArgumentException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultData<String> invalidArgumentException(Exception e) {
        log.error("default global exception", (Throwable)e);
        return ResultData.fail((int)ReturnCode.INVALID_REQUEST.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={CommonException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultData<String> commonException(CommonException e) {
        log.error("default global exception", (Throwable)e);
        return ResultData.fail((int)e.getCode(), (String)e.getMessage());
    }
}

