/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic;

import com.els.config.FastJsonAutoConfig;
import com.els.modules.db.TableEntityRedisConfig;
import com.els.modules.db.TableEntityScanner;
import dev.langchain4j.openai.spring.AutoConfig;
import dev.langchain4j.spring.LangChain4jAutoConfig;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ComponentScan(excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"com.els.modules.system.listener.*"}), @ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={TableEntityRedisConfig.class, TableEntityScanner.class, FastJsonAutoConfig.class, LangChain4jAutoConfig.class, AutoConfig.class, dev.langchain4j.ollama.spring.AutoConfig.class, dev.langchain4j.azure.openai.spring.AutoConfig.class, dev.langchain4j.azure.aisearch.spring.AutoConfig.class, dev.langchain4j.anthropic.spring.AutoConfig.class})}, basePackages={"com.tencent.supersonic", "com.els", "dev.langchain4j"})
@EnableScheduling
@EnableAsync
@EnableSwagger2
public class StandaloneLauncher {
    private static final Logger log = LoggerFactory.getLogger(StandaloneLauncher.class);

    public static void main(String[] args) throws Exception {
        ConfigurableApplicationContext application = SpringApplication.run(StandaloneLauncher.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        log.info("StandaloneLauncher start");
        String port = env.getProperty("server.port");
        String path = env.getProperty("spring.mvc.servlet.path");
        log.error("\n-------------------------------------------------------------------------------------\n\tApplication Product-SRM-V6 is running! Access URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/\n\t----------------------------------------------------------");
    }
}

