/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.sql.api.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.third.sql.dto.MaterialFromOracleDto;
import com.els.modules.third.sql.util.OracleSqlUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.rpc.service.ManualTransactionManagementService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialFromCQGTOracleDbImpl.class);
    @Autowired
    private PurchaseMaterialHeadService materialHeadService;
    @Autowired
    private PurchaseMaterialItemService materialItemService;
    @Autowired
    private TemplateRpcService templateRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Resource
    private ManualTransactionManagementService manualTransactionManagementService;
    @Autowired
    private RedisUtil redisUtil;
    String key = "GetMaterialFromCQGTOracleDbImpl:";

    public boolean invokeCheck(JSONObject obj, Object custom) {
        String elsAccount = TenantContext.getTenant();
        String key = String.format("%s_%s", elsAccount, "PurchaseRequest");
        if (null == this.redisUtil.get(key = key + elsAccount)) {
            return true;
        }
        this.redisUtil.set(key, (Object)key);
        return false;
    }

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_MTL_SYSTEM_ITEMS";
        JSONObject customObject = (JSONObject)custom;
        JSONObject customParam = customObject.getJSONObject("custom_param");
        boolean isIncrement = true;
        if (customParam != null && customParam.getBoolean("isIncrement") != null) {
            isIncrement = customParam.getBoolean("isIncrement");
        }
        if (isIncrement) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, 0);
            calendar.add(5, -1);
            obj.put("body", (Object)(OracleSqlUtil.getIncrementDataSql((String)tableName, (Date)calendar.getTime()) + " order by UPDATE_TIME"));
        } else {
            obj.put("body", (Object)(OracleSqlUtil.getAllDataSql((String)tableName) + " order by UPDATE_TIME"));
        }
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray itemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        if (CollUtil.isEmpty((Collection)itemList)) {
            log.info("GetMaterialFromCQGTOracleDbImpl \u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
            JSONObject result = new JSONObject();
            result.put("message", (Object)"\u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
            return result;
        }
        JSONObject customObject = (JSONObject)custom;
        JSONObject customParam = customObject.getJSONObject("custom_param");
        boolean isIncrement = true;
        if (customParam != null && customParam.getBoolean("isIncrement") != null) {
            isIncrement = customParam.getBoolean("isIncrement");
        }
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        String token = this.getToken();
        try {
            this.saveInfo(itemList, elsAccount, isIncrement);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.redisUtil.del(new String[]{this.key + elsAccount});
                throw throwable;
            }
        }
        this.redisUtil.del(new String[]{this.key + elsAccount});
        return interfaceResult;
    }

    private void saveInfo(JSONArray itemList, String elsAccount, boolean isIncrement) {
        ArrayList<PurchaseMaterialHead> insertmaterials = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateMaterials = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialItem> insertMaterialItems = new ArrayList<PurchaseMaterialItem>();
        ArrayList<String> insertMaterialNumbers = new ArrayList<String>();
        List templateList = this.templateRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        Map<String, List<Object>> groupItem = itemList.stream().collect(Collectors.groupingBy(item -> JSON.parseObject((String)item.toString()).getString("ITEM_CODE")));
        Set<String> materialNumberList = groupItem.keySet();
        Map<String, PurchaseMaterialHead> materialMap = this.getPurchaseMaterial(elsAccount, materialNumberList, isIncrement);
        Map<String, List<PurchaseMaterialItem>> materialItemMap = this.getPurchaseMaterialItem(elsAccount, materialNumberList, isIncrement);
        LoginUser loginUser = SysUtil.getLoginUser();
        Map<String, String> factoryMap = this.invokeBaseRpcService.queryTableDictListByFilterSql(TenantContext.getTenant(), "purchase_organization_info", "org_name", "org_code", "org_category_code='factory' and status='1'").stream().collect(Collectors.toMap(DictDTO::getValue, DictDTO::getText));
        Map<String, String> codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, PurchaseMaterialCode::getCateName, (newVal, oldVal) -> oldVal));
        for (Map.Entry<String, List<Object>> entry : groupItem.entrySet()) {
            List<Object> value = entry.getValue();
            PurchaseMaterialHead head = new PurchaseMaterialHead();
            for (int i = 0; i < value.size(); ++i) {
                JSONObject materialDtoJson = (JSONObject)value.get(i);
                MaterialFromOracleDto materialDto = (MaterialFromOracleDto)JSON.parseObject((String)materialDtoJson.toJSONString(), MaterialFromOracleDto.class);
                String cateCode = materialDto.getCateCode();
                if (materialMap.containsKey(materialDto.getMaterialNumber())) {
                    List itemIds;
                    PurchaseMaterialHead materialHead = materialMap.get(materialDto.getMaterialNumber());
                    long time = OracleSqlUtil.getUpdateTime((String)materialDto.getUpdateTime()).getTime();
                    long dbUpdateTime = OracleSqlUtil.getUpdateTime((String)materialHead.getFbk20()).getTime();
                    List<PurchaseMaterialItem> items = materialItemMap.get(materialDto.getMaterialNumber());
                    head = this.setPurchaseMaterialHead(false, template, materialMap, headDefaultValue, materialDto, cateCode, codeMap.get(cateCode));
                    if (time > dbUpdateTime) {
                        if (i == 0) {
                            updateMaterials.add(head);
                        }
                        if (CollUtil.isNotEmpty(items) && CollUtil.isNotEmpty(itemIds = items.parallelStream().filter(item -> item.getFactory().equals(materialDto.getFactoryCode())).map(BaseEntity::getId).collect(Collectors.toList()))) {
                            this.materialItemService.removeByIds(itemIds);
                        }
                        PurchaseMaterialItem item2 = this.getMaterialItemData(head, materialDto, factoryMap, elsAccount, loginUser);
                        insertMaterialItems.add(item2);
                        continue;
                    }
                    if (!CollUtil.isNotEmpty(items) || !CollUtil.isEmpty(itemIds = items.parallelStream().filter(item -> item.getFactory().equals(materialDto.getFactoryCode())).map(BaseEntity::getId).collect(Collectors.toList()))) continue;
                    PurchaseMaterialItem item3 = this.getMaterialItemData(head, materialDto, factoryMap, elsAccount, loginUser);
                    insertMaterialItems.add(item3);
                    continue;
                }
                if (!insertMaterialNumbers.contains(materialDto.getMaterialNumber())) {
                    head = this.setPurchaseMaterialHead(true, template, materialMap, headDefaultValue, materialDto, cateCode, codeMap.get(cateCode));
                    insertmaterials.add(head);
                    insertMaterialNumbers.add(materialDto.getMaterialNumber());
                }
                PurchaseMaterialItem item4 = this.getMaterialItemData(head, materialDto, factoryMap, elsAccount, loginUser);
                insertMaterialItems.add(item4);
            }
        }
        if (CollectionUtil.isNotEmpty(insertmaterials)) {
            this.materialHeadService.saveBatch(insertmaterials, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateMaterials)) {
            this.materialHeadService.updateBatchById(updateMaterials, 2000);
        }
        if (CollectionUtil.isNotEmpty(insertMaterialItems)) {
            this.materialItemService.saveBatch(insertMaterialItems, 2000);
        }
    }

    private PurchaseMaterialItem getMaterialItemData(PurchaseMaterialHead head, MaterialFromOracleDto materialDto, Map<String, String> factoryMap, String elsAccount, LoginUser loginUser) {
        PurchaseMaterialItem item = new PurchaseMaterialItem();
        item.setHeadId(head.getId());
        item.setMaterialNumber(materialDto.getMaterialNumber());
        item.setFactory(materialDto.getFactoryCode());
        item.setFactoryName(factoryMap.get(materialDto.getFactoryCode()));
        item.setItemCount(Integer.valueOf(0));
        item.setFbk10(materialDto.getSourceId());
        item.setElsAccount(elsAccount);
        item.setCreateBy(loginUser.getSubAccount());
        item.setCreateById(loginUser.getId());
        item.setCreateTime(new Date());
        item.setUpdateBy(loginUser.getSubAccount());
        item.setUpdateById(loginUser.getId());
        return item;
    }

    private Map<String, PurchaseMaterialHead> getPurchaseMaterial(String elsAccount, Set<String> materialNumbers, boolean isIncrement) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(PurchaseMaterialHead::getSourceType, (Object)"erp");
        if (isIncrement) {
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumbers);
        }
        if (CollectionUtil.isEmpty((Collection)(list = this.materialHeadService.list((Wrapper)wrapper)))) {
            return new HashMap<String, PurchaseMaterialHead>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private Map<String, List<PurchaseMaterialItem>> getPurchaseMaterialItem(String elsAccount, Set<String> materialNumbers, boolean isIncrement) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        if (isIncrement) {
            wrapper.in(PurchaseMaterialItem::getMaterialNumber, materialNumbers);
        }
        if (CollectionUtil.isEmpty((Collection)(list = this.materialItemService.list((Wrapper)wrapper)))) {
            return new HashMap<String, List<PurchaseMaterialItem>>();
        }
        return list.stream().collect(Collectors.groupingBy(PurchaseMaterialItem::getMaterialNumber));
    }

    private PurchaseMaterialHead setPurchaseMaterialHead(boolean isSave, TemplateHeadDTO template, Map<String, PurchaseMaterialHead> materialMap, Map<String, String> headDefaultValue, MaterialFromOracleDto materialDto, String cateCode, String cateName) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (isSave) {
            PurchaseMaterialHead materialHead = (PurchaseMaterialHead)JSON.parseObject((String)JSON.toJSONString(headDefaultValue), PurchaseMaterialHead.class);
            materialHead.setId(IdWorker.getIdStr());
            materialHead.setElsAccount(TenantContext.getTenant());
            materialHead.setTemplateNumber(template.getTemplateNumber());
            materialHead.setTemplateName(template.getTemplateName());
            materialHead.setTemplateAccount(template.getElsAccount());
            materialHead.setTemplateVersion(template.getTemplateVersion());
            materialHead.setMaterialNumber(materialDto.getMaterialNumber());
            materialHead.setMaterialName(materialDto.getMaterialName());
            materialHead.setMaterialDesc(materialDto.getMaterialName());
            materialHead.setBaseUnit(materialDto.getBaseUnit());
            materialHead.setPurchaseUnit(materialDto.getBaseUnit());
            materialHead.setRepertoryUnit(materialDto.getBaseUnit());
            materialHead.setFbk20(materialDto.getUpdateTime());
            materialHead.setUpdateTime(OracleSqlUtil.getUpdateTime((String)materialDto.getUpdateTime()));
            materialHead.setCateCode(cateCode);
            materialHead.setCateName(cateName);
            materialHead.setCateLevelCode("1");
            materialHead.setNeedAudit("0");
            materialHead.setSubmitStatus("0");
            materialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            materialHead.setSourceType("erp");
            materialHead.setSourceId(materialDto.getSourceId());
            materialHead.setCreateBy(loginUser.getSubAccount());
            materialHead.setCreateById(loginUser.getId());
            materialHead.setCreateTime(new Date());
            materialHead.setUpdateBy(loginUser.getSubAccount());
            materialHead.setUpdateById(loginUser.getId());
            return materialHead;
        }
        PurchaseMaterialHead materialHead = materialMap.get(materialDto.getMaterialNumber());
        materialHead.setMaterialName(materialDto.getMaterialName());
        materialHead.setMaterialDesc(materialDto.getMaterialName());
        materialHead.setCateCode(cateCode);
        materialHead.setCateName(cateName);
        materialHead.setBaseUnit(materialDto.getBaseUnit());
        materialHead.setPurchaseUnit(materialDto.getBaseUnit());
        materialHead.setRepertoryUnit(materialDto.getBaseUnit());
        materialHead.setFbk20(materialDto.getUpdateTime());
        materialHead.setUpdateTime(OracleSqlUtil.getUpdateTime((String)materialDto.getUpdateTime()));
        materialHead.setUpdateBy(loginUser.getSubAccount());
        materialHead.setUpdateById(loginUser.getId());
        return materialHead;
    }

    private String getToken() {
        String token = SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = SpringContextUtils.getHttpServletRequest().getHeader("token");
        }
        return token;
    }
}

